/*
 * Decompiled with CFR 0.152.
 */
package systems.composable.dropwizard.cassandra;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.MetricSet;
import com.codahale.metrics.health.HealthCheck;
import com.codahale.metrics.health.HealthCheckRegistry;
import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.ProtocolOptions;
import com.datastax.driver.core.ProtocolVersion;
import com.datastax.driver.core.QueryOptions;
import com.datastax.driver.core.SocketOptions;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Strings;
import io.dropwizard.lifecycle.Managed;
import io.dropwizard.setup.Environment;
import io.dropwizard.util.Duration;
import java.util.Optional;
import javax.validation.Valid;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import org.hibernate.validator.constraints.NotEmpty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import systems.composable.dropwizard.cassandra.CassandraHealthCheck;
import systems.composable.dropwizard.cassandra.CassandraManager;
import systems.composable.dropwizard.cassandra.CassandraMetricSet;
import systems.composable.dropwizard.cassandra.auth.AuthProviderFactory;
import systems.composable.dropwizard.cassandra.loadbalancing.LoadBalancingPolicyFactory;
import systems.composable.dropwizard.cassandra.network.AddressTranslatorFactory;
import systems.composable.dropwizard.cassandra.pooling.PoolingOptionsFactory;
import systems.composable.dropwizard.cassandra.reconnection.ReconnectionPolicyFactory;
import systems.composable.dropwizard.cassandra.retry.RetryPolicyFactory;
import systems.composable.dropwizard.cassandra.speculativeexecution.SpeculativeExecutionPolicyFactory;
import systems.composable.dropwizard.cassandra.ssl.SSLOptionsFactory;

public class CassandraFactory {
    private static final Logger LOG = LoggerFactory.getLogger(CassandraFactory.class);
    private String clusterName;
    private String keyspace;
    @NotEmpty
    private String validationQuery = "SELECT key FROM system.local";
    @NotEmpty
    private String[] contactPoints;
    @Min(value=1L)
    private int port = 9042;
    private Optional<ProtocolVersion> protocolVersion = Optional.empty();
    @Valid
    private Optional<SSLOptionsFactory> ssl = Optional.empty();
    @NotNull
    private ProtocolOptions.Compression compression = ProtocolOptions.Compression.NONE;
    private Optional<Duration> maxSchemaAgreementWait = Optional.empty();
    @Valid
    private Optional<ReconnectionPolicyFactory> reconnectionPolicy = Optional.empty();
    @Valid
    private Optional<AuthProviderFactory> authProvider = Optional.empty();
    @Valid
    private Optional<RetryPolicyFactory> retryPolicy = Optional.empty();
    @Valid
    private Optional<LoadBalancingPolicyFactory> loadBalancingPolicy = Optional.empty();
    @Valid
    private Optional<SpeculativeExecutionPolicyFactory> speculativeExecutionPolicy = Optional.empty();
    private Optional<QueryOptions> queryOptions = Optional.empty();
    private Optional<SocketOptions> socketOptions = Optional.empty();
    @Valid
    private Optional<PoolingOptionsFactory> poolingOptions = Optional.empty();
    @Valid
    private Optional<AddressTranslatorFactory> addressTranslator = Optional.empty();
    private boolean metricsEnabled = true;
    private boolean jmxEnabled = false;
    @NotNull
    private Duration shutdownGracePeriod = Duration.seconds((long)30L);
    @NotNull
    private Duration healthCheckTimeout = Duration.seconds((long)2L);

    @JsonProperty
    public String getClusterName() {
        return this.clusterName;
    }

    @JsonProperty
    public void setClusterName(String clusterName) {
        this.clusterName = clusterName;
    }

    @JsonProperty
    public String getKeyspace() {
        return this.keyspace;
    }

    @JsonProperty
    public void setKeyspace(String keyspace) {
        this.keyspace = keyspace;
    }

    @JsonProperty
    public String getValidationQuery() {
        return this.validationQuery;
    }

    @JsonProperty
    public void setValidationQuery(String validationQuery) {
        this.validationQuery = validationQuery;
    }

    @JsonProperty
    public String[] getContactPoints() {
        return this.contactPoints;
    }

    @JsonProperty
    public void setContactPoints(String[] contactPoints) {
        this.contactPoints = contactPoints;
    }

    @JsonProperty
    public int getPort() {
        return this.port;
    }

    @JsonProperty
    public void setPort(int port) {
        this.port = port;
    }

    @JsonProperty
    public Optional<ProtocolVersion> getProtocolVersion() {
        return this.protocolVersion;
    }

    @JsonProperty
    public void setProtocolVersion(Optional<ProtocolVersion> protocolVersion) {
        this.protocolVersion = protocolVersion;
    }

    @JsonProperty
    public Optional<SSLOptionsFactory> getSsl() {
        return this.ssl;
    }

    @JsonProperty
    public void setSsl(Optional<SSLOptionsFactory> ssl) {
        this.ssl = ssl;
    }

    @JsonProperty
    public ProtocolOptions.Compression getCompression() {
        return this.compression;
    }

    @JsonProperty
    public void setCompression(ProtocolOptions.Compression compression) {
        this.compression = compression;
    }

    @JsonProperty
    public void setMaxSchemaAgreementWait(Optional<Duration> maxSchemaAgreementWait) {
        this.maxSchemaAgreementWait = maxSchemaAgreementWait;
    }

    @JsonProperty
    public Optional<ReconnectionPolicyFactory> getReconnectionPolicy() {
        return this.reconnectionPolicy;
    }

    @JsonProperty
    public void setReconnectionPolicy(Optional<ReconnectionPolicyFactory> reconnectionPolicy) {
        this.reconnectionPolicy = reconnectionPolicy;
    }

    @JsonProperty
    public Optional<AuthProviderFactory> getAuthProvider() {
        return this.authProvider;
    }

    @JsonProperty
    public void setAuthProvider(Optional<AuthProviderFactory> authProvider) {
        this.authProvider = authProvider;
    }

    @JsonProperty
    public Optional<RetryPolicyFactory> getRetryPolicy() {
        return this.retryPolicy;
    }

    @JsonProperty
    public void setRetryPolicy(Optional<RetryPolicyFactory> retryPolicy) {
        this.retryPolicy = retryPolicy;
    }

    @JsonProperty
    public Optional<LoadBalancingPolicyFactory> getLoadBalancingPolicy() {
        return this.loadBalancingPolicy;
    }

    @JsonProperty
    public void setLoadBalancingPolicy(Optional<LoadBalancingPolicyFactory> loadBalancingPolicy) {
        this.loadBalancingPolicy = loadBalancingPolicy;
    }

    @JsonProperty
    public Optional<SpeculativeExecutionPolicyFactory> getSpeculativeExecutionPolicy() {
        return this.speculativeExecutionPolicy;
    }

    @JsonProperty
    public void setSpeculativeExecutionPolicy(Optional<SpeculativeExecutionPolicyFactory> speculativeExecutionPolicy) {
        this.speculativeExecutionPolicy = speculativeExecutionPolicy;
    }

    @JsonProperty
    public Optional<QueryOptions> getQueryOptions() {
        return this.queryOptions;
    }

    @JsonProperty
    public void setQueryOptions(Optional<QueryOptions> queryOptions) {
        this.queryOptions = queryOptions;
    }

    @JsonProperty
    public Optional<SocketOptions> getSocketOptions() {
        return this.socketOptions;
    }

    @JsonProperty
    public void setSocketOptions(Optional<SocketOptions> socketOptions) {
        this.socketOptions = socketOptions;
    }

    @JsonProperty
    public Optional<PoolingOptionsFactory> getPoolingOptions() {
        return this.poolingOptions;
    }

    @JsonProperty
    public void setPoolingOptions(Optional<PoolingOptionsFactory> poolingOptions) {
        this.poolingOptions = poolingOptions;
    }

    @JsonProperty
    public boolean isMetricsEnabled() {
        return this.metricsEnabled;
    }

    @JsonProperty
    public void setMetricsEnabled(boolean metricsEnabled) {
        this.metricsEnabled = metricsEnabled;
    }

    @JsonProperty
    public boolean isJmxEnabled() {
        return this.jmxEnabled;
    }

    @JsonProperty
    public void setJmxEnabled(boolean jmxEnabled) {
        this.jmxEnabled = jmxEnabled;
    }

    @JsonProperty
    public Duration getShutdownGracePeriod() {
        return this.shutdownGracePeriod;
    }

    @JsonProperty
    public void setShutdownGracePeriod(Duration shutdownGracePeriod) {
        this.shutdownGracePeriod = shutdownGracePeriod;
    }

    @JsonProperty
    public Duration getHealthCheckTimeout() {
        return this.healthCheckTimeout;
    }

    @JsonProperty
    public void setHealthCheckTimeout(Duration healthCheckTimeout) {
        this.healthCheckTimeout = healthCheckTimeout;
    }

    @JsonProperty
    public Optional<AddressTranslatorFactory> getAddressTranslator() {
        return this.addressTranslator;
    }

    @JsonProperty
    public void setAddressTranslator(Optional<AddressTranslatorFactory> addressTranslator) {
        this.addressTranslator = addressTranslator;
    }

    public Cluster build(Environment environment) {
        Cluster cluster = this.build(environment.metrics(), environment.healthChecks());
        LOG.debug("Registering {} Cassandra cluster for lifecycle management", (Object)cluster.getClusterName());
        environment.lifecycle().manage((Managed)new CassandraManager(cluster, this.getShutdownGracePeriod()));
        return cluster;
    }

    public Cluster build(MetricRegistry metrics, HealthCheckRegistry healthChecks) {
        Cluster.Builder builder = Cluster.builder();
        for (String contactPoint : this.contactPoints) {
            builder.addContactPoints(new String[]{contactPoint});
        }
        builder.withPort(this.port);
        builder.withCompression(this.compression);
        this.protocolVersion.ifPresent(arg_0 -> ((Cluster.Builder)builder).withProtocolVersion(arg_0));
        this.ssl.map(SSLOptionsFactory::build).ifPresent(arg_0 -> ((Cluster.Builder)builder).withSSL(arg_0));
        this.maxSchemaAgreementWait.map(Duration::toSeconds).map(Long::intValue).ifPresent(arg_0 -> ((Cluster.Builder)builder).withMaxSchemaAgreementWaitSeconds(arg_0));
        this.authProvider.map(AuthProviderFactory::build).ifPresent(arg_0 -> ((Cluster.Builder)builder).withAuthProvider(arg_0));
        this.reconnectionPolicy.map(ReconnectionPolicyFactory::build).ifPresent(arg_0 -> ((Cluster.Builder)builder).withReconnectionPolicy(arg_0));
        this.retryPolicy.map(RetryPolicyFactory::build).ifPresent(arg_0 -> ((Cluster.Builder)builder).withRetryPolicy(arg_0));
        this.loadBalancingPolicy.map(LoadBalancingPolicyFactory::build).ifPresent(arg_0 -> ((Cluster.Builder)builder).withLoadBalancingPolicy(arg_0));
        this.speculativeExecutionPolicy.map(SpeculativeExecutionPolicyFactory::build).ifPresent(arg_0 -> ((Cluster.Builder)builder).withSpeculativeExecutionPolicy(arg_0));
        this.queryOptions.ifPresent(arg_0 -> ((Cluster.Builder)builder).withQueryOptions(arg_0));
        this.socketOptions.ifPresent(arg_0 -> ((Cluster.Builder)builder).withSocketOptions(arg_0));
        this.poolingOptions.map(PoolingOptionsFactory::build).ifPresent(arg_0 -> ((Cluster.Builder)builder).withPoolingOptions(arg_0));
        this.addressTranslator.map(AddressTranslatorFactory::build).ifPresent(arg_0 -> ((Cluster.Builder)builder).withAddressTranslator(arg_0));
        if (!this.metricsEnabled) {
            builder.withoutMetrics();
        }
        if (!this.jmxEnabled) {
            builder.withoutJMXReporting();
        }
        if (!Strings.isNullOrEmpty((String)this.clusterName)) {
            builder.withClusterName(this.clusterName);
        }
        Cluster cluster = builder.build();
        LOG.debug("Registering {} Cassandra health check", (Object)cluster.getClusterName());
        CassandraHealthCheck healthCheck = new CassandraHealthCheck(cluster, this.validationQuery, this.healthCheckTimeout);
        healthChecks.register(MetricRegistry.name((String)"cassandra", (String[])new String[]{cluster.getClusterName()}), (HealthCheck)healthCheck);
        if (this.isMetricsEnabled()) {
            LOG.debug("Registering {} Cassandra metrics", (Object)cluster.getClusterName());
            metrics.registerAll((MetricSet)new CassandraMetricSet(cluster));
        }
        return cluster;
    }
}

