/*
 * Decompiled with CFR 0.152.
 */
package systems.composable.dropwizard.cassandra.pooling;

import com.datastax.driver.core.HostDistance;
import com.datastax.driver.core.PoolingOptions;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.dropwizard.util.Duration;
import javax.validation.Valid;
import systems.composable.dropwizard.cassandra.pooling.HostDistanceOptions;

public class PoolingOptionsFactory {
    @Valid
    private Duration heartbeatInterval;
    @Valid
    private Duration poolTimeout;
    @Valid
    private Duration idleTimeout;
    @Valid
    private HostDistanceOptions remote;
    @Valid
    private HostDistanceOptions local;

    @JsonProperty
    public Duration getHeartbeatInterval() {
        return this.heartbeatInterval;
    }

    @JsonProperty
    public void setHeartbeatInterval(Duration heartbeatInterval) {
        this.heartbeatInterval = heartbeatInterval;
    }

    @JsonProperty
    public Duration getPoolTimeout() {
        return this.poolTimeout;
    }

    @JsonProperty
    public void setPoolTimeout(Duration poolTimeout) {
        this.poolTimeout = poolTimeout;
    }

    @JsonProperty
    public Duration getIdleTimeout() {
        return this.idleTimeout;
    }

    @JsonProperty
    public void setIdleTimeout(Duration idleTimeout) {
        this.idleTimeout = idleTimeout;
    }

    @JsonProperty
    public HostDistanceOptions getRemote() {
        return this.remote;
    }

    @JsonProperty
    public void setRemote(HostDistanceOptions remote) {
        this.remote = remote;
    }

    @JsonProperty
    public HostDistanceOptions getLocal() {
        return this.local;
    }

    @JsonProperty
    public void setLocal(HostDistanceOptions local) {
        this.local = local;
    }

    public PoolingOptions build() {
        PoolingOptions poolingOptions = new PoolingOptions();
        if (this.local != null) {
            this.setPoolingOptions(poolingOptions, HostDistance.LOCAL, this.local);
        }
        if (this.remote != null) {
            this.setPoolingOptions(poolingOptions, HostDistance.REMOTE, this.remote);
        }
        if (this.heartbeatInterval != null) {
            poolingOptions.setHeartbeatIntervalSeconds((int)this.heartbeatInterval.toSeconds());
        }
        if (this.poolTimeout != null) {
            poolingOptions.setPoolTimeoutMillis((int)this.poolTimeout.toMilliseconds());
        }
        if (this.idleTimeout != null) {
            poolingOptions.setIdleTimeoutSeconds((int)this.idleTimeout.toSeconds());
        }
        return poolingOptions;
    }

    private void setPoolingOptions(PoolingOptions poolingOptions, HostDistance hostDistance, HostDistanceOptions options) {
        if (options.getCoreConnections() != null) {
            poolingOptions.setCoreConnectionsPerHost(hostDistance, options.getCoreConnections().intValue());
        }
        if (options.getMaxConnections() != null) {
            poolingOptions.setMaxConnectionsPerHost(hostDistance, options.getMaxConnections().intValue());
        }
        if (options.getMaxRequestsPerConnection() != null) {
            poolingOptions.setMaxRequestsPerConnection(hostDistance, options.getMaxRequestsPerConnection().intValue());
        }
        if (options.getNewConnectionThreshold() != null) {
            poolingOptions.setNewConnectionThreshold(hostDistance, options.getNewConnectionThreshold().intValue());
        }
    }
}

