/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.util.args;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import java.util.SortedMap;
import java.util.TreeMap;
import org.opends.messages.Message;
import org.opends.messages.MessageBuilder;
import org.opends.messages.ToolMessages;
import org.opends.messages.UtilityMessages;
import org.opends.server.core.DirectoryServer;
import org.opends.server.util.ServerConstants;
import org.opends.server.util.StaticUtils;
import org.opends.server.util.args.Argument;
import org.opends.server.util.args.ArgumentException;
import org.opends.server.util.args.ArgumentParser;
import org.opends.server.util.args.SubCommand;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubCommandArgumentParser
extends ArgumentParser {
    private Argument usageArgument;
    private Map<Argument, Collection<SubCommand>> usageGroupArguments;
    private ArrayList<String> trailingArguments;
    private boolean longArgumentsCaseSensitive;
    private boolean usageOrVersionDisplayed;
    private HashMap<Character, Argument> globalShortIDMap;
    private HashMap<String, Argument> globalArgumentMap;
    private HashMap<String, Argument> globalLongIDMap;
    private SortedMap<String, SubCommand> subCommands;
    private LinkedList<Argument> globalArgumentList;
    private OutputStream usageOutputStream;
    private String mainClassName;
    private Message toolDescription;
    private String[] rawArguments;
    private SubCommand subCommand;

    public SubCommandArgumentParser(String mainClassName, Message toolDescription, boolean longArgumentsCaseSensitive) {
        super(mainClassName, toolDescription, longArgumentsCaseSensitive);
        this.mainClassName = mainClassName;
        this.toolDescription = toolDescription;
        this.longArgumentsCaseSensitive = longArgumentsCaseSensitive;
        this.trailingArguments = new ArrayList();
        this.globalArgumentList = new LinkedList();
        this.globalArgumentMap = new HashMap();
        this.globalShortIDMap = new HashMap();
        this.globalLongIDMap = new HashMap();
        this.usageGroupArguments = new HashMap<Argument, Collection<SubCommand>>();
        this.subCommands = new TreeMap<String, SubCommand>();
        this.usageOrVersionDisplayed = false;
        this.rawArguments = null;
        this.subCommand = null;
        this.usageArgument = null;
        this.usageOutputStream = null;
    }

    @Override
    public String getMainClassName() {
        return this.mainClassName;
    }

    @Override
    public Message getToolDescription() {
        return this.toolDescription;
    }

    public boolean longArgumentsCaseSensitive() {
        return this.longArgumentsCaseSensitive;
    }

    public LinkedList<Argument> getGlobalArgumentList() {
        return this.globalArgumentList;
    }

    public boolean hasGlobalArgument(String argumentName) {
        return this.globalArgumentMap.containsKey(argumentName);
    }

    public Argument getGlobalArgument(String name) {
        return this.globalArgumentMap.get(name);
    }

    public HashMap<Character, Argument> getGlobalArgumentsByShortID() {
        return this.globalShortIDMap;
    }

    public boolean hasGlobalArgumentWithShortID(Character shortID) {
        return this.globalShortIDMap.containsKey(shortID);
    }

    public Argument getGlobalArgumentForShortID(Character shortID) {
        return this.globalShortIDMap.get(shortID);
    }

    public HashMap<String, Argument> getGlobalArgumentsByLongID() {
        return this.globalLongIDMap;
    }

    public boolean hasGlobalArgumentWithLongID(String longID) {
        return this.globalLongIDMap.containsKey(longID);
    }

    public Argument getGlobalArgumentForLongID(String longID) {
        return this.globalLongIDMap.get(longID);
    }

    public SortedMap<String, SubCommand> getSubCommands() {
        return this.subCommands;
    }

    public boolean hasSubCommand(String name) {
        return this.subCommands.containsKey(name);
    }

    public SubCommand getSubCommand(String name) {
        return (SubCommand)this.subCommands.get(name);
    }

    public SubCommand getSubCommand() {
        return this.subCommand;
    }

    @Override
    public String[] getRawArguments() {
        return this.rawArguments;
    }

    public void addGlobalArgument(Argument argument) throws ArgumentException {
        String longID;
        String argumentName = argument.getName();
        if (this.globalArgumentMap.containsKey(argumentName)) {
            Message message = UtilityMessages.ERR_SUBCMDPARSER_DUPLICATE_GLOBAL_ARG_NAME.get(argumentName);
            throw new ArgumentException(message);
        }
        for (SubCommand s : this.subCommands.values()) {
            if (s.getArgumentForName(argumentName) == null) continue;
            Message message = UtilityMessages.ERR_SUBCMDPARSER_GLOBAL_ARG_NAME_SUBCMD_CONFLICT.get(argumentName, s.getName());
            throw new ArgumentException(message);
        }
        Character shortID = argument.getShortIdentifier();
        if (shortID != null) {
            if (this.globalShortIDMap.containsKey(shortID)) {
                String name = this.globalShortIDMap.get(shortID).getName();
                Message message = UtilityMessages.ERR_SUBCMDPARSER_DUPLICATE_GLOBAL_ARG_SHORT_ID.get(String.valueOf(shortID), argumentName, name);
                throw new ArgumentException(message);
            }
            for (SubCommand s : this.subCommands.values()) {
                if (s.getArgument(shortID) == null) continue;
                String cmdName = s.getName();
                String name = s.getArgument(shortID).getName();
                Message message = UtilityMessages.ERR_SUBCMDPARSER_GLOBAL_ARG_SHORT_ID_CONFLICT.get(String.valueOf(shortID), argumentName, name, cmdName);
                throw new ArgumentException(message);
            }
        }
        if ((longID = argument.getLongIdentifier()) != null) {
            if (!this.longArgumentsCaseSensitive) {
                longID = StaticUtils.toLowerCase(longID);
            }
            if (this.globalLongIDMap.containsKey(longID)) {
                String name = this.globalLongIDMap.get(longID).getName();
                Message message = UtilityMessages.ERR_SUBCMDPARSER_DUPLICATE_GLOBAL_ARG_LONG_ID.get(longID, argumentName, name);
                throw new ArgumentException(message);
            }
            for (SubCommand s : this.subCommands.values()) {
                if (s.getArgument(longID) == null) continue;
                String cmdName = s.getName();
                String name = s.getArgument(longID).getName();
                Message message = UtilityMessages.ERR_SUBCMDPARSER_GLOBAL_ARG_LONG_ID_CONFLICT.get(longID, argumentName, name, cmdName);
                throw new ArgumentException(message);
            }
        }
        if (shortID != null) {
            this.globalShortIDMap.put(shortID, argument);
        }
        if (longID != null) {
            this.globalLongIDMap.put(longID, argument);
        }
        this.globalArgumentList.add(argument);
    }

    protected void removeGlobalArgument(Argument argument) {
        String longID;
        String argumentName = argument.getName();
        this.globalArgumentMap.remove(argumentName);
        Character shortID = argument.getShortIdentifier();
        if (shortID != null) {
            this.globalShortIDMap.remove(shortID);
        }
        if ((longID = argument.getLongIdentifier()) != null) {
            if (!this.longArgumentsCaseSensitive) {
                longID = StaticUtils.toLowerCase(longID);
            }
            this.globalLongIDMap.remove(longID);
        }
        this.globalArgumentList.remove(argument);
    }

    @Override
    public void setUsageArgument(Argument argument, OutputStream outputStream) {
        this.usageArgument = argument;
        this.usageOutputStream = outputStream;
        this.usageGroupArguments.put(argument, Collections.emptySet());
    }

    public void setUsageGroupArgument(Argument argument, Collection<SubCommand> subCommands) {
        this.usageGroupArguments.put(argument, subCommands);
    }

    @Override
    public void parseArguments(String[] rawArguments) throws ArgumentException {
        this.parseArguments(rawArguments, null);
    }

    @Override
    public void parseArguments(String[] rawArguments, String propertiesFile, boolean requirePropertiesFile) throws ArgumentException {
        Properties argumentProperties;
        block2: {
            this.rawArguments = rawArguments;
            argumentProperties = null;
            try {
                Properties p = new Properties();
                FileInputStream fis = new FileInputStream(propertiesFile);
                p.load(fis);
                fis.close();
                argumentProperties = p;
            }
            catch (Exception e) {
                if (!requirePropertiesFile) break block2;
                Message message = UtilityMessages.ERR_SUBCMDPARSER_CANNOT_READ_PROPERTIES_FILE.get(String.valueOf(propertiesFile), StaticUtils.getExceptionMessage(e));
                throw new ArgumentException(message, (Throwable)e);
            }
        }
        this.parseArguments(rawArguments, argumentProperties);
    }

    @Override
    public void parseArguments(String[] rawArguments, Properties argumentProperties) throws ArgumentException {
        Message message;
        String value;
        this.rawArguments = rawArguments;
        this.subCommand = null;
        this.trailingArguments = new ArrayList();
        this.usageOrVersionDisplayed = false;
        boolean inTrailingArgs = false;
        int numArguments = rawArguments.length;
        for (int i = 0; i < numArguments; ++i) {
            SubCommand sc;
            String argValue;
            String arg = rawArguments[i];
            if (inTrailingArgs) {
                this.trailingArguments.add(arg);
                if (this.subCommand.getMaxTrailingArguments() <= 0 || this.trailingArguments.size() <= this.subCommand.getMaxTrailingArguments()) continue;
                Message message2 = UtilityMessages.ERR_ARGPARSER_TOO_MANY_TRAILING_ARGS.get(this.subCommand.getMaxTrailingArguments());
                throw new ArgumentException(message2);
            }
            if (arg.equals("--")) {
                inTrailingArgs = true;
                continue;
            }
            if (arg.startsWith("--")) {
                Argument a;
                String argName = arg.substring(2);
                argValue = null;
                int equalPos = argName.indexOf(61);
                if (equalPos >= 0) {
                    if (equalPos == 0) {
                        Message message3 = UtilityMessages.ERR_SUBCMDPARSER_LONG_ARG_WITHOUT_NAME.get(arg);
                        throw new ArgumentException(message3);
                    }
                    argValue = argName.substring(equalPos + 1);
                    argName = argName.substring(0, equalPos);
                }
                if (!this.longArgumentsCaseSensitive) {
                    argName = StaticUtils.toLowerCase(argName);
                }
                if ((a = this.globalLongIDMap.get(argName)) == null) {
                    if (this.subCommand == null) {
                        if (argName.equals("help")) {
                            try {
                                this.getUsage(this.usageOutputStream);
                            }
                            catch (Exception e) {
                                // empty catch block
                            }
                            return;
                        }
                        if (argName.equals("version")) {
                            try {
                                DirectoryServer.printVersion(this.usageOutputStream);
                                this.usageOrVersionDisplayed = true;
                            }
                            catch (Exception e) {
                                // empty catch block
                            }
                            return;
                        }
                        Message message4 = UtilityMessages.ERR_SUBCMDPARSER_NO_GLOBAL_ARGUMENT_FOR_LONG_ID.get(argName);
                        throw new ArgumentException(message4);
                    }
                    a = this.subCommand.getArgument(argName);
                    if (a == null) {
                        if (argName.equals("help")) {
                            try {
                                this.getUsage(this.usageOutputStream);
                            }
                            catch (Exception e) {
                                // empty catch block
                            }
                            return;
                        }
                        if (argName.equals("version")) {
                            try {
                                DirectoryServer.printVersion(this.usageOutputStream);
                                this.usageOrVersionDisplayed = true;
                            }
                            catch (Exception e) {
                                // empty catch block
                            }
                            return;
                        }
                        Message message5 = UtilityMessages.ERR_SUBCMDPARSER_NO_ARGUMENT_FOR_LONG_ID.get(argName);
                        throw new ArgumentException(message5);
                    }
                }
                a.setPresent(true);
                if (this.usageGroupArguments.containsKey(a)) {
                    try {
                        this.getUsage(a, this.usageOutputStream);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    return;
                }
                if (a.needsValue()) {
                    MessageBuilder invalidReason;
                    if (argValue == null) {
                        if (i + 1 == numArguments) {
                            Message message6 = UtilityMessages.ERR_SUBCMDPARSER_NO_VALUE_FOR_ARGUMENT_WITH_LONG_ID.get(argName);
                            throw new ArgumentException(message6);
                        }
                        argValue = rawArguments[++i];
                    }
                    if (!a.valueIsAcceptable(argValue, invalidReason = new MessageBuilder())) {
                        Message message7 = UtilityMessages.ERR_SUBCMDPARSER_VALUE_UNACCEPTABLE_FOR_LONG_ID.get(argValue, argName, invalidReason.toString());
                        throw new ArgumentException(message7);
                    }
                    if (a.hasValue() && !a.isMultiValued()) {
                        Message message8 = UtilityMessages.ERR_SUBCMDPARSER_NOT_MULTIVALUED_FOR_LONG_ID.get(argName);
                        throw new ArgumentException(message8);
                    }
                    a.addValue(argValue);
                    continue;
                }
                if (argValue == null) continue;
                Message message9 = UtilityMessages.ERR_SUBCMDPARSER_ARG_FOR_LONG_ID_DOESNT_TAKE_VALUE.get(argName);
                throw new ArgumentException(message9);
            }
            if (arg.startsWith("-")) {
                if (arg.equals("-")) {
                    Message message10 = UtilityMessages.ERR_SUBCMDPARSER_INVALID_DASH_AS_ARGUMENT.get();
                    throw new ArgumentException(message10);
                }
                char argCharacter = arg.charAt(1);
                argValue = arg.length() > 2 ? arg.substring(2) : null;
                Argument a = this.globalShortIDMap.get(Character.valueOf(argCharacter));
                if (a == null) {
                    if (this.subCommand == null) {
                        if (argCharacter == '?') {
                            try {
                                this.getUsage(this.usageOutputStream);
                            }
                            catch (Exception e) {
                                // empty catch block
                            }
                            return;
                        }
                        if (argCharacter == 'V') {
                            boolean dashVAccepted = true;
                            if (this.globalShortIDMap.containsKey(Character.valueOf('V'))) {
                                dashVAccepted = false;
                            } else {
                                for (SubCommand subCmd : this.subCommands.values()) {
                                    if (subCmd.getArgument(Character.valueOf('V')) == null) continue;
                                    dashVAccepted = false;
                                    break;
                                }
                            }
                            if (dashVAccepted) {
                                this.usageOrVersionDisplayed = true;
                                try {
                                    DirectoryServer.printVersion(this.usageOutputStream);
                                }
                                catch (Exception e) {
                                    // empty catch block
                                }
                                return;
                            }
                            Message message11 = UtilityMessages.ERR_SUBCMDPARSER_NO_GLOBAL_ARGUMENT_FOR_SHORT_ID.get(String.valueOf(argCharacter));
                            throw new ArgumentException(message11);
                        }
                        Message message12 = UtilityMessages.ERR_SUBCMDPARSER_NO_GLOBAL_ARGUMENT_FOR_SHORT_ID.get(String.valueOf(argCharacter));
                        throw new ArgumentException(message12);
                    }
                    a = this.subCommand.getArgument(Character.valueOf(argCharacter));
                    if (a == null) {
                        if (argCharacter == '?') {
                            try {
                                this.getUsage(this.usageOutputStream);
                            }
                            catch (Exception e) {
                                // empty catch block
                            }
                            return;
                        }
                        if (argCharacter == 'V') {
                            boolean dashVAccepted = true;
                            if (this.globalShortIDMap.containsKey(Character.valueOf('V'))) {
                                dashVAccepted = false;
                            } else {
                                for (SubCommand subCmd : this.subCommands.values()) {
                                    if (subCmd.getArgument(Character.valueOf('V')) == null) continue;
                                    dashVAccepted = false;
                                    break;
                                }
                            }
                            if (dashVAccepted) {
                                this.usageOrVersionDisplayed = true;
                                try {
                                    DirectoryServer.printVersion(this.usageOutputStream);
                                }
                                catch (Exception e) {
                                    // empty catch block
                                }
                                return;
                            }
                        } else {
                            Message message13 = UtilityMessages.ERR_SUBCMDPARSER_NO_ARGUMENT_FOR_SHORT_ID.get(String.valueOf(argCharacter));
                            throw new ArgumentException(message13);
                        }
                    }
                }
                a.setPresent(true);
                if (this.usageGroupArguments.containsKey(a)) {
                    try {
                        this.getUsage(a, this.usageOutputStream);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    return;
                }
                if (a.needsValue()) {
                    MessageBuilder invalidReason;
                    if (argValue == null) {
                        if (i + 1 == numArguments) {
                            Message message14 = UtilityMessages.ERR_SUBCMDPARSER_NO_VALUE_FOR_ARGUMENT_WITH_SHORT_ID.get(String.valueOf(argCharacter));
                            throw new ArgumentException(message14);
                        }
                        argValue = rawArguments[++i];
                    }
                    if (!a.valueIsAcceptable(argValue, invalidReason = new MessageBuilder())) {
                        Message message15 = UtilityMessages.ERR_SUBCMDPARSER_VALUE_UNACCEPTABLE_FOR_SHORT_ID.get(argValue, String.valueOf(argCharacter), invalidReason.toString());
                        throw new ArgumentException(message15);
                    }
                    if (a.hasValue() && !a.isMultiValued()) {
                        Message message16 = UtilityMessages.ERR_SUBCMDPARSER_NOT_MULTIVALUED_FOR_SHORT_ID.get(String.valueOf(argCharacter));
                        throw new ArgumentException(message16);
                    }
                    a.addValue(argValue);
                    continue;
                }
                if (argValue == null) continue;
                int valueLength = argValue.length();
                for (int j = 0; j < valueLength; ++j) {
                    char c = argValue.charAt(j);
                    Argument b = this.globalShortIDMap.get(Character.valueOf(c));
                    if (b == null) {
                        if (this.subCommand == null) {
                            Message message17 = UtilityMessages.ERR_SUBCMDPARSER_NO_GLOBAL_ARGUMENT_FOR_SHORT_ID.get(String.valueOf(argCharacter));
                            throw new ArgumentException(message17);
                        }
                        b = this.subCommand.getArgument(Character.valueOf(c));
                        if (b == null) {
                            Message message18 = UtilityMessages.ERR_SUBCMDPARSER_NO_ARGUMENT_FOR_SHORT_ID.get(String.valueOf(argCharacter));
                            throw new ArgumentException(message18);
                        }
                    }
                    if (b.needsValue()) {
                        Message message19 = UtilityMessages.ERR_SUBCMDPARSER_CANT_MIX_ARGS_WITH_VALUES.get(String.valueOf(argCharacter), argValue, String.valueOf(c));
                        throw new ArgumentException(message19);
                    }
                    b.setPresent(true);
                    if (!this.usageGroupArguments.containsKey(b)) continue;
                    try {
                        this.getUsage(b, this.usageOutputStream);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    return;
                }
                continue;
            }
            if (this.subCommand != null) {
                if (this.subCommand.allowsTrailingArguments()) {
                    this.trailingArguments.add(arg);
                    inTrailingArgs = true;
                    continue;
                }
                Message message20 = UtilityMessages.ERR_ARGPARSER_DISALLOWED_TRAILING_ARGUMENT.get(arg);
                throw new ArgumentException(message20);
            }
            String nameToCheck = arg;
            if (!this.longArgumentsCaseSensitive) {
                nameToCheck = StaticUtils.toLowerCase(arg);
            }
            if ((sc = (SubCommand)this.subCommands.get(nameToCheck)) == null) {
                Message message21 = UtilityMessages.ERR_SUBCMDPARSER_INVALID_ARGUMENT.get(arg);
                throw new ArgumentException(message21);
            }
            this.subCommand = sc;
        }
        if (this.subCommand != null) {
            int minTrailingArguments = this.subCommand.getMinTrailingArguments();
            if (this.subCommand.allowsTrailingArguments() && minTrailingArguments > 0 && this.trailingArguments.size() < minTrailingArguments) {
                Message message22 = UtilityMessages.ERR_ARGPARSER_TOO_FEW_TRAILING_ARGUMENTS.get(minTrailingArguments);
                throw new ArgumentException(message22);
            }
        }
        for (Argument a : this.globalArgumentList) {
            if (a.isPresent() || !a.needsValue()) continue;
            boolean valueSet = false;
            if (argumentProperties != null && a.getPropertyName() != null && (value = argumentProperties.getProperty(a.getPropertyName())) != null) {
                a.addValue(value);
                valueSet = true;
            }
            if (!valueSet && a.getDefaultValue() != null) {
                a.addValue(a.getDefaultValue());
                valueSet = true;
            }
            if (valueSet || !a.isRequired()) continue;
            message = UtilityMessages.ERR_SUBCMDPARSER_NO_VALUE_FOR_REQUIRED_ARG.get(a.getName());
            throw new ArgumentException(message);
        }
        if (this.subCommand != null) {
            for (Argument a : this.subCommand.getArguments()) {
                if (a.isPresent() || !a.needsValue()) continue;
                boolean valueSet = false;
                if (argumentProperties != null && a.getPropertyName() != null && (value = argumentProperties.getProperty(a.getPropertyName())) != null) {
                    a.addValue(value);
                    valueSet = true;
                }
                if (!valueSet && a.getDefaultValue() != null) {
                    a.addValue(a.getDefaultValue());
                    valueSet = true;
                }
                if (valueSet || !a.isRequired()) continue;
                message = UtilityMessages.ERR_SUBCMDPARSER_NO_VALUE_FOR_REQUIRED_ARG.get(a.getName());
                throw new ArgumentException(message);
            }
        }
    }

    public void getSubCommandUsage(MessageBuilder buffer, SubCommand subCommand) {
        this.usageOrVersionDisplayed = true;
        String scriptName = System.getProperty("org.opends.server.scriptName");
        if (scriptName == null || scriptName.length() == 0) {
            scriptName = "java " + this.mainClassName;
        }
        buffer.append(UtilityMessages.INFO_ARGPARSER_USAGE.get());
        buffer.append("  ");
        buffer.append(scriptName);
        buffer.append(" ");
        buffer.append(subCommand.getName());
        buffer.append(" {options}");
        if (subCommand.allowsTrailingArguments()) {
            buffer.append(' ');
            buffer.append(subCommand.getTrailingArgumentsDisplayName());
        }
        buffer.append(ServerConstants.EOL);
        buffer.append(subCommand.getDescription());
        buffer.append(ServerConstants.EOL);
        if (!this.globalArgumentList.isEmpty()) {
            buffer.append(ServerConstants.EOL);
            buffer.append(UtilityMessages.INFO_GLOBAL_OPTIONS.get());
            buffer.append(ServerConstants.EOL);
            buffer.append("    ");
            buffer.append(UtilityMessages.INFO_GLOBAL_OPTIONS_REFERENCE.get(scriptName));
            buffer.append(ServerConstants.EOL);
        }
        if (!subCommand.getArguments().isEmpty()) {
            buffer.append(ServerConstants.EOL);
            buffer.append(UtilityMessages.INFO_SUBCMD_OPTIONS.get());
            buffer.append(ServerConstants.EOL);
        }
        for (Argument a : subCommand.getArguments()) {
            if (a.isHidden()) continue;
            Character shortID = a.getShortIdentifier();
            String longID = a.getLongIdentifier();
            if (shortID != null) {
                int currentLength = buffer.length();
                if (a.equals(this.usageArgument)) {
                    buffer.append("-?, ");
                }
                buffer.append("-");
                buffer.append(shortID.charValue());
                if (a.needsValue() && longID == null) {
                    buffer.append(" ");
                    buffer.append(a.getValuePlaceholder());
                }
                if (longID != null) {
                    int lineLength;
                    StringBuilder newBuffer = new StringBuilder();
                    newBuffer.append(", --");
                    newBuffer.append(longID);
                    if (a.needsValue()) {
                        newBuffer.append(" ");
                        newBuffer.append(a.getValuePlaceholder());
                    }
                    if ((lineLength = buffer.length() - currentLength + newBuffer.length()) > 80) {
                        buffer.append(ServerConstants.EOL);
                        buffer.append(newBuffer.toString());
                    } else {
                        buffer.append(newBuffer.toString());
                    }
                }
                buffer.append(ServerConstants.EOL);
            } else if (longID != null) {
                if (a.equals(this.usageArgument)) {
                    buffer.append("-?, ");
                }
                buffer.append("--");
                buffer.append(longID);
                if (a.needsValue()) {
                    buffer.append(" ");
                    buffer.append(a.getValuePlaceholder());
                }
                buffer.append(ServerConstants.EOL);
            }
            Message description = a.getDescription();
            if (description.length() <= 75) {
                buffer.append("    ");
                buffer.append(description);
                buffer.append(ServerConstants.EOL);
                continue;
            }
            String s = description.toString();
            while (s.length() > 75) {
                int spacePos = s.lastIndexOf(32, 75);
                if (spacePos > 0) {
                    buffer.append("    ");
                    buffer.append(s.substring(0, spacePos).trim());
                    s = s.substring(spacePos + 1).trim();
                    buffer.append(ServerConstants.EOL);
                    continue;
                }
                spacePos = s.indexOf(32);
                if (spacePos > 0) {
                    buffer.append("    ");
                    buffer.append(s.substring(0, spacePos).trim());
                    s = s.substring(spacePos + 1).trim();
                    buffer.append(ServerConstants.EOL);
                    continue;
                }
                buffer.append("    ");
                buffer.append(s);
                s = "";
                buffer.append(ServerConstants.EOL);
            }
            if (s.length() <= 0) continue;
            buffer.append("    ");
            buffer.append(s);
            buffer.append(ServerConstants.EOL);
        }
    }

    @Override
    public String getUsage() {
        MessageBuilder buffer = new MessageBuilder();
        if (this.subCommand == null) {
            if (this.usageGroupArguments.size() > 1) {
                this.getFullUsage(Collections.<SubCommand>emptySet(), true, buffer);
            } else {
                this.getFullUsage(this.subCommands.values(), true, buffer);
            }
        } else {
            this.getSubCommandUsage(buffer, this.subCommand);
        }
        return buffer.toMessage().toString();
    }

    public Message getHelpUsageReference() {
        this.usageOrVersionDisplayed = true;
        String scriptName = System.getProperty("org.opends.server.scriptName");
        if (scriptName == null || scriptName.length() == 0) {
            scriptName = "java " + this.mainClassName;
        }
        MessageBuilder buffer = new MessageBuilder();
        buffer.append(UtilityMessages.INFO_GLOBAL_HELP_REFERENCE.get(scriptName));
        buffer.append(ServerConstants.EOL);
        return buffer.toMessage();
    }

    @Override
    public ArrayList<String> getTrailingArguments() {
        return this.trailingArguments;
    }

    @Override
    public boolean usageOrVersionDisplayed() {
        return this.usageOrVersionDisplayed;
    }

    void addSubCommand(SubCommand subCommand) {
        this.subCommands.put(StaticUtils.toLowerCase(subCommand.getName()), subCommand);
    }

    private void getUsage(Argument a, OutputStream outputStream) throws IOException {
        MessageBuilder buffer = new MessageBuilder();
        if (a.equals(this.usageArgument) && this.subCommand != null) {
            this.getSubCommandUsage(buffer, this.subCommand);
        } else if (a.equals(this.usageArgument) && this.usageGroupArguments.size() <= 1) {
            this.getFullUsage(this.subCommands.values(), true, buffer);
        } else if (a.equals(this.usageArgument)) {
            this.getFullUsage(Collections.<SubCommand>emptySet(), true, buffer);
        } else {
            this.getFullUsage(this.usageGroupArguments.get(a), false, buffer);
        }
        outputStream.write(StaticUtils.getBytes(buffer.toString()));
    }

    @Override
    public void getUsage(OutputStream outputStream) throws IOException {
        outputStream.write(StaticUtils.getBytes(String.valueOf(this.getUsage())));
    }

    private void getFullUsage(Collection<SubCommand> c, boolean showGlobalOptions, MessageBuilder buffer) {
        String scriptName;
        this.usageOrVersionDisplayed = true;
        if (this.toolDescription != null && this.toolDescription.length() > 0) {
            buffer.append(StaticUtils.wrapText(this.toolDescription, 79));
            buffer.append(ServerConstants.EOL);
        }
        if ((scriptName = System.getProperty("org.opends.server.scriptName")) == null || scriptName.length() == 0) {
            scriptName = "java " + this.mainClassName;
        }
        buffer.append(UtilityMessages.INFO_ARGPARSER_USAGE.get());
        buffer.append("  ");
        buffer.append(scriptName);
        if (this.subCommands.isEmpty()) {
            buffer.append(" " + UtilityMessages.INFO_SUBCMDPARSER_OPTIONS.get());
        } else {
            buffer.append(" " + UtilityMessages.INFO_SUBCMDPARSER_SUBCMD_AND_OPTIONS.get());
        }
        if (!this.subCommands.isEmpty()) {
            buffer.append(ServerConstants.EOL);
            buffer.append(ServerConstants.EOL);
            if (c.isEmpty()) {
                buffer.append(UtilityMessages.INFO_SUBCMDPARSER_SUBCMD_HELP_HEADING.get());
            } else {
                buffer.append(UtilityMessages.INFO_SUBCMDPARSER_SUBCMD_HEADING.get());
            }
            buffer.append(ServerConstants.EOL);
        }
        if (c.isEmpty()) {
            for (Argument a : this.globalArgumentList) {
                if (a.isHidden() || !this.usageGroupArguments.containsKey(a) || a.equals(this.usageArgument)) continue;
                this.printArgumentUsage(a, buffer);
            }
        } else {
            int indentNb = 0;
            for (SubCommand sc : c) {
                if (sc.isHidden() || sc.getName().length() <= indentNb) continue;
                indentNb = sc.getName().length();
            }
            ++indentNb;
            for (SubCommand sc : c) {
                if (sc.isHidden()) continue;
                buffer.append("    " + sc.getName());
                for (int i = 0; i < indentNb - sc.getName().length(); ++i) {
                    buffer.append(" ");
                }
                buffer.append(sc.getDescription());
                buffer.append(ServerConstants.EOL);
            }
        }
        buffer.append(ServerConstants.EOL);
        if (showGlobalOptions) {
            if (this.subCommands.isEmpty()) {
                buffer.append(UtilityMessages.INFO_SUBCMDPARSER_WHERE_OPTIONS_INCLUDE.get());
                buffer.append(ServerConstants.EOL);
            } else {
                buffer.append(UtilityMessages.INFO_SUBCMDPARSER_GLOBAL_HEADING.get());
                buffer.append(ServerConstants.EOL);
            }
            boolean dashVAccepted = true;
            if (this.globalShortIDMap.containsKey(Character.valueOf('V'))) {
                dashVAccepted = false;
            } else {
                for (SubCommand subCmd : this.subCommands.values()) {
                    if (subCmd.getArgument(Character.valueOf('V')) == null) continue;
                    dashVAccepted = false;
                    break;
                }
            }
            if (dashVAccepted) {
                buffer.append("-V, ");
            }
            buffer.append("--version");
            buffer.append(ServerConstants.EOL);
            buffer.append("    ");
            buffer.append(ToolMessages.INFO_DESCRIPTION_PRODUCT_VERSION.get());
            buffer.append(ServerConstants.EOL);
            for (Argument a : this.globalArgumentList) {
                if (a.isHidden() || this.usageGroupArguments.containsKey(a)) continue;
                this.printArgumentUsage(a, buffer);
            }
            if (this.usageArgument != null) {
                this.printArgumentUsage(this.usageArgument, buffer);
            } else {
                buffer.append("-?");
            }
            buffer.append(ServerConstants.EOL);
        }
    }

    private void printArgumentUsage(Argument a, MessageBuilder buffer) {
        String valuePlaceholder;
        String value = a.needsValue() ? ((valuePlaceholder = a.getValuePlaceholder()) == null ? " {value}" : " " + valuePlaceholder) : "";
        Character shortIDChar = a.getShortIdentifier();
        if (shortIDChar != null) {
            if (a.equals(this.usageArgument)) {
                buffer.append("-?, ");
            }
            buffer.append("-");
            buffer.append(shortIDChar);
            String longIDString = a.getLongIdentifier();
            if (longIDString != null) {
                buffer.append(", --");
                buffer.append(longIDString);
            }
            buffer.append(value);
        } else {
            String longIDString = a.getLongIdentifier();
            if (longIDString != null) {
                if (a.equals(this.usageArgument)) {
                    buffer.append("-?, ");
                }
                buffer.append("--");
                buffer.append(longIDString);
                buffer.append(value);
            }
        }
        buffer.append(ServerConstants.EOL);
        this.indentAndWrap(Message.raw("    ", new Object[0]), a.getDescription(), buffer);
    }

    private void indentAndWrap(Message indent, Message text, MessageBuilder buffer) {
        int actualSize = 80 - indent.length();
        if (text.length() <= actualSize) {
            buffer.append(indent);
            buffer.append(text);
            buffer.append(ServerConstants.EOL);
        } else {
            String s = text.toString();
            while (s.length() > actualSize) {
                int spacePos = s.lastIndexOf(32, actualSize);
                if (spacePos > 0) {
                    buffer.append(indent);
                    buffer.append(s.substring(0, spacePos).trim());
                    s = s.substring(spacePos + 1).trim();
                    buffer.append(ServerConstants.EOL);
                    continue;
                }
                spacePos = s.indexOf(32);
                if (spacePos > 0) {
                    buffer.append(indent);
                    buffer.append(s.substring(0, spacePos).trim());
                    s = s.substring(spacePos + 1).trim();
                    buffer.append(ServerConstants.EOL);
                    continue;
                }
                buffer.append(indent);
                buffer.append(s);
                s = "";
                buffer.append(ServerConstants.EOL);
            }
            if (s.length() > 0) {
                buffer.append(indent);
                buffer.append(s);
                buffer.append(ServerConstants.EOL);
            }
        }
    }
}

