/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.util.args;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Properties;
import org.opends.messages.Message;
import org.opends.messages.MessageBuilder;
import org.opends.messages.ToolMessages;
import org.opends.messages.UtilityMessages;
import org.opends.server.core.DirectoryServer;
import org.opends.server.util.ServerConstants;
import org.opends.server.util.StaticUtils;
import org.opends.server.util.args.Argument;
import org.opends.server.util.args.ArgumentException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArgumentParser {
    private Argument usageArgument;
    private ArrayList<String> trailingArguments;
    private boolean allowsTrailingArguments;
    private boolean longArgumentsCaseSensitive;
    private boolean usageOrVersionDisplayed;
    private HashMap<Character, Argument> shortIDMap;
    private HashMap<String, Argument> argumentMap;
    private HashMap<String, Argument> longIDMap;
    private int maxTrailingArguments;
    private int minTrailingArguments;
    private LinkedList<Argument> argumentList;
    private OutputStream usageOutputStream;
    private String mainClassName;
    private Message toolDescription;
    private String trailingArgsDisplayName;
    private String[] rawArguments;

    public ArgumentParser(String mainClassName, Message toolDescription, boolean longArgumentsCaseSensitive) {
        this.mainClassName = mainClassName;
        this.toolDescription = toolDescription;
        this.longArgumentsCaseSensitive = longArgumentsCaseSensitive;
        this.argumentList = new LinkedList();
        this.argumentMap = new HashMap();
        this.shortIDMap = new HashMap();
        this.longIDMap = new HashMap();
        this.allowsTrailingArguments = false;
        this.usageOrVersionDisplayed = false;
        this.trailingArgsDisplayName = null;
        this.maxTrailingArguments = 0;
        this.minTrailingArguments = 0;
        this.trailingArguments = new ArrayList();
        this.rawArguments = null;
        this.usageArgument = null;
        this.usageOutputStream = System.out;
    }

    public ArgumentParser(String mainClassName, Message toolDescription, boolean longArgumentsCaseSensitive, boolean allowsTrailingArguments, int minTrailingArguments, int maxTrailingArguments, String trailingArgsDisplayName) {
        this.mainClassName = mainClassName;
        this.toolDescription = toolDescription;
        this.longArgumentsCaseSensitive = longArgumentsCaseSensitive;
        this.allowsTrailingArguments = allowsTrailingArguments;
        this.minTrailingArguments = minTrailingArguments;
        this.maxTrailingArguments = maxTrailingArguments;
        this.trailingArgsDisplayName = trailingArgsDisplayName;
        this.argumentList = new LinkedList();
        this.argumentMap = new HashMap();
        this.shortIDMap = new HashMap();
        this.longIDMap = new HashMap();
        this.trailingArguments = new ArrayList();
        this.usageOrVersionDisplayed = false;
        this.rawArguments = null;
        this.usageArgument = null;
        this.usageOutputStream = System.out;
    }

    public String getMainClassName() {
        return this.mainClassName;
    }

    public Message getToolDescription() {
        return this.toolDescription;
    }

    public boolean allowsTrailingArguments() {
        return this.allowsTrailingArguments;
    }

    public int getMinTrailingArguments() {
        return this.minTrailingArguments;
    }

    public int getMaxTrailingArguments() {
        return this.maxTrailingArguments;
    }

    public LinkedList<Argument> getArgumentList() {
        return this.argumentList;
    }

    public Argument getArgument(String name) {
        return this.argumentMap.get(name);
    }

    public HashMap<Character, Argument> getArgumentsByShortID() {
        return this.shortIDMap;
    }

    public Argument getArgumentForShortID(Character shortID) {
        return this.shortIDMap.get(shortID);
    }

    public HashMap<String, Argument> getArgumentsByLongID() {
        return this.longIDMap;
    }

    public Argument getArgumentForLongID(String longID) {
        return this.longIDMap.get(longID);
    }

    public ArrayList<String> getTrailingArguments() {
        return this.trailingArguments;
    }

    public String[] getRawArguments() {
        return this.rawArguments;
    }

    public void addArgument(Argument argument) throws ArgumentException {
        Character shortID = argument.getShortIdentifier();
        if (shortID != null && this.shortIDMap.containsKey(shortID)) {
            String conflictingName = this.shortIDMap.get(shortID).getName();
            Message message = UtilityMessages.ERR_ARGPARSER_DUPLICATE_SHORT_ID.get(argument.getName(), String.valueOf(shortID), conflictingName);
            throw new ArgumentException(message);
        }
        String longID = argument.getLongIdentifier();
        if (longID != null) {
            if (!this.longArgumentsCaseSensitive) {
                longID = StaticUtils.toLowerCase(longID);
            }
            if (this.longIDMap.containsKey(longID)) {
                String conflictingName = this.longIDMap.get(longID).getName();
                Message message = UtilityMessages.ERR_ARGPARSER_DUPLICATE_LONG_ID.get(argument.getName(), String.valueOf(longID), conflictingName);
                throw new ArgumentException(message);
            }
        }
        if (shortID != null) {
            this.shortIDMap.put(shortID, argument);
        }
        if (longID != null) {
            this.longIDMap.put(longID, argument);
        }
        this.argumentList.add(argument);
    }

    public void setUsageArgument(Argument argument) {
        this.usageArgument = argument;
        this.usageOutputStream = System.out;
    }

    public void setUsageArgument(Argument argument, OutputStream outputStream) {
        this.usageArgument = argument;
        this.usageOutputStream = outputStream;
    }

    public void parseArguments(String[] rawArguments) throws ArgumentException {
        this.parseArguments(rawArguments, null);
    }

    public void parseArguments(String[] rawArguments, String propertiesFile, boolean requirePropertiesFile) throws ArgumentException {
        Properties argumentProperties;
        block2: {
            this.rawArguments = rawArguments;
            argumentProperties = null;
            try {
                Properties p = new Properties();
                FileInputStream fis = new FileInputStream(propertiesFile);
                p.load(fis);
                fis.close();
                argumentProperties = p;
            }
            catch (Exception e) {
                if (!requirePropertiesFile) break block2;
                Message message = UtilityMessages.ERR_ARGPARSER_CANNOT_READ_PROPERTIES_FILE.get(String.valueOf(propertiesFile), StaticUtils.getExceptionMessage(e));
                throw new ArgumentException(message, (Throwable)e);
            }
        }
        this.parseArguments(rawArguments, argumentProperties);
    }

    public void parseArguments(String[] rawArguments, Properties argumentProperties) throws ArgumentException {
        this.rawArguments = rawArguments;
        boolean inTrailingArgs = false;
        int numArguments = rawArguments.length;
        for (int i = 0; i < numArguments; ++i) {
            String argValue;
            String arg = rawArguments[i];
            if (inTrailingArgs) {
                this.trailingArguments.add(arg);
                if (this.maxTrailingArguments <= 0 || this.trailingArguments.size() <= this.maxTrailingArguments) continue;
                Message message = UtilityMessages.ERR_ARGPARSER_TOO_MANY_TRAILING_ARGS.get(this.maxTrailingArguments);
                throw new ArgumentException(message);
            }
            if (arg.equals("--")) {
                inTrailingArgs = true;
                continue;
            }
            if (arg.startsWith("--")) {
                Argument a;
                String argName = arg.substring(2);
                argValue = null;
                int equalPos = argName.indexOf(61);
                if (equalPos >= 0) {
                    if (equalPos == 0) {
                        Message message = UtilityMessages.ERR_ARGPARSER_LONG_ARG_WITHOUT_NAME.get(arg);
                        throw new ArgumentException(message);
                    }
                    argValue = argName.substring(equalPos + 1);
                    argName = argName.substring(0, equalPos);
                }
                if (!this.longArgumentsCaseSensitive) {
                    argName = StaticUtils.toLowerCase(argName);
                }
                if ((a = this.longIDMap.get(argName)) == null) {
                    if (argName.equals("help")) {
                        try {
                            this.getUsage(this.usageOutputStream);
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        return;
                    }
                    if (argName.equals("version")) {
                        this.usageOrVersionDisplayed = true;
                        try {
                            DirectoryServer.printVersion(this.usageOutputStream);
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        return;
                    }
                    Message message = UtilityMessages.ERR_ARGPARSER_NO_ARGUMENT_WITH_LONG_ID.get(argName);
                    throw new ArgumentException(message);
                }
                a.setPresent(true);
                if (this.usageArgument != null && this.usageArgument.getName().equals(a.getName())) {
                    try {
                        this.getUsage(this.usageOutputStream);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    return;
                }
                if (a.needsValue()) {
                    MessageBuilder invalidReason;
                    if (argValue == null) {
                        if (i + 1 == numArguments) {
                            Message message = UtilityMessages.ERR_ARGPARSER_NO_VALUE_FOR_ARGUMENT_WITH_LONG_ID.get(argName);
                            throw new ArgumentException(message);
                        }
                        argValue = rawArguments[++i];
                    }
                    if (!a.valueIsAcceptable(argValue, invalidReason = new MessageBuilder())) {
                        Message message = UtilityMessages.ERR_ARGPARSER_VALUE_UNACCEPTABLE_FOR_LONG_ID.get(argValue, argName, invalidReason.toString());
                        throw new ArgumentException(message);
                    }
                    if (a.hasValue() && !a.isMultiValued()) {
                        Message message = UtilityMessages.ERR_ARGPARSER_NOT_MULTIVALUED_FOR_LONG_ID.get(argName);
                        throw new ArgumentException(message);
                    }
                    a.addValue(argValue);
                    continue;
                }
                if (argValue == null) continue;
                Message message = UtilityMessages.ERR_ARGPARSER_ARG_FOR_LONG_ID_DOESNT_TAKE_VALUE.get(argName);
                throw new ArgumentException(message);
            }
            if (arg.startsWith("-")) {
                if (arg.equals("-")) {
                    Message message = UtilityMessages.ERR_ARGPARSER_INVALID_DASH_AS_ARGUMENT.get();
                    throw new ArgumentException(message);
                }
                char argCharacter = arg.charAt(1);
                argValue = arg.length() > 2 ? arg.substring(2) : null;
                Argument a = this.shortIDMap.get(Character.valueOf(argCharacter));
                if (a == null) {
                    if (argCharacter == '?') {
                        try {
                            this.getUsage(this.usageOutputStream);
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        return;
                    }
                    if (argCharacter == 'V' && !this.shortIDMap.containsKey(Character.valueOf('V'))) {
                        this.usageOrVersionDisplayed = true;
                        try {
                            DirectoryServer.printVersion(this.usageOutputStream);
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        return;
                    }
                    Message message = UtilityMessages.ERR_ARGPARSER_NO_ARGUMENT_WITH_SHORT_ID.get(String.valueOf(argCharacter));
                    throw new ArgumentException(message);
                }
                a.setPresent(true);
                if (this.usageArgument != null && this.usageArgument.getName().equals(a.getName())) {
                    try {
                        this.getUsage(this.usageOutputStream);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    return;
                }
                if (a.needsValue()) {
                    MessageBuilder invalidReason;
                    if (argValue == null) {
                        if (i + 1 == numArguments) {
                            Message message = UtilityMessages.ERR_ARGPARSER_NO_VALUE_FOR_ARGUMENT_WITH_SHORT_ID.get(String.valueOf(argCharacter));
                            throw new ArgumentException(message);
                        }
                        argValue = rawArguments[++i];
                    }
                    if (!a.valueIsAcceptable(argValue, invalidReason = new MessageBuilder())) {
                        Message message = UtilityMessages.ERR_ARGPARSER_VALUE_UNACCEPTABLE_FOR_SHORT_ID.get(argValue, String.valueOf(argCharacter), invalidReason.toString());
                        throw new ArgumentException(message);
                    }
                    if (a.hasValue() && !a.isMultiValued()) {
                        Message message = UtilityMessages.ERR_ARGPARSER_NOT_MULTIVALUED_FOR_SHORT_ID.get(String.valueOf(argCharacter));
                        throw new ArgumentException(message);
                    }
                    a.addValue(argValue);
                    continue;
                }
                if (argValue == null) continue;
                int valueLength = argValue.length();
                for (int j = 0; j < valueLength; ++j) {
                    char c = argValue.charAt(j);
                    Argument b = this.shortIDMap.get(Character.valueOf(c));
                    if (b == null) {
                        Message message = UtilityMessages.ERR_ARGPARSER_NO_ARGUMENT_WITH_SHORT_ID.get(String.valueOf(argCharacter));
                        throw new ArgumentException(message);
                    }
                    if (b.needsValue()) {
                        Message message = UtilityMessages.ERR_ARGPARSER_CANT_MIX_ARGS_WITH_VALUES.get(String.valueOf(argCharacter), argValue, String.valueOf(c));
                        throw new ArgumentException(message);
                    }
                    b.setPresent(true);
                    if (this.usageArgument == null || !this.usageArgument.getName().equals(b.getName())) continue;
                    try {
                        this.getUsage(this.usageOutputStream);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    return;
                }
                continue;
            }
            if (this.allowsTrailingArguments) {
                inTrailingArgs = true;
                this.trailingArguments.add(arg);
                continue;
            }
            Message message = UtilityMessages.ERR_ARGPARSER_DISALLOWED_TRAILING_ARGUMENT.get(arg);
            throw new ArgumentException(message);
        }
        if (this.allowsTrailingArguments && this.minTrailingArguments > 0 && this.trailingArguments.size() < this.minTrailingArguments) {
            Message message = UtilityMessages.ERR_ARGPARSER_TOO_FEW_TRAILING_ARGUMENTS.get(this.minTrailingArguments);
            throw new ArgumentException(message);
        }
        for (Argument a : this.argumentList) {
            String value;
            if (a.isPresent() || !a.needsValue()) continue;
            boolean valueSet = false;
            if (argumentProperties != null && a.getPropertyName() != null && (value = argumentProperties.getProperty(a.getPropertyName())) != null) {
                a.addValue(value);
                valueSet = true;
            }
            if (!valueSet && a.getDefaultValue() != null) {
                a.addValue(a.getDefaultValue());
                valueSet = true;
            }
            if (valueSet || !a.isRequired()) continue;
            Message message = UtilityMessages.ERR_ARGPARSER_NO_VALUE_FOR_REQUIRED_ARG.get(a.getName());
            throw new ArgumentException(message);
        }
    }

    public void getUsage(StringBuilder buffer) {
        String scriptName;
        this.usageOrVersionDisplayed = true;
        if (this.toolDescription != null && this.toolDescription.length() > 0) {
            buffer.append(StaticUtils.wrapText(this.toolDescription.toString(), 79));
            buffer.append(ServerConstants.EOL);
        }
        if ((scriptName = System.getProperty("org.opends.server.scriptName")) == null || scriptName.length() == 0) {
            buffer.append("Usage:  java ");
            buffer.append(this.mainClassName);
        } else {
            buffer.append("Usage:  ");
            buffer.append(scriptName);
        }
        buffer.append(" {options}");
        if (this.allowsTrailingArguments) {
            if (this.trailingArgsDisplayName == null) {
                buffer.append(" {trailing-arguments}");
            } else {
                buffer.append(" ");
                buffer.append(this.trailingArgsDisplayName);
            }
        }
        buffer.append(ServerConstants.EOL);
        buffer.append(UtilityMessages.INFO_SUBCMDPARSER_WHERE_OPTIONS_INCLUDE.get());
        buffer.append(ServerConstants.EOL);
        if (!this.shortIDMap.containsKey(Character.valueOf('V'))) {
            buffer.append("-V, ");
        }
        buffer.append("--version");
        buffer.append(ServerConstants.EOL);
        buffer.append("    ");
        buffer.append(ToolMessages.INFO_DESCRIPTION_PRODUCT_VERSION.get());
        buffer.append(ServerConstants.EOL);
        Argument helpArgument = null;
        for (Argument a : this.argumentList) {
            if (a.isHidden()) continue;
            if (this.usageArgument != null && this.usageArgument.getName().equals(a.getName())) {
                helpArgument = a;
                continue;
            }
            this.printArgumentUsage(a, buffer);
        }
        if (helpArgument != null) {
            this.printArgumentUsage(helpArgument, buffer);
        } else {
            buffer.append(ServerConstants.EOL);
            buffer.append("-?");
            buffer.append(ServerConstants.EOL);
        }
    }

    public String getUsage() {
        StringBuilder buffer = new StringBuilder();
        this.getUsage(buffer);
        return buffer.toString();
    }

    public void getUsage(OutputStream outputStream) throws IOException {
        StringBuilder buffer = new StringBuilder();
        this.getUsage(buffer);
        outputStream.write(StaticUtils.getBytes(buffer.toString()));
    }

    public boolean usageOrVersionDisplayed() {
        return this.usageOrVersionDisplayed;
    }

    private void printArgumentUsage(Argument a, StringBuilder buffer) {
        Character shortID = a.getShortIdentifier();
        String longID = a.getLongIdentifier();
        if (shortID != null) {
            int currentLength = buffer.length();
            if (this.usageArgument.getName().equals(a.getName())) {
                buffer.append("-?, ");
            }
            buffer.append("-");
            buffer.append(shortID.charValue());
            if (a.needsValue() && longID == null) {
                buffer.append(" ");
                buffer.append(a.getValuePlaceholder());
            }
            if (longID != null) {
                int lineLength;
                StringBuilder newBuffer = new StringBuilder();
                newBuffer.append(", --");
                newBuffer.append(longID);
                if (a.needsValue()) {
                    newBuffer.append(" ");
                    newBuffer.append(a.getValuePlaceholder());
                }
                if ((lineLength = buffer.length() - currentLength + newBuffer.length()) > 80) {
                    buffer.append(ServerConstants.EOL);
                    buffer.append(newBuffer.toString());
                } else {
                    buffer.append(newBuffer.toString());
                }
            }
            buffer.append(ServerConstants.EOL);
        } else if (longID != null) {
            if (this.usageArgument.getName().equals(a.getName())) {
                buffer.append("-?, ");
            }
            buffer.append("--");
            buffer.append(longID);
            if (a.needsValue()) {
                buffer.append(" ");
                buffer.append(a.getValuePlaceholder());
            }
            buffer.append(ServerConstants.EOL);
        }
        Message description = a.getDescription();
        if (description.length() <= 75) {
            buffer.append("    ");
            buffer.append(description);
            buffer.append(ServerConstants.EOL);
        } else {
            String s = description.toString();
            while (s.length() > 75) {
                int spacePos = s.lastIndexOf(32, 75);
                if (spacePos > 0) {
                    buffer.append("    ");
                    buffer.append(s.substring(0, spacePos).trim());
                    s = s.substring(spacePos + 1).trim();
                    buffer.append(ServerConstants.EOL);
                    continue;
                }
                spacePos = s.indexOf(32);
                if (spacePos > 0) {
                    buffer.append("    ");
                    buffer.append(s.substring(0, spacePos).trim());
                    s = s.substring(spacePos + 1).trim();
                    buffer.append(ServerConstants.EOL);
                    continue;
                }
                buffer.append("    ");
                buffer.append(s);
                s = "";
                buffer.append(ServerConstants.EOL);
            }
            if (s.length() > 0) {
                buffer.append("    ");
                buffer.append(s);
                buffer.append(ServerConstants.EOL);
            }
        }
    }
}

