/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.util;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.LinkedList;
import org.opends.server.types.OperatingSystem;
import org.opends.server.types.PublicAPI;
import org.opends.server.types.StabilityLevel;

@PublicAPI(stability=StabilityLevel.VOLATILE, mayInstantiate=false, mayExtend=false, mayInvoke=true)
public class SetupUtils {
    public static final String IS_WEBSTART = "org.opends.quicksetup.iswebstart";
    public static final String LAZY_JAR_URLS = "org.opends.quicksetup.lazyjarurls";
    public static final String ZIP_FILE_NAME = "org.opends.quicksetup.zipfilename";

    public static File createTemplateFile(String baseDN, int numEntries) throws IOException {
        File templateFile = File.createTempFile("opends-install", ".template");
        templateFile.deleteOnExit();
        LinkedList<String> lines = new LinkedList<String>();
        lines.add("define suffix=" + baseDN);
        if (numEntries > 0) {
            lines.add("define numusers=" + numEntries);
        }
        lines.add("");
        lines.add("branch: [suffix]");
        lines.add("");
        lines.add("branch: ou=People,[suffix]");
        if (numEntries > 0) {
            lines.add("subordinateTemplate: person:[numusers]");
            lines.add("");
            lines.add("template: person");
            lines.add("rdnAttr: uid");
            lines.add("objectClass: top");
            lines.add("objectClass: person");
            lines.add("objectClass: organizationalPerson");
            lines.add("objectClass: inetOrgPerson");
            lines.add("givenName: <first>");
            lines.add("sn: <last>");
            lines.add("cn: {givenName} {sn}");
            lines.add("initials: {givenName:1}<random:chars:ABCDEFGHIJKLMNOPQRSTUVWXYZ:1>{sn:1}");
            lines.add("employeeNumber: <sequential:0>");
            lines.add("uid: user.{employeeNumber}");
            lines.add("mail: {uid}@maildomain.net");
            lines.add("userPassword: password");
            lines.add("telephoneNumber: <random:telephone>");
            lines.add("homePhone: <random:telephone>");
            lines.add("pager: <random:telephone>");
            lines.add("mobile: <random:telephone>");
            lines.add("street: <random:numeric:5> <file:streets> Street");
            lines.add("l: <file:cities>");
            lines.add("st: <file:states>");
            lines.add("postalCode: <random:numeric:5>");
            lines.add("postalAddress: {cn}${street}${l}, {st}  {postalCode}");
            lines.add("description: This is the description for {cn}.");
        }
        BufferedWriter writer = new BufferedWriter(new FileWriter(templateFile));
        for (String line : lines) {
            writer.write(line);
            writer.newLine();
        }
        writer.flush();
        writer.close();
        return templateFile;
    }

    public static boolean isMacOS() {
        return OperatingSystem.MACOS == SetupUtils.getOperatingSystem();
    }

    public static boolean isUnix() {
        return OperatingSystem.isUNIXBased(SetupUtils.getOperatingSystem());
    }

    public static boolean isWindows() {
        return OperatingSystem.WINDOWS == SetupUtils.getOperatingSystem();
    }

    public static boolean isVista() {
        String os = System.getProperty("os.name");
        boolean isVista = os != null ? SetupUtils.isWindows() && os.toLowerCase().indexOf("vista") != -1 : false;
        return isVista;
    }

    public static String getOSString() {
        return SetupUtils.getOperatingSystem().toString();
    }

    private static OperatingSystem getOperatingSystem() {
        return OperatingSystem.forName(System.getProperty("os.name"));
    }

    public static File writeSetJavaHome(String serverRoot) throws IOException {
        File setJavaHomeFile;
        String javaHome = System.getenv("JAVA_HOME");
        if (javaHome == null || javaHome.length() == 0) {
            javaHome = System.getProperty("java.home");
        }
        File libDirectory = new File(serverRoot, "lib");
        if (SetupUtils.isWindows()) {
            setJavaHomeFile = new File(libDirectory, "set-java-home.bat");
            if (setJavaHomeFile.exists()) {
                return setJavaHomeFile;
            }
            BufferedWriter writer = new BufferedWriter(new FileWriter(setJavaHomeFile));
            writer.write("set JAVA_HOME=" + javaHome);
            writer.newLine();
            writer.close();
        } else {
            setJavaHomeFile = new File(libDirectory, "set-java-home");
            if (setJavaHomeFile.exists()) {
                return setJavaHomeFile;
            }
            BufferedWriter writer = new BufferedWriter(new FileWriter(setJavaHomeFile));
            writer.write("#!/bin/sh");
            writer.newLine();
            writer.newLine();
            writer.write("JAVA_HOME=" + javaHome);
            writer.newLine();
            writer.write("export JAVA_HOME");
            writer.newLine();
            writer.close();
        }
        return setJavaHomeFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean canUseAsPort(String hostname, int port) {
        boolean canUseAsPort = false;
        ServerSocket serverSocket = null;
        try {
            InetSocketAddress socketAddress = new InetSocketAddress(hostname, port);
            serverSocket = new ServerSocket();
            if (!SetupUtils.isWindows()) {
                serverSocket.setReuseAddress(true);
            }
            serverSocket.bind(socketAddress);
            canUseAsPort = true;
            serverSocket.close();
            Socket s = null;
            s = new Socket();
            s.connect(socketAddress, 1000);
            canUseAsPort = false;
            if (s == null) return canUseAsPort;
            try {
                s.close();
                return canUseAsPort;
            }
            catch (Throwable t) {}
            return canUseAsPort;
            catch (Throwable t) {
                if (s == null) return canUseAsPort;
                try {
                    s.close();
                    return canUseAsPort;
                }
                catch (Throwable t2) {}
                return canUseAsPort;
                catch (Throwable throwable) {
                    if (s == null) throw throwable;
                    try {
                        s.close();
                        throw throwable;
                    }
                    catch (Throwable t3) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
        }
        catch (IOException ex) {
            canUseAsPort = false;
            return canUseAsPort;
        }
        finally {
            try {
                if (serverSocket != null) {
                    serverSocket.close();
                }
            }
            catch (Exception ex) {}
        }
    }

    public static boolean canUseAsPort(int port) {
        return SetupUtils.canUseAsPort("localhost", port);
    }

    public static boolean isPriviledgedPort(int port) {
        return port <= 1024 && !SetupUtils.isWindows();
    }

    public static int getDefaultJMXPort() {
        return 1689;
    }

    public static boolean isWebStart() {
        return "true".equals(System.getProperty(IS_WEBSTART));
    }
}

