/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.util;

import org.opends.server.types.DN;
import org.opends.server.types.PublicAPI;
import org.opends.server.types.RDN;
import org.opends.server.types.StabilityLevel;
import org.opends.server.util.ChangeOperationType;
import org.opends.server.util.ChangeRecordEntry;
import org.opends.server.util.Validator;

@PublicAPI(stability=StabilityLevel.VOLATILE, mayInstantiate=true, mayExtend=false, mayInvoke=true)
public final class ModifyDNChangeRecordEntry
extends ChangeRecordEntry {
    private final RDN newRDN;
    private final DN newSuperiorDN;
    private final boolean deleteOldRDN;

    public ModifyDNChangeRecordEntry(DN dn, RDN newRDN, boolean deleteOldRDN, DN newSuperiorDN) {
        super(dn);
        Validator.ensureNotNull(newRDN);
        this.newSuperiorDN = newSuperiorDN;
        this.newRDN = newRDN;
        this.deleteOldRDN = deleteOldRDN;
    }

    public RDN getNewRDN() {
        return this.newRDN;
    }

    public DN getNewSuperiorDN() {
        return this.newSuperiorDN;
    }

    public boolean deleteOldRDN() {
        return this.deleteOldRDN;
    }

    public ChangeOperationType getChangeOperationType() {
        return ChangeOperationType.MODIFY_DN;
    }
}

