/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import org.opends.messages.Message;
import org.opends.messages.MessageBuilder;
import org.opends.messages.UtilityMessages;
import org.opends.server.api.plugin.LDIFPluginResult;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.PluginConfigManager;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.protocols.ldap.LDAPAttribute;
import org.opends.server.protocols.ldap.LDAPModification;
import org.opends.server.types.AcceptRejectWarn;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.ByteString;
import org.opends.server.types.DN;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.Entry;
import org.opends.server.types.LDIFImportConfig;
import org.opends.server.types.ModificationType;
import org.opends.server.types.ObjectClass;
import org.opends.server.types.PublicAPI;
import org.opends.server.types.RDN;
import org.opends.server.types.RawModification;
import org.opends.server.types.StabilityLevel;
import org.opends.server.util.AddChangeRecordEntry;
import org.opends.server.util.Base64;
import org.opends.server.util.ChangeRecordEntry;
import org.opends.server.util.DeleteChangeRecordEntry;
import org.opends.server.util.LDIFException;
import org.opends.server.util.ModifyChangeRecordEntry;
import org.opends.server.util.ModifyDNChangeRecordEntry;
import org.opends.server.util.StaticUtils;
import org.opends.server.util.Validator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@PublicAPI(stability=StabilityLevel.UNCOMMITTED, mayInstantiate=true, mayExtend=false, mayInvoke=true)
public final class LDIFReader {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private BufferedReader reader;
    private byte[] buffer;
    private LDIFImportConfig importConfig;
    private LinkedList<StringBuilder> lastEntryBodyLines;
    private LinkedList<StringBuilder> lastEntryHeaderLines;
    private long entriesIgnored;
    private long entriesRead;
    private long entriesRejected;
    private long lastEntryLineNumber;
    private long lineNumber;
    private PluginConfigManager pluginConfigManager;

    public LDIFReader(LDIFImportConfig importConfig) throws IOException {
        Validator.ensureNotNull(importConfig);
        this.importConfig = importConfig;
        this.reader = importConfig.getReader();
        this.buffer = new byte[4096];
        this.entriesRead = 0L;
        this.entriesIgnored = 0L;
        this.entriesRejected = 0L;
        this.lineNumber = 0L;
        this.lastEntryLineNumber = -1L;
        this.lastEntryBodyLines = new LinkedList();
        this.lastEntryHeaderLines = new LinkedList();
        this.pluginConfigManager = DirectoryServer.getPluginConfigManager();
    }

    public Entry readEntry() throws IOException, LDIFException {
        return this.readEntry(this.importConfig.validateSchema());
    }

    public Entry readEntry(boolean checkSchema) throws IOException, LDIFException {
        MessageBuilder invalidReason;
        Message message;
        Entry entry;
        DN entryDN;
        LinkedList<StringBuilder> lines;
        while (true) {
            LDIFPluginResult pluginResult;
            if ((lines = this.readEntryLines()) == null) {
                return null;
            }
            this.lastEntryBodyLines = lines;
            this.lastEntryHeaderLines = new LinkedList();
            entryDN = this.readDN(lines);
            if (entryDN == null) continue;
            if (!this.importConfig.includeEntry(entryDN)) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugInfo("Skipping entry %s because the DN is not one that should be included based on the include and exclude branches.", entryDN);
                }
                ++this.entriesRead;
                Message message2 = UtilityMessages.ERR_LDIF_SKIP.get(String.valueOf(entryDN));
                this.logToSkipWriter(lines, message2);
                ++this.entriesIgnored;
                continue;
            }
            ++this.entriesRead;
            HashMap<ObjectClass, String> objectClasses = new HashMap<ObjectClass, String>();
            HashMap<AttributeType, List<Attribute>> userAttributes = new HashMap<AttributeType, List<Attribute>>();
            HashMap<AttributeType, List<Attribute>> operationalAttributes = new HashMap<AttributeType, List<Attribute>>();
            try {
                for (StringBuilder line : lines) {
                    this.readAttribute(lines, line, entryDN, objectClasses, userAttributes, operationalAttributes, checkSchema);
                }
            }
            catch (LDIFException e) {
                ++this.entriesRejected;
                throw e;
            }
            entry = new Entry(entryDN, objectClasses, userAttributes, operationalAttributes);
            TRACER.debugProtocolElement(DebugLogLevel.VERBOSE, entry);
            try {
                if (!this.importConfig.includeEntry(entry)) {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugInfo("Skipping entry %s because the DN is not one that should be included based on the include and exclude filters.", entryDN);
                    }
                    Message message3 = UtilityMessages.ERR_LDIF_SKIP.get(String.valueOf(entryDN));
                    this.logToSkipWriter(lines, message3);
                    ++this.entriesIgnored;
                    continue;
                }
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                message = UtilityMessages.ERR_LDIF_COULD_NOT_EVALUATE_FILTERS_FOR_IMPORT.get(String.valueOf(entry.getDN()), this.lastEntryLineNumber, String.valueOf(e));
                throw new LDIFException(message, this.lastEntryLineNumber, true, e);
            }
            if (!this.importConfig.invokeImportPlugins() || (pluginResult = this.pluginConfigManager.invokeLDIFImportPlugins(this.importConfig, entry)).continueEntryProcessing()) break;
            message = UtilityMessages.ERR_LDIF_SKIP.get(String.valueOf(entryDN));
            this.logToSkipWriter(lines, message);
            ++this.entriesIgnored;
        }
        if (checkSchema && !entry.conformsToSchema(null, false, true, false, invalidReason = new MessageBuilder())) {
            message = UtilityMessages.ERR_LDIF_SCHEMA_VIOLATION.get(String.valueOf(entryDN), this.lastEntryLineNumber, invalidReason.toString());
            this.logToRejectWriter(lines, message);
            ++this.entriesRejected;
            throw new LDIFException(message, this.lastEntryLineNumber, true);
        }
        return entry;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ChangeRecordEntry readChangeRecord(boolean defaultAdd) throws IOException, LDIFException {
        LinkedList<StringBuilder> lines;
        DN entryDN;
        do {
            if ((lines = this.readEntryLines()) != null) continue;
            return null;
        } while ((entryDN = this.readDN(lines)) == null);
        String changeType = this.readChangeType(lines);
        ChangeRecordEntry entry = null;
        if (changeType != null) {
            if (changeType.equals("add")) {
                return this.parseAddChangeRecordEntry(entryDN, lines);
            }
            if (changeType.equals("delete")) {
                return this.parseDeleteChangeRecordEntry(entryDN, lines);
            }
            if (changeType.equals("modify")) {
                return this.parseModifyChangeRecordEntry(entryDN, lines);
            }
            if (changeType.equals("modrdn")) {
                return this.parseModifyDNChangeRecordEntry(entryDN, lines);
            }
            if (changeType.equals("moddn")) {
                return this.parseModifyDNChangeRecordEntry(entryDN, lines);
            }
            Message message = UtilityMessages.ERR_LDIF_INVALID_CHANGETYPE_ATTRIBUTE.get(changeType, "add, delete, modify, moddn, modrdn");
            throw new LDIFException(message, this.lastEntryLineNumber, false);
        }
        if (defaultAdd) {
            return this.parseAddChangeRecordEntry(entryDN, lines);
        }
        Message message = UtilityMessages.ERR_LDIF_INVALID_CHANGETYPE_ATTRIBUTE.get(null, "add, delete, modify, moddn, modrdn");
        throw new LDIFException(message, this.lastEntryLineNumber, false);
    }

    private LinkedList<StringBuilder> readEntryLines() throws IOException, LDIFException {
        LinkedList<StringBuilder> lines = new LinkedList<StringBuilder>();
        int lastLine = -1;
        while (true) {
            String line = this.reader.readLine();
            ++this.lineNumber;
            if (line == null) {
                if (!lines.isEmpty()) break;
                this.reader = this.importConfig.nextReader();
                if (this.reader == null) {
                    return null;
                }
                return this.readEntryLines();
            }
            if (line.length() == 0) {
                if (!lines.isEmpty()) break;
                continue;
            }
            if (line.charAt(0) == '#') continue;
            if (line.charAt(0) == ' ' || line.charAt(0) == '\t') {
                if (lastLine >= 0) {
                    lines.get(lastLine).append(line.substring(1));
                    continue;
                }
                Message message = UtilityMessages.ERR_LDIF_INVALID_LEADING_SPACE.get(this.lineNumber, line);
                this.logToRejectWriter(lines, message);
                throw new LDIFException(message, this.lineNumber, false);
            }
            if (lines.isEmpty()) {
                this.lastEntryLineNumber = this.lineNumber;
            }
            lines.add(new StringBuilder(line));
            ++lastLine;
        }
        return lines;
    }

    private DN readDN(LinkedList<StringBuilder> lines) throws LDIFException {
        int pos;
        if (lines.isEmpty()) {
            return null;
        }
        StringBuilder line = lines.remove();
        this.lastEntryHeaderLines.add(line);
        int colonPos = line.indexOf(":");
        if (colonPos <= 0) {
            Message message = UtilityMessages.ERR_LDIF_NO_ATTR_NAME.get(this.lastEntryLineNumber, line.toString());
            this.logToRejectWriter(lines, message);
            throw new LDIFException(message, this.lastEntryLineNumber, true);
        }
        String attrName = StaticUtils.toLowerCase(line.substring(0, colonPos));
        if (attrName.equals("version")) {
            return this.readDN(lines);
        }
        if (!attrName.equals("dn")) {
            Message message = UtilityMessages.ERR_LDIF_NO_DN.get(this.lastEntryLineNumber, line.toString());
            this.logToRejectWriter(lines, message);
            throw new LDIFException(message, this.lastEntryLineNumber, true);
        }
        int length = line.length();
        if (colonPos == length - 1) {
            return DN.nullDN();
        }
        if (line.charAt(colonPos + 1) == ':') {
            String dnStr;
            int pos2;
            for (pos2 = colonPos + 2; pos2 < length && line.charAt(pos2) == ' '; ++pos2) {
            }
            String encodedDNStr = line.substring(pos2);
            try {
                dnStr = new String(Base64.decode(encodedDNStr), "UTF-8");
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                Message message = UtilityMessages.ERR_LDIF_COULD_NOT_BASE64_DECODE_DN.get(this.lastEntryLineNumber, line, String.valueOf(e));
                this.logToRejectWriter(lines, message);
                throw new LDIFException(message, this.lastEntryLineNumber, true, e);
            }
            try {
                return DN.decode(dnStr);
            }
            catch (DirectoryException de) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, de);
                }
                Message message = UtilityMessages.ERR_LDIF_INVALID_DN.get(this.lastEntryLineNumber, line.toString(), de.getMessageObject());
                this.logToRejectWriter(lines, message);
                throw new LDIFException(message, this.lastEntryLineNumber, true, de);
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                Message message = UtilityMessages.ERR_LDIF_INVALID_DN.get(this.lastEntryLineNumber, line.toString(), String.valueOf(e));
                this.logToRejectWriter(lines, message);
                throw new LDIFException(message, this.lastEntryLineNumber, true, e);
            }
        }
        for (pos = colonPos + 1; pos < length && line.charAt(pos) == ' '; ++pos) {
        }
        String dnString = line.substring(pos);
        try {
            return DN.decode(dnString);
        }
        catch (DirectoryException de) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, de);
            }
            Message message = UtilityMessages.ERR_LDIF_INVALID_DN.get(this.lastEntryLineNumber, line.toString(), de.getMessageObject());
            this.logToRejectWriter(lines, message);
            throw new LDIFException(message, this.lastEntryLineNumber, true, de);
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = UtilityMessages.ERR_LDIF_INVALID_DN.get(this.lastEntryLineNumber, line.toString(), String.valueOf(e));
            this.logToRejectWriter(lines, message);
            throw new LDIFException(message, this.lastEntryLineNumber, true, e);
        }
    }

    private String readChangeType(LinkedList<StringBuilder> lines) throws LDIFException {
        int pos;
        if (lines.isEmpty()) {
            return null;
        }
        StringBuilder line = lines.get(0);
        this.lastEntryHeaderLines.add(line);
        int colonPos = line.indexOf(":");
        if (colonPos <= 0) {
            Message message = UtilityMessages.ERR_LDIF_NO_ATTR_NAME.get(this.lastEntryLineNumber, line.toString());
            this.logToRejectWriter(lines, message);
            throw new LDIFException(message, this.lastEntryLineNumber, true);
        }
        String attrName = StaticUtils.toLowerCase(line.substring(0, colonPos));
        if (!attrName.equals("changetype")) {
            return null;
        }
        lines.remove();
        int length = line.length();
        if (colonPos == length - 1) {
            Message message = UtilityMessages.ERR_LDIF_INVALID_CHANGETYPE_ATTRIBUTE.get(null, "add, delete, modify, moddn, modrdn");
            throw new LDIFException(message, this.lastEntryLineNumber, false);
        }
        if (line.charAt(colonPos + 1) == ':') {
            String changeTypeStr;
            int pos2;
            for (pos2 = colonPos + 2; pos2 < length && line.charAt(pos2) == ' '; ++pos2) {
            }
            String encodedChangeTypeStr = line.substring(pos2);
            try {
                changeTypeStr = new String(Base64.decode(encodedChangeTypeStr), "UTF-8");
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                Message message = UtilityMessages.ERR_LDIF_COULD_NOT_BASE64_DECODE_DN.get(this.lastEntryLineNumber, line, String.valueOf(e));
                this.logToRejectWriter(lines, message);
                throw new LDIFException(message, this.lastEntryLineNumber, true, e);
            }
            return changeTypeStr;
        }
        for (pos = colonPos + 1; pos < length && line.charAt(pos) == ' '; ++pos) {
        }
        String changeTypeString = line.substring(pos);
        return changeTypeString;
    }

    private void readAttribute(LinkedList<StringBuilder> lines, StringBuilder line, DN entryDN, HashMap<ObjectClass, String> objectClasses, HashMap<AttributeType, List<Attribute>> userAttributes, HashMap<AttributeType, List<Attribute>> operationalAttributes, boolean checkSchema) throws LDIFException {
        int colonPos = this.parseColonPosition(lines, line);
        String attrDescr = line.substring(0, colonPos);
        Attribute attribute = LDIFReader.parseAttrDescription(attrDescr);
        String attrName = attribute.getName();
        String lowerName = StaticUtils.toLowerCase(attrName);
        LinkedHashSet<String> options = attribute.getOptions();
        ASN1OctetString value = this.parseSingleValue(lines, line, entryDN, colonPos, attrName);
        if (lowerName.equals("objectclass")) {
            if (!this.importConfig.includeObjectClasses()) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugVerbose("Skipping objectclass %s for entry %s due to the import configuration.", value, entryDN);
                }
                return;
            }
            String ocName = value.stringValue();
            String lowerOCName = StaticUtils.toLowerCase(ocName);
            ObjectClass objectClass = DirectoryServer.getObjectClass(lowerOCName);
            if (objectClass == null) {
                objectClass = DirectoryServer.getDefaultObjectClass(ocName);
            }
            if (objectClasses.containsKey(objectClass)) {
                ErrorLogger.logError(UtilityMessages.WARN_LDIF_DUPLICATE_OBJECTCLASS.get(String.valueOf(entryDN), this.lastEntryLineNumber, ocName));
            } else {
                objectClasses.put(objectClass, ocName);
            }
        } else {
            List<Attribute> attrList;
            AttributeType attrType = DirectoryServer.getAttributeType(lowerName);
            if (attrType == null) {
                attrType = DirectoryServer.getDefaultAttributeType(attrName);
            }
            if (!this.importConfig.includeAttribute(attrType)) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugVerbose("Skipping attribute %s for entry %s due to the import configuration.", attrName, entryDN);
                }
                return;
            }
            if (checkSchema && DirectoryServer.getSyntaxEnforcementPolicy() != AcceptRejectWarn.ACCEPT) {
                MessageBuilder invalidReason = new MessageBuilder();
                if (!attrType.getSyntax().valueIsAcceptable(value, invalidReason)) {
                    Message message = UtilityMessages.WARN_LDIF_VALUE_VIOLATES_SYNTAX.get(String.valueOf(entryDN), this.lastEntryLineNumber, value.stringValue(), attrName, invalidReason.toString());
                    if (DirectoryServer.getSyntaxEnforcementPolicy() == AcceptRejectWarn.WARN) {
                        ErrorLogger.logError(message);
                    } else {
                        this.logToRejectWriter(lines, message);
                        throw new LDIFException(message, this.lastEntryLineNumber, true);
                    }
                }
            }
            AttributeValue attributeValue = new AttributeValue(attrType, (ByteString)value);
            if (attrType.isOperational()) {
                attrList = operationalAttributes.get(attrType);
                if (attrList == null) {
                    LinkedHashSet<AttributeValue> valueSet = new LinkedHashSet<AttributeValue>();
                    valueSet.add(attributeValue);
                    attrList = new ArrayList<Attribute>();
                    attrList.add(new Attribute(attrType, attrName, options, valueSet));
                    operationalAttributes.put(attrType, attrList);
                    return;
                }
            } else {
                attrList = userAttributes.get(attrType);
                if (attrList == null) {
                    LinkedHashSet<AttributeValue> valueSet = new LinkedHashSet<AttributeValue>();
                    valueSet.add(attributeValue);
                    attrList = new ArrayList<Attribute>();
                    attrList.add(new Attribute(attrType, attrName, options, valueSet));
                    userAttributes.put(attrType, attrList);
                    return;
                }
            }
            for (Attribute a : attrList) {
                if (!a.optionsEqual(options)) continue;
                LinkedHashSet<AttributeValue> valueSet = a.getValues();
                if (valueSet.contains(attributeValue)) {
                    if (!checkSchema) {
                        for (AttributeValue v : valueSet) {
                            if (!v.getValue().equals(attributeValue.getValue())) continue;
                            Message message = UtilityMessages.WARN_LDIF_DUPLICATE_ATTR.get(String.valueOf(entryDN), this.lastEntryLineNumber, attrName, value.stringValue());
                            this.logToRejectWriter(lines, message);
                            throw new LDIFException(message, this.lastEntryLineNumber, true);
                        }
                    } else {
                        Message message = UtilityMessages.WARN_LDIF_DUPLICATE_ATTR.get(String.valueOf(entryDN), this.lastEntryLineNumber, attrName, value.stringValue());
                        this.logToRejectWriter(lines, message);
                        throw new LDIFException(message, this.lastEntryLineNumber, true);
                    }
                }
                if (attrType.isSingleValue() && !valueSet.isEmpty() && checkSchema) {
                    Message message = UtilityMessages.ERR_LDIF_MULTIPLE_VALUES_FOR_SINGLE_VALUED_ATTR.get(String.valueOf(entryDN), this.lastEntryLineNumber, attrName);
                    this.logToRejectWriter(lines, message);
                    throw new LDIFException(message, this.lastEntryLineNumber, true);
                }
                valueSet.add(attributeValue);
                return;
            }
            LinkedHashSet<AttributeValue> valueSet = new LinkedHashSet<AttributeValue>();
            valueSet.add(attributeValue);
            attrList.add(new Attribute(attrType, attrName, options, valueSet));
            return;
        }
    }

    private Attribute readSingleValueAttribute(LinkedList<StringBuilder> lines, StringBuilder line, DN entryDN, String attributeName) throws LDIFException {
        Attribute expectedAttr;
        int colonPos = this.parseColonPosition(lines, line);
        String attrDescr = line.substring(0, colonPos);
        Attribute attribute = LDIFReader.parseAttrDescription(attrDescr);
        String attrName = attribute.getName();
        if (attributeName != null && !attribute.equals(expectedAttr = LDIFReader.parseAttrDescription(attributeName))) {
            Message message = UtilityMessages.ERR_LDIF_INVALID_CHANGERECORD_ATTRIBUTE.get(attrDescr, attributeName);
            throw new LDIFException(message, this.lastEntryLineNumber, false);
        }
        ASN1OctetString value = this.parseSingleValue(lines, line, entryDN, colonPos, attrName);
        AttributeType attrType = attribute.getAttributeType();
        AttributeValue attributeValue = new AttributeValue(attrType, (ByteString)value);
        attribute.getValues().add(attributeValue);
        return attribute;
    }

    public long getLastEntryLineNumber() {
        return this.lastEntryLineNumber;
    }

    public void rejectLastEntry(Message message) {
        block6: {
            ++this.entriesRejected;
            BufferedWriter rejectWriter = this.importConfig.getRejectWriter();
            if (rejectWriter != null) {
                try {
                    if (message != null && message.length() > 0) {
                        rejectWriter.write("# ");
                        rejectWriter.write(message.toString());
                        rejectWriter.newLine();
                    }
                    for (StringBuilder sb : this.lastEntryHeaderLines) {
                        rejectWriter.write(sb.toString());
                        rejectWriter.newLine();
                    }
                    for (StringBuilder sb : this.lastEntryBodyLines) {
                        rejectWriter.write(sb.toString());
                        rejectWriter.newLine();
                    }
                    rejectWriter.newLine();
                }
                catch (Exception e) {
                    if (!DebugLogger.debugEnabled()) break block6;
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
            }
        }
    }

    public void close() {
        this.importConfig.close();
    }

    private static Attribute parseAttrDescription(String attrDescr) {
        LinkedHashSet<String> options;
        String attrName;
        int semicolonPos = attrDescr.indexOf(59);
        if (semicolonPos > 0) {
            String option;
            attrName = attrDescr.substring(0, semicolonPos);
            options = new LinkedHashSet<String>();
            int nextPos = attrDescr.indexOf(59, semicolonPos + 1);
            while (nextPos > 0) {
                option = attrDescr.substring(semicolonPos + 1, nextPos);
                if (option.length() <= 0) continue;
                options.add(option);
                semicolonPos = nextPos;
                nextPos = attrDescr.indexOf(59, semicolonPos + 1);
            }
            option = attrDescr.substring(semicolonPos + 1);
            if (option.length() > 0) {
                options.add(option);
            }
        } else {
            attrName = attrDescr;
            options = null;
        }
        String lowerName = StaticUtils.toLowerCase(attrName);
        AttributeType attrType = DirectoryServer.getAttributeType(lowerName);
        if (attrType == null) {
            attrType = DirectoryServer.getDefaultAttributeType(attrName);
        }
        return new Attribute(attrType, attrName, options, null);
    }

    public long getEntriesRead() {
        return this.entriesRead;
    }

    public long getEntriesIgnored() {
        return this.entriesIgnored;
    }

    public long getEntriesRejected() {
        return this.entriesRejected;
    }

    private ChangeRecordEntry parseModifyDNChangeRecordEntry(DN entryDN, LinkedList<StringBuilder> lines) throws LDIFException {
        DN newSuperiorDN = null;
        RDN newRDN = null;
        boolean deleteOldRDN = false;
        if (lines.isEmpty()) {
            Message message = UtilityMessages.ERR_LDIF_NO_MOD_DN_ATTRIBUTES.get();
            throw new LDIFException(message, this.lineNumber, true);
        }
        StringBuilder line = lines.remove();
        String rdnStr = this.getModifyDNAttributeValue(lines, line, entryDN, "newrdn");
        try {
            newRDN = RDN.decode(rdnStr);
        }
        catch (DirectoryException de) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, de);
            }
            Message message = UtilityMessages.ERR_LDIF_INVALID_DN.get(this.lineNumber, line.toString(), de.getMessageObject());
            throw new LDIFException(message, this.lineNumber, true);
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = UtilityMessages.ERR_LDIF_INVALID_DN.get(this.lineNumber, line.toString(), e.getMessage());
            throw new LDIFException(message, this.lineNumber, true);
        }
        if (lines.isEmpty()) {
            Message message = UtilityMessages.ERR_LDIF_NO_DELETE_OLDRDN_ATTRIBUTE.get();
            throw new LDIFException(message, this.lineNumber, true);
        }
        ++this.lineNumber;
        line = lines.remove();
        String delStr = this.getModifyDNAttributeValue(lines, line, entryDN, "deleteoldrdn");
        if (delStr.equalsIgnoreCase("false") || delStr.equalsIgnoreCase("no") || delStr.equalsIgnoreCase("0")) {
            deleteOldRDN = false;
        } else if (delStr.equalsIgnoreCase("true") || delStr.equalsIgnoreCase("yes") || delStr.equalsIgnoreCase("1")) {
            deleteOldRDN = true;
        } else {
            Message message = UtilityMessages.ERR_LDIF_INVALID_DELETE_OLDRDN_ATTRIBUTE.get(delStr);
            throw new LDIFException(message, this.lineNumber, true);
        }
        if (!lines.isEmpty()) {
            ++this.lineNumber;
            line = lines.remove();
            String dnStr = this.getModifyDNAttributeValue(lines, line, entryDN, "newsuperior");
            try {
                newSuperiorDN = DN.decode(dnStr);
            }
            catch (DirectoryException de) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, de);
                }
                Message message = UtilityMessages.ERR_LDIF_INVALID_DN.get(this.lineNumber, line.toString(), de.getMessageObject());
                throw new LDIFException(message, this.lineNumber, true);
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                Message message = UtilityMessages.ERR_LDIF_INVALID_DN.get(this.lineNumber, line.toString(), e.getMessage());
                throw new LDIFException(message, this.lineNumber, true);
            }
        }
        return new ModifyDNChangeRecordEntry(entryDN, newRDN, deleteOldRDN, newSuperiorDN);
    }

    private String getModifyDNAttributeValue(LinkedList<StringBuilder> lines, StringBuilder line, DN entryDN, String attributeName) throws LDIFException {
        Attribute attr = this.readSingleValueAttribute(lines, line, entryDN, attributeName);
        LinkedHashSet<AttributeValue> values = attr.getValues();
        Object[] vals = values.toArray();
        return ((AttributeValue)vals[0]).getStringValue();
    }

    private ChangeRecordEntry parseModifyChangeRecordEntry(DN entryDN, LinkedList<StringBuilder> lines) throws LDIFException {
        ArrayList<RawModification> modifications = new ArrayList<RawModification>();
        while (!lines.isEmpty()) {
            ModificationType modType = null;
            StringBuilder line = lines.remove();
            Attribute attr = this.readSingleValueAttribute(lines, line, entryDN, null);
            String name = attr.getName();
            LinkedHashSet<AttributeValue> values = attr.getValues();
            String attrDescr = ((AttributeValue)values.iterator().next()).getStringValue();
            String lowerName = StaticUtils.toLowerCase(name);
            if (lowerName.equals("add")) {
                modType = ModificationType.ADD;
            } else if (lowerName.equals("delete")) {
                modType = ModificationType.DELETE;
            } else if (lowerName.equals("replace")) {
                modType = ModificationType.REPLACE;
            } else if (lowerName.equals("increment")) {
                modType = ModificationType.INCREMENT;
            } else {
                Message message = UtilityMessages.ERR_LDIF_INVALID_MODIFY_ATTRIBUTE.get(name, "add, delete, replace, increment");
                throw new LDIFException(message, this.lineNumber, true);
            }
            Attribute modAttr = LDIFReader.parseAttrDescription(attrDescr);
            while (!lines.isEmpty() && !(line = lines.remove()).toString().equals("-")) {
                Attribute a = this.readSingleValueAttribute(lines, line, entryDN, attrDescr);
                modAttr.getValues().addAll(a.getValues());
            }
            LDAPAttribute ldapAttr = new LDAPAttribute(modAttr);
            LDAPModification mod = new LDAPModification(modType, ldapAttr);
            modifications.add(mod);
        }
        return new ModifyChangeRecordEntry(entryDN, modifications);
    }

    private ChangeRecordEntry parseDeleteChangeRecordEntry(DN entryDN, LinkedList<StringBuilder> lines) throws LDIFException {
        if (!lines.isEmpty()) {
            Message message = UtilityMessages.ERR_LDIF_INVALID_DELETE_ATTRIBUTES.get();
            throw new LDIFException(message, this.lineNumber, true);
        }
        return new DeleteChangeRecordEntry(entryDN);
    }

    private ChangeRecordEntry parseAddChangeRecordEntry(DN entryDN, LinkedList<StringBuilder> lines) throws LDIFException {
        HashMap<ObjectClass, String> objectClasses = new HashMap<ObjectClass, String>();
        HashMap<AttributeType, List<Attribute>> attributes = new HashMap<AttributeType, List<Attribute>>();
        for (StringBuilder line : lines) {
            this.readAttribute(lines, line, entryDN, objectClasses, attributes, attributes, this.importConfig.validateSchema());
        }
        AttributeType ocType = DirectoryServer.getObjectClassAttributeType();
        LinkedHashSet<AttributeValue> ocValues = new LinkedHashSet<AttributeValue>(objectClasses.size());
        for (String value : objectClasses.values()) {
            AttributeValue av = new AttributeValue(ocType, value);
            ocValues.add(av);
        }
        Attribute ocAttr = new Attribute(ocType, "objectClass", ocValues);
        ArrayList<Attribute> ocAttrList = new ArrayList<Attribute>(1);
        ocAttrList.add(ocAttr);
        attributes.put(ocType, ocAttrList);
        return new AddChangeRecordEntry(entryDN, attributes);
    }

    private int parseColonPosition(LinkedList<StringBuilder> lines, StringBuilder line) throws LDIFException {
        int colonPos = line.indexOf(":");
        if (colonPos <= 0) {
            Message message = UtilityMessages.ERR_LDIF_NO_ATTR_NAME.get(this.lastEntryLineNumber, line.toString());
            this.logToRejectWriter(lines, message);
            throw new LDIFException(message, this.lastEntryLineNumber, true);
        }
        return colonPos;
    }

    private ASN1OctetString parseSingleValue(LinkedList<StringBuilder> lines, StringBuilder line, DN entryDN, int colonPos, String attrName) throws LDIFException {
        ASN1OctetString value;
        int length = line.length();
        if (colonPos == length - 1) {
            value = new ASN1OctetString();
        } else {
            int pos;
            char c = line.charAt(colonPos + 1);
            if (c == ':') {
                int pos2;
                for (pos2 = colonPos + 2; pos2 < length && line.charAt(pos2) == ' '; ++pos2) {
                }
                try {
                    value = new ASN1OctetString(Base64.decode(line.substring(pos2)));
                }
                catch (Exception e) {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugCaught(DebugLogLevel.ERROR, e);
                    }
                    Message message = UtilityMessages.ERR_LDIF_COULD_NOT_BASE64_DECODE_ATTR.get(String.valueOf(entryDN), this.lastEntryLineNumber, line, String.valueOf(e));
                    this.logToRejectWriter(lines, message);
                    throw new LDIFException(message, this.lastEntryLineNumber, true, e);
                }
            }
            if (c == '<') {
                URL contentURL;
                int pos3;
                for (pos3 = colonPos + 2; pos3 < length && line.charAt(pos3) == ' '; ++pos3) {
                }
                try {
                    contentURL = new URL(line.substring(pos3));
                }
                catch (Exception e) {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugCaught(DebugLogLevel.ERROR, e);
                    }
                    Message message = UtilityMessages.ERR_LDIF_INVALID_URL.get(String.valueOf(entryDN), this.lastEntryLineNumber, String.valueOf(attrName), String.valueOf(e));
                    this.logToRejectWriter(lines, message);
                    throw new LDIFException(message, this.lastEntryLineNumber, true, e);
                }
                InputStream inputStream = null;
                ByteArrayOutputStream outputStream = null;
                try {
                    int bytesRead;
                    outputStream = new ByteArrayOutputStream();
                    inputStream = contentURL.openConnection().getInputStream();
                    while ((bytesRead = inputStream.read(this.buffer)) > 0) {
                        outputStream.write(this.buffer, 0, bytesRead);
                    }
                    value = new ASN1OctetString(outputStream.toByteArray());
                }
                catch (Exception e) {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugCaught(DebugLogLevel.ERROR, e);
                    }
                    Message message = UtilityMessages.ERR_LDIF_URL_IO_ERROR.get(String.valueOf(entryDN), this.lastEntryLineNumber, String.valueOf(attrName), String.valueOf(contentURL), String.valueOf(e));
                    this.logToRejectWriter(lines, message);
                    throw new LDIFException(message, this.lastEntryLineNumber, true, e);
                }
                finally {
                    if (outputStream != null) {
                        try {
                            outputStream.close();
                        }
                        catch (Exception e) {}
                    }
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Exception e) {}
                    }
                }
            }
            for (pos = colonPos + 1; pos < length && line.charAt(pos) == ' '; ++pos) {
            }
            value = new ASN1OctetString(line.substring(pos));
        }
        return value;
    }

    private void logToRejectWriter(LinkedList<StringBuilder> lines, Message message) {
        BufferedWriter rejectWriter = this.importConfig.getRejectWriter();
        if (rejectWriter != null) {
            this.logToWriter(rejectWriter, lines, message);
        }
    }

    private void logToSkipWriter(LinkedList<StringBuilder> lines, Message message) {
        BufferedWriter skipWriter = this.importConfig.getSkipWriter();
        if (skipWriter != null) {
            this.logToWriter(skipWriter, lines, message);
        }
    }

    private void logToWriter(BufferedWriter writer, LinkedList<StringBuilder> lines, Message message) {
        block4: {
            if (writer != null) {
                try {
                    writer.write("# ");
                    writer.write(String.valueOf(message));
                    writer.newLine();
                    for (StringBuilder sb : lines) {
                        writer.write(sb.toString());
                        writer.newLine();
                    }
                    writer.newLine();
                }
                catch (Exception e) {
                    if (!DebugLogger.debugEnabled()) break block4;
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
            }
        }
    }
}

