/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.ByteBuffer;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.opends.messages.Message;
import org.opends.messages.MessageBuilder;
import org.opends.messages.UtilityMessages;
import org.opends.server.types.PublicAPI;
import org.opends.server.types.StabilityLevel;
import org.opends.server.util.StaticUtils;
import org.opends.server.util.Validator;
import org.opends.server.util.args.Argument;
import org.opends.server.util.args.ArgumentException;
import org.opends.server.util.args.BooleanArgument;
import org.opends.server.util.args.StringArgument;
import org.opends.server.util.args.SubCommand;
import org.opends.server.util.args.SubCommandArgumentParser;

@PublicAPI(stability=StabilityLevel.UNCOMMITTED, mayInstantiate=false, mayExtend=false, mayInvoke=true)
public final class Base64 {
    private static final char[] BASE64_ALPHABET = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/".toCharArray();

    private Base64() {
    }

    public static String encode(byte[] rawData) {
        Validator.ensureNotNull(rawData);
        StringBuilder buffer = new StringBuilder(4 * rawData.length / 3);
        int pos = 0;
        int iterations = rawData.length / 3;
        for (int i = 0; i < iterations; ++i) {
            int value = (rawData[pos++] & 0xFF) << 16 | (rawData[pos++] & 0xFF) << 8 | rawData[pos++] & 0xFF;
            buffer.append(BASE64_ALPHABET[value >>> 18 & 0x3F]);
            buffer.append(BASE64_ALPHABET[value >>> 12 & 0x3F]);
            buffer.append(BASE64_ALPHABET[value >>> 6 & 0x3F]);
            buffer.append(BASE64_ALPHABET[value & 0x3F]);
        }
        switch (rawData.length % 3) {
            case 1: {
                buffer.append(BASE64_ALPHABET[rawData[pos] >>> 2 & 0x3F]);
                buffer.append(BASE64_ALPHABET[rawData[pos] << 4 & 0x3F]);
                buffer.append("==");
                break;
            }
            case 2: {
                int value = (rawData[pos++] & 0xFF) << 8 | rawData[pos] & 0xFF;
                buffer.append(BASE64_ALPHABET[value >>> 10 & 0x3F]);
                buffer.append(BASE64_ALPHABET[value >>> 4 & 0x3F]);
                buffer.append(BASE64_ALPHABET[value << 2 & 0x3F]);
                buffer.append("=");
            }
        }
        return buffer.toString();
    }

    public static byte[] decode(String encodedData) throws ParseException {
        Validator.ensureNotNull(encodedData);
        int length = encodedData.length();
        if (length % 4 != 0) {
            Message message = UtilityMessages.ERR_BASE64_DECODE_INVALID_LENGTH.get(encodedData);
            throw new ParseException(message.toString(), 0);
        }
        ByteBuffer buffer = ByteBuffer.allocate(length);
        for (int i = 0; i < length; i += 4) {
            boolean append = true;
            int value = 0;
            for (int j = 0; j < 4; ++j) {
                switch (encodedData.charAt(i + j)) {
                    case 'A': {
                        value <<= 6;
                        break;
                    }
                    case 'B': {
                        value = value << 6 | 1;
                        break;
                    }
                    case 'C': {
                        value = value << 6 | 2;
                        break;
                    }
                    case 'D': {
                        value = value << 6 | 3;
                        break;
                    }
                    case 'E': {
                        value = value << 6 | 4;
                        break;
                    }
                    case 'F': {
                        value = value << 6 | 5;
                        break;
                    }
                    case 'G': {
                        value = value << 6 | 6;
                        break;
                    }
                    case 'H': {
                        value = value << 6 | 7;
                        break;
                    }
                    case 'I': {
                        value = value << 6 | 8;
                        break;
                    }
                    case 'J': {
                        value = value << 6 | 9;
                        break;
                    }
                    case 'K': {
                        value = value << 6 | 0xA;
                        break;
                    }
                    case 'L': {
                        value = value << 6 | 0xB;
                        break;
                    }
                    case 'M': {
                        value = value << 6 | 0xC;
                        break;
                    }
                    case 'N': {
                        value = value << 6 | 0xD;
                        break;
                    }
                    case 'O': {
                        value = value << 6 | 0xE;
                        break;
                    }
                    case 'P': {
                        value = value << 6 | 0xF;
                        break;
                    }
                    case 'Q': {
                        value = value << 6 | 0x10;
                        break;
                    }
                    case 'R': {
                        value = value << 6 | 0x11;
                        break;
                    }
                    case 'S': {
                        value = value << 6 | 0x12;
                        break;
                    }
                    case 'T': {
                        value = value << 6 | 0x13;
                        break;
                    }
                    case 'U': {
                        value = value << 6 | 0x14;
                        break;
                    }
                    case 'V': {
                        value = value << 6 | 0x15;
                        break;
                    }
                    case 'W': {
                        value = value << 6 | 0x16;
                        break;
                    }
                    case 'X': {
                        value = value << 6 | 0x17;
                        break;
                    }
                    case 'Y': {
                        value = value << 6 | 0x18;
                        break;
                    }
                    case 'Z': {
                        value = value << 6 | 0x19;
                        break;
                    }
                    case 'a': {
                        value = value << 6 | 0x1A;
                        break;
                    }
                    case 'b': {
                        value = value << 6 | 0x1B;
                        break;
                    }
                    case 'c': {
                        value = value << 6 | 0x1C;
                        break;
                    }
                    case 'd': {
                        value = value << 6 | 0x1D;
                        break;
                    }
                    case 'e': {
                        value = value << 6 | 0x1E;
                        break;
                    }
                    case 'f': {
                        value = value << 6 | 0x1F;
                        break;
                    }
                    case 'g': {
                        value = value << 6 | 0x20;
                        break;
                    }
                    case 'h': {
                        value = value << 6 | 0x21;
                        break;
                    }
                    case 'i': {
                        value = value << 6 | 0x22;
                        break;
                    }
                    case 'j': {
                        value = value << 6 | 0x23;
                        break;
                    }
                    case 'k': {
                        value = value << 6 | 0x24;
                        break;
                    }
                    case 'l': {
                        value = value << 6 | 0x25;
                        break;
                    }
                    case 'm': {
                        value = value << 6 | 0x26;
                        break;
                    }
                    case 'n': {
                        value = value << 6 | 0x27;
                        break;
                    }
                    case 'o': {
                        value = value << 6 | 0x28;
                        break;
                    }
                    case 'p': {
                        value = value << 6 | 0x29;
                        break;
                    }
                    case 'q': {
                        value = value << 6 | 0x2A;
                        break;
                    }
                    case 'r': {
                        value = value << 6 | 0x2B;
                        break;
                    }
                    case 's': {
                        value = value << 6 | 0x2C;
                        break;
                    }
                    case 't': {
                        value = value << 6 | 0x2D;
                        break;
                    }
                    case 'u': {
                        value = value << 6 | 0x2E;
                        break;
                    }
                    case 'v': {
                        value = value << 6 | 0x2F;
                        break;
                    }
                    case 'w': {
                        value = value << 6 | 0x30;
                        break;
                    }
                    case 'x': {
                        value = value << 6 | 0x31;
                        break;
                    }
                    case 'y': {
                        value = value << 6 | 0x32;
                        break;
                    }
                    case 'z': {
                        value = value << 6 | 0x33;
                        break;
                    }
                    case '0': {
                        value = value << 6 | 0x34;
                        break;
                    }
                    case '1': {
                        value = value << 6 | 0x35;
                        break;
                    }
                    case '2': {
                        value = value << 6 | 0x36;
                        break;
                    }
                    case '3': {
                        value = value << 6 | 0x37;
                        break;
                    }
                    case '4': {
                        value = value << 6 | 0x38;
                        break;
                    }
                    case '5': {
                        value = value << 6 | 0x39;
                        break;
                    }
                    case '6': {
                        value = value << 6 | 0x3A;
                        break;
                    }
                    case '7': {
                        value = value << 6 | 0x3B;
                        break;
                    }
                    case '8': {
                        value = value << 6 | 0x3C;
                        break;
                    }
                    case '9': {
                        value = value << 6 | 0x3D;
                        break;
                    }
                    case '+': {
                        value = value << 6 | 0x3E;
                        break;
                    }
                    case '/': {
                        value = value << 6 | 0x3F;
                        break;
                    }
                    case '=': {
                        append = false;
                        switch (j) {
                            case 2: {
                                buffer.put((byte)(value >>> 4 & 0xFF));
                                break;
                            }
                            case 3: {
                                buffer.put((byte)(value >>> 10 & 0xFF));
                                buffer.put((byte)(value >>> 2 & 0xFF));
                            }
                        }
                        break;
                    }
                    default: {
                        Message message = UtilityMessages.ERR_BASE64_DECODE_INVALID_CHARACTER.get(encodedData, Character.valueOf(encodedData.charAt(i + j)));
                        throw new ParseException(message.toString(), i + j);
                    }
                }
                if (!append) break;
            }
            if (!append) break;
            buffer.put((byte)(value >>> 16 & 0xFF));
            buffer.put((byte)(value >>> 8 & 0xFF));
            buffer.put((byte)(value & 0xFF));
        }
        buffer.flip();
        byte[] returnArray = new byte[buffer.limit()];
        buffer.get(returnArray);
        return returnArray;
    }

    public static void main(String[] args) {
        block38: {
            Message description = UtilityMessages.INFO_BASE64_TOOL_DESCRIPTION.get();
            SubCommandArgumentParser argParser = new SubCommandArgumentParser(Base64.class.getName(), description, false);
            Argument showUsage = null;
            StringArgument encodedData = null;
            Argument encodedFile = null;
            Argument rawData = null;
            Argument rawFile = null;
            Argument toEncodedFile = null;
            Argument toRawFile = null;
            SubCommand decodeSubCommand = null;
            SubCommand encodeSubCommand = null;
            try {
                decodeSubCommand = new SubCommand(argParser, "decode", UtilityMessages.INFO_BASE64_DECODE_DESCRIPTION.get());
                encodeSubCommand = new SubCommand(argParser, "encode", UtilityMessages.INFO_BASE64_ENCODE_DESCRIPTION.get());
                encodedData = new StringArgument("encodeddata", Character.valueOf('d'), "encodedData", false, false, true, "{data}", null, null, UtilityMessages.INFO_BASE64_ENCODED_DATA_DESCRIPTION.get());
                decodeSubCommand.addArgument(encodedData);
                encodedFile = new StringArgument("encodedfile", Character.valueOf('f'), "encodedDataFile", false, false, true, "{path}", null, null, UtilityMessages.INFO_BASE64_ENCODED_FILE_DESCRIPTION.get());
                decodeSubCommand.addArgument(encodedFile);
                toRawFile = new StringArgument("torawfile", Character.valueOf('o'), "toRawFile", false, false, true, "{path}", null, null, UtilityMessages.INFO_BASE64_TO_RAW_FILE_DESCRIPTION.get());
                decodeSubCommand.addArgument(toRawFile);
                rawData = new StringArgument("rawdata", Character.valueOf('d'), "rawData", false, false, true, "{data}", null, null, UtilityMessages.INFO_BASE64_RAW_DATA_DESCRIPTION.get());
                encodeSubCommand.addArgument(rawData);
                rawFile = new StringArgument("rawfile", Character.valueOf('f'), "rawDataFile", false, false, true, "{path}", null, null, UtilityMessages.INFO_BASE64_RAW_FILE_DESCRIPTION.get());
                encodeSubCommand.addArgument(rawFile);
                toEncodedFile = new StringArgument("toencodedfile", Character.valueOf('o'), "toEncodedFile", false, false, true, "{path}", null, null, UtilityMessages.INFO_BASE64_TO_ENCODED_FILE_DESCRIPTION.get());
                encodeSubCommand.addArgument(toEncodedFile);
                ArrayList<SubCommand> subCommandList = new ArrayList<SubCommand>(2);
                subCommandList.add(decodeSubCommand);
                subCommandList.add(encodeSubCommand);
                showUsage = new BooleanArgument("help", Character.valueOf('H'), "help", UtilityMessages.INFO_BASE64_HELP_DESCRIPTION.get());
                argParser.addGlobalArgument(showUsage);
                argParser.setUsageGroupArgument(showUsage, subCommandList);
            }
            catch (ArgumentException ae) {
                System.err.println(UtilityMessages.ERR_CANNOT_INITIALIZE_ARGS.get(ae.getMessage()));
                System.exit(1);
            }
            try {
                argParser.parseArguments(args);
            }
            catch (ArgumentException ae) {
                System.err.println(UtilityMessages.ERR_CANNOT_PARSE_ARGS.get(ae.getMessage()).toString());
                System.exit(1);
            }
            SubCommand subCommand = argParser.getSubCommand();
            if (showUsage.isPresent()) {
                if (subCommand == null) {
                    System.out.println(argParser.getUsage());
                } else {
                    MessageBuilder messageBuilder = new MessageBuilder();
                    argParser.getSubCommandUsage(messageBuilder, subCommand);
                    System.out.println(messageBuilder.toString());
                }
                return;
            }
            if (subCommand == null) {
                System.err.println(argParser.getUsage());
                System.exit(1);
            }
            if (subCommand.getName().equals(encodeSubCommand.getName())) {
                byte[] dataToEncode = null;
                if (rawData.isPresent()) {
                    dataToEncode = rawData.getValue().getBytes();
                } else {
                    try {
                        int bytesRead;
                        boolean shouldClose;
                        InputStream inputStream;
                        if (rawFile.isPresent()) {
                            inputStream = new FileInputStream(rawFile.getValue());
                            shouldClose = true;
                        } else {
                            inputStream = System.in;
                            shouldClose = false;
                        }
                        ByteArrayOutputStream baos = new ByteArrayOutputStream();
                        byte[] buffer = new byte[8192];
                        while ((bytesRead = inputStream.read(buffer)) >= 0) {
                            baos.write(buffer, 0, bytesRead);
                        }
                        if (shouldClose) {
                            inputStream.close();
                        }
                        dataToEncode = baos.toByteArray();
                    }
                    catch (Exception e) {
                        System.err.println(UtilityMessages.ERR_BASE64_CANNOT_READ_RAW_DATA.get(StaticUtils.getExceptionMessage(e)).toString());
                        System.exit(1);
                    }
                }
                String base64Data = Base64.encode(dataToEncode);
                if (toEncodedFile.isPresent()) {
                    try {
                        BufferedWriter writer = new BufferedWriter(new FileWriter(toEncodedFile.getValue()));
                        writer.write(base64Data);
                        writer.newLine();
                        writer.close();
                    }
                    catch (Exception e) {
                        System.err.println(UtilityMessages.ERR_BASE64_CANNOT_WRITE_ENCODED_DATA.get(StaticUtils.getExceptionMessage(e)).toString());
                        System.exit(1);
                    }
                } else {
                    System.out.println(base64Data);
                }
            } else if (subCommand.getName().equals(decodeSubCommand.getName())) {
                String dataToDecode = null;
                if (rawData.isPresent()) {
                    dataToDecode = rawData.getValue();
                } else {
                    try {
                        String line;
                        boolean shouldClose;
                        BufferedReader reader;
                        if (encodedFile.isPresent()) {
                            reader = new BufferedReader(new FileReader(encodedFile.getValue()));
                            shouldClose = true;
                        } else {
                            reader = new BufferedReader(new InputStreamReader(System.in));
                            shouldClose = false;
                        }
                        StringBuilder buffer = new StringBuilder();
                        while ((line = reader.readLine()) != null) {
                            StringTokenizer tokenizer = new StringTokenizer(line);
                            while (tokenizer.hasMoreTokens()) {
                                buffer.append(tokenizer.nextToken());
                            }
                        }
                        if (shouldClose) {
                            reader.close();
                        }
                        dataToDecode = buffer.toString();
                    }
                    catch (Exception e) {
                        System.err.println(UtilityMessages.ERR_BASE64_CANNOT_READ_ENCODED_DATA.get(StaticUtils.getExceptionMessage(e)).toString());
                        System.exit(1);
                    }
                }
                byte[] decodedData = null;
                try {
                    decodedData = Base64.decode(dataToDecode);
                }
                catch (ParseException pe) {
                    System.err.println(pe.getMessage());
                    System.exit(1);
                }
                try {
                    if (toRawFile.isPresent()) {
                        FileOutputStream outputStream = new FileOutputStream(toRawFile.getValue());
                        outputStream.write(decodedData);
                        outputStream.close();
                        break block38;
                    }
                    System.out.write(decodedData);
                    System.out.flush();
                }
                catch (Exception e) {
                    System.err.println(UtilityMessages.ERR_BASE64_CANNOT_WRITE_RAW_DATA.get(StaticUtils.getExceptionMessage(e)).toString());
                    System.exit(1);
                }
            } else {
                System.err.println(UtilityMessages.ERR_BASE64_UNKNOWN_SUBCOMMAND.get(subCommand.getName()).toString());
                System.exit(1);
            }
        }
    }
}

