/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.types;

import java.util.ArrayList;
import java.util.List;
import org.opends.messages.Message;
import org.opends.messages.ProtocolMessages;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.protocols.asn1.ASN1Element;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.protocols.asn1.ASN1Sequence;
import org.opends.server.protocols.asn1.ASN1Set;
import org.opends.server.protocols.ldap.LDAPAttribute;
import org.opends.server.types.Attribute;
import org.opends.server.types.ByteString;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.LDAPException;
import org.opends.server.types.PublicAPI;
import org.opends.server.types.StabilityLevel;
import org.opends.server.util.Validator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@PublicAPI(stability=StabilityLevel.UNCOMMITTED, mayInstantiate=true, mayExtend=false, mayInvoke=true)
public abstract class RawAttribute {
    private static final DebugTracer TRACER = DebugLogger.getTracer();

    public static RawAttribute create(String attributeType) {
        Validator.ensureNotNull(attributeType);
        return new LDAPAttribute(attributeType);
    }

    public static RawAttribute create(String attributeType, String value) {
        Validator.ensureNotNull(attributeType, value);
        return new LDAPAttribute(attributeType, value);
    }

    public static RawAttribute create(String attributeType, ByteString value) {
        Validator.ensureNotNull(attributeType);
        return new LDAPAttribute(attributeType, value.toASN1OctetString());
    }

    public static RawAttribute create(String attributeType, List<ByteString> values) {
        Validator.ensureNotNull(attributeType);
        return new LDAPAttribute(attributeType, RawAttribute.convertValues(values));
    }

    public static RawAttribute create(Attribute attribute) {
        Validator.ensureNotNull(attribute);
        return new LDAPAttribute(attribute);
    }

    private static ArrayList<ASN1OctetString> convertValues(List<ByteString> values) {
        if (values == null) {
            return null;
        }
        ArrayList<ASN1OctetString> convertedList = new ArrayList<ASN1OctetString>(values.size());
        for (ByteString s : values) {
            convertedList.add(s.toASN1OctetString());
        }
        return convertedList;
    }

    public abstract String getAttributeType();

    public abstract void setAttributeType(String var1);

    public abstract ArrayList<ASN1OctetString> getValues();

    public abstract Attribute toAttribute() throws LDAPException;

    public final ASN1Element encode() {
        ArrayList<ASN1Element> elements = new ArrayList<ASN1Element>(2);
        elements.add(new ASN1OctetString(this.getAttributeType()));
        ArrayList<ASN1OctetString> values = this.getValues();
        if (values == null || values.isEmpty()) {
            elements.add(new ASN1Set());
        } else {
            elements.add(new ASN1Set(new ArrayList<ASN1Element>(values)));
        }
        return new ASN1Sequence(elements);
    }

    public static LDAPAttribute decode(ASN1Element element) throws LDAPException {
        ArrayList<ASN1OctetString> values;
        String attributeType;
        ArrayList<ASN1Element> elements;
        try {
            elements = element.decodeAsSequence().elements();
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = ProtocolMessages.ERR_LDAP_ATTRIBUTE_DECODE_SEQUENCE.get(String.valueOf(e));
            throw new LDAPException(2, message, e);
        }
        int numElements = elements.size();
        if (numElements != 2) {
            Message message = ProtocolMessages.ERR_LDAP_ATTRIBUTE_DECODE_INVALID_ELEMENT_COUNT.get(numElements);
            throw new LDAPException(2, message);
        }
        try {
            attributeType = elements.get(0).decodeAsOctetString().stringValue();
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = ProtocolMessages.ERR_LDAP_ATTRIBUTE_DECODE_TYPE.get(String.valueOf(e));
            throw new LDAPException(2, message, e);
        }
        try {
            ArrayList<ASN1Element> valueElements = elements.get(1).decodeAsSet().elements();
            values = new ArrayList<ASN1OctetString>(valueElements.size());
            for (ASN1Element e : valueElements) {
                values.add(e.decodeAsOctetString());
            }
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = ProtocolMessages.ERR_LDAP_ATTRIBUTE_DECODE_VALUES.get(String.valueOf(e));
            throw new LDAPException(2, message, e);
        }
        return new LDAPAttribute(attributeType, values);
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        this.toString(buffer);
        return buffer.toString();
    }

    public abstract void toString(StringBuilder var1);

    public abstract void toString(StringBuilder var1, int var2);
}

