/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.types;

import java.io.File;
import java.io.FileNotFoundException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import org.opends.messages.Message;
import org.opends.messages.UtilityMessages;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.OperatingSystem;
import org.opends.server.types.PublicAPI;
import org.opends.server.types.ResultCode;
import org.opends.server.types.StabilityLevel;
import org.opends.server.util.StaticUtils;

@PublicAPI(stability=StabilityLevel.VOLATILE, mayInstantiate=true, mayExtend=false, mayInvoke=true)
public class FilePermission {
    private static final DebugTracer TRACER;
    public static final int OWNER_READABLE = 256;
    public static final int OWNER_WRITABLE = 128;
    public static final int OWNER_EXECUTABLE = 64;
    public static final int GROUP_READABLE = 32;
    public static final int GROUP_WRITABLE = 16;
    public static final int GROUP_EXECUTABLE = 8;
    public static final int OTHER_READABLE = 4;
    public static final int OTHER_WRITABLE = 2;
    public static final int OTHER_EXECUTABLE = 1;
    private static boolean allowExec;
    private static Method setExecutableMethod;
    private static Method setReadableMethod;
    private static Method setWritableMethod;
    private int encodedPermission;

    public FilePermission(int encodedPermission) {
        this.encodedPermission = encodedPermission;
    }

    public FilePermission(boolean ownerReadable, boolean ownerWritable, boolean ownerExecutable) {
        this.encodedPermission = 0;
        if (ownerReadable) {
            this.encodedPermission |= 0x100;
        }
        if (ownerWritable) {
            this.encodedPermission |= 0x80;
        }
        if (ownerExecutable) {
            this.encodedPermission |= 0x40;
        }
    }

    public FilePermission(boolean ownerReadable, boolean ownerWritable, boolean ownerExecutable, boolean groupReadable, boolean groupWritable, boolean groupExecutable, boolean otherReadable, boolean otherWritable, boolean otherExecutable) {
        this.encodedPermission = 0;
        if (ownerReadable) {
            this.encodedPermission |= 0x100;
        }
        if (ownerWritable) {
            this.encodedPermission |= 0x80;
        }
        if (ownerExecutable) {
            this.encodedPermission |= 0x40;
        }
        if (groupReadable) {
            this.encodedPermission |= 0x20;
        }
        if (groupWritable) {
            this.encodedPermission |= 0x10;
        }
        if (groupExecutable) {
            this.encodedPermission |= 8;
        }
        if (otherReadable) {
            this.encodedPermission |= 4;
        }
        if (otherWritable) {
            this.encodedPermission |= 2;
        }
        if (otherExecutable) {
            this.encodedPermission |= 1;
        }
    }

    public boolean isOwnerReadable() {
        return (this.encodedPermission & 0x100) == 256;
    }

    public boolean isOwnerWritable() {
        return (this.encodedPermission & 0x80) == 128;
    }

    public boolean isOwnerExecutable() {
        return (this.encodedPermission & 0x40) == 64;
    }

    public boolean isGroupReadable() {
        return (this.encodedPermission & 0x20) == 32;
    }

    public boolean isGroupWritable() {
        return (this.encodedPermission & 0x10) == 16;
    }

    public boolean isGroupExecutable() {
        return (this.encodedPermission & 8) == 8;
    }

    public boolean isOtherReadable() {
        return (this.encodedPermission & 4) == 4;
    }

    public boolean isOtherWritable() {
        return (this.encodedPermission & 2) == 2;
    }

    public boolean isOtherExecutable() {
        return (this.encodedPermission & 1) == 1;
    }

    public static boolean canSetPermissions() {
        if (setReadableMethod != null && setWritableMethod != null && setExecutableMethod != null) {
            return true;
        }
        OperatingSystem os = DirectoryServer.getOperatingSystem();
        return allowExec && os != null && OperatingSystem.isUNIXBased(os);
    }

    public static boolean setPermissions(File f, FilePermission p) throws FileNotFoundException, DirectoryException {
        if (!f.exists()) {
            Message message = UtilityMessages.ERR_FILEPERM_SET_NO_SUCH_FILE.get(f.getAbsolutePath());
            throw new FileNotFoundException(message.toString());
        }
        OperatingSystem os = DirectoryServer.getOperatingSystem();
        if (allowExec && os != null && OperatingSystem.isUNIXBased(os)) {
            return FilePermission.setUsingUNIX(f, p);
        }
        if (setReadableMethod != null && setWritableMethod != null && setExecutableMethod != null) {
            return FilePermission.setUsingJava(f, p);
        }
        return false;
    }

    private static boolean setUsingUNIX(File f, FilePermission p) throws DirectoryException {
        int exitCode;
        String[] arguments = new String[]{FilePermission.toUNIXMode(p), f.getAbsolutePath()};
        ArrayList<String> outputLines = new ArrayList<String>(1);
        try {
            exitCode = StaticUtils.exec("chmod", arguments, null, null, outputLines);
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = UtilityMessages.ERR_FILEPERM_CANNOT_EXEC_CHMOD.get(f.getAbsolutePath(), String.valueOf(e));
            throw new DirectoryException(ResultCode.OTHER, message, e);
        }
        return exitCode == 0;
    }

    private static boolean setUsingJava(File f, FilePermission p) throws DirectoryException {
        Boolean b;
        boolean anySuccessful = false;
        boolean anyFailed = false;
        boolean exceptionThrown = false;
        if (p.isOwnerReadable() && !p.isOtherReadable()) {
            try {
                Boolean b2 = (Boolean)setReadableMethod.invoke((Object)f, false, false);
                if (b2.booleanValue()) {
                    anySuccessful = true;
                } else if (!DirectoryServer.getOperatingSystem().equals((Object)OperatingSystem.WINDOWS)) {
                    anyFailed = true;
                }
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                exceptionThrown = true;
            }
        }
        try {
            boolean ownerOnly = p.isOwnerReadable() != p.isOtherReadable();
            b = (Boolean)setReadableMethod.invoke((Object)f, p.isOwnerReadable(), ownerOnly);
            if (b.booleanValue()) {
                anySuccessful = true;
            } else if (!DirectoryServer.getOperatingSystem().equals((Object)OperatingSystem.WINDOWS) || p.isOwnerReadable()) {
                anyFailed = true;
            }
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            exceptionThrown = true;
        }
        if (p.isOwnerWritable() && !p.isOtherWritable()) {
            try {
                Boolean b3 = (Boolean)setWritableMethod.invoke((Object)f, false, false);
                if (b3.booleanValue()) {
                    anySuccessful = true;
                } else {
                    anyFailed = true;
                }
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                exceptionThrown = true;
            }
        }
        try {
            boolean ownerOnly = p.isOwnerWritable() != p.isOtherWritable();
            b = (Boolean)setWritableMethod.invoke((Object)f, p.isOwnerWritable(), ownerOnly);
            if (b.booleanValue()) {
                anySuccessful = true;
            } else {
                anyFailed = true;
            }
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            exceptionThrown = true;
        }
        if (p.isOwnerExecutable() && !p.isOtherExecutable()) {
            try {
                Boolean b4 = (Boolean)setExecutableMethod.invoke((Object)f, false, false);
                if (b4.booleanValue()) {
                    anySuccessful = true;
                } else if (!DirectoryServer.getOperatingSystem().equals((Object)OperatingSystem.WINDOWS)) {
                    anyFailed = true;
                }
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                exceptionThrown = true;
            }
        }
        try {
            boolean ownerOnly = p.isOwnerExecutable() != p.isOtherExecutable();
            b = (Boolean)setExecutableMethod.invoke((Object)f, p.isOwnerExecutable(), ownerOnly);
            if (b.booleanValue()) {
                anySuccessful = true;
            } else if (!DirectoryServer.getOperatingSystem().equals((Object)OperatingSystem.WINDOWS) || p.isOwnerExecutable()) {
                anyFailed = true;
            }
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            exceptionThrown = true;
        }
        if (exceptionThrown) {
            Message message = UtilityMessages.ERR_FILEPERM_SET_JAVA_EXCEPTION.get(f.getAbsolutePath());
            throw new DirectoryException(ResultCode.OTHER, message);
        }
        if (anyFailed) {
            if (anySuccessful) {
                Message message = UtilityMessages.ERR_FILEPERM_SET_JAVA_FAILED_ALTERED.get(f.getAbsolutePath());
                throw new DirectoryException(ResultCode.OTHER, message);
            }
            Message message = UtilityMessages.ERR_FILEPERM_SET_JAVA_FAILED_UNALTERED.get(f.getAbsolutePath());
            throw new DirectoryException(ResultCode.OTHER, message);
        }
        return anySuccessful;
    }

    public static String toUNIXMode(FilePermission p) {
        StringBuilder buffer = new StringBuilder(3);
        FilePermission.toUNIXMode(buffer, p);
        return buffer.toString();
    }

    public static void toUNIXMode(StringBuilder buffer, FilePermission p) {
        int modeByte = 0;
        if (p.isOwnerReadable()) {
            modeByte = (byte)(modeByte | 4);
        }
        if (p.isOwnerWritable()) {
            modeByte = (byte)(modeByte | 2);
        }
        if (p.isOwnerExecutable()) {
            modeByte = (byte)(modeByte | 1);
        }
        buffer.append(String.valueOf(modeByte));
        modeByte = 0;
        if (p.isGroupReadable()) {
            modeByte = (byte)(modeByte | 4);
        }
        if (p.isGroupWritable()) {
            modeByte = (byte)(modeByte | 2);
        }
        if (p.isGroupExecutable()) {
            modeByte = (byte)(modeByte | 1);
        }
        buffer.append(String.valueOf(modeByte));
        modeByte = 0;
        if (p.isOtherReadable()) {
            modeByte = (byte)(modeByte | 4);
        }
        if (p.isOtherWritable()) {
            modeByte = (byte)(modeByte | 2);
        }
        if (p.isOtherExecutable()) {
            modeByte = (byte)(modeByte | 1);
        }
        buffer.append(String.valueOf(modeByte));
    }

    public static FilePermission decodeUNIXMode(String modeString) throws DirectoryException {
        if (modeString == null || modeString.length() != 3) {
            Message message = UtilityMessages.ERR_FILEPERM_INVALID_UNIX_MODE_STRING.get(String.valueOf(modeString));
            throw new DirectoryException(ResultCode.OTHER, message);
        }
        int encodedPermission = 0;
        switch (modeString.charAt(0)) {
            case '0': {
                break;
            }
            case '1': {
                encodedPermission |= 0x40;
                break;
            }
            case '2': {
                encodedPermission |= 0x80;
                break;
            }
            case '3': {
                encodedPermission |= 0xC0;
                break;
            }
            case '4': {
                encodedPermission |= 0x100;
                break;
            }
            case '5': {
                encodedPermission |= 0x140;
                break;
            }
            case '6': {
                encodedPermission |= 0x180;
                break;
            }
            case '7': {
                encodedPermission |= 0x1C0;
                break;
            }
            default: {
                Message message = UtilityMessages.ERR_FILEPERM_INVALID_UNIX_MODE_STRING.get(String.valueOf(modeString));
                throw new DirectoryException(ResultCode.OTHER, message);
            }
        }
        switch (modeString.charAt(1)) {
            case '0': {
                break;
            }
            case '1': {
                encodedPermission |= 8;
                break;
            }
            case '2': {
                encodedPermission |= 0x10;
                break;
            }
            case '3': {
                encodedPermission |= 0x18;
                break;
            }
            case '4': {
                encodedPermission |= 0x20;
                break;
            }
            case '5': {
                encodedPermission |= 0x28;
                break;
            }
            case '6': {
                encodedPermission |= 0x30;
                break;
            }
            case '7': {
                encodedPermission |= 0x38;
                break;
            }
            default: {
                Message message = UtilityMessages.ERR_FILEPERM_INVALID_UNIX_MODE_STRING.get(String.valueOf(modeString));
                throw new DirectoryException(ResultCode.OTHER, message);
            }
        }
        switch (modeString.charAt(2)) {
            case '0': {
                break;
            }
            case '1': {
                encodedPermission |= 1;
                break;
            }
            case '2': {
                encodedPermission |= 2;
                break;
            }
            case '3': {
                encodedPermission |= 3;
                break;
            }
            case '4': {
                encodedPermission |= 4;
                break;
            }
            case '5': {
                encodedPermission |= 5;
                break;
            }
            case '6': {
                encodedPermission |= 6;
                break;
            }
            case '7': {
                encodedPermission |= 7;
                break;
            }
            default: {
                Message message = UtilityMessages.ERR_FILEPERM_INVALID_UNIX_MODE_STRING.get(String.valueOf(modeString));
                throw new DirectoryException(ResultCode.OTHER, message);
            }
        }
        return new FilePermission(encodedPermission);
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        this.toString(buffer);
        return buffer.toString();
    }

    public void toString(StringBuilder buffer) {
        buffer.append("Owner=");
        if (this.isOwnerReadable()) {
            buffer.append("r");
        }
        if (this.isOwnerWritable()) {
            buffer.append("w");
        }
        if (this.isOwnerExecutable()) {
            buffer.append("x");
        }
        buffer.append(", Group=");
        if (this.isGroupReadable()) {
            buffer.append("r");
        }
        if (this.isGroupWritable()) {
            buffer.append("w");
        }
        if (this.isGroupExecutable()) {
            buffer.append("x");
        }
        buffer.append(", Other=");
        if (this.isOtherReadable()) {
            buffer.append("r");
        }
        if (this.isOtherWritable()) {
            buffer.append("w");
        }
        if (this.isOtherExecutable()) {
            buffer.append("x");
        }
    }

    static {
        block5: {
            TRACER = DebugLogger.getTracer();
            try {
                setExecutableMethod = null;
                setReadableMethod = null;
                setWritableMethod = null;
                for (Method m : File.class.getMethods()) {
                    String name = m.getName();
                    Class<?>[] argTypes = m.getParameterTypes();
                    if (name.equals("setExecutable") && argTypes.length == 2) {
                        setExecutableMethod = m;
                        continue;
                    }
                    if (name.equals("setReadable") && argTypes.length == 2) {
                        setReadableMethod = m;
                        continue;
                    }
                    if (!name.equals("setWritable") || argTypes.length != 2) continue;
                    setWritableMethod = m;
                }
            }
            catch (Exception e) {
                if (!DebugLogger.debugEnabled()) break block5;
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
        }
        allowExec = StaticUtils.mayUseExec();
    }
}

