/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.types;

import org.opends.messages.CoreMessages;
import org.opends.messages.Message;
import org.opends.server.core.DirectoryServer;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.PublicAPI;
import org.opends.server.types.StabilityLevel;

@PublicAPI(stability=StabilityLevel.VOLATILE, mayInstantiate=true, mayExtend=false, mayInvoke=true)
public final class EntryEncodeConfig {
    private static final byte ENCODE_FLAG_EXCLUDE_DN = 1;
    private static final byte ENCODE_FLAG_COMPRESS_OCS = 2;
    private static final byte ENCODE_FLAG_COMPRESS_ADS = 4;
    public static final EntryEncodeConfig DEFAULT_CONFIG = new EntryEncodeConfig();
    private final boolean compressAttrDescriptions;
    private final boolean compressObjectClassSets;
    private final boolean excludeDN;
    private final byte[] encodedRepresentation;

    public EntryEncodeConfig() {
        this.excludeDN = false;
        this.compressAttrDescriptions = false;
        this.compressObjectClassSets = false;
        this.encodedRepresentation = new byte[]{0};
    }

    public EntryEncodeConfig(boolean excludeDN, boolean compressAttrDescriptions, boolean compressObjectClassSets) {
        this.excludeDN = excludeDN;
        this.compressAttrDescriptions = compressAttrDescriptions;
        this.compressObjectClassSets = compressObjectClassSets;
        byte flagByte = 0;
        if (excludeDN) {
            flagByte = (byte)(flagByte | 1);
        }
        if (compressAttrDescriptions) {
            flagByte = (byte)(flagByte | 4);
        }
        if (compressObjectClassSets) {
            flagByte = (byte)(flagByte | 2);
        }
        this.encodedRepresentation = new byte[]{flagByte};
    }

    public boolean excludeDN() {
        return this.excludeDN;
    }

    public boolean compressAttributeDescriptions() {
        return this.compressAttrDescriptions;
    }

    public boolean compressObjectClassSets() {
        return this.compressObjectClassSets;
    }

    public byte[] encode() {
        return this.encodedRepresentation;
    }

    public static EntryEncodeConfig decode(byte[] encodedEntry, int startPos, int length) throws DirectoryException {
        if (length != 1) {
            Message message = CoreMessages.ERR_ENTRYENCODECFG_INVALID_LENGTH.get();
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message);
        }
        boolean excludeDN = false;
        if ((encodedEntry[startPos] & 1) == 1) {
            excludeDN = true;
        }
        boolean compressAttrDescriptions = false;
        if ((encodedEntry[startPos] & 4) == 4) {
            compressAttrDescriptions = true;
        }
        boolean compressObjectClassSets = false;
        if ((encodedEntry[startPos] & 2) == 2) {
            compressObjectClassSets = true;
        }
        return new EntryEncodeConfig(excludeDN, compressAttrDescriptions, compressObjectClassSets);
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        this.toString(buffer);
        return buffer.toString();
    }

    public void toString(StringBuilder buffer) {
        buffer.append("EntryEncodeConfig(excludeDN=");
        buffer.append(this.excludeDN);
        buffer.append(", compressAttrDescriptions=");
        buffer.append(this.compressAttrDescriptions);
        buffer.append(", compressObjectClassSets=");
        buffer.append(this.compressObjectClassSets);
        buffer.append(")");
    }
}

