/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.types;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import org.opends.messages.CoreMessages;
import org.opends.messages.Message;
import org.opends.messages.MessageBuilder;
import org.opends.messages.UtilityMessages;
import org.opends.server.api.AttributeValueDecoder;
import org.opends.server.api.ProtocolElement;
import org.opends.server.api.plugin.LDIFPluginResult;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.PluginConfigManager;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.protocols.asn1.ASN1Element;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.types.AcceptRejectWarn;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.AttributeValueIterable;
import org.opends.server.types.ByteString;
import org.opends.server.types.CompressedSchema;
import org.opends.server.types.DITContentRule;
import org.opends.server.types.DITStructureRule;
import org.opends.server.types.DN;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.EntryEncodeConfig;
import org.opends.server.types.LDIFExportConfig;
import org.opends.server.types.LockManager;
import org.opends.server.types.Modification;
import org.opends.server.types.NameForm;
import org.opends.server.types.ObjectClass;
import org.opends.server.types.ObjectClassType;
import org.opends.server.types.PublicAPI;
import org.opends.server.types.RDN;
import org.opends.server.types.ResultCode;
import org.opends.server.types.Schema;
import org.opends.server.types.SearchScope;
import org.opends.server.types.StabilityLevel;
import org.opends.server.types.VirtualAttribute;
import org.opends.server.types.VirtualAttributeRule;
import org.opends.server.util.LDIFException;
import org.opends.server.util.LDIFWriter;
import org.opends.server.util.ServerConstants;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@PublicAPI(stability=StabilityLevel.UNCOMMITTED, mayInstantiate=true, mayExtend=false, mayInvoke=true)
public class Entry
implements ProtocolElement {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private boolean virtualAttributeProcessingPerformed = false;
    private Map<AttributeType, List<Attribute>> operationalAttributes;
    private Map<AttributeType, List<Attribute>> userAttributes;
    private Map<AttributeType, List<Attribute>> suppressedAttributes;
    private Map<ObjectClass, String> objectClasses;
    private DN dn;
    private transient Object attachment = null;
    private Schema schema = DirectoryServer.getSchema();

    public Entry(DN dn, Map<ObjectClass, String> objectClasses, Map<AttributeType, List<Attribute>> userAttributes, Map<AttributeType, List<Attribute>> operationalAttributes) {
        this.suppressedAttributes = new LinkedHashMap<AttributeType, List<Attribute>>();
        this.dn = dn == null ? DN.nullDN() : dn;
        this.objectClasses = objectClasses == null ? new HashMap<ObjectClass, String>() : objectClasses;
        this.userAttributes = userAttributes == null ? new HashMap<AttributeType, List<Attribute>>() : userAttributes;
        this.operationalAttributes = operationalAttributes == null ? new HashMap<AttributeType, List<Attribute>>() : operationalAttributes;
    }

    public DN getDN() {
        return this.dn;
    }

    public void setDN(DN dn) {
        this.dn = dn == null ? DN.nullDN() : dn;
        this.attachment = null;
    }

    public Map<ObjectClass, String> getObjectClasses() {
        return this.objectClasses;
    }

    public boolean hasObjectClass(ObjectClass objectClass) {
        return this.objectClasses.containsKey(objectClass);
    }

    public ObjectClass getStructuralObjectClass() {
        ObjectClass structuralClass = null;
        for (ObjectClass oc : this.objectClasses.keySet()) {
            if (oc.getObjectClassType() != ObjectClassType.STRUCTURAL) continue;
            if (structuralClass == null) {
                structuralClass = oc;
                continue;
            }
            if (!oc.isDescendantOf(structuralClass)) continue;
            structuralClass = oc;
        }
        return structuralClass;
    }

    public void setObjectClasses(Collection<AttributeValue> objectClassNames) throws DirectoryException {
        this.attachment = null;
        LinkedHashMap<ObjectClass, String> ocMap = new LinkedHashMap<ObjectClass, String>();
        for (AttributeValue v : objectClassNames) {
            String lowerName;
            String name = v.getStringValue();
            try {
                lowerName = v.getNormalizedStringValue();
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                lowerName = StaticUtils.toLowerCase(v.getStringValue());
            }
            ObjectClass oc = DirectoryServer.getObjectClass(lowerName);
            if (oc == null) {
                Message message = CoreMessages.ERR_ENTRY_ADD_UNKNOWN_OC.get(name, String.valueOf(this.dn));
                throw new DirectoryException(ResultCode.OBJECTCLASS_VIOLATION, message);
            }
            ocMap.put(oc, name);
        }
        this.objectClasses = ocMap;
    }

    public void addObjectClass(AttributeValue objectClassName) throws DirectoryException {
        String lowerName;
        this.attachment = null;
        String name = objectClassName.getStringValue();
        try {
            lowerName = objectClassName.getNormalizedStringValue();
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            lowerName = StaticUtils.toLowerCase(name);
        }
        ObjectClass oc = DirectoryServer.getObjectClass(lowerName, true);
        if (this.objectClasses.containsKey(oc)) {
            Message message = CoreMessages.ERR_ENTRY_ADD_DUPLICATE_OC.get(name, String.valueOf(this.dn));
            throw new DirectoryException(ResultCode.OBJECTCLASS_VIOLATION, message);
        }
        this.objectClasses.put(oc, name);
    }

    public void addObjectClass(ObjectClass oc) throws DirectoryException {
        this.attachment = null;
        if (this.objectClasses.containsKey(oc)) {
            Message message = CoreMessages.ERR_ENTRY_ADD_DUPLICATE_OC.get(oc.getNameOrOID(), String.valueOf(this.dn));
            throw new DirectoryException(ResultCode.OBJECTCLASS_VIOLATION, message);
        }
        this.objectClasses.put(oc, oc.getNameOrOID());
    }

    public void addObjectClasses(Collection<AttributeValue> objectClassNames) throws DirectoryException {
        String name;
        this.attachment = null;
        LinkedHashMap<ObjectClass, String> tmpOCMap = new LinkedHashMap<ObjectClass, String>();
        for (AttributeValue v : objectClassNames) {
            String lowerName;
            name = v.getStringValue();
            try {
                lowerName = v.getNormalizedStringValue();
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                lowerName = StaticUtils.toLowerCase(v.getStringValue());
            }
            ObjectClass oc = DirectoryServer.getObjectClass(lowerName);
            if (oc == null) {
                Message message = CoreMessages.ERR_ENTRY_ADD_UNKNOWN_OC.get(name, String.valueOf(this.dn));
                throw new DirectoryException(ResultCode.OBJECTCLASS_VIOLATION, message);
            }
            if (this.objectClasses.containsKey(oc)) {
                Message message = CoreMessages.ERR_ENTRY_ADD_DUPLICATE_OC.get(name, String.valueOf(this.dn));
                throw new DirectoryException(ResultCode.OBJECTCLASS_VIOLATION, message);
            }
            if (oc.isObsolete()) {
                Message message = CoreMessages.ERR_ENTRY_ADD_OBSOLETE_OC.get(name, String.valueOf(this.dn));
                throw new DirectoryException(ResultCode.OBJECTCLASS_VIOLATION, message);
            }
            tmpOCMap.put(oc, name);
        }
        for (ObjectClass oc : tmpOCMap.keySet()) {
            name = (String)tmpOCMap.get(oc);
            this.objectClasses.put(oc, name);
        }
    }

    public List<Attribute> getAttributes() {
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        for (List<Attribute> list : this.userAttributes.values()) {
            for (Attribute a : list) {
                attributes.add(a);
            }
        }
        for (List<Attribute> list : this.operationalAttributes.values()) {
            for (Attribute a : list) {
                attributes.add(a);
            }
        }
        return attributes;
    }

    public Map<AttributeType, List<Attribute>> getUserAttributes() {
        return this.userAttributes;
    }

    public Map<AttributeType, List<Attribute>> getOperationalAttributes() {
        return this.operationalAttributes;
    }

    public Attribute getObjectClassAttribute() {
        if (this.objectClasses == null || this.objectClasses.isEmpty()) {
            return null;
        }
        AttributeType ocType = DirectoryServer.getObjectClassAttributeType();
        LinkedHashSet<AttributeValue> ocValues = new LinkedHashSet<AttributeValue>(this.objectClasses.size());
        for (String s : this.objectClasses.values()) {
            ocValues.add(new AttributeValue(ocType, (ByteString)new ASN1OctetString(s)));
        }
        return new Attribute(ocType, "objectClass", ocValues);
    }

    public boolean hasAttribute(AttributeType attributeType) {
        if (this.userAttributes.containsKey(attributeType) || this.operationalAttributes.containsKey(attributeType)) {
            return true;
        }
        if (attributeType.mayHaveSubordinateTypes()) {
            for (AttributeType at : this.schema.getSubTypes(attributeType)) {
                if (!this.userAttributes.containsKey(at) && !this.operationalAttributes.containsKey(at)) continue;
                return true;
            }
        }
        return attributeType.isObjectClassType() && !this.objectClasses.isEmpty();
    }

    public boolean hasAttribute(AttributeType attributeType, Set<String> attributeOptions) {
        List<Object> attributes;
        if (attributeType.mayHaveSubordinateTypes()) {
            attributes = new LinkedList();
            List<Attribute> attrs = this.userAttributes.get(attributeType);
            if (attrs != null) {
                attributes.addAll(attrs);
            }
            if ((attrs = this.operationalAttributes.get(attributeType)) != null) {
                attributes.addAll(attrs);
            }
            for (AttributeType at : this.schema.getSubTypes(attributeType)) {
                attrs = this.userAttributes.get(at);
                if (attrs != null) {
                    attributes.addAll(attrs);
                }
                if ((attrs = this.operationalAttributes.get(at)) == null) continue;
                attributes.addAll(attrs);
            }
        } else {
            attributes = this.userAttributes.get(attributeType);
            if (attributes == null && (attributes = this.operationalAttributes.get(attributeType)) == null) {
                if (attributeType.isObjectClassType() && !this.objectClasses.isEmpty()) {
                    return attributeOptions == null || attributeOptions.isEmpty();
                }
                return false;
            }
        }
        for (Attribute attribute : attributes) {
            if (!attribute.hasValue() || !attribute.hasOptions(attributeOptions)) continue;
            return true;
        }
        return false;
    }

    public List<Attribute> getAttribute(AttributeType attributeType) {
        if (attributeType.mayHaveSubordinateTypes()) {
            LinkedList<Attribute> attributes = new LinkedList<Attribute>();
            List<Attribute> attrs = this.userAttributes.get(attributeType);
            if (attrs != null) {
                attributes.addAll(attrs);
            }
            if ((attrs = this.operationalAttributes.get(attributeType)) != null) {
                attributes.addAll(attrs);
            }
            for (AttributeType at : this.schema.getSubTypes(attributeType)) {
                attrs = this.userAttributes.get(at);
                if (attrs != null) {
                    attributes.addAll(attrs);
                }
                if ((attrs = this.operationalAttributes.get(at)) == null) continue;
                attributes.addAll(attrs);
            }
            if (attributes.isEmpty()) {
                return null;
            }
            return attributes;
        }
        List<Attribute> attributes = this.userAttributes.get(attributeType);
        if (attributes == null) {
            attributes = this.operationalAttributes.get(attributeType);
            if (attributes == null) {
                if (attributeType.isObjectClassType() && !this.objectClasses.isEmpty()) {
                    attributes = new ArrayList<Attribute>(1);
                    attributes.add(this.getObjectClassAttribute());
                    return attributes;
                }
                return null;
            }
            return attributes;
        }
        return attributes;
    }

    public List<Attribute> getAttribute(String lowerName) {
        for (AttributeType attr : this.userAttributes.keySet()) {
            if (!attr.hasNameOrOID(lowerName)) continue;
            return this.getAttribute(attr);
        }
        for (AttributeType attr : this.operationalAttributes.keySet()) {
            if (!attr.hasNameOrOID(lowerName)) continue;
            return this.getAttribute(attr);
        }
        if (lowerName.equals("objectclass") && !this.objectClasses.isEmpty()) {
            LinkedList<Attribute> attrList = new LinkedList<Attribute>();
            attrList.add(this.getObjectClassAttribute());
            return attrList;
        }
        return null;
    }

    public List<Attribute> getAttribute(AttributeType attributeType, Set<String> options) {
        List<Attribute> attrs;
        LinkedList<Attribute> attributes = new LinkedList<Attribute>();
        if (attributeType.mayHaveSubordinateTypes()) {
            attrs = this.userAttributes.get(attributeType);
            if (attrs != null) {
                attributes.addAll(attrs);
            }
            if ((attrs = this.operationalAttributes.get(attributeType)) != null) {
                attributes.addAll(attrs);
            }
            for (AttributeType at : this.schema.getSubTypes(attributeType)) {
                attrs = this.userAttributes.get(at);
                if (attrs != null) {
                    attributes.addAll(attrs);
                }
                if ((attrs = this.operationalAttributes.get(at)) == null) continue;
                attributes.addAll(attrs);
            }
        } else {
            attrs = this.userAttributes.get(attributeType);
            if (attrs == null) {
                attrs = this.operationalAttributes.get(attributeType);
                if (attrs == null) {
                    if (attributeType.isObjectClassType() && !this.objectClasses.isEmpty() && (options == null || options.isEmpty())) {
                        attributes.add(this.getObjectClassAttribute());
                        return attributes;
                    }
                    return null;
                }
                attributes.addAll(attrs);
            } else {
                attributes.addAll(attrs);
            }
        }
        Iterator iterator = attributes.iterator();
        while (iterator.hasNext()) {
            Attribute a = (Attribute)iterator.next();
            if (a.hasOptions(options)) continue;
            iterator.remove();
        }
        if (attributes.isEmpty()) {
            return null;
        }
        return attributes;
    }

    public List<Attribute> getAttribute(String lowerName, Set<String> options) {
        for (AttributeType attr : this.userAttributes.keySet()) {
            if (!attr.hasNameOrOID(lowerName)) continue;
            return this.getAttribute(attr, options);
        }
        for (AttributeType attr : this.operationalAttributes.keySet()) {
            if (!attr.hasNameOrOID(lowerName)) continue;
            return this.getAttribute(attr, options);
        }
        if (lowerName.equals("objectclass") && (options == null || options.isEmpty())) {
            LinkedList<Attribute> attributes = new LinkedList<Attribute>();
            attributes.add(this.getObjectClassAttribute());
            return attributes;
        }
        return null;
    }

    public final <T> T getAttributeValue(AttributeType attributeType, AttributeValueDecoder<T> decoder) throws DirectoryException {
        List<Attribute> attributes = this.getAttribute(attributeType);
        AttributeValueIterable values = new AttributeValueIterable(attributes);
        Iterator<AttributeValue> iterator = values.iterator();
        if (iterator.hasNext()) {
            return decoder.decode(iterator.next());
        }
        return null;
    }

    public final <T> Collection<T> getAttributeValues(AttributeType attributeType, AttributeValueDecoder<? extends T> decoder, Collection<T> collection) throws DirectoryException {
        List<Attribute> attributes = this.getAttribute(attributeType);
        AttributeValueIterable values = new AttributeValueIterable(attributes);
        for (AttributeValue value : values) {
            collection.add(decoder.decode(value));
        }
        return collection;
    }

    public boolean hasUserAttribute(AttributeType attributeType) {
        if (this.userAttributes.containsKey(attributeType)) {
            return true;
        }
        if (attributeType.mayHaveSubordinateTypes()) {
            for (AttributeType at : this.schema.getSubTypes(attributeType)) {
                if (!this.userAttributes.containsKey(at)) continue;
                return true;
            }
        }
        return false;
    }

    public List<Attribute> getUserAttribute(AttributeType attributeType) {
        if (attributeType.mayHaveSubordinateTypes()) {
            LinkedList<Attribute> attributes = new LinkedList<Attribute>();
            List<Attribute> attrs = this.userAttributes.get(attributeType);
            if (attrs != null) {
                attributes.addAll(attrs);
            }
            for (AttributeType at : this.schema.getSubTypes(attributeType)) {
                attrs = this.userAttributes.get(at);
                if (attrs == null) continue;
                attributes.addAll(attrs);
            }
            if (attributes.isEmpty()) {
                return null;
            }
            return attributes;
        }
        return this.userAttributes.get(attributeType);
    }

    public List<Attribute> getUserAttribute(AttributeType attributeType, Set<String> options) {
        LinkedList<Attribute> attributes = new LinkedList<Attribute>();
        List<Attribute> attrs = this.userAttributes.get(attributeType);
        if (attrs != null) {
            attributes.addAll(attrs);
        }
        if (attributeType.mayHaveSubordinateTypes()) {
            for (AttributeType at : this.schema.getSubTypes(attributeType)) {
                attrs = this.userAttributes.get(at);
                if (attrs == null) continue;
                attributes.addAll(attrs);
            }
        }
        Iterator iterator = attributes.iterator();
        while (iterator.hasNext()) {
            Attribute a = (Attribute)iterator.next();
            if (a.hasOptions(options)) continue;
            iterator.remove();
        }
        if (attributes.isEmpty()) {
            return null;
        }
        return attributes;
    }

    public List<Attribute> duplicateUserAttribute(AttributeType attributeType) {
        LinkedList<Attribute> attributes = new LinkedList<Attribute>();
        List<Attribute> attrs = this.userAttributes.get(attributeType);
        if (attrs != null) {
            for (Attribute a : attrs) {
                attributes.add(a.duplicate());
            }
        }
        if (attributeType.mayHaveSubordinateTypes()) {
            for (AttributeType at : this.schema.getSubTypes(attributeType)) {
                attrs = this.userAttributes.get(at);
                if (attrs == null) continue;
                for (Attribute a : attrs) {
                    attributes.add(a.duplicate());
                }
            }
        }
        if (attributes.isEmpty()) {
            return null;
        }
        return attributes;
    }

    private static List<Attribute> duplicateAttribute(List<Attribute> attrList, Set<String> options, boolean omitValues) {
        if (attrList == null) {
            return null;
        }
        ArrayList<Attribute> duplicateList = new ArrayList<Attribute>(attrList.size());
        for (Attribute a : attrList) {
            if (!a.hasOptions(options)) continue;
            duplicateList.add(a.duplicate(omitValues));
        }
        if (duplicateList.isEmpty()) {
            return null;
        }
        return duplicateList;
    }

    public List<Attribute> duplicateUserAttribute(AttributeType attributeType, Set<String> options, boolean omitValues) {
        List<Attribute> currentList = this.getUserAttribute(attributeType);
        return Entry.duplicateAttribute(currentList, options, omitValues);
    }

    public List<Attribute> duplicateOperationalAttribute(AttributeType attributeType, Set<String> options, boolean omitValues) {
        List<Attribute> currentList = this.getOperationalAttribute(attributeType);
        return Entry.duplicateAttribute(currentList, options, omitValues);
    }

    public boolean hasOperationalAttribute(AttributeType attributeType) {
        if (this.operationalAttributes.containsKey(attributeType)) {
            return true;
        }
        if (attributeType.mayHaveSubordinateTypes()) {
            for (AttributeType at : this.schema.getSubTypes(attributeType)) {
                if (!this.operationalAttributes.containsKey(at)) continue;
                return true;
            }
        }
        return false;
    }

    public List<Attribute> getOperationalAttribute(AttributeType attributeType) {
        if (attributeType.mayHaveSubordinateTypes()) {
            LinkedList<Attribute> attributes = new LinkedList<Attribute>();
            List<Attribute> attrs = this.operationalAttributes.get(attributeType);
            if (attrs != null) {
                attributes.addAll(attrs);
            }
            for (AttributeType at : this.schema.getSubTypes(attributeType)) {
                attrs = this.operationalAttributes.get(at);
                if (attrs == null) continue;
                attributes.addAll(attrs);
            }
            if (attributes.isEmpty()) {
                return null;
            }
            return attributes;
        }
        return this.operationalAttributes.get(attributeType);
    }

    public List<Attribute> getOperationalAttribute(AttributeType attributeType, Set<String> options) {
        LinkedList<Attribute> attributes = new LinkedList<Attribute>();
        List<Attribute> attrs = this.operationalAttributes.get(attributeType);
        if (attrs != null) {
            attributes.addAll(attrs);
        }
        if (attributeType.mayHaveSubordinateTypes()) {
            for (AttributeType at : this.schema.getSubTypes(attributeType)) {
                attrs = this.operationalAttributes.get(at);
                if (attrs == null) continue;
                attributes.addAll(attrs);
            }
        }
        Iterator iterator = attributes.iterator();
        while (iterator.hasNext()) {
            Attribute a = (Attribute)iterator.next();
            if (a.hasOptions(options)) continue;
            iterator.remove();
        }
        if (attributes.isEmpty()) {
            return null;
        }
        return attributes;
    }

    public List<Attribute> duplicateOperationalAttribute(AttributeType attributeType) {
        LinkedList<Attribute> attributes = new LinkedList<Attribute>();
        List<Attribute> attrs = this.operationalAttributes.get(attributeType);
        if (attrs != null) {
            for (Attribute a : attrs) {
                attributes.add(a.duplicate());
            }
        }
        if (attributeType.mayHaveSubordinateTypes()) {
            for (AttributeType at : this.schema.getSubTypes(attributeType)) {
                attrs = this.operationalAttributes.get(at);
                if (attrs == null) continue;
                for (Attribute a : attrs) {
                    attributes.add(a.duplicate());
                }
            }
        }
        if (attributes.isEmpty()) {
            return null;
        }
        return attributes;
    }

    public void putAttribute(AttributeType attributeType, List<Attribute> attributeList) {
        this.attachment = null;
        List<Attribute> attrList = this.userAttributes.get(attributeType);
        if (attrList != null) {
            this.userAttributes.put(attributeType, attributeList);
            return;
        }
        attrList = this.operationalAttributes.get(attributeType);
        if (attrList != null) {
            this.operationalAttributes.put(attributeType, attributeList);
            return;
        }
        if (attributeType.isOperational()) {
            this.operationalAttributes.put(attributeType, attributeList);
        } else {
            this.userAttributes.put(attributeType, attributeList);
        }
    }

    public void addAttribute(Attribute attribute, List<AttributeValue> duplicateValues) {
        this.attachment = null;
        List<Attribute> attrList = this.getAttribute(attribute.getAttributeType());
        if (attrList == null) {
            attrList = new ArrayList<Attribute>(1);
            attrList.add(attribute);
            AttributeType attrType = attribute.getAttributeType();
            if (attrType.isOperational()) {
                this.operationalAttributes.put(attrType, attrList);
            } else {
                this.userAttributes.put(attrType, attrList);
            }
            return;
        }
        LinkedHashSet<String> options = attribute.getOptions();
        for (Attribute a : attrList) {
            if (!a.optionsEqual(options)) continue;
            LinkedHashSet<AttributeValue> existingValues = a.getValues();
            LinkedHashSet<AttributeValue> newValues = attribute.getValues();
            for (AttributeValue v : newValues) {
                if (existingValues.add(v)) continue;
                duplicateValues.add(v);
            }
            return;
        }
        attrList.add(attribute);
    }

    public boolean removeAttribute(AttributeType attributeType) {
        this.attachment = null;
        if (attributeType.isObjectClassType()) {
            this.objectClasses.clear();
            return true;
        }
        return this.userAttributes.remove(attributeType) != null || this.operationalAttributes.remove(attributeType) != null;
    }

    public boolean removeAttribute(AttributeType attributeType, Set<String> options) {
        this.attachment = null;
        if (options == null || options.isEmpty()) {
            return this.removeAttribute(attributeType);
        }
        List<Attribute> attrList = this.userAttributes.get(attributeType);
        if (attrList == null && (attrList = this.operationalAttributes.get(attributeType)) == null) {
            return false;
        }
        boolean removed = false;
        Iterator<Attribute> iterator = attrList.iterator();
        while (iterator.hasNext()) {
            Attribute a = iterator.next();
            if (!a.optionsEqual(options)) continue;
            iterator.remove();
            removed = true;
            break;
        }
        if (attrList.isEmpty()) {
            this.userAttributes.remove(attributeType);
            this.operationalAttributes.remove(attributeType);
        }
        return removed;
    }

    public boolean removeAttribute(Attribute attribute, List<AttributeValue> missingValues) {
        this.attachment = null;
        if (attribute.getAttributeType().isObjectClassType()) {
            LinkedHashSet<AttributeValue> valueSet = attribute.getValues();
            if (valueSet == null || valueSet.isEmpty()) {
                this.objectClasses.clear();
                return true;
            }
            boolean allSuccessful = true;
            for (AttributeValue v : attribute.getValues()) {
                String ocName;
                try {
                    ocName = v.getNormalizedStringValue();
                }
                catch (Exception e) {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugCaught(DebugLogLevel.ERROR, e);
                    }
                    ocName = StaticUtils.toLowerCase(v.getStringValue());
                }
                boolean matchFound = false;
                for (ObjectClass oc : this.objectClasses.keySet()) {
                    if (!oc.hasNameOrOID(ocName)) continue;
                    matchFound = true;
                    this.objectClasses.remove(oc);
                    break;
                }
                if (matchFound) continue;
                allSuccessful = false;
                missingValues.add(v);
            }
            return allSuccessful;
        }
        if (attribute.hasOptions()) {
            LinkedHashSet<String> options = attribute.getOptions();
            LinkedHashSet<AttributeValue> valueSet = attribute.getValues();
            if (valueSet == null || valueSet.isEmpty()) {
                return this.removeAttribute(attribute.getAttributeType(), options);
            }
            List<Attribute> attrList = this.getAttribute(attribute.getAttributeType());
            if (attrList == null) {
                return false;
            }
            for (Attribute a : attrList) {
                if (!a.optionsEqual(options)) continue;
                LinkedHashSet<AttributeValue> existingValueSet = a.getValues();
                for (AttributeValue v : valueSet) {
                    if (existingValueSet.remove(v)) continue;
                    missingValues.add(v);
                }
                if (existingValueSet.isEmpty()) {
                    return this.removeAttribute(attribute.getAttributeType(), options);
                }
                return true;
            }
            return false;
        }
        LinkedHashSet<AttributeValue> valueSet = attribute.getValues();
        if (valueSet == null || valueSet.isEmpty()) {
            return this.removeAttribute(attribute.getAttributeType());
        }
        List<Attribute> attrList = this.getAttribute(attribute.getAttributeType());
        if (attrList == null) {
            return false;
        }
        for (Attribute a : attrList) {
            if (a.hasOptions()) continue;
            LinkedHashSet<AttributeValue> existingValueSet = a.getValues();
            for (AttributeValue v : valueSet) {
                if (existingValueSet.remove(v)) continue;
                missingValues.add(v);
            }
            if (existingValueSet.isEmpty()) {
                return this.removeAttribute(attribute.getAttributeType());
            }
            return true;
        }
        return false;
    }

    public boolean allowsAttribute(AttributeType attributeType) {
        for (ObjectClass o : this.objectClasses.keySet()) {
            if (!o.isRequiredOrOptional(attributeType)) continue;
            return true;
        }
        return false;
    }

    public boolean requiresAttribute(AttributeType attributeType) {
        for (ObjectClass o : this.objectClasses.keySet()) {
            if (!o.isRequired(attributeType)) continue;
            return true;
        }
        return false;
    }

    public boolean hasValue(AttributeType attributeType, Set<String> options, AttributeValue value) {
        List<Attribute> attrList = this.getAttribute(attributeType);
        if (attrList == null || attrList.isEmpty()) {
            return false;
        }
        for (Attribute a : attrList) {
            if (!a.optionsEqual(options)) continue;
            return a.hasValue(value);
        }
        return false;
    }

    public void applyModification(Modification mod) throws DirectoryException {
        Attribute a = mod.getAttribute();
        AttributeType t = a.getAttributeType();
        if (t.isObjectClassType()) {
            LinkedHashMap<ObjectClass, String> ocs = new LinkedHashMap<ObjectClass, String>();
            for (AttributeValue v : a.getValues()) {
                String ocName = v.getStringValue();
                String lowerName = StaticUtils.toLowerCase(ocName);
                ObjectClass oc = DirectoryServer.getObjectClass(lowerName, true);
                ocs.put(oc, ocName);
            }
            switch (mod.getModificationType()) {
                case ADD: {
                    Message message;
                    for (ObjectClass oc : ocs.keySet()) {
                        if (this.objectClasses.containsKey(oc)) {
                            message = CoreMessages.ERR_ENTRY_DUPLICATE_VALUES.get(a.getName());
                            throw new DirectoryException(ResultCode.ATTRIBUTE_OR_VALUE_EXISTS, message);
                        }
                        this.objectClasses.put(oc, ocs.get(oc));
                    }
                    break;
                }
                case DELETE: {
                    Message message;
                    for (ObjectClass oc : ocs.keySet()) {
                        if (this.objectClasses.remove(oc) != null) continue;
                        message = CoreMessages.ERR_ENTRY_NO_SUCH_VALUE.get(a.getName());
                        throw new DirectoryException(ResultCode.NO_SUCH_ATTRIBUTE, message);
                    }
                    break;
                }
                case REPLACE: {
                    this.objectClasses = ocs;
                    break;
                }
                case INCREMENT: {
                    Message message = CoreMessages.ERR_ENTRY_OC_INCREMENT_NOT_SUPPORTED.get();
                    throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message);
                }
                default: {
                    Message message = CoreMessages.ERR_ENTRY_UNKNOWN_MODIFICATION_TYPE.get(String.valueOf((Object)mod.getModificationType()));
                    throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message);
                }
            }
            return;
        }
        switch (mod.getModificationType()) {
            case ADD: {
                LinkedList<AttributeValue> duplicateValues = new LinkedList<AttributeValue>();
                this.addAttribute(a, duplicateValues);
                if (duplicateValues.isEmpty()) break;
                Message message = CoreMessages.ERR_ENTRY_DUPLICATE_VALUES.get(a.getName());
                throw new DirectoryException(ResultCode.ATTRIBUTE_OR_VALUE_EXISTS, message);
            }
            case DELETE: {
                LinkedList<AttributeValue> missingValues = new LinkedList<AttributeValue>();
                this.removeAttribute(a, missingValues);
                if (missingValues.isEmpty()) break;
                Message message = CoreMessages.ERR_ENTRY_NO_SUCH_VALUE.get(a.getName());
                throw new DirectoryException(ResultCode.NO_SUCH_ATTRIBUTE, message);
            }
            case REPLACE: {
                this.removeAttribute(t, a.getOptions());
                if (!a.hasValue()) break;
                LinkedList<AttributeValue> duplicateValues = new LinkedList<AttributeValue>();
                this.addAttribute(a, duplicateValues);
                break;
            }
            case INCREMENT: {
                long newValue;
                List<Attribute> attrList = this.getAttribute(t);
                if (attrList == null || attrList.isEmpty()) {
                    Message message = CoreMessages.ERR_ENTRY_INCREMENT_NO_SUCH_ATTRIBUTE.get(a.getName());
                    throw new DirectoryException(ResultCode.NO_SUCH_ATTRIBUTE, message);
                }
                if (attrList.size() != 1) {
                    Message message = CoreMessages.ERR_ENTRY_INCREMENT_MULTIPLE_VALUES.get(a.getName());
                    throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, message);
                }
                LinkedHashSet<AttributeValue> values = attrList.get(0).getValues();
                if (values.isEmpty()) {
                    Message message = CoreMessages.ERR_ENTRY_INCREMENT_NO_SUCH_ATTRIBUTE.get(a.getName());
                    throw new DirectoryException(ResultCode.NO_SUCH_ATTRIBUTE, message);
                }
                if (values.size() > 1) {
                    Message message = CoreMessages.ERR_ENTRY_INCREMENT_MULTIPLE_VALUES.get(a.getName());
                    throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, message);
                }
                LinkedHashSet<AttributeValue> newValues = a.getValues();
                if (newValues.size() != 1) {
                    Message message = CoreMessages.ERR_ENTRY_INCREMENT_INVALID_VALUE_COUNT.get(a.getName());
                    throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, message);
                }
                try {
                    String s = ((AttributeValue)values.iterator().next()).getStringValue();
                    long currentValue = Long.parseLong(s);
                    s = ((AttributeValue)a.getValues().iterator().next()).getStringValue();
                    long increment = Long.parseLong(s);
                    newValue = currentValue + increment;
                }
                catch (NumberFormatException nfe) {
                    Message message = CoreMessages.ERR_ENTRY_INCREMENT_CANNOT_PARSE_AS_INT.get(a.getName());
                    throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, message);
                }
                values.clear();
                values.add(new AttributeValue(t, String.valueOf(newValue)));
                break;
            }
            default: {
                Message message = CoreMessages.ERR_ENTRY_UNKNOWN_MODIFICATION_TYPE.get(String.valueOf((Object)mod.getModificationType()));
                throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message);
            }
        }
    }

    public void applyModifications(List<Modification> mods) throws DirectoryException {
        for (Modification m : mods) {
            this.applyModification(m);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean conformsToSchema(Entry parentEntry, boolean parentProvided, boolean validateNameForms, boolean validateStructureRules, MessageBuilder invalidReason) {
        DN parentDN;
        RDN rdn;
        Message message16;
        Message message2;
        AcceptRejectWarn structuralPolicy = DirectoryServer.getSingleStructuralObjectClassPolicy();
        ObjectClass structuralClass = null;
        boolean multipleOCErrorLogged = false;
        for (ObjectClass oc : this.objectClasses.keySet()) {
            if (oc.getObjectClassType() != ObjectClassType.STRUCTURAL) continue;
            if (structuralClass == null || oc.isDescendantOf(structuralClass)) {
                structuralClass = oc;
                continue;
            }
            if (structuralClass.isDescendantOf(oc)) continue;
            Message message3 = CoreMessages.ERR_ENTRY_SCHEMA_MULTIPLE_STRUCTURAL_CLASSES.get(String.valueOf(this.dn), structuralClass.getNameOrOID(), oc.getNameOrOID());
            if (structuralPolicy == AcceptRejectWarn.REJECT) {
                invalidReason.append(message3);
                return false;
            }
            if (structuralPolicy != AcceptRejectWarn.WARN || multipleOCErrorLogged) continue;
            ErrorLogger.logError(message3);
            multipleOCErrorLogged = true;
        }
        NameForm nameForm = null;
        DITContentRule ditContentRule = null;
        DITStructureRule ditStructureRule = null;
        if (structuralClass == null) {
            Message message4 = CoreMessages.ERR_ENTRY_SCHEMA_NO_STRUCTURAL_CLASS.get(String.valueOf(this.dn));
            if (structuralPolicy == AcceptRejectWarn.REJECT) {
                invalidReason.append(message4);
                return false;
            }
            if (structuralPolicy == AcceptRejectWarn.WARN) {
                ErrorLogger.logError(message4);
            }
        } else {
            ditContentRule = DirectoryServer.getDITContentRule(structuralClass);
            if (ditContentRule != null && ditContentRule.isObsolete()) {
                ditContentRule = null;
            }
            if (validateNameForms) {
                nameForm = DirectoryServer.getNameForm(structuralClass);
                if (nameForm != null && nameForm.isObsolete()) {
                    nameForm = null;
                }
                if (validateStructureRules && nameForm != null && (ditStructureRule = DirectoryServer.getDITStructureRule(nameForm)) != null && ditStructureRule.isObsolete()) {
                    ditStructureRule = null;
                }
            }
        }
        for (ObjectClass o : this.objectClasses.keySet()) {
            Message message5;
            if (DirectoryServer.getObjectClass(o.getOID()) == null) {
                message5 = CoreMessages.ERR_ENTRY_SCHEMA_UNKNOWN_OC.get(String.valueOf(this.dn), o.getNameOrOID());
                invalidReason.append(message5);
                return false;
            }
            if (o.getObjectClassType() == ObjectClassType.AUXILIARY && ditContentRule != null && !ditContentRule.getAuxiliaryClasses().contains(o)) {
                message5 = CoreMessages.ERR_ENTRY_SCHEMA_DISALLOWED_AUXILIARY_CLASS.get(String.valueOf(this.dn), o.getNameOrOID(), ditContentRule.getName());
                if (structuralPolicy == AcceptRejectWarn.REJECT) {
                    invalidReason.append(message5);
                    return false;
                }
                if (structuralPolicy == AcceptRejectWarn.WARN) {
                    ErrorLogger.logError(message5);
                }
            }
            for (AttributeType t : o.getRequiredAttributes()) {
                if (this.userAttributes.containsKey(t) || this.operationalAttributes.containsKey(t) || t.isObjectClassType()) continue;
                Message message6 = CoreMessages.ERR_ENTRY_SCHEMA_MISSING_REQUIRED_ATTR_FOR_OC.get(String.valueOf(this.dn), t.getNameOrOID(), o.getNameOrOID());
                invalidReason.append(message6);
                return false;
            }
        }
        for (AttributeType t : this.userAttributes.keySet()) {
            boolean found = false;
            for (ObjectClass o : this.objectClasses.keySet()) {
                if (!o.isRequiredOrOptional(t)) continue;
                found = true;
                break;
            }
            if (!found && ditContentRule != null && ditContentRule.isRequiredOrOptional(t)) {
                found = true;
            }
            if (!found) {
                message2 = CoreMessages.ERR_ENTRY_SCHEMA_DISALLOWED_USER_ATTR_FOR_OC.get(String.valueOf(this.dn), t.getNameOrOID());
                invalidReason.append(message2);
                return false;
            }
            List<Attribute> attrList = this.userAttributes.get(t);
            if (attrList == null) continue;
            for (Attribute a : attrList) {
                LinkedHashSet<AttributeValue> values = a.getValues();
                if (values.isEmpty()) {
                    Message message7 = CoreMessages.ERR_ENTRY_SCHEMA_ATTR_NO_VALUES.get(String.valueOf(this.dn), t.getNameOrOID());
                    invalidReason.append(message7);
                    return false;
                }
                if (!t.isSingleValue() || values.size() == 1) continue;
                Message message8 = CoreMessages.ERR_ENTRY_SCHEMA_ATTR_SINGLE_VALUED.get(String.valueOf(this.dn), t.getNameOrOID());
                invalidReason.append(message8);
                return false;
            }
        }
        for (AttributeType t : this.operationalAttributes.keySet()) {
            List<Attribute> attrList;
            if (!t.isSingleValue() || (attrList = this.operationalAttributes.get(t)) == null) continue;
            for (Attribute a : attrList) {
                if (a.getValues().size() <= 1) continue;
                message16 = CoreMessages.ERR_ENTRY_SCHEMA_ATTR_SINGLE_VALUED.get(String.valueOf(this.dn), t.getNameOrOID());
                invalidReason.append(message16);
                return false;
            }
        }
        if (nameForm != null && (rdn = this.dn.getRDN()) != null) {
            for (AttributeType t : nameForm.getRequiredAttributes()) {
                if (rdn.hasAttributeType(t)) continue;
                message2 = CoreMessages.ERR_ENTRY_SCHEMA_RDN_MISSING_REQUIRED_ATTR.get(String.valueOf(this.dn), t.getNameOrOID(), nameForm.getNameOrOID());
                if (structuralPolicy == AcceptRejectWarn.REJECT) {
                    invalidReason.append(message2);
                    return false;
                }
                if (structuralPolicy != AcceptRejectWarn.WARN) continue;
                ErrorLogger.logError(message2);
            }
            int numAVAs = rdn.getNumValues();
            for (int i = 0; i < numAVAs; ++i) {
                AttributeType t;
                t = rdn.getAttributeType(i);
                if (nameForm.isRequiredOrOptional(t)) continue;
                Message message9 = CoreMessages.ERR_ENTRY_SCHEMA_RDN_DISALLOWED_ATTR.get(String.valueOf(this.dn), t.getNameOrOID(), nameForm.getNameOrOID());
                if (structuralPolicy == AcceptRejectWarn.REJECT) {
                    invalidReason.append(message9);
                    return false;
                }
                if (structuralPolicy != AcceptRejectWarn.WARN) continue;
                ErrorLogger.logError(message9);
            }
        }
        if (ditContentRule != null) {
            for (AttributeType t : ditContentRule.getRequiredAttributes()) {
                if (this.userAttributes.containsKey(t) || this.operationalAttributes.containsKey(t) || t.isObjectClassType()) continue;
                Message message10 = CoreMessages.ERR_ENTRY_SCHEMA_MISSING_REQUIRED_ATTR_FOR_DCR.get(String.valueOf(this.dn), t.getNameOrOID(), ditContentRule.getName());
                if (structuralPolicy == AcceptRejectWarn.REJECT) {
                    invalidReason.append(message10);
                    return false;
                }
                if (structuralPolicy != AcceptRejectWarn.WARN) continue;
                ErrorLogger.logError(message10);
            }
            for (AttributeType t : ditContentRule.getProhibitedAttributes()) {
                if (!this.userAttributes.containsKey(t) && !this.operationalAttributes.containsKey(t)) continue;
                Message message11 = CoreMessages.ERR_ENTRY_SCHEMA_PROHIBITED_ATTR_FOR_DCR.get(String.valueOf(this.dn), t.getNameOrOID(), ditContentRule.getName());
                if (structuralPolicy == AcceptRejectWarn.REJECT) {
                    invalidReason.append(message11);
                    return false;
                }
                if (structuralPolicy != AcceptRejectWarn.WARN) continue;
                ErrorLogger.logError(message11);
            }
        }
        if (ditStructureRule != null && ditStructureRule.hasSuperiorRules()) {
            if (parentProvided) {
                boolean dsrValid;
                if (parentEntry == null || (dsrValid = this.validateDITStructureRule(ditStructureRule, structuralClass, parentEntry, structuralPolicy, invalidReason))) return true;
                return false;
            }
            DN parentDN2 = this.dn.getParentDNInSuffix();
            if (parentDN2 == null) return true;
            Lock lock = null;
            for (int i = 0; i < 3 && (lock = LockManager.lockRead(parentDN2)) == null; ++i) {
            }
            if (lock == null) {
                Message message12 = CoreMessages.ERR_ENTRY_SCHEMA_DSR_COULD_NOT_LOCK_PARENT.get(String.valueOf(this.dn), String.valueOf(parentDN2));
                if (structuralPolicy == AcceptRejectWarn.REJECT) {
                    invalidReason.append(message12);
                    return false;
                }
                if (structuralPolicy != AcceptRejectWarn.WARN) return true;
                ErrorLogger.logError(message12);
                return true;
            } else {
                try {
                    parentEntry = DirectoryServer.getEntry(parentDN2);
                    if (parentEntry == null) {
                        Message message13 = CoreMessages.ERR_ENTRY_SCHEMA_DSR_NO_PARENT_ENTRY.get(String.valueOf(this.dn), String.valueOf(parentDN2));
                        if (structuralPolicy == AcceptRejectWarn.REJECT) {
                            invalidReason.append(message13);
                            boolean t = false;
                            return t;
                        }
                        if (structuralPolicy != AcceptRejectWarn.WARN) return true;
                        ErrorLogger.logError(message13);
                        return true;
                    }
                    boolean dsrValid = this.validateDITStructureRule(ditStructureRule, structuralClass, parentEntry, structuralPolicy, invalidReason);
                    if (dsrValid) return true;
                    boolean t = false;
                    return t;
                }
                catch (Exception e) {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugCaught(DebugLogLevel.ERROR, e);
                    }
                    message2 = CoreMessages.ERR_ENTRY_SCHEMA_COULD_NOT_CHECK_DSR.get(String.valueOf(this.dn), ditStructureRule.getNameOrRuleID(), StaticUtils.getExceptionMessage(e));
                    if (structuralPolicy == AcceptRejectWarn.REJECT) {
                        invalidReason.append(message2);
                        boolean message9 = false;
                        return message9;
                    }
                    if (structuralPolicy != AcceptRejectWarn.WARN) return true;
                    ErrorLogger.logError(message2);
                    return true;
                }
                finally {
                    LockManager.unlock(parentDN2, lock);
                }
            }
        }
        if (!validateStructureRules) return true;
        boolean parentExists = false;
        ObjectClass parentStructuralClass = null;
        if (parentEntry != null) {
            parentExists = true;
            parentStructuralClass = parentEntry.getStructuralObjectClass();
        } else if (!parentProvided && (parentDN = this.getDN().getParentDNInSuffix()) != null) {
            Lock lock = null;
            for (int i = 0; i < 3 && (lock = LockManager.lockRead(parentDN)) == null; ++i) {
            }
            if (lock == null) {
                Message message14 = CoreMessages.ERR_ENTRY_SCHEMA_DSR_COULD_NOT_LOCK_PARENT.get(String.valueOf(this.dn), String.valueOf(parentDN));
                if (structuralPolicy == AcceptRejectWarn.REJECT) {
                    invalidReason.append(message14);
                    return false;
                }
                if (structuralPolicy == AcceptRejectWarn.WARN) {
                    ErrorLogger.logError(message14);
                }
            } else {
                try {
                    parentEntry = DirectoryServer.getEntry(parentDN);
                    if (parentEntry == null) {
                        Message message15 = CoreMessages.ERR_ENTRY_SCHEMA_DSR_NO_PARENT_ENTRY.get(String.valueOf(this.dn), String.valueOf(parentDN));
                        if (structuralPolicy == AcceptRejectWarn.REJECT) {
                            invalidReason.append(message15);
                            boolean message16 = false;
                            return message16;
                        }
                        if (structuralPolicy == AcceptRejectWarn.WARN) {
                            ErrorLogger.logError(message15);
                        }
                    } else {
                        parentExists = true;
                        parentStructuralClass = parentEntry.getStructuralObjectClass();
                    }
                }
                catch (Exception e) {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugCaught(DebugLogLevel.ERROR, e);
                    }
                    message16 = CoreMessages.ERR_ENTRY_SCHEMA_COULD_NOT_CHECK_PARENT_DSR.get(String.valueOf(this.dn), StaticUtils.getExceptionMessage(e));
                    if (structuralPolicy == AcceptRejectWarn.REJECT) {
                        invalidReason.append(message16);
                        boolean bl = false;
                        return bl;
                    }
                    if (structuralPolicy == AcceptRejectWarn.WARN) {
                        ErrorLogger.logError(message16);
                    }
                }
                finally {
                    LockManager.unlock(parentDN, lock);
                }
            }
        }
        if (!parentExists) return true;
        if (parentStructuralClass == null) {
            Message message17 = CoreMessages.ERR_ENTRY_SCHEMA_DSR_NO_PARENT_OC.get(String.valueOf(this.dn), String.valueOf(parentEntry.getDN()));
            if (structuralPolicy == AcceptRejectWarn.REJECT) {
                invalidReason.append(message17);
                return false;
            }
            if (structuralPolicy != AcceptRejectWarn.WARN) return true;
            ErrorLogger.logError(message17);
            return true;
        } else {
            DITStructureRule parentDSR;
            NameForm parentNF = DirectoryServer.getNameForm(parentStructuralClass);
            if (parentNF == null || parentNF.isObsolete() || (parentDSR = DirectoryServer.getDITStructureRule(parentNF)) == null || parentDSR.isObsolete()) return true;
            Message message18 = CoreMessages.ERR_ENTRY_SCHEMA_VIOLATES_PARENT_DSR.get(String.valueOf(this.dn), String.valueOf(parentEntry.getDN()));
            if (structuralPolicy == AcceptRejectWarn.REJECT) {
                invalidReason.append(message18);
                return false;
            }
            if (structuralPolicy != AcceptRejectWarn.WARN) return true;
            ErrorLogger.logError(message18);
        }
        return true;
    }

    private boolean validateDITStructureRule(DITStructureRule dsr, ObjectClass structuralClass, Entry parentEntry, AcceptRejectWarn structuralPolicy, MessageBuilder invalidReason) {
        ObjectClass oc = parentEntry.getStructuralObjectClass();
        if (oc == null) {
            Message message = CoreMessages.ERR_ENTRY_SCHEMA_DSR_NO_PARENT_OC.get(String.valueOf(this.dn), String.valueOf(parentEntry.getDN()));
            if (structuralPolicy == AcceptRejectWarn.REJECT) {
                invalidReason.append(message);
                return false;
            }
            if (structuralPolicy == AcceptRejectWarn.WARN) {
                ErrorLogger.logError(message);
            }
        }
        boolean matchFound = false;
        for (DITStructureRule dsr2 : dsr.getSuperiorRules()) {
            if (!dsr2.getStructuralClass().equals(oc)) continue;
            matchFound = true;
        }
        if (!matchFound) {
            Message message = CoreMessages.ERR_ENTRY_SCHEMA_DSR_DISALLOWED_SUPERIOR_OC.get(String.valueOf(this.dn), dsr.getNameOrRuleID(), structuralClass.getNameOrOID(), oc.getNameOrOID());
            if (structuralPolicy == AcceptRejectWarn.REJECT) {
                invalidReason.append(message);
                return false;
            }
            if (structuralPolicy == AcceptRejectWarn.WARN) {
                ErrorLogger.logError(message);
            }
        }
        return true;
    }

    public Object getAttachment() {
        return this.attachment;
    }

    public void setAttachment(Object attachment) {
        this.attachment = attachment;
    }

    public Entry duplicate(boolean processVirtual) {
        HashMap<ObjectClass, String> objectClassesCopy = new HashMap<ObjectClass, String>(this.objectClasses);
        HashMap<AttributeType, List<Attribute>> userAttrsCopy = new HashMap<AttributeType, List<Attribute>>(this.userAttributes.size());
        this.deepCopy(this.userAttributes, userAttrsCopy, false);
        HashMap<AttributeType, List<Attribute>> operationalAttrsCopy = new HashMap<AttributeType, List<Attribute>>(this.operationalAttributes.size());
        this.deepCopy(this.operationalAttributes, operationalAttrsCopy, false);
        for (AttributeType t : this.suppressedAttributes.keySet()) {
            List<Attribute> attrList = this.suppressedAttributes.get(t);
            if (t.isOperational()) {
                this.operationalAttributes.put(t, attrList);
                continue;
            }
            this.userAttributes.put(t, attrList);
        }
        Entry e = new Entry(this.dn, objectClassesCopy, userAttrsCopy, operationalAttrsCopy);
        if (processVirtual) {
            e.processVirtualAttributes();
        }
        return e;
    }

    public Entry duplicateWithoutOperationalAttributes(boolean typesOnly, boolean processVirtual) {
        HashMap<Object, Object> objectClassesCopy = typesOnly ? new HashMap(0) : new HashMap<ObjectClass, String>(this.objectClasses);
        HashMap<AttributeType, List<Attribute>> userAttrsCopy = new HashMap<AttributeType, List<Attribute>>(this.userAttributes.size());
        if (typesOnly) {
            AttributeType ocType = DirectoryServer.getObjectClassAttributeType();
            ArrayList<Attribute> ocList = new ArrayList<Attribute>(1);
            ocList.add(new Attribute(ocType));
            userAttrsCopy.put(ocType, ocList);
        }
        this.deepCopy(this.userAttributes, userAttrsCopy, typesOnly);
        HashMap<AttributeType, List<Attribute>> operationalAttrsCopy = new HashMap<AttributeType, List<Attribute>>(0);
        for (AttributeType t : this.suppressedAttributes.keySet()) {
            List<Attribute> attrList = this.suppressedAttributes.get(t);
            if (t.isOperational()) continue;
            this.userAttributes.put(t, attrList);
        }
        Entry e = new Entry(this.dn, objectClassesCopy, userAttrsCopy, operationalAttrsCopy);
        if (processVirtual) {
            e.processVirtualAttributes(false);
        }
        return e;
    }

    private void deepCopy(Map<AttributeType, List<Attribute>> source, Map<AttributeType, List<Attribute>> target, boolean omitValues) {
        for (AttributeType t : source.keySet()) {
            List<Attribute> sourceList = source.get(t);
            ArrayList<Attribute> targetList = new ArrayList<Attribute>(sourceList.size());
            for (Attribute a : sourceList) {
                if (a.isVirtual()) continue;
                targetList.add(a.duplicate(omitValues));
            }
            if (targetList.isEmpty()) continue;
            target.put(t, targetList);
        }
    }

    public Entry duplicateWithoutAttributes() {
        HashMap<ObjectClass, String> objectClassesCopy = new HashMap<ObjectClass, String>(this.objectClasses.size());
        HashMap<AttributeType, List<Attribute>> userAttrsCopy = new HashMap<AttributeType, List<Attribute>>(this.userAttributes.size());
        HashMap<AttributeType, List<Attribute>> operationalAttrsCopy = new HashMap<AttributeType, List<Attribute>>(this.operationalAttributes.size());
        return new Entry(this.dn, objectClassesCopy, userAttrsCopy, operationalAttrsCopy);
    }

    public boolean isReferral() {
        ObjectClass referralOC = DirectoryServer.getObjectClass("referral");
        if (referralOC == null) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugWarning("No %s objectclass is defined in the server schema.", "referral");
            }
            for (String ocName : this.objectClasses.values()) {
                if (!ocName.equalsIgnoreCase("referral")) continue;
                return true;
            }
            return false;
        }
        if (!this.objectClasses.containsKey(referralOC)) {
            return false;
        }
        AttributeType referralType = DirectoryServer.getAttributeType("ref");
        if (referralType == null) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugWarning("No %s attribute type is defined in the server schema.", "ref");
            }
            return false;
        }
        return this.userAttributes.containsKey(referralType) || this.operationalAttributes.containsKey(referralType);
    }

    public LinkedHashSet<String> getReferralURLs() {
        AttributeType referralType = DirectoryServer.getAttributeType("ref");
        if (referralType == null) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugWarning("No %s attribute type is defined in the server schema.", "ref");
            }
            return null;
        }
        List<Attribute> refAttrs = this.userAttributes.get(referralType);
        if (refAttrs == null && (refAttrs = this.operationalAttributes.get(referralType)) == null) {
            return null;
        }
        LinkedHashSet<String> referralURLs = new LinkedHashSet<String>();
        for (Attribute a : refAttrs) {
            for (AttributeValue v : a.getValues()) {
                referralURLs.add(v.getStringValue());
            }
        }
        return referralURLs;
    }

    public boolean isAlias() {
        ObjectClass aliasOC = DirectoryServer.getObjectClass("alias");
        if (aliasOC == null) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugWarning("No %s objectclass is defined in the server schema.", "alias");
            }
            for (String ocName : this.objectClasses.values()) {
                if (!ocName.equalsIgnoreCase("alias")) continue;
                return true;
            }
            return false;
        }
        if (!this.objectClasses.containsKey(aliasOC)) {
            return false;
        }
        AttributeType aliasType = DirectoryServer.getAttributeType("aliasedobjectname");
        if (aliasType == null) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugWarning("No %s attribute type is defined in the server schema.", "aliasedobjectname");
            }
            return false;
        }
        return this.userAttributes.containsKey(aliasType) || this.operationalAttributes.containsKey(aliasType);
    }

    public DN getAliasedDN() throws DirectoryException {
        AttributeType aliasType = DirectoryServer.getAttributeType("ref");
        if (aliasType == null) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugWarning("No %s attribute type is defined in the server schema.", "aliasedobjectname");
            }
            return null;
        }
        List<Attribute> aliasAttrs = this.userAttributes.get(aliasType);
        if (aliasAttrs == null && (aliasAttrs = this.operationalAttributes.get(aliasType)) == null) {
            return null;
        }
        if (aliasAttrs.isEmpty()) {
            return null;
        }
        Attribute aliasAttr = aliasAttrs.get(0);
        LinkedHashSet<AttributeValue> attrValues = aliasAttr.getValues();
        if (attrValues.isEmpty()) {
            return null;
        }
        return DN.decode(((AttributeValue)attrValues.iterator().next()).getStringValue());
    }

    public boolean isLDAPSubentry() {
        ObjectClass ldapSubentryOC = DirectoryServer.getObjectClass("ldapsubentry");
        if (ldapSubentryOC == null) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugWarning("No %s objectclass is defined in the server schema.", "ldapSubentry");
            }
            for (String ocName : this.objectClasses.values()) {
                if (!ocName.equalsIgnoreCase("ldapSubentry")) continue;
                return true;
            }
            return false;
        }
        return this.objectClasses.containsKey(ldapSubentryOC);
    }

    public boolean matchesBaseAndScope(DN baseDN, SearchScope scope) {
        return this.dn.matchesBaseAndScope(baseDN, scope);
    }

    public void processVirtualAttributes() {
        this.processVirtualAttributes(true);
    }

    public void processVirtualAttributes(boolean includeOperational) {
        for (VirtualAttributeRule rule : DirectoryServer.getVirtualAttributes(this)) {
            AttributeType attributeType = rule.getAttributeType();
            if (attributeType.isOperational() && !includeOperational) continue;
            List<Attribute> attrList = this.userAttributes.get(attributeType);
            if (attrList == null || attrList.isEmpty()) {
                attrList = this.operationalAttributes.get(attributeType);
                if (attrList == null || attrList.isEmpty()) {
                    attrList = new LinkedList<Attribute>();
                    attrList.add(new VirtualAttribute(attributeType, this, rule));
                    if (attributeType.isOperational()) {
                        this.operationalAttributes.put(attributeType, attrList);
                        continue;
                    }
                    this.userAttributes.put(attributeType, attrList);
                    continue;
                }
                if (attrList.get(0).isVirtual()) continue;
                switch (rule.getConflictBehavior()) {
                    case REAL_OVERRIDES_VIRTUAL: {
                        break;
                    }
                    case VIRTUAL_OVERRIDES_REAL: {
                        this.suppressedAttributes.put(attributeType, attrList);
                        attrList = new LinkedList<Attribute>();
                        attrList.add(new VirtualAttribute(attributeType, this, rule));
                        this.operationalAttributes.put(attributeType, attrList);
                        break;
                    }
                    case MERGE_REAL_AND_VIRTUAL: {
                        attrList.add(new VirtualAttribute(attributeType, this, rule));
                    }
                }
                continue;
            }
            if (attrList.get(0).isVirtual()) continue;
            switch (rule.getConflictBehavior()) {
                case REAL_OVERRIDES_VIRTUAL: {
                    break;
                }
                case VIRTUAL_OVERRIDES_REAL: {
                    this.suppressedAttributes.put(attributeType, attrList);
                    attrList = new LinkedList<Attribute>();
                    attrList.add(new VirtualAttribute(attributeType, this, rule));
                    this.userAttributes.put(attributeType, attrList);
                    break;
                }
                case MERGE_REAL_AND_VIRTUAL: {
                    attrList.add(new VirtualAttribute(attributeType, this, rule));
                }
            }
        }
        this.virtualAttributeProcessingPerformed = true;
    }

    public boolean virtualAttributeProcessingPerformed() {
        return this.virtualAttributeProcessingPerformed;
    }

    public void stripRealAttributes() {
        Attribute a;
        Iterator<Attribute> attrIterator;
        Map.Entry<AttributeType, List<Attribute>> mapEntry;
        this.objectClasses.clear();
        Iterator<Map.Entry<AttributeType, List<Attribute>>> attrListIterator = this.userAttributes.entrySet().iterator();
        while (attrListIterator.hasNext()) {
            mapEntry = attrListIterator.next();
            attrIterator = mapEntry.getValue().iterator();
            while (attrIterator.hasNext()) {
                a = attrIterator.next();
                if (a.isVirtual()) continue;
                attrIterator.remove();
            }
            if (!mapEntry.getValue().isEmpty()) continue;
            attrListIterator.remove();
        }
        attrListIterator = this.operationalAttributes.entrySet().iterator();
        while (attrListIterator.hasNext()) {
            mapEntry = attrListIterator.next();
            attrIterator = mapEntry.getValue().iterator();
            while (attrIterator.hasNext()) {
                a = attrIterator.next();
                if (a.isVirtual()) continue;
                attrIterator.remove();
            }
            if (!mapEntry.getValue().isEmpty()) continue;
            attrListIterator.remove();
        }
    }

    public void stripVirtualAttributes() {
        Attribute a;
        Iterator<Attribute> attrIterator;
        Map.Entry<AttributeType, List<Attribute>> mapEntry;
        Iterator<Map.Entry<AttributeType, List<Attribute>>> attrListIterator = this.userAttributes.entrySet().iterator();
        while (attrListIterator.hasNext()) {
            mapEntry = attrListIterator.next();
            attrIterator = mapEntry.getValue().iterator();
            while (attrIterator.hasNext()) {
                a = attrIterator.next();
                if (!a.isVirtual()) continue;
                attrIterator.remove();
            }
            if (!mapEntry.getValue().isEmpty()) continue;
            attrListIterator.remove();
        }
        attrListIterator = this.operationalAttributes.entrySet().iterator();
        while (attrListIterator.hasNext()) {
            mapEntry = attrListIterator.next();
            attrIterator = mapEntry.getValue().iterator();
            while (attrIterator.hasNext()) {
                a = attrIterator.next();
                if (!a.isVirtual()) continue;
                attrIterator.remove();
            }
            if (!mapEntry.getValue().isEmpty()) continue;
            attrListIterator.remove();
        }
    }

    public byte[] encode(EntryEncodeConfig config) throws DirectoryException {
        return this.encodeV2(config);
    }

    public byte[] encodeV1() {
        byte[] dnBytes = StaticUtils.getBytes(this.dn.toString());
        byte[] dnLength = ASN1Element.encodeLength(dnBytes.length);
        int totalBytes = 1 + dnBytes.length + dnLength.length;
        int i = 0;
        int totalOCBytes = this.objectClasses.size() - 1;
        byte[][] ocBytes = new byte[this.objectClasses.size()][];
        for (String ocName : this.objectClasses.values()) {
            ocBytes[i] = StaticUtils.getBytes(ocName);
            totalOCBytes += ocBytes[i++].length;
        }
        byte[] ocLength = ASN1Element.encodeLength(totalOCBytes);
        totalBytes += totalOCBytes + ocLength.length;
        i = 0;
        int numUserAttributes = 0;
        int totalUserAttrBytes = 0;
        LinkedList<byte[]> userAttrBytes = new LinkedList<byte[]>();
        for (List<Attribute> attrList : this.userAttributes.values()) {
            for (Attribute a : attrList) {
                if (a.isVirtual() || !a.hasValue()) continue;
                ++numUserAttributes;
                byte[] nameBytes = StaticUtils.getBytes(a.getNameWithOptions());
                int numValues = 0;
                int totalValueBytes = 0;
                LinkedList<byte[]> valueBytes = new LinkedList<byte[]>();
                for (AttributeValue v : a.getValues()) {
                    ++numValues;
                    byte[] vBytes = v.getValueBytes();
                    byte[] vLength = ASN1Element.encodeLength(vBytes.length);
                    valueBytes.add(vLength);
                    valueBytes.add(vBytes);
                    totalValueBytes += vLength.length + vBytes.length;
                }
                byte[] numValuesBytes = ASN1Element.encodeLength(numValues);
                byte[] attrBytes = new byte[nameBytes.length + numValuesBytes.length + totalValueBytes + 1];
                System.arraycopy(nameBytes, 0, attrBytes, 0, nameBytes.length);
                int pos = nameBytes.length + 1;
                System.arraycopy(numValuesBytes, 0, attrBytes, pos, numValuesBytes.length);
                pos += numValuesBytes.length;
                for (byte[] b : valueBytes) {
                    System.arraycopy(b, 0, attrBytes, pos, b.length);
                    pos += b.length;
                }
                userAttrBytes.add(attrBytes);
                totalUserAttrBytes += attrBytes.length;
            }
        }
        byte[] userAttrCount = ASN1OctetString.encodeLength(numUserAttributes);
        totalBytes += totalUserAttrBytes + userAttrCount.length;
        i = 0;
        int numOperationalAttributes = 0;
        int totalOperationalAttrBytes = 0;
        LinkedList<byte[]> operationalAttrBytes = new LinkedList<byte[]>();
        for (List<Attribute> attrList : this.operationalAttributes.values()) {
            for (Attribute a : attrList) {
                if (a.isVirtual() || !a.hasValue()) continue;
                ++numOperationalAttributes;
                byte[] nameBytes = StaticUtils.getBytes(a.getNameWithOptions());
                int numValues = 0;
                int totalValueBytes = 0;
                LinkedList<byte[]> valueBytes = new LinkedList<byte[]>();
                for (AttributeValue v : a.getValues()) {
                    ++numValues;
                    byte[] vBytes = v.getValueBytes();
                    byte[] vLength = ASN1Element.encodeLength(vBytes.length);
                    valueBytes.add(vLength);
                    valueBytes.add(vBytes);
                    totalValueBytes += vLength.length + vBytes.length;
                }
                byte[] numValuesBytes = ASN1Element.encodeLength(numValues);
                byte[] attrBytes = new byte[nameBytes.length + numValuesBytes.length + totalValueBytes + 1];
                System.arraycopy(nameBytes, 0, attrBytes, 0, nameBytes.length);
                int pos = nameBytes.length + 1;
                System.arraycopy(numValuesBytes, 0, attrBytes, pos, numValuesBytes.length);
                pos += numValuesBytes.length;
                for (byte[] b : valueBytes) {
                    System.arraycopy(b, 0, attrBytes, pos, b.length);
                    pos += b.length;
                }
                operationalAttrBytes.add(attrBytes);
                totalOperationalAttrBytes += attrBytes.length;
            }
        }
        byte[] operationalAttrCount = ASN1OctetString.encodeLength(numOperationalAttributes);
        byte[] entryBytes = new byte[totalBytes += totalOperationalAttrBytes + operationalAttrCount.length];
        entryBytes[0] = 1;
        System.arraycopy(dnLength, 0, entryBytes, 1, dnLength.length);
        int pos = 1 + dnLength.length;
        System.arraycopy(dnBytes, 0, entryBytes, pos, dnBytes.length);
        System.arraycopy(ocLength, 0, entryBytes, pos += dnBytes.length, ocLength.length);
        pos += ocLength.length;
        for (byte[] b : ocBytes) {
            System.arraycopy(b, 0, entryBytes, pos, b.length);
            pos += b.length + 1;
        }
        System.arraycopy(userAttrCount, 0, entryBytes, --pos, userAttrCount.length);
        pos += userAttrCount.length;
        for (byte[] b : userAttrBytes) {
            System.arraycopy(b, 0, entryBytes, pos, b.length);
            pos += b.length;
        }
        System.arraycopy(operationalAttrCount, 0, entryBytes, pos, operationalAttrCount.length);
        pos += operationalAttrCount.length;
        for (byte[] b : operationalAttrBytes) {
            System.arraycopy(b, 0, entryBytes, pos, b.length);
            pos += b.length;
        }
        return entryBytes;
    }

    public byte[] encodeV2(EntryEncodeConfig config) throws DirectoryException {
        byte[] ocLength;
        byte[] configBytes = config.encode();
        byte[] configLength = ASN1Element.encodeLength(configBytes.length);
        int totalBytes = 1 + configBytes.length + configLength.length;
        byte[] dnBytes = null;
        byte[] dnLength = null;
        if (!config.excludeDN()) {
            dnBytes = StaticUtils.getBytes(this.dn.toString());
            dnLength = ASN1Element.encodeLength(dnBytes.length);
            totalBytes += dnBytes.length + dnLength.length;
        }
        LinkedList<byte[]> ocBytes = new LinkedList<byte[]>();
        if (config.compressObjectClassSets()) {
            byte[] b = CompressedSchema.encodeObjectClasses(this.objectClasses);
            ocBytes.add(b);
            ocLength = ASN1Element.encodeLength(b.length);
            totalBytes += ocLength.length + b.length;
        } else {
            int totalOCBytes = this.objectClasses.size() - 1;
            for (String ocName : this.objectClasses.values()) {
                byte[] b = StaticUtils.getBytes(ocName);
                ocBytes.add(b);
                totalOCBytes += b.length;
            }
            ocLength = ASN1Element.encodeLength(totalOCBytes);
            totalBytes += totalOCBytes + ocLength.length;
        }
        int numUserAttributes = 0;
        int totalUserAttrBytes = 0;
        LinkedList<byte[]> userAttrBytes = new LinkedList<byte[]>();
        if (config.compressAttributeDescriptions()) {
            for (List<Attribute> attrList : this.userAttributes.values()) {
                for (Attribute a : attrList) {
                    if (a.isVirtual() || !a.hasValue()) continue;
                    ++numUserAttributes;
                    byte[] attrBytes = CompressedSchema.encodeAttribute(a);
                    byte[] lengthBytes = ASN1Element.encodeLength(attrBytes.length);
                    userAttrBytes.add(lengthBytes);
                    userAttrBytes.add(attrBytes);
                    totalUserAttrBytes += lengthBytes.length + attrBytes.length;
                }
            }
        } else {
            for (List<Attribute> attrList : this.userAttributes.values()) {
                for (Attribute a : attrList) {
                    if (a.isVirtual() || !a.hasValue()) continue;
                    ++numUserAttributes;
                    byte[] nameBytes = StaticUtils.getBytes(a.getNameWithOptions());
                    int numValues = 0;
                    int totalValueBytes = 0;
                    LinkedList<byte[]> valueBytes = new LinkedList<byte[]>();
                    for (AttributeValue v : a.getValues()) {
                        ++numValues;
                        byte[] vBytes = v.getValueBytes();
                        byte[] vLength = ASN1Element.encodeLength(vBytes.length);
                        valueBytes.add(vLength);
                        valueBytes.add(vBytes);
                        totalValueBytes += vLength.length + vBytes.length;
                    }
                    byte[] numValuesBytes = ASN1Element.encodeLength(numValues);
                    byte[] attrBytes = new byte[nameBytes.length + numValuesBytes.length + totalValueBytes + 1];
                    System.arraycopy(nameBytes, 0, attrBytes, 0, nameBytes.length);
                    int pos = nameBytes.length + 1;
                    System.arraycopy(numValuesBytes, 0, attrBytes, pos, numValuesBytes.length);
                    pos += numValuesBytes.length;
                    for (byte[] b : valueBytes) {
                        System.arraycopy(b, 0, attrBytes, pos, b.length);
                        pos += b.length;
                    }
                    userAttrBytes.add(attrBytes);
                    totalUserAttrBytes += attrBytes.length;
                }
            }
        }
        byte[] userAttrCount = ASN1OctetString.encodeLength(numUserAttributes);
        totalBytes += totalUserAttrBytes + userAttrCount.length;
        int numOperationalAttributes = 0;
        int totalOperationalAttrBytes = 0;
        LinkedList<byte[]> operationalAttrBytes = new LinkedList<byte[]>();
        if (config.compressAttributeDescriptions()) {
            for (List<Attribute> attrList : this.operationalAttributes.values()) {
                for (Attribute a : attrList) {
                    if (a.isVirtual() || !a.hasValue()) continue;
                    ++numOperationalAttributes;
                    byte[] attrBytes = CompressedSchema.encodeAttribute(a);
                    byte[] lengthBytes = ASN1Element.encodeLength(attrBytes.length);
                    operationalAttrBytes.add(lengthBytes);
                    operationalAttrBytes.add(attrBytes);
                    totalOperationalAttrBytes += lengthBytes.length + attrBytes.length;
                }
            }
        } else {
            for (List<Attribute> attrList : this.operationalAttributes.values()) {
                for (Attribute a : attrList) {
                    if (a.isVirtual() || !a.hasValue()) continue;
                    ++numOperationalAttributes;
                    byte[] nameBytes = StaticUtils.getBytes(a.getNameWithOptions());
                    int numValues = 0;
                    int totalValueBytes = 0;
                    LinkedList<byte[]> valueBytes = new LinkedList<byte[]>();
                    for (AttributeValue v : a.getValues()) {
                        ++numValues;
                        byte[] vBytes = v.getValueBytes();
                        byte[] vLength = ASN1Element.encodeLength(vBytes.length);
                        valueBytes.add(vLength);
                        valueBytes.add(vBytes);
                        totalValueBytes += vLength.length + vBytes.length;
                    }
                    byte[] numValuesBytes = ASN1Element.encodeLength(numValues);
                    byte[] attrBytes = new byte[nameBytes.length + numValuesBytes.length + totalValueBytes + 1];
                    System.arraycopy(nameBytes, 0, attrBytes, 0, nameBytes.length);
                    int pos = nameBytes.length + 1;
                    System.arraycopy(numValuesBytes, 0, attrBytes, pos, numValuesBytes.length);
                    pos += numValuesBytes.length;
                    for (byte[] b : valueBytes) {
                        System.arraycopy(b, 0, attrBytes, pos, b.length);
                        pos += b.length;
                    }
                    operationalAttrBytes.add(attrBytes);
                    totalOperationalAttrBytes += attrBytes.length;
                }
            }
        }
        byte[] operationalAttrCount = ASN1OctetString.encodeLength(numOperationalAttributes);
        byte[] entryBytes = new byte[totalBytes += totalOperationalAttrBytes + operationalAttrCount.length];
        entryBytes[0] = 2;
        System.arraycopy(configLength, 0, entryBytes, 1, configLength.length);
        int pos = 1 + configLength.length;
        System.arraycopy(configBytes, 0, entryBytes, pos, configBytes.length);
        pos += configBytes.length;
        if (!config.excludeDN()) {
            System.arraycopy(dnLength, 0, entryBytes, pos, dnLength.length);
            System.arraycopy(dnBytes, 0, entryBytes, pos += dnLength.length, dnBytes.length);
            pos += dnBytes.length;
        }
        System.arraycopy(ocLength, 0, entryBytes, pos, ocLength.length);
        pos += ocLength.length;
        if (config.compressObjectClassSets()) {
            for (byte[] b : ocBytes) {
                System.arraycopy(b, 0, entryBytes, pos, b.length);
                pos += b.length;
            }
        } else {
            for (byte[] b : ocBytes) {
                System.arraycopy(b, 0, entryBytes, pos, b.length);
                pos += b.length + 1;
            }
            --pos;
        }
        System.arraycopy(userAttrCount, 0, entryBytes, pos, userAttrCount.length);
        pos += userAttrCount.length;
        for (byte[] b : userAttrBytes) {
            System.arraycopy(b, 0, entryBytes, pos, b.length);
            pos += b.length;
        }
        System.arraycopy(operationalAttrCount, 0, entryBytes, pos, operationalAttrCount.length);
        pos += operationalAttrCount.length;
        for (byte[] b : operationalAttrBytes) {
            System.arraycopy(b, 0, entryBytes, pos, b.length);
            pos += b.length;
        }
        return entryBytes;
    }

    public static Entry decode(byte[] entryBytes) throws DirectoryException {
        switch (entryBytes[0]) {
            case 1: {
                return Entry.decodeV1(entryBytes);
            }
            case 2: {
                return Entry.decodeV2(entryBytes);
            }
        }
        Message message = CoreMessages.ERR_ENTRY_DECODE_UNRECOGNIZED_VERSION.get(StaticUtils.byteToHex(entryBytes[0]));
        throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message);
    }

    public static Entry decodeV1(byte[] entryBytes) throws DirectoryException {
        try {
            int i;
            int numOperationalAttrs;
            int i2;
            int dnLength;
            if (entryBytes[0] != 1) {
                Message message = CoreMessages.ERR_ENTRY_DECODE_UNRECOGNIZED_VERSION.get(StaticUtils.byteToHex(entryBytes[0]));
                throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message);
            }
            int pos = 1;
            if (entryBytes[pos++] != (dnLength = entryBytes[pos] & 0x7F)) {
                int numLengthBytes = dnLength;
                dnLength = 0;
                int i3 = 0;
                while (i3 < numLengthBytes) {
                    dnLength = dnLength << 8 | entryBytes[pos] & 0xFF;
                    ++i3;
                    ++pos;
                }
            }
            byte[] dnBytes = new byte[dnLength];
            System.arraycopy(entryBytes, pos, dnBytes, 0, dnLength);
            DN dn = DN.decode(new ASN1OctetString(dnBytes));
            int ocLength = entryBytes[pos += dnLength] & 0x7F;
            if (entryBytes[pos++] != ocLength) {
                int numLengthBytes = ocLength;
                ocLength = 0;
                int i4 = 0;
                while (i4 < numLengthBytes) {
                    ocLength = ocLength << 8 | entryBytes[pos] & 0xFF;
                    ++i4;
                    ++pos;
                }
            }
            LinkedHashMap<ObjectClass, String> objectClasses = new LinkedHashMap<ObjectClass, String>();
            int startPos = pos;
            int i5 = 0;
            while (i5 < ocLength) {
                if (entryBytes[pos] == 0) {
                    String name = new String(entryBytes, startPos, pos - startPos, "UTF-8");
                    String lowerName = StaticUtils.toLowerCase(name);
                    ObjectClass oc = DirectoryServer.getObjectClass(lowerName, true);
                    objectClasses.put(oc, name);
                    startPos = pos + 1;
                }
                ++i5;
                ++pos;
            }
            String name = new String(entryBytes, startPos, pos - startPos, "UTF-8");
            String lowerName = StaticUtils.toLowerCase(name);
            ObjectClass oc = DirectoryServer.getObjectClass(lowerName, true);
            objectClasses.put(oc, name);
            int numUserAttrs = entryBytes[pos] & 0x7F;
            if (entryBytes[pos++] != numUserAttrs) {
                int numLengthBytes = numUserAttrs;
                numUserAttrs = 0;
                i2 = 0;
                while (i2 < numLengthBytes) {
                    numUserAttrs = numUserAttrs << 8 | entryBytes[pos] & 0xFF;
                    ++i2;
                    ++pos;
                }
            }
            LinkedHashMap<AttributeType, List<Attribute>> userAttributes = new LinkedHashMap<AttributeType, List<Attribute>>();
            for (i2 = 0; i2 < numUserAttrs; ++i2) {
                int j;
                LinkedHashSet<String> options;
                startPos = pos;
                while (entryBytes[pos] != 0) {
                    ++pos;
                }
                name = new String(entryBytes, startPos, pos - startPos, "UTF-8");
                int semicolonPos = name.indexOf(59);
                if (semicolonPos > 0) {
                    String option;
                    String baseName = name.substring(0, semicolonPos);
                    lowerName = StaticUtils.toLowerCase(baseName);
                    options = new LinkedHashSet();
                    int nextPos = name.indexOf(59, semicolonPos + 1);
                    while (nextPos > 0) {
                        option = name.substring(semicolonPos + 1, nextPos);
                        if (option.length() > 0) {
                            options.add(option);
                        }
                        semicolonPos = nextPos;
                        nextPos = name.indexOf(59, semicolonPos + 1);
                    }
                    option = name.substring(semicolonPos + 1);
                    if (option.length() > 0) {
                        options.add(option);
                    }
                    name = baseName;
                } else {
                    lowerName = StaticUtils.toLowerCase(name);
                    options = new LinkedHashSet<String>(0);
                }
                AttributeType attributeType = DirectoryServer.getAttributeType(lowerName, true);
                int numValues = entryBytes[++pos] & 0x7F;
                if (entryBytes[pos++] != numValues) {
                    int numLengthBytes = numValues;
                    numValues = 0;
                    j = 0;
                    while (j < numLengthBytes) {
                        numValues = numValues << 8 | entryBytes[pos] & 0xFF;
                        ++j;
                        ++pos;
                    }
                }
                LinkedHashSet<AttributeValue> values = new LinkedHashSet<AttributeValue>(numValues);
                for (j = 0; j < numValues; ++j) {
                    int valueLength;
                    if (entryBytes[pos++] != (valueLength = entryBytes[pos] & 0x7F)) {
                        int numLengthBytes = valueLength;
                        valueLength = 0;
                        int k = 0;
                        while (k < numLengthBytes) {
                            valueLength = valueLength << 8 | entryBytes[pos] & 0xFF;
                            ++k;
                            ++pos;
                        }
                    }
                    byte[] valueBytes = new byte[valueLength];
                    System.arraycopy(entryBytes, pos, valueBytes, 0, valueLength);
                    values.add(new AttributeValue(attributeType, (ByteString)new ASN1OctetString(valueBytes)));
                    pos += valueLength;
                }
                Attribute a = new Attribute(attributeType, name, options, values);
                List<Attribute> attrList = userAttributes.get(attributeType);
                if (attrList == null) {
                    attrList = new ArrayList<Attribute>(1);
                    attrList.add(a);
                    userAttributes.put(attributeType, attrList);
                    continue;
                }
                attrList.add(a);
            }
            if (entryBytes[pos++] != (numOperationalAttrs = entryBytes[pos] & 0x7F)) {
                int numLengthBytes = numOperationalAttrs;
                numOperationalAttrs = 0;
                i = 0;
                while (i < numLengthBytes) {
                    numOperationalAttrs = numOperationalAttrs << 8 | entryBytes[pos] & 0xFF;
                    ++i;
                    ++pos;
                }
            }
            LinkedHashMap<AttributeType, List<Attribute>> operationalAttributes = new LinkedHashMap<AttributeType, List<Attribute>>();
            for (i = 0; i < numOperationalAttrs; ++i) {
                LinkedHashSet<String> options;
                startPos = pos;
                while (entryBytes[pos] != 0) {
                    ++pos;
                }
                name = new String(entryBytes, startPos, pos - startPos, "UTF-8");
                int semicolonPos = name.indexOf(59);
                if (semicolonPos > 0) {
                    String option;
                    String baseName = name.substring(0, semicolonPos);
                    lowerName = StaticUtils.toLowerCase(baseName);
                    options = new LinkedHashSet();
                    int nextPos = name.indexOf(59, semicolonPos + 1);
                    while (nextPos > 0) {
                        option = name.substring(semicolonPos + 1, nextPos);
                        if (option.length() > 0) {
                            options.add(option);
                        }
                        semicolonPos = nextPos;
                        nextPos = name.indexOf(59, semicolonPos + 1);
                    }
                    option = name.substring(semicolonPos + 1);
                    if (option.length() > 0) {
                        options.add(option);
                    }
                    name = baseName;
                } else {
                    lowerName = StaticUtils.toLowerCase(name);
                    options = new LinkedHashSet<String>(0);
                }
                AttributeType attributeType = DirectoryServer.getAttributeType(lowerName, true);
                int numValues = entryBytes[++pos] & 0x7F;
                if (entryBytes[pos++] != numValues) {
                    int numLengthBytes = numValues;
                    numValues = 0;
                    int j = 0;
                    while (j < numLengthBytes) {
                        numValues = numValues << 8 | entryBytes[pos] & 0xFF;
                        ++j;
                        ++pos;
                    }
                }
                LinkedHashSet<AttributeValue> values = new LinkedHashSet<AttributeValue>(numValues);
                for (int j = 0; j < numValues; ++j) {
                    int valueLength;
                    if (entryBytes[pos++] != (valueLength = entryBytes[pos] & 0x7F)) {
                        int numLengthBytes = valueLength;
                        valueLength = 0;
                        int k = 0;
                        while (k < numLengthBytes) {
                            valueLength = valueLength << 8 | entryBytes[pos] & 0xFF;
                            ++k;
                            ++pos;
                        }
                    }
                    byte[] valueBytes = new byte[valueLength];
                    System.arraycopy(entryBytes, pos, valueBytes, 0, valueLength);
                    values.add(new AttributeValue(attributeType, (ByteString)new ASN1OctetString(valueBytes)));
                    pos += valueLength;
                }
                Attribute a = new Attribute(attributeType, name, options, values);
                List<Attribute> attrList = operationalAttributes.get(attributeType);
                if (attrList == null) {
                    attrList = new ArrayList<Attribute>(1);
                    attrList.add(a);
                    operationalAttributes.put(attributeType, attrList);
                    continue;
                }
                attrList.add(a);
            }
            return new Entry(dn, objectClasses, userAttributes, operationalAttributes);
        }
        catch (DirectoryException de) {
            throw de;
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = CoreMessages.ERR_ENTRY_DECODE_EXCEPTION.get(StaticUtils.getExceptionMessage(e));
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message, e);
        }
    }

    public static Entry decodeV2(byte[] entryBytes) throws DirectoryException {
        try {
            int numOperationalAttrs;
            int i;
            Map<Object, Object> objectClasses;
            int i2;
            DN dn;
            int configLength;
            if (entryBytes[0] != 2) {
                Message message = CoreMessages.ERR_ENTRY_DECODE_UNRECOGNIZED_VERSION.get(StaticUtils.byteToHex(entryBytes[0]));
                throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message);
            }
            int pos = 1;
            if (entryBytes[pos++] != (configLength = entryBytes[pos] & 0x7F)) {
                int numLengthBytes = configLength;
                configLength = 0;
                int i3 = 0;
                while (i3 < numLengthBytes) {
                    configLength = configLength << 8 | entryBytes[pos] & 0xFF;
                    ++i3;
                    ++pos;
                }
            }
            EntryEncodeConfig config = EntryEncodeConfig.decode(entryBytes, pos, configLength);
            pos += configLength;
            if (config.excludeDN()) {
                dn = DN.NULL_DN;
            } else {
                int dnLength;
                if (entryBytes[pos++] != (dnLength = entryBytes[pos] & 0x7F)) {
                    int numLengthBytes = dnLength;
                    dnLength = 0;
                    i2 = 0;
                    while (i2 < numLengthBytes) {
                        dnLength = dnLength << 8 | entryBytes[pos] & 0xFF;
                        ++i2;
                        ++pos;
                    }
                }
                byte[] dnBytes = new byte[dnLength];
                System.arraycopy(entryBytes, pos, dnBytes, 0, dnLength);
                pos += dnLength;
                dn = DN.decode(new ASN1OctetString(dnBytes));
            }
            int ocLength = entryBytes[pos] & 0x7F;
            if (entryBytes[pos++] != ocLength) {
                int numLengthBytes = ocLength;
                ocLength = 0;
                i2 = 0;
                while (i2 < numLengthBytes) {
                    ocLength = ocLength << 8 | entryBytes[pos] & 0xFF;
                    ++i2;
                    ++pos;
                }
            }
            if (config.compressObjectClassSets()) {
                byte[] ocBytes = new byte[ocLength];
                System.arraycopy(entryBytes, pos, ocBytes, 0, ocLength);
                objectClasses = CompressedSchema.decodeObjectClasses(ocBytes);
                pos += ocLength;
            } else {
                objectClasses = new LinkedHashMap();
                int startPos = pos;
                int i4 = 0;
                while (i4 < ocLength) {
                    if (entryBytes[pos] == 0) {
                        String name = new String(entryBytes, startPos, pos - startPos, "UTF-8");
                        String lowerName = StaticUtils.toLowerCase(name);
                        ObjectClass oc = DirectoryServer.getObjectClass(lowerName, true);
                        objectClasses.put(oc, name);
                        startPos = pos + 1;
                    }
                    ++i4;
                    ++pos;
                }
                String name = new String(entryBytes, startPos, pos - startPos, "UTF-8");
                String lowerName = StaticUtils.toLowerCase(name);
                ObjectClass oc = DirectoryServer.getObjectClass(lowerName, true);
                objectClasses.put(oc, name);
            }
            int numUserAttrs = entryBytes[pos] & 0x7F;
            if (entryBytes[pos++] != numUserAttrs) {
                int numLengthBytes = numUserAttrs;
                numUserAttrs = 0;
                int i5 = 0;
                while (i5 < numLengthBytes) {
                    numUserAttrs = numUserAttrs << 8 | entryBytes[pos] & 0xFF;
                    ++i5;
                    ++pos;
                }
            }
            LinkedHashMap<AttributeType, List<Attribute>> userAttributes = new LinkedHashMap<AttributeType, List<Attribute>>();
            if (config.compressAttributeDescriptions()) {
                for (i = 0; i < numUserAttrs; ++i) {
                    Attribute a;
                    ArrayList<Attribute> attrList;
                    int attrLength;
                    if (entryBytes[pos++] != (attrLength = entryBytes[pos] & 0x7F)) {
                        int attrLengthBytes = attrLength;
                        attrLength = 0;
                        int j = 0;
                        while (j < attrLengthBytes) {
                            attrLength = attrLength << 8 | entryBytes[pos] & 0xFF;
                            ++j;
                            ++pos;
                        }
                    }
                    if ((attrList = (ArrayList<Attribute>)userAttributes.get((a = CompressedSchema.decodeAttribute(entryBytes, pos, attrLength)).getAttributeType())) == null) {
                        attrList = new ArrayList<Attribute>(1);
                        userAttributes.put(a.getAttributeType(), attrList);
                    }
                    attrList.add(a);
                    pos += attrLength;
                }
            } else {
                for (i = 0; i < numUserAttrs; ++i) {
                    int j;
                    LinkedHashSet<String> options;
                    String lowerName;
                    int startPos = pos;
                    while (entryBytes[pos] != 0) {
                        ++pos;
                    }
                    String name = new String(entryBytes, startPos, pos - startPos, "UTF-8");
                    int semicolonPos = name.indexOf(59);
                    if (semicolonPos > 0) {
                        String option;
                        String baseName = name.substring(0, semicolonPos);
                        lowerName = StaticUtils.toLowerCase(baseName);
                        options = new LinkedHashSet();
                        int nextPos = name.indexOf(59, semicolonPos + 1);
                        while (nextPos > 0) {
                            option = name.substring(semicolonPos + 1, nextPos);
                            if (option.length() > 0) {
                                options.add(option);
                            }
                            semicolonPos = nextPos;
                            nextPos = name.indexOf(59, semicolonPos + 1);
                        }
                        option = name.substring(semicolonPos + 1);
                        if (option.length() > 0) {
                            options.add(option);
                        }
                        name = baseName;
                    } else {
                        lowerName = StaticUtils.toLowerCase(name);
                        options = new LinkedHashSet<String>(0);
                    }
                    AttributeType attributeType = DirectoryServer.getAttributeType(lowerName, true);
                    int numValues = entryBytes[++pos] & 0x7F;
                    if (entryBytes[pos++] != numValues) {
                        int numLengthBytes = numValues;
                        numValues = 0;
                        j = 0;
                        while (j < numLengthBytes) {
                            numValues = numValues << 8 | entryBytes[pos] & 0xFF;
                            ++j;
                            ++pos;
                        }
                    }
                    LinkedHashSet<AttributeValue> values = new LinkedHashSet<AttributeValue>(numValues);
                    for (j = 0; j < numValues; ++j) {
                        int valueLength;
                        if (entryBytes[pos++] != (valueLength = entryBytes[pos] & 0x7F)) {
                            int numLengthBytes = valueLength;
                            valueLength = 0;
                            int k = 0;
                            while (k < numLengthBytes) {
                                valueLength = valueLength << 8 | entryBytes[pos] & 0xFF;
                                ++k;
                                ++pos;
                            }
                        }
                        byte[] valueBytes = new byte[valueLength];
                        System.arraycopy(entryBytes, pos, valueBytes, 0, valueLength);
                        values.add(new AttributeValue(attributeType, (ByteString)new ASN1OctetString(valueBytes)));
                        pos += valueLength;
                    }
                    Attribute a = new Attribute(attributeType, name, options, values);
                    List<Attribute> attrList = userAttributes.get(attributeType);
                    if (attrList == null) {
                        attrList = new ArrayList<Attribute>(1);
                        attrList.add(a);
                        userAttributes.put(attributeType, attrList);
                        continue;
                    }
                    attrList.add(a);
                }
            }
            if (entryBytes[pos++] != (numOperationalAttrs = entryBytes[pos] & 0x7F)) {
                int numLengthBytes = numOperationalAttrs;
                numOperationalAttrs = 0;
                int i6 = 0;
                while (i6 < numLengthBytes) {
                    numOperationalAttrs = numOperationalAttrs << 8 | entryBytes[pos] & 0xFF;
                    ++i6;
                    ++pos;
                }
            }
            LinkedHashMap<AttributeType, List<Attribute>> operationalAttributes = new LinkedHashMap<AttributeType, List<Attribute>>();
            if (config.compressAttributeDescriptions()) {
                for (int i7 = 0; i7 < numOperationalAttrs; ++i7) {
                    Attribute a;
                    List<Attribute> attrList;
                    int attrLength;
                    if (entryBytes[pos++] != (attrLength = entryBytes[pos] & 0x7F)) {
                        int attrLengthBytes = attrLength;
                        attrLength = 0;
                        int j = 0;
                        while (j < attrLengthBytes) {
                            attrLength = attrLength << 8 | entryBytes[pos] & 0xFF;
                            ++j;
                            ++pos;
                        }
                    }
                    if ((attrList = operationalAttributes.get((a = CompressedSchema.decodeAttribute(entryBytes, pos, attrLength)).getAttributeType())) == null) {
                        attrList = new ArrayList<Attribute>(1);
                        operationalAttributes.put(a.getAttributeType(), attrList);
                    }
                    attrList.add(a);
                    pos += attrLength;
                }
            } else {
                for (int i8 = 0; i8 < numOperationalAttrs; ++i8) {
                    LinkedHashSet<String> options;
                    String lowerName;
                    int startPos = pos;
                    while (entryBytes[pos] != 0) {
                        ++pos;
                    }
                    String name = new String(entryBytes, startPos, pos - startPos, "UTF-8");
                    int semicolonPos = name.indexOf(59);
                    if (semicolonPos > 0) {
                        String option;
                        String baseName = name.substring(0, semicolonPos);
                        lowerName = StaticUtils.toLowerCase(baseName);
                        options = new LinkedHashSet();
                        int nextPos = name.indexOf(59, semicolonPos + 1);
                        while (nextPos > 0) {
                            option = name.substring(semicolonPos + 1, nextPos);
                            if (option.length() > 0) {
                                options.add(option);
                            }
                            semicolonPos = nextPos;
                            nextPos = name.indexOf(59, semicolonPos + 1);
                        }
                        option = name.substring(semicolonPos + 1);
                        if (option.length() > 0) {
                            options.add(option);
                        }
                        name = baseName;
                    } else {
                        lowerName = StaticUtils.toLowerCase(name);
                        options = new LinkedHashSet<String>(0);
                    }
                    AttributeType attributeType = DirectoryServer.getAttributeType(lowerName, true);
                    int numValues = entryBytes[++pos] & 0x7F;
                    if (entryBytes[pos++] != numValues) {
                        int numLengthBytes = numValues;
                        numValues = 0;
                        int j = 0;
                        while (j < numLengthBytes) {
                            numValues = numValues << 8 | entryBytes[pos] & 0xFF;
                            ++j;
                            ++pos;
                        }
                    }
                    LinkedHashSet<AttributeValue> values = new LinkedHashSet<AttributeValue>(numValues);
                    for (int j = 0; j < numValues; ++j) {
                        int valueLength;
                        if (entryBytes[pos++] != (valueLength = entryBytes[pos] & 0x7F)) {
                            int numLengthBytes = valueLength;
                            valueLength = 0;
                            int k = 0;
                            while (k < numLengthBytes) {
                                valueLength = valueLength << 8 | entryBytes[pos] & 0xFF;
                                ++k;
                                ++pos;
                            }
                        }
                        byte[] valueBytes = new byte[valueLength];
                        System.arraycopy(entryBytes, pos, valueBytes, 0, valueLength);
                        values.add(new AttributeValue(attributeType, (ByteString)new ASN1OctetString(valueBytes)));
                        pos += valueLength;
                    }
                    Attribute a = new Attribute(attributeType, name, options, values);
                    List<Attribute> attrList = operationalAttributes.get(attributeType);
                    if (attrList == null) {
                        attrList = new ArrayList<Attribute>(1);
                        attrList.add(a);
                        operationalAttributes.put(attributeType, attrList);
                        continue;
                    }
                    attrList.add(a);
                }
            }
            return new Entry(dn, objectClasses, userAttributes, operationalAttributes);
        }
        catch (DirectoryException de) {
            throw de;
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = CoreMessages.ERR_ENTRY_DECODE_EXCEPTION.get(StaticUtils.getExceptionMessage(e));
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message, e);
        }
    }

    public List<StringBuilder> toLDIF() {
        StringBuilder attrLine;
        StringBuilder attrName;
        LinkedList<StringBuilder> ldifLines = new LinkedList<StringBuilder>();
        StringBuilder dnLine = new StringBuilder();
        dnLine.append("dn");
        LDIFWriter.appendLDIFSeparatorAndValue(dnLine, StaticUtils.getBytes(this.dn.toString()));
        ldifLines.add(dnLine);
        for (String string : this.objectClasses.values()) {
            StringBuilder ocLine = new StringBuilder();
            ocLine.append("objectClass: ");
            ocLine.append(string);
            ldifLines.add(ocLine);
        }
        for (List list : this.userAttributes.values()) {
            for (Attribute a : list) {
                attrName = new StringBuilder(a.getName());
                for (String o : a.getOptions()) {
                    attrName.append(";");
                    attrName.append(o);
                }
                for (AttributeValue v : a.getValues()) {
                    attrLine = new StringBuilder();
                    attrLine.append((CharSequence)attrName);
                    LDIFWriter.appendLDIFSeparatorAndValue(attrLine, v.getValueBytes());
                    ldifLines.add(attrLine);
                }
            }
        }
        for (List list : this.operationalAttributes.values()) {
            for (Attribute a : list) {
                attrName = new StringBuilder(a.getName());
                for (String o : a.getOptions()) {
                    attrName.append(";");
                    attrName.append(o);
                }
                for (AttributeValue v : a.getValues()) {
                    attrLine = new StringBuilder();
                    attrLine.append((CharSequence)attrName);
                    LDIFWriter.appendLDIFSeparatorAndValue(attrLine, v.getValueBytes());
                    ldifLines.add(attrLine);
                }
            }
        }
        return ldifLines;
    }

    public boolean toLDIF(LDIFExportConfig exportConfig) throws IOException, LDIFException {
        StringBuilder attrLine;
        StringBuilder attrName;
        List<Attribute> attrList;
        PluginConfigManager pluginConfigManager;
        LDIFPluginResult pluginResult;
        try {
            if (!exportConfig.includeEntry(this)) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugInfo("Skipping entry %s because of the export configuration.", String.valueOf(this.dn));
                }
                return false;
            }
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = UtilityMessages.ERR_LDIF_COULD_NOT_EVALUATE_FILTERS_FOR_EXPORT.get(String.valueOf(this.dn), String.valueOf(e));
            throw new LDIFException(message, (Throwable)e);
        }
        if (exportConfig.invokeExportPlugins() && !(pluginResult = (pluginConfigManager = DirectoryServer.getPluginConfigManager()).invokeLDIFExportPlugins(exportConfig, this)).continueEntryProcessing()) {
            return false;
        }
        BufferedWriter writer = exportConfig.getWriter();
        int wrapColumn = exportConfig.getWrapColumn();
        boolean wrapLines = wrapColumn > 1;
        StringBuilder dnLine = new StringBuilder();
        dnLine.append("dn");
        LDIFWriter.appendLDIFSeparatorAndValue(dnLine, StaticUtils.getBytes(this.dn.toString()));
        LDIFWriter.writeLDIFLine(dnLine, writer, wrapLines, wrapColumn);
        if (exportConfig.includeObjectClasses()) {
            if (exportConfig.typesOnly()) {
                StringBuilder ocLine = new StringBuilder("objectClass:");
                LDIFWriter.writeLDIFLine(ocLine, writer, wrapLines, wrapColumn);
            } else {
                for (String s : this.objectClasses.values()) {
                    StringBuilder ocLine = new StringBuilder();
                    ocLine.append("objectClass: ");
                    ocLine.append(s);
                    LDIFWriter.writeLDIFLine(ocLine, writer, wrapLines, wrapColumn);
                }
            }
        } else if (DebugLogger.debugEnabled()) {
            TRACER.debugVerbose("Skipping objectclasses for entry %s because of the export configuration.", String.valueOf(this.dn));
        }
        for (AttributeType attrType : this.userAttributes.keySet()) {
            if (exportConfig.includeAttribute(attrType)) {
                attrList = this.userAttributes.get(attrType);
                for (Attribute a : attrList) {
                    if (a.isVirtual() && !exportConfig.includeVirtualAttributes()) continue;
                    if (exportConfig.typesOnly()) {
                        attrName = new StringBuilder(a.getName());
                        for (String o : a.getOptions()) {
                            attrName.append(";");
                            attrName.append(o);
                        }
                        attrName.append(":");
                        LDIFWriter.writeLDIFLine(attrName, writer, wrapLines, wrapColumn);
                        continue;
                    }
                    attrName = new StringBuilder(a.getName());
                    for (String o : a.getOptions()) {
                        attrName.append(";");
                        attrName.append(o);
                    }
                    for (AttributeValue v : a.getValues()) {
                        attrLine = new StringBuilder();
                        attrLine.append((CharSequence)attrName);
                        LDIFWriter.appendLDIFSeparatorAndValue(attrLine, v.getValueBytes());
                        LDIFWriter.writeLDIFLine(attrLine, writer, wrapLines, wrapColumn);
                    }
                }
                continue;
            }
            if (!DebugLogger.debugEnabled()) continue;
            TRACER.debugVerbose("Skipping user attribute %s for entry %s because of the export configuration.", attrType.getNameOrOID(), String.valueOf(this.dn));
        }
        if (exportConfig.includeOperationalAttributes()) {
            for (AttributeType attrType : this.operationalAttributes.keySet()) {
                if (exportConfig.includeAttribute(attrType)) {
                    attrList = this.operationalAttributes.get(attrType);
                    for (Attribute a : attrList) {
                        if (a.isVirtual() && !exportConfig.includeVirtualAttributes()) continue;
                        if (exportConfig.typesOnly()) {
                            attrName = new StringBuilder(a.getName());
                            for (String o : a.getOptions()) {
                                attrName.append(";");
                                attrName.append(o);
                            }
                            attrName.append(":");
                            LDIFWriter.writeLDIFLine(attrName, writer, wrapLines, wrapColumn);
                            continue;
                        }
                        attrName = new StringBuilder(a.getName());
                        for (String o : a.getOptions()) {
                            attrName.append(";");
                            attrName.append(o);
                        }
                        for (AttributeValue v : a.getValues()) {
                            attrLine = new StringBuilder();
                            attrLine.append((CharSequence)attrName);
                            LDIFWriter.appendLDIFSeparatorAndValue(attrLine, v.getValueBytes());
                            LDIFWriter.writeLDIFLine(attrLine, writer, wrapLines, wrapColumn);
                        }
                    }
                    continue;
                }
                if (!DebugLogger.debugEnabled()) continue;
                TRACER.debugVerbose("Skipping operational attribute %s for entry %s because of the export configuration.", attrType.getNameOrOID(), String.valueOf(this.dn));
            }
        } else if (DebugLogger.debugEnabled()) {
            TRACER.debugVerbose("Skipping all operational attributes for entry %s because of the export configuration.", String.valueOf(this.dn));
        }
        if (!exportConfig.includeVirtualAttributes()) {
            for (AttributeType t : this.suppressedAttributes.keySet()) {
                if (!exportConfig.includeAttribute(t)) continue;
                for (Attribute a : this.suppressedAttributes.get(t)) {
                    StringBuilder attrName2;
                    if (exportConfig.typesOnly()) {
                        attrName2 = new StringBuilder(a.getName());
                        for (String o : a.getOptions()) {
                            attrName2.append(";");
                            attrName2.append(o);
                        }
                        attrName2.append(":");
                        LDIFWriter.writeLDIFLine(attrName2, writer, wrapLines, wrapColumn);
                        continue;
                    }
                    attrName2 = new StringBuilder(a.getName());
                    for (String o : a.getOptions()) {
                        attrName2.append(";");
                        attrName2.append(o);
                    }
                    for (AttributeValue v : a.getValues()) {
                        StringBuilder attrLine2 = new StringBuilder();
                        attrLine2.append((CharSequence)attrName2);
                        LDIFWriter.appendLDIFSeparatorAndValue(attrLine2, v.getValueBytes());
                        LDIFWriter.writeLDIFLine(attrLine2, writer, wrapLines, wrapColumn);
                    }
                }
            }
        }
        writer.newLine();
        return true;
    }

    @Override
    public String getProtocolElementName() {
        return "Entry";
    }

    public int hashCode() {
        int hashCode = this.dn.hashCode();
        for (ObjectClass objectClass : this.objectClasses.keySet()) {
            hashCode += objectClass.hashCode();
        }
        for (List list : this.userAttributes.values()) {
            for (Attribute a : list) {
                hashCode += a.hashCode();
            }
        }
        for (List list : this.operationalAttributes.values()) {
            for (Attribute a : list) {
                hashCode += a.hashCode();
            }
        }
        return hashCode;
    }

    public boolean equals(Object o) {
        List<Attribute> list2;
        List<Attribute> list1;
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (!(o instanceof Entry)) {
            return false;
        }
        Entry e = (Entry)o;
        if (!this.dn.equals(e.dn)) {
            return false;
        }
        if (!((Object)this.objectClasses.keySet()).equals(e.objectClasses.keySet())) {
            return false;
        }
        for (AttributeType at : this.userAttributes.keySet()) {
            list1 = this.userAttributes.get(at);
            list2 = e.userAttributes.get(at);
            if (list2 == null || list1.size() != list2.size()) {
                return false;
            }
            for (Attribute a : list1) {
                if (list2.contains(a)) continue;
                return false;
            }
        }
        for (AttributeType at : this.operationalAttributes.keySet()) {
            list1 = this.operationalAttributes.get(at);
            list2 = e.operationalAttributes.get(at);
            if (list2 == null || list1.size() != list2.size()) {
                return false;
            }
            for (Attribute a : list1) {
                if (list2.contains(a)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder buffer = new StringBuilder();
        this.toString(buffer);
        return buffer.toString();
    }

    @Override
    public void toString(StringBuilder buffer) {
        Iterator<AttributeType> attrs;
        buffer.append("Entry(dn=\"");
        this.dn.toString(buffer);
        buffer.append("\", objectClasses={");
        if (!this.objectClasses.isEmpty()) {
            Iterator<String> ocNames = this.objectClasses.values().iterator();
            buffer.append(ocNames.next());
            while (ocNames.hasNext()) {
                buffer.append(",");
                buffer.append(ocNames.next());
            }
        }
        buffer.append("}, userAttrs={");
        if (!this.userAttributes.isEmpty()) {
            attrs = this.userAttributes.keySet().iterator();
            buffer.append(attrs.next().getNameOrOID());
            while (attrs.hasNext()) {
                buffer.append(",");
                buffer.append(attrs.next().getNameOrOID());
            }
        }
        buffer.append("}, operationalAttrs={");
        if (!this.operationalAttributes.isEmpty()) {
            attrs = this.operationalAttributes.keySet().iterator();
            buffer.append(attrs.next().getNameOrOID());
            while (attrs.hasNext()) {
                buffer.append(",");
                buffer.append(attrs.next().getNameOrOID());
            }
        }
        buffer.append("})");
    }

    @Override
    public void toString(StringBuilder buffer, int indent) {
        StringBuilder indentBuf = new StringBuilder(indent);
        for (int i = 0; i < indent; ++i) {
            indentBuf.append(' ');
        }
        for (StringBuilder b : this.toLDIF()) {
            buffer.append((CharSequence)indentBuf);
            buffer.append((CharSequence)b);
            buffer.append(ServerConstants.EOL);
        }
    }

    public String toLDIFString() {
        StringBuilder buffer = new StringBuilder();
        for (StringBuilder ldifLine : this.toLDIF()) {
            buffer.append((CharSequence)ldifLine);
            buffer.append(ServerConstants.EOL);
        }
        return buffer.toString();
    }

    public String toSingleLineString() {
        StringBuilder buffer = new StringBuilder();
        this.toSingleLineString(buffer);
        return buffer.toString();
    }

    public void toSingleLineString(StringBuilder buffer) {
        Iterator valueIterator;
        buffer.append("Entry(dn=\"");
        this.dn.toString(buffer);
        buffer.append("\",objectClasses={");
        Iterator<String> iterator = this.objectClasses.values().iterator();
        if (iterator.hasNext()) {
            buffer.append(iterator.next());
            while (iterator.hasNext()) {
                buffer.append(",");
                buffer.append(iterator.next());
            }
        }
        buffer.append("},userAttrs={");
        boolean firstAttr = true;
        for (List<Attribute> attrList : this.userAttributes.values()) {
            for (Attribute a : attrList) {
                if (firstAttr) {
                    firstAttr = false;
                } else {
                    buffer.append(",");
                }
                buffer.append(a.getName());
                if (a.hasOptions()) {
                    for (String optionString : a.getOptions()) {
                        buffer.append(";");
                        buffer.append(optionString);
                    }
                }
                buffer.append("={");
                valueIterator = a.getValues().iterator();
                if (valueIterator.hasNext()) {
                    buffer.append(((AttributeValue)valueIterator.next()).getStringValue());
                    while (valueIterator.hasNext()) {
                        buffer.append(",");
                        buffer.append(((AttributeValue)valueIterator.next()).getStringValue());
                    }
                }
                buffer.append("}");
            }
        }
        buffer.append("},operationalAttrs={");
        for (List<Attribute> attrList : this.operationalAttributes.values()) {
            for (Attribute a : attrList) {
                if (firstAttr) {
                    firstAttr = false;
                } else {
                    buffer.append(",");
                }
                buffer.append(a.getName());
                if (a.hasOptions()) {
                    for (String optionString : a.getOptions()) {
                        buffer.append(";");
                        buffer.append(optionString);
                    }
                }
                buffer.append("={");
                valueIterator = a.getValues().iterator();
                if (valueIterator.hasNext()) {
                    buffer.append(((AttributeValue)valueIterator.next()).getStringValue());
                    while (valueIterator.hasNext()) {
                        buffer.append(",");
                        buffer.append(((AttributeValue)valueIterator.next()).getStringValue());
                    }
                }
                buffer.append("}");
            }
        }
        buffer.append("})");
    }
}

