/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.types;

import java.io.File;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.opends.messages.CoreMessages;
import org.opends.server.api.AccessLogPublisher;
import org.opends.server.api.ConfigHandler;
import org.opends.server.api.DebugLogPublisher;
import org.opends.server.api.ErrorLogPublisher;
import org.opends.server.config.ConfigConstants;
import org.opends.server.core.DirectoryServer;
import org.opends.server.extensions.ConfigFileHandler;
import org.opends.server.types.InitializationException;
import org.opends.server.types.PublicAPI;
import org.opends.server.types.StabilityLevel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@PublicAPI(stability=StabilityLevel.VOLATILE, mayInstantiate=true, mayExtend=false, mayInvoke=true)
public final class DirectoryEnvironmentConfig {
    private final ArrayList<AccessLogPublisher> accessLoggers;
    private final ArrayList<DebugLogPublisher> debugLoggers;
    private final ArrayList<ErrorLogPublisher> errorLoggers;
    private final HashMap<String, String> configProperties;

    public DirectoryEnvironmentConfig() {
        this(System.getProperties());
    }

    public DirectoryEnvironmentConfig(Properties properties) {
        this.configProperties = new HashMap();
        if (properties != null) {
            Enumeration<?> propertyNames = properties.propertyNames();
            while (propertyNames.hasMoreElements()) {
                Object o = propertyNames.nextElement();
                this.configProperties.put(String.valueOf(o), String.valueOf(properties.get(o)));
            }
        }
        this.accessLoggers = new ArrayList();
        this.debugLoggers = new ArrayList();
        this.errorLoggers = new ArrayList();
    }

    public DirectoryEnvironmentConfig(Map<String, String> properties) {
        this.configProperties = properties == null ? new HashMap() : new HashMap<String, String>(properties);
        this.accessLoggers = new ArrayList();
        this.debugLoggers = new ArrayList();
        this.errorLoggers = new ArrayList();
    }

    public String getProperty(String name) {
        String value = this.configProperties.get(name);
        if (value == null) {
            value = System.getProperty(name);
        }
        return value;
    }

    public String setProperty(String name, String value) throws InitializationException {
        if (DirectoryServer.isRunning()) {
            throw new InitializationException(CoreMessages.ERR_DIRCFG_SERVER_ALREADY_RUNNING.get());
        }
        if (value == null) {
            return this.configProperties.remove(name);
        }
        return this.configProperties.put(name, value);
    }

    public File getServerRoot() {
        String serverRootPath = this.getProperty("org.opends.server.ServerRoot");
        if (serverRootPath == null) {
            serverRootPath = System.getenv("INSTANCE_ROOT");
        }
        if (serverRootPath == null) {
            return null;
        }
        return new File(serverRootPath);
    }

    public File setServerRoot(File serverRoot) throws InitializationException {
        String serverRootPath;
        if (DirectoryServer.isRunning()) {
            throw new InitializationException(CoreMessages.ERR_DIRCFG_SERVER_ALREADY_RUNNING.get());
        }
        if (!serverRoot.exists() || !serverRoot.isDirectory()) {
            throw new InitializationException(CoreMessages.ERR_DIRCFG_INVALID_SERVER_ROOT.get(serverRoot.getAbsolutePath()));
        }
        try {
            serverRootPath = serverRoot.getCanonicalPath();
        }
        catch (Exception e) {
            serverRootPath = serverRoot.getAbsolutePath();
        }
        String oldRootPath = this.setProperty("org.opends.server.ServerRoot", serverRootPath);
        if (oldRootPath == null) {
            return null;
        }
        return new File(oldRootPath);
    }

    public File getConfigFile() {
        String configFilePath = this.getProperty("org.opends.server.ConfigFile");
        if (configFilePath == null) {
            File configDir;
            File configFile;
            File serverRoot = this.getServerRoot();
            if (serverRoot != null && (configFile = new File(configDir = new File(serverRoot, "config"), "config.ldif")).exists()) {
                return configFile;
            }
            return null;
        }
        return new File(configFilePath);
    }

    public File setConfigFile(File configFile) throws InitializationException {
        String configFilePath;
        if (DirectoryServer.isRunning()) {
            throw new InitializationException(CoreMessages.ERR_DIRCFG_SERVER_ALREADY_RUNNING.get());
        }
        if (!configFile.exists() || !configFile.isFile()) {
            throw new InitializationException(CoreMessages.ERR_DIRCFG_INVALID_CONFIG_FILE.get(configFile.getAbsolutePath()));
        }
        try {
            configFilePath = configFile.getCanonicalPath();
        }
        catch (Exception e) {
            configFilePath = configFile.getAbsolutePath();
        }
        String oldConfigFilePath = this.setProperty("org.opends.server.ConfigFile", configFilePath);
        if (oldConfigFilePath == null) {
            return null;
        }
        return new File(oldConfigFilePath);
    }

    public Class getConfigClass() {
        String className = this.getProperty("org.opends.server.ConfigClass");
        if (className == null) {
            return ConfigFileHandler.class;
        }
        try {
            return Class.forName(className);
        }
        catch (Exception e) {
            return ConfigFileHandler.class;
        }
    }

    public Class setConfigClass(Class configClass) throws InitializationException {
        if (DirectoryServer.isRunning()) {
            throw new InitializationException(CoreMessages.ERR_DIRCFG_SERVER_ALREADY_RUNNING.get());
        }
        if (!ConfigHandler.class.isAssignableFrom(configClass)) {
            throw new InitializationException(CoreMessages.ERR_DIRCFG_INVALID_CONFIG_CLASS.get(configClass.getName()));
        }
        String oldClassName = this.setProperty("org.opends.server.ConfigClass", configClass.getName());
        if (oldClassName == null) {
            return null;
        }
        try {
            return Class.forName(oldClassName);
        }
        catch (Exception e) {
            return null;
        }
    }

    public File getSchemaDirectory() {
        String schemaDirectoryPath = this.getProperty("org.opends.server.SchemaDirectory");
        if (schemaDirectoryPath == null) {
            File schemaDir;
            File serverRoot = this.getServerRoot();
            if (serverRoot != null && (schemaDir = new File(serverRoot.getAbsolutePath() + File.separator + ConfigConstants.PATH_SCHEMA_DIR)).exists() && schemaDir.isDirectory()) {
                return schemaDir;
            }
            return null;
        }
        return new File(schemaDirectoryPath);
    }

    public File setSchemaDirectory(File schemaDirectory) throws InitializationException {
        String schemaDirectoryPath;
        if (DirectoryServer.isRunning()) {
            throw new InitializationException(CoreMessages.ERR_DIRCFG_SERVER_ALREADY_RUNNING.get());
        }
        if (!schemaDirectory.exists() || !schemaDirectory.isDirectory()) {
            throw new InitializationException(CoreMessages.ERR_DIRCFG_INVALID_SCHEMA_DIRECTORY.get(schemaDirectory.getAbsolutePath()));
        }
        try {
            schemaDirectoryPath = schemaDirectory.getCanonicalPath();
        }
        catch (Exception e) {
            schemaDirectoryPath = schemaDirectory.getAbsolutePath();
        }
        String oldSchemaDir = this.setProperty("org.opends.server.SchemaDirectory", schemaDirectoryPath);
        if (oldSchemaDir == null) {
            return null;
        }
        return new File(oldSchemaDir);
    }

    public File getLockDirectory() {
        String lockFilePath = this.getProperty("org.opends.server.LockDirectory");
        if (lockFilePath == null) {
            File serverRoot = this.getServerRoot();
            if (serverRoot == null) {
                return null;
            }
            return new File(serverRoot, "locks");
        }
        return new File(lockFilePath);
    }

    public File setLockDirectory(File lockDirectory) throws InitializationException {
        String lockDirectoryPath;
        File parentFile;
        if (DirectoryServer.isRunning()) {
            throw new InitializationException(CoreMessages.ERR_DIRCFG_SERVER_ALREADY_RUNNING.get());
        }
        if (lockDirectory.exists() ? !lockDirectory.isDirectory() : !(parentFile = lockDirectory.getParentFile()).exists() || !parentFile.isDirectory()) {
            throw new InitializationException(CoreMessages.ERR_DIRCFG_INVALID_LOCK_DIRECTORY.get(lockDirectory.getAbsolutePath()));
        }
        try {
            lockDirectoryPath = lockDirectory.getCanonicalPath();
        }
        catch (Exception e) {
            lockDirectoryPath = lockDirectory.getAbsolutePath();
        }
        String oldLockDir = this.setProperty("org.opends.server.LockDirectory", lockDirectoryPath);
        if (oldLockDir == null) {
            return null;
        }
        return new File(oldLockDir);
    }

    public boolean disableConnectionHandlers() {
        String disableStr = this.getProperty("org.opends.server.DisableConnectionHandlers");
        if (disableStr == null) {
            return false;
        }
        return disableStr.equalsIgnoreCase("true");
    }

    public boolean setDisableConnectionHandlers(boolean disableConnectionHandlers) throws InitializationException {
        if (DirectoryServer.isRunning()) {
            throw new InitializationException(CoreMessages.ERR_DIRCFG_SERVER_ALREADY_RUNNING.get());
        }
        String oldDisableStr = this.setProperty("org.opends.server.DisableConnectionHandlers", String.valueOf(disableConnectionHandlers));
        if (oldDisableStr == null) {
            return false;
        }
        return oldDisableStr.equalsIgnoreCase("true");
    }

    public boolean forceDaemonThreads() {
        String forceDaemonStr = this.getProperty("org.opends.server.ForceDaemonThreads");
        if (forceDaemonStr == null) {
            return false;
        }
        return forceDaemonStr.equalsIgnoreCase("true");
    }

    public boolean setForceDaemonThreads(boolean forceDaemonThreads) throws InitializationException {
        if (DirectoryServer.isRunning()) {
            throw new InitializationException(CoreMessages.ERR_DIRCFG_SERVER_ALREADY_RUNNING.get());
        }
        String oldForceDaemonStr = this.setProperty("org.opends.server.ForceDaemonThreads", String.valueOf(forceDaemonThreads));
        if (oldForceDaemonStr == null) {
            return false;
        }
        return oldForceDaemonStr.equalsIgnoreCase("true");
    }

    public boolean disableExec() {
        String disableStr = this.getProperty("org.opends.server.DisableExec");
        if (disableStr == null) {
            return false;
        }
        return disableStr.equalsIgnoreCase("true");
    }

    public boolean setDisableExec(boolean disableExec) throws InitializationException {
        if (DirectoryServer.isRunning()) {
            throw new InitializationException(CoreMessages.ERR_DIRCFG_SERVER_ALREADY_RUNNING.get());
        }
        String oldDisableStr = this.setProperty("org.opends.server.DisableExec", String.valueOf(disableExec));
        if (oldDisableStr == null) {
            return false;
        }
        return oldDisableStr.equalsIgnoreCase("true");
    }

    public int getLockManagerConcurrencyLevel() {
        String levelStr = this.getProperty("org.opends.server.LockManagerConcurrencyLevel");
        if (levelStr == null) {
            return 32;
        }
        int concurrencyLevel = -1;
        try {
            concurrencyLevel = Integer.parseInt(levelStr);
        }
        catch (Exception e) {
            return 32;
        }
        if (concurrencyLevel <= 0) {
            return 32;
        }
        return concurrencyLevel;
    }

    public int setLockManagerConcurrencyLevel(int concurrencyLevel) throws InitializationException {
        if (DirectoryServer.isRunning()) {
            throw new InitializationException(CoreMessages.ERR_DIRCFG_SERVER_ALREADY_RUNNING.get());
        }
        if (concurrencyLevel <= 0) {
            throw new InitializationException(CoreMessages.ERR_DIRCFG_INVALID_CONCURRENCY_LEVEL.get(concurrencyLevel));
        }
        String concurrencyStr = this.setProperty("org.opends.server.LockManagerConcurrencyLevel", String.valueOf(concurrencyLevel));
        if (concurrencyStr == null) {
            return 32;
        }
        try {
            return Integer.parseInt(concurrencyStr);
        }
        catch (Exception e) {
            return 32;
        }
    }

    public boolean getLockManagerFairOrdering() {
        String sizeStr = this.getProperty("org.opends.server.LockManagerFairOrdering");
        if (sizeStr == null) {
            return true;
        }
        try {
            return Boolean.parseBoolean(sizeStr);
        }
        catch (Exception e) {
            return true;
        }
    }

    public boolean setLockManagerFairOrdering(boolean fairOrdering) throws InitializationException {
        if (DirectoryServer.isRunning()) {
            throw new InitializationException(CoreMessages.ERR_DIRCFG_SERVER_ALREADY_RUNNING.get());
        }
        String fairOrderingStr = this.setProperty("org.opends.server.LockManagerFairOrdering", String.valueOf(fairOrdering));
        if (fairOrderingStr == null) {
            return true;
        }
        try {
            return Boolean.parseBoolean(fairOrderingStr);
        }
        catch (Exception e) {
            return true;
        }
    }

    public int getLockManagerTableSize() {
        String sizeStr = this.getProperty("org.opends.server.LockManagerTableSize");
        if (sizeStr == null) {
            return 64;
        }
        try {
            return Integer.parseInt(sizeStr);
        }
        catch (Exception e) {
            return 64;
        }
    }

    public int setLockManagerTableSize(int lockTableSize) throws InitializationException {
        if (DirectoryServer.isRunning()) {
            throw new InitializationException(CoreMessages.ERR_DIRCFG_SERVER_ALREADY_RUNNING.get());
        }
        if (lockTableSize <= 0) {
            throw new InitializationException(CoreMessages.ERR_DIRCFG_INVALID_LOCK_TABLE_SIZE.get(lockTableSize));
        }
        String tableSizeStr = this.setProperty("org.opends.server.LockManagerTableSize", String.valueOf(lockTableSize));
        if (tableSizeStr == null) {
            return 64;
        }
        try {
            return Integer.parseInt(tableSizeStr);
        }
        catch (Exception e) {
            return 64;
        }
    }

    public List<AccessLogPublisher> getAccessLoggers() {
        return this.accessLoggers;
    }

    public void addAccessLogger(AccessLogPublisher accessLogger) throws InitializationException {
        if (DirectoryServer.isRunning()) {
            throw new InitializationException(CoreMessages.ERR_DIRCFG_SERVER_ALREADY_RUNNING.get());
        }
        this.accessLoggers.add(accessLogger);
    }

    public List<ErrorLogPublisher> getErrorLoggers() {
        return this.errorLoggers;
    }

    public void addErrorLogger(ErrorLogPublisher errorLogger) throws InitializationException {
        if (DirectoryServer.isRunning()) {
            throw new InitializationException(CoreMessages.ERR_DIRCFG_SERVER_ALREADY_RUNNING.get());
        }
        this.errorLoggers.add(errorLogger);
    }

    public List<DebugLogPublisher> getDebugLoggers() {
        return this.debugLoggers;
    }

    public void addDebugLogger(DebugLogPublisher debugLogger) throws InitializationException {
        if (DirectoryServer.isRunning()) {
            throw new InitializationException(CoreMessages.ERR_DIRCFG_SERVER_ALREADY_RUNNING.get());
        }
        this.debugLoggers.add(debugLogger);
    }
}

