/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.types;

import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import javax.crypto.Cipher;
import javax.crypto.Mac;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.opends.messages.Message;
import org.opends.server.config.ConfigException;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.InitializationException;
import org.opends.server.types.PublicAPI;
import org.opends.server.types.StabilityLevel;
import org.opends.server.util.StaticUtils;

@PublicAPI(stability=StabilityLevel.VOLATILE, mayInstantiate=false, mayExtend=false, mayInvoke=true)
public class CryptoManager {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private SecretKey secretKey = new SecretKeySpec(new byte[16], "AES");
    private String preferredCipher = "AES/CBC/PKCS5Padding";
    private String preferredDigestAlgorithm = "SHA-1";
    private String preferredMACAlgorithm = "HmacSHA1";

    public CryptoManager() throws ConfigException, InitializationException {
        try {
            MessageDigest.getInstance(this.preferredDigestAlgorithm);
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            throw new InitializationException(Message.raw("Can't get preferred digest:  " + StaticUtils.getExceptionMessage(e).toString(), new Object[0]), (Throwable)e);
        }
        try {
            Mac mac = Mac.getInstance(this.preferredMACAlgorithm);
            mac.init(this.secretKey);
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            throw new InitializationException(Message.raw("Can't get preferred MAC provider:  " + StaticUtils.getExceptionMessage(e).toString(), new Object[0]), (Throwable)e);
        }
        try {
            Cipher cipher = Cipher.getInstance(this.preferredCipher);
            cipher.init(1, this.secretKey);
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            throw new InitializationException(Message.raw("Can't get preferred cipher:  " + StaticUtils.getExceptionMessage(e).toString(), new Object[0]), (Throwable)e);
        }
    }

    public SecureRandom getSecureRandom() {
        return new SecureRandom();
    }

    public String getPreferredMessageDigestAlgorithm() {
        return this.preferredDigestAlgorithm;
    }

    public MessageDigest getPreferredMessageDigest() throws NoSuchAlgorithmException {
        return MessageDigest.getInstance(this.preferredDigestAlgorithm);
    }

    public MessageDigest getMessageDigest(String digestAlgorithm) throws NoSuchAlgorithmException {
        return MessageDigest.getInstance(digestAlgorithm);
    }

    public byte[] digest(byte[] data) throws NoSuchAlgorithmException {
        return MessageDigest.getInstance(this.preferredDigestAlgorithm).digest(data);
    }

    public byte[] digest(String digestAlgorithm, byte[] data) throws NoSuchAlgorithmException {
        return MessageDigest.getInstance(digestAlgorithm).digest(data);
    }

    public byte[] digest(InputStream inputStream) throws IOException, NoSuchAlgorithmException {
        int bytesRead;
        MessageDigest digest = MessageDigest.getInstance(this.preferredDigestAlgorithm);
        byte[] buffer = new byte[8192];
        while ((bytesRead = inputStream.read(buffer)) >= 0) {
            digest.update(buffer, 0, bytesRead);
        }
        return digest.digest();
    }

    public byte[] digest(String digestAlgorithm, InputStream inputStream) throws IOException, NoSuchAlgorithmException {
        int bytesRead;
        MessageDigest digest = MessageDigest.getInstance(digestAlgorithm);
        byte[] buffer = new byte[8192];
        while ((bytesRead = inputStream.read(buffer)) >= 0) {
            digest.update(buffer, 0, bytesRead);
        }
        return digest.digest();
    }

    public String getPreferredMACAlgorithm() {
        return this.preferredMACAlgorithm;
    }

    public Mac getPreferredMACProvider() throws NoSuchAlgorithmException, InvalidKeyException {
        Mac mac = Mac.getInstance(this.preferredMACAlgorithm);
        mac.init(this.secretKey);
        return mac;
    }

    public Mac getMACProvider(String macAlgorithm) throws NoSuchAlgorithmException, InvalidKeyException {
        Mac mac = Mac.getInstance(macAlgorithm);
        mac.init(this.secretKey);
        return mac;
    }

    public byte[] mac(byte[] data) throws NoSuchAlgorithmException {
        return Mac.getInstance(this.preferredMACAlgorithm).doFinal(data);
    }

    public byte[] mac(String macAlgorithm, byte[] data) throws NoSuchAlgorithmException {
        return Mac.getInstance(macAlgorithm).doFinal(data);
    }

    public byte[] mac(InputStream inputStream) throws IOException, NoSuchAlgorithmException {
        int bytesRead;
        Mac mac = Mac.getInstance(this.preferredMACAlgorithm);
        byte[] buffer = new byte[8192];
        while ((bytesRead = inputStream.read(buffer)) >= 0) {
            mac.update(buffer, 0, bytesRead);
        }
        return mac.doFinal();
    }

    public byte[] mac(String macAlgorithm, InputStream inputStream) throws IOException, NoSuchAlgorithmException {
        int bytesRead;
        Mac mac = Mac.getInstance(macAlgorithm);
        byte[] buffer = new byte[8192];
        while ((bytesRead = inputStream.read(buffer)) >= 0) {
            mac.update(buffer, 0, bytesRead);
        }
        return mac.doFinal();
    }

    public String getPreferredCipherAlgorithm() {
        return this.preferredCipher;
    }

    public Cipher getPreferredCipher(int cipherMode) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException {
        Cipher cipher = Cipher.getInstance(this.preferredCipher);
        IvParameterSpec iv = new IvParameterSpec(new byte[16]);
        cipher.init(cipherMode, (Key)this.secretKey, iv);
        return cipher;
    }

    public Cipher getCipher(String cipherAlgorithm, int cipherMode) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException {
        Cipher cipher = Cipher.getInstance(cipherAlgorithm);
        IvParameterSpec iv = new IvParameterSpec(new byte[16]);
        cipher.init(cipherMode, (Key)this.secretKey, iv);
        return cipher;
    }

    public byte[] encrypt(byte[] data) throws GeneralSecurityException {
        Cipher cipher = Cipher.getInstance(this.preferredCipher);
        IvParameterSpec iv = new IvParameterSpec(new byte[16]);
        cipher.init(1, (Key)this.secretKey, iv);
        return cipher.doFinal(data);
    }

    public byte[] decrypt(byte[] data) throws GeneralSecurityException {
        Cipher cipher = Cipher.getInstance(this.preferredCipher);
        IvParameterSpec iv = new IvParameterSpec(new byte[16]);
        cipher.init(2, (Key)this.secretKey, iv);
        return cipher.doFinal(data);
    }

    public byte[] encrypt(String cipherAlgorithm, byte[] data) throws GeneralSecurityException {
        Cipher cipher = Cipher.getInstance(cipherAlgorithm);
        IvParameterSpec iv = new IvParameterSpec(new byte[16]);
        cipher.init(1, (Key)this.secretKey, iv);
        return cipher.doFinal(data);
    }

    public byte[] decrypt(String cipherAlgorithm, byte[] data) throws GeneralSecurityException {
        Cipher cipher = Cipher.getInstance(cipherAlgorithm);
        IvParameterSpec iv = new IvParameterSpec(new byte[16]);
        cipher.init(2, (Key)this.secretKey, iv);
        return cipher.doFinal(data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int compress(byte[] src, byte[] dst) {
        Deflater deflater = new Deflater();
        try {
            deflater.setInput(src);
            deflater.finish();
            int compressedLength = deflater.deflate(dst);
            if (deflater.finished()) {
                int n = compressedLength;
                return n;
            }
            int n = -1;
            return n;
        }
        finally {
            deflater.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int uncompress(byte[] src, byte[] dst) throws DataFormatException {
        Inflater inflater = new Inflater();
        try {
            inflater.setInput(src);
            int decompressedLength = inflater.inflate(dst);
            if (inflater.finished()) {
                int n = decompressedLength;
                return n;
            }
            int totalLength = decompressedLength;
            while (!inflater.finished()) {
                totalLength += inflater.inflate(dst);
            }
            int n = -totalLength;
            return n;
        }
        finally {
            inflater.end();
        }
    }
}

