/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.tools.tasks;

import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import org.opends.messages.Message;
import org.opends.messages.ToolMessages;
import org.opends.server.protocols.asn1.ASN1Exception;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.protocols.ldap.AddRequestProtocolOp;
import org.opends.server.protocols.ldap.AddResponseProtocolOp;
import org.opends.server.protocols.ldap.ExtendedResponseProtocolOp;
import org.opends.server.protocols.ldap.LDAPAttribute;
import org.opends.server.protocols.ldap.LDAPControl;
import org.opends.server.protocols.ldap.LDAPMessage;
import org.opends.server.tools.LDAPConnection;
import org.opends.server.tools.LDAPReader;
import org.opends.server.tools.LDAPWriter;
import org.opends.server.tools.tasks.TaskScheduleInformation;
import org.opends.server.types.LDAPException;
import org.opends.server.types.RawAttribute;
import org.opends.server.types.ResultCode;
import org.opends.server.util.ServerConstants;
import org.opends.server.util.StaticUtils;

public class TaskSchedulingClient {
    protected LDAPConnection connection;

    public TaskSchedulingClient(LDAPConnection conn) {
        this.connection = conn;
    }

    public synchronized int schedule(TaskScheduleInformation information, PrintStream out, PrintStream err) {
        LDAPMessage responseMessage;
        AtomicInteger nextMessageID = new AtomicInteger(1);
        LDAPReader reader = this.connection.getLDAPReader();
        LDAPWriter writer = this.connection.getLDAPWriter();
        String taskID = UUID.randomUUID().toString();
        ASN1OctetString entryDN = new ASN1OctetString("ds-task-id=" + taskID + "," + "cn=Scheduled Tasks" + "," + "cn=Tasks");
        ArrayList<LDAPControl> controls = new ArrayList<LDAPControl>();
        ArrayList<RawAttribute> attributes = new ArrayList<RawAttribute>();
        ArrayList<ASN1OctetString> ocValues = new ArrayList<ASN1OctetString>(3);
        ocValues.add(new ASN1OctetString("top"));
        ocValues.add(new ASN1OctetString("ds-task"));
        ocValues.add(new ASN1OctetString(information.getTaskObjectclass()));
        attributes.add(new LDAPAttribute("objectClass", ocValues));
        ArrayList<ASN1OctetString> taskIDValues = new ArrayList<ASN1OctetString>(1);
        taskIDValues.add(new ASN1OctetString(taskID));
        attributes.add(new LDAPAttribute("ds-task-id", taskIDValues));
        ArrayList<ASN1OctetString> classValues = new ArrayList<ASN1OctetString>(1);
        classValues.add(new ASN1OctetString(information.getTaskClass().getName()));
        attributes.add(new LDAPAttribute("ds-task-class-name", classValues));
        information.addTaskAttributes(attributes);
        AddRequestProtocolOp addRequest = new AddRequestProtocolOp(entryDN, attributes);
        LDAPMessage requestMessage = new LDAPMessage(nextMessageID.getAndIncrement(), addRequest, controls);
        try {
            writer.writeMessage(requestMessage);
            responseMessage = reader.readMessage();
            if (responseMessage == null) {
                Message message = ToolMessages.ERR_TASK_CLIENT_UNEXPECTED_CONNECTION_CLOSURE.get();
                if (err != null) {
                    err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
                }
                return 81;
            }
        }
        catch (IOException ioe) {
            Message message = ToolMessages.ERR_TASK_CLIENT_IO_ERROR.get(String.valueOf(ioe));
            if (err != null) {
                err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
            }
            return 81;
        }
        catch (ASN1Exception ae) {
            Message message = ToolMessages.ERR_TASK_CLIENT_DECODE_ERROR.get(ae.getMessage());
            if (err != null) {
                err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
            }
            return 84;
        }
        catch (LDAPException le) {
            Message message = ToolMessages.ERR_TASK_CLIENT_DECODE_ERROR.get(le.getMessage());
            if (err != null) {
                err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
            }
            return 84;
        }
        if (responseMessage.getProtocolOpType() != 105) {
            ExtendedResponseProtocolOp extendedResponse;
            String responseOID;
            if (responseMessage.getProtocolOpType() == 120 && (responseOID = (extendedResponse = responseMessage.getExtendedResponseProtocolOp()).getOID()) != null && responseOID.equals("1.3.6.1.4.1.1466.20036")) {
                Message message = extendedResponse.getErrorMessage();
                if (message != null && err != null) {
                    err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
                }
                return extendedResponse.getResultCode();
            }
            Message message = ToolMessages.ERR_TASK_CLIENT_INVALID_RESPONSE_TYPE.get(responseMessage.getProtocolOpName());
            if (err != null) {
                err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
            }
            return 82;
        }
        AddResponseProtocolOp addResponse = responseMessage.getAddResponseProtocolOp();
        Message errorMessage = addResponse.getErrorMessage();
        if (errorMessage != null && err != null) {
            err.println(StaticUtils.wrapText(errorMessage, ServerConstants.MAX_LINE_WIDTH));
        }
        if (addResponse.getResultCode() == ResultCode.SUCCESS.getIntValue() && out != null) {
            out.println(StaticUtils.wrapText(ToolMessages.INFO_TASK_CLIENT_TASK_SCHEDULED.get(taskID), ServerConstants.MAX_LINE_WIDTH));
        }
        return addResponse.getResultCode();
    }
}

