/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.tools.dsconfig;

import org.opends.messages.Message;
import org.opends.messages.ToolMessages;
import org.opends.server.admin.client.AuthenticationException;
import org.opends.server.admin.client.AuthenticationNotSupportedException;
import org.opends.server.admin.client.CommunicationException;
import org.opends.server.admin.client.ManagementContext;
import org.opends.server.admin.client.ldap.JNDIDirContextAdaptor;
import org.opends.server.admin.client.ldap.LDAPManagementContext;
import org.opends.server.tools.ClientException;
import org.opends.server.tools.dsconfig.ArgumentExceptionFactory;
import org.opends.server.tools.dsconfig.ConsoleApplication;
import org.opends.server.tools.dsconfig.ManagementContextFactory;
import org.opends.server.util.args.ArgumentException;
import org.opends.server.util.args.FileBasedArgument;
import org.opends.server.util.args.IntegerArgument;
import org.opends.server.util.args.StringArgument;
import org.opends.server.util.args.SubCommandArgumentParser;

public final class LDAPManagementContextFactory
implements ManagementContextFactory {
    private static final String DEFAULT_BIND_DN = "cn=directory manager";
    private ManagementContext context = null;
    private StringArgument bindDNArgument;
    private StringArgument bindPasswordArgument;
    private FileBasedArgument bindPasswordFileArgument;
    private StringArgument hostArgument;
    private IntegerArgument portArgument;

    public ManagementContext getManagementContext(ConsoleApplication app) throws ArgumentException, ClientException {
        if (this.context == null) {
            String hostName = this.hostArgument.getValue();
            int portNumber = this.portArgument.getIntValue();
            String bindDN = this.bindDNArgument.getValue();
            String bindPassword = this.bindPasswordArgument.getValue();
            if (this.bindPasswordFileArgument.isPresent()) {
                bindPassword = this.bindPasswordFileArgument.getValue();
                if (bindPassword == null) {
                    throw ArgumentExceptionFactory.missingBindPassword(bindDN);
                }
            } else if (bindPassword == null || bindPassword.equals("-")) {
                if (!app.isInteractive()) {
                    throw ArgumentExceptionFactory.unableToReadBindPasswordInteractively();
                }
                try {
                    Message prompt = ToolMessages.INFO_LDAPAUTH_PASSWORD_PROMPT.get(bindDN);
                    bindPassword = app.readPassword(prompt);
                }
                catch (Exception e) {
                    throw ArgumentExceptionFactory.unableToReadBindPassword(e);
                }
            }
            try {
                JNDIDirContextAdaptor conn = JNDIDirContextAdaptor.simpleBind(hostName, portNumber, bindDN, bindPassword);
                this.context = LDAPManagementContext.createFromContext(conn);
            }
            catch (AuthenticationNotSupportedException e) {
                Message message = ToolMessages.ERR_DSCFG_ERROR_LDAP_SIMPLE_BIND_NOT_SUPPORTED.get();
                throw new ClientException(7, message);
            }
            catch (AuthenticationException e) {
                Message message = ToolMessages.ERR_DSCFG_ERROR_LDAP_SIMPLE_BIND_FAILED.get(bindDN);
                throw new ClientException(49, message);
            }
            catch (CommunicationException e) {
                Message message = ToolMessages.ERR_DSCFG_ERROR_LDAP_FAILED_TO_CONNECT.get(hostName, String.valueOf(portNumber));
                throw new ClientException(91, message);
            }
        }
        return this.context;
    }

    public void registerGlobalArguments(SubCommandArgumentParser parser) throws ArgumentException {
        this.hostArgument = new StringArgument("host", Character.valueOf('h'), "hostname", false, false, true, "{host}", "localhost", null, ToolMessages.INFO_DESCRIPTION_HOST.get());
        this.portArgument = new IntegerArgument("port", Character.valueOf('p'), "port", false, false, true, "{port}", 389, null, ToolMessages.INFO_DESCRIPTION_PORT.get());
        this.bindDNArgument = new StringArgument("bindDN", Character.valueOf('D'), "bindDN", false, false, true, "{bindDN}", DEFAULT_BIND_DN, null, ToolMessages.INFO_DESCRIPTION_BINDDN.get());
        this.bindPasswordArgument = new StringArgument("bindPassword", Character.valueOf('w'), "bindPassword", false, false, true, "{bindPassword}", null, null, ToolMessages.INFO_DESCRIPTION_BINDPASSWORD.get());
        this.bindPasswordFileArgument = new FileBasedArgument("bindPasswordFile", Character.valueOf('j'), "bindPasswordFile", false, false, "{bindPasswordFile}", null, null, ToolMessages.INFO_DESCRIPTION_BINDPASSWORDFILE.get());
        parser.addGlobalArgument(this.hostArgument);
        parser.addGlobalArgument(this.portArgument);
        parser.addGlobalArgument(this.bindDNArgument);
        parser.addGlobalArgument(this.bindPasswordArgument);
        parser.addGlobalArgument(this.bindPasswordFileArgument);
    }

    public void validateGlobalArguments() throws ArgumentException {
        if (this.bindPasswordArgument.isPresent() && this.bindPasswordFileArgument.isPresent()) {
            Message message = ToolMessages.ERR_TOOL_CONFLICTING_ARGS.get(this.bindPasswordArgument.getLongIdentifier(), this.bindPasswordFileArgument.getLongIdentifier());
            throw new ArgumentException(message);
        }
    }
}

