/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.tools.dsconfig;

import java.io.PrintStream;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import org.opends.messages.Message;
import org.opends.messages.ToolMessages;
import org.opends.server.admin.AbsoluteInheritedDefaultBehaviorProvider;
import org.opends.server.admin.AliasDefaultBehaviorProvider;
import org.opends.server.admin.Configuration;
import org.opends.server.admin.DefaultBehaviorProviderVisitor;
import org.opends.server.admin.DefinedDefaultBehaviorProvider;
import org.opends.server.admin.DefinitionDecodingException;
import org.opends.server.admin.InstantiableRelationDefinition;
import org.opends.server.admin.ManagedObjectDefinition;
import org.opends.server.admin.ManagedObjectNotFoundException;
import org.opends.server.admin.ManagedObjectPath;
import org.opends.server.admin.OptionalRelationDefinition;
import org.opends.server.admin.PropertyDefinition;
import org.opends.server.admin.PropertyOption;
import org.opends.server.admin.RelationDefinition;
import org.opends.server.admin.RelativeInheritedDefaultBehaviorProvider;
import org.opends.server.admin.SingletonRelationDefinition;
import org.opends.server.admin.UndefinedDefaultBehaviorProvider;
import org.opends.server.admin.client.AuthorizationException;
import org.opends.server.admin.client.CommunicationException;
import org.opends.server.admin.client.ConcurrentModificationException;
import org.opends.server.admin.client.ManagedObject;
import org.opends.server.admin.client.ManagedObjectDecodingException;
import org.opends.server.tools.ClientException;
import org.opends.server.tools.dsconfig.ArgumentExceptionFactory;
import org.opends.server.tools.dsconfig.ConsoleApplication;
import org.opends.server.tools.dsconfig.PropertyValuePrinter;
import org.opends.server.tools.dsconfig.SubCommandHandler;
import org.opends.server.util.args.ArgumentException;
import org.opends.server.util.args.StringArgument;
import org.opends.server.util.args.SubCommand;
import org.opends.server.util.args.SubCommandArgumentParser;
import org.opends.server.util.table.TableBuilder;
import org.opends.server.util.table.TablePrinter;
import org.opends.server.util.table.TextTablePrinter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class GetPropSubCommandHandler
extends SubCommandHandler {
    private final List<StringArgument> namingArgs;
    private final ManagedObjectPath<?, ?> path;
    private final SubCommand subCommand;

    public static GetPropSubCommandHandler create(ConsoleApplication app, SubCommandArgumentParser parser, ManagedObjectPath<?, ?> path, InstantiableRelationDefinition<?, ?> r) throws ArgumentException {
        return new GetPropSubCommandHandler(app, parser, path.child(r, "DUMMY"), r);
    }

    public static GetPropSubCommandHandler create(ConsoleApplication app, SubCommandArgumentParser parser, ManagedObjectPath<?, ?> path, OptionalRelationDefinition<?, ?> r) throws ArgumentException {
        return new GetPropSubCommandHandler(app, parser, path.child(r), r);
    }

    public static GetPropSubCommandHandler create(ConsoleApplication app, SubCommandArgumentParser parser, ManagedObjectPath<?, ?> path, SingletonRelationDefinition<?, ?> r) throws ArgumentException {
        return new GetPropSubCommandHandler(app, parser, path.child(r), r);
    }

    private GetPropSubCommandHandler(ConsoleApplication app, SubCommandArgumentParser parser, ManagedObjectPath<?, ?> path, RelationDefinition<?, ?> r) throws ArgumentException {
        super(app);
        this.path = path;
        String name = "get-" + r.getName() + "-prop";
        Message message = ToolMessages.INFO_DSCFG_DESCRIPTION_SUBCMD_GETPROP.get(r.getChildDefinition().getUserFriendlyName());
        this.subCommand = new SubCommand(parser, name, false, 0, 0, null, message);
        this.namingArgs = this.createNamingArgs(this.subCommand, path, false);
        this.registerPropertyNameArgument(this.subCommand);
        this.registerAdvancedModeArgument(this.subCommand, ToolMessages.INFO_DSCFG_DESCRIPTION_ADVANCED_GET.get(r.getUserFriendlyName()));
        this.registerRecordModeArgument(this.subCommand);
        this.registerUnitSizeArgument(this.subCommand);
        this.registerUnitTimeArgument(this.subCommand);
        this.addTags(path.getManagedObjectDefinition().getAllTags());
    }

    @Override
    public SubCommand getSubCommand() {
        return this.subCommand;
    }

    @Override
    public int run() throws ArgumentException, ClientException {
        TablePrinter printer;
        Collection<PropertyDefinition<?>> pdList;
        ManagedObject<?> child;
        Set<String> propertyNames = this.getPropertyNames();
        PropertyValuePrinter valuePrinter = new PropertyValuePrinter(this.getSizeUnit(), this.getTimeUnit(), this.getConsoleApplication().isScriptFriendly());
        List<String> names = this.getNamingArgValues(this.namingArgs);
        try {
            child = this.getManagedObject(this.path, names);
        }
        catch (AuthorizationException e) {
            Message ufn = this.path.getManagedObjectDefinition().getUserFriendlyName();
            Message msg = ToolMessages.ERR_DSCFG_ERROR_GET_CHILD_AUTHZ.get(ufn);
            throw new ClientException(50, msg);
        }
        catch (DefinitionDecodingException e) {
            Message ufn = this.path.getManagedObjectDefinition().getUserFriendlyName();
            Message msg = ToolMessages.ERR_DSCFG_ERROR_GET_CHILD_DDE.get(ufn, ufn, ufn);
            throw new ClientException(1, msg);
        }
        catch (ManagedObjectDecodingException e) {
            Message ufn = this.path.getManagedObjectDefinition().getUserFriendlyName();
            Message msg = ToolMessages.ERR_DSCFG_ERROR_GET_CHILD_MODE.get(ufn);
            throw new ClientException(1, msg);
        }
        catch (CommunicationException e) {
            Message ufn = this.path.getManagedObjectDefinition().getUserFriendlyName();
            Message msg = ToolMessages.ERR_DSCFG_ERROR_GET_CHILD_CE.get(ufn, e.getMessage());
            throw new ClientException(81, msg);
        }
        catch (ConcurrentModificationException e) {
            Message ufn = this.path.getManagedObjectDefinition().getUserFriendlyName();
            Message msg = ToolMessages.ERR_DSCFG_ERROR_GET_CHILD_CME.get(ufn);
            throw new ClientException(19, msg);
        }
        catch (ManagedObjectNotFoundException e) {
            Message ufn = this.path.getManagedObjectDefinition().getUserFriendlyName();
            Message msg = ToolMessages.ERR_DSCFG_ERROR_GET_CHILD_MONFE.get(ufn);
            throw new ClientException(32, msg);
        }
        ManagedObjectDefinition<?, Configuration> d = child.getManagedObjectDefinition();
        if (propertyNames.isEmpty()) {
            pdList = d.getAllPropertyDefinitions();
        } else {
            pdList = new LinkedList();
            for (String name : propertyNames) {
                try {
                    pdList.add(d.getPropertyDefinition(name));
                }
                catch (IllegalArgumentException e) {
                    throw ArgumentExceptionFactory.unknownProperty(d, name);
                }
            }
        }
        TableBuilder builder = new TableBuilder();
        builder.appendHeading(ToolMessages.INFO_DSCFG_HEADING_PROPERTY_NAME.get());
        builder.appendHeading(ToolMessages.INFO_DSCFG_HEADING_PROPERTY_VALUE.get());
        builder.addSortKey(0);
        for (PropertyDefinition<?> pd : pdList) {
            if (pd.hasOption(PropertyOption.HIDDEN) || !this.isAdvancedMode() && pd.hasOption(PropertyOption.ADVANCED) || !propertyNames.isEmpty() && !propertyNames.contains(pd.getName())) continue;
            this.displayProperty(builder, child, pd, valuePrinter);
        }
        PrintStream out = this.getConsoleApplication().getOutputStream();
        if (this.getConsoleApplication().isScriptFriendly()) {
            printer = this.createScriptFriendlyTablePrinter(out);
            builder.print(printer);
        } else {
            printer = new TextTablePrinter(out);
            ((TextTablePrinter)printer).setColumnSeparator(":");
            ((TextTablePrinter)printer).setColumnWidth(1, 0);
            builder.print(printer);
        }
        return 0;
    }

    private <T> void displayProperty(TableBuilder builder, ManagedObject<?> mo, PropertyDefinition<T> pd, PropertyValuePrinter valuePrinter) {
        SortedSet<T> values = mo.getPropertyValues(pd);
        if (values.isEmpty()) {
            DefaultBehaviorProviderVisitor visitor = new DefaultBehaviorProviderVisitor<T, Message, Void>(){

                @Override
                public Message visitAbsoluteInherited(AbsoluteInheritedDefaultBehaviorProvider<T> d, Void p) {
                    throw new IllegalStateException();
                }

                @Override
                public Message visitAlias(AliasDefaultBehaviorProvider<T> d, Void p) {
                    if (GetPropSubCommandHandler.this.getConsoleApplication().isVerbose()) {
                        return d.getSynopsis();
                    }
                    return null;
                }

                @Override
                public Message visitDefined(DefinedDefaultBehaviorProvider<T> d, Void p) {
                    throw new IllegalStateException();
                }

                @Override
                public Message visitRelativeInherited(RelativeInheritedDefaultBehaviorProvider<T> d, Void p) {
                    throw new IllegalStateException();
                }

                @Override
                public Message visitUndefined(UndefinedDefaultBehaviorProvider<T> d, Void p) {
                    return null;
                }
            };
            builder.startRow();
            builder.appendCell(pd.getName());
            Message content = (Message)pd.getDefaultBehaviorProvider().accept(visitor, null);
            if (content == null) {
                if (this.getConsoleApplication().isScriptFriendly()) {
                    builder.appendCell();
                } else {
                    builder.appendCell("-");
                }
            } else {
                builder.appendCell(content);
            }
        } else if (this.isRecordMode()) {
            for (Object value : values) {
                builder.startRow();
                builder.appendCell(pd.getName());
                builder.appendCell(valuePrinter.print(pd, value));
            }
        } else {
            builder.startRow();
            builder.appendCell(pd.getName());
            if (this.getConsoleApplication().isScriptFriendly()) {
                for (Object value : values) {
                    builder.appendCell(valuePrinter.print(pd, value));
                }
            } else {
                StringBuilder sb = new StringBuilder();
                boolean isFirst = true;
                for (Object value : values) {
                    if (!isFirst) {
                        sb.append(", ");
                    }
                    sb.append(valuePrinter.print(pd, value));
                    isFirst = false;
                }
                builder.appendCell(sb.toString());
            }
        }
    }
}

