/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.tools.dsconfig;

import java.io.BufferedReader;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.util.List;
import org.opends.messages.Message;
import org.opends.messages.MessageBuilder;
import org.opends.messages.ToolMessages;
import org.opends.server.admin.client.ManagementContext;
import org.opends.server.tools.ClientException;
import org.opends.server.tools.dsconfig.ArgumentExceptionFactory;
import org.opends.server.tools.dsconfig.HelpCallback;
import org.opends.server.tools.dsconfig.ValidationCallback;
import org.opends.server.types.NullOutputStream;
import org.opends.server.util.PasswordReader;
import org.opends.server.util.ServerConstants;
import org.opends.server.util.StaticUtils;
import org.opends.server.util.Validator;
import org.opends.server.util.args.ArgumentException;
import org.opends.server.util.table.TableBuilder;
import org.opends.server.util.table.TextTablePrinter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ConsoleApplication {
    private final PrintStream err;
    private final BufferedReader in;
    private final PrintStream out;

    protected ConsoleApplication(InputStream in, OutputStream out, OutputStream err) {
        this.in = in != null ? new BufferedReader(new InputStreamReader(in)) : new BufferedReader(new Reader(){

            public void close() throws IOException {
            }

            public int read(char[] cbuf, int off, int len) throws IOException {
                return -1;
            }
        });
        this.out = out != null ? new PrintStream(out) : NullOutputStream.printStream();
        this.err = err != null ? new PrintStream(err) : NullOutputStream.printStream();
    }

    public final boolean confirmAction(Message prompt) throws ArgumentException {
        if (!this.isInteractive()) {
            return true;
        }
        final Message yes = ToolMessages.INFO_DSCFG_GENERAL_CONFIRM_YES.get();
        final Message no = ToolMessages.INFO_DSCFG_GENERAL_CONFIRM_NO.get();
        final Message errMsg = ToolMessages.ERR_DSCFG_ERROR_GENERAL_CONFIRM.get(yes, no);
        MessageBuilder mb = new MessageBuilder();
        mb.append(prompt);
        mb.append(String.format(" (%s / %s): ", yes, no));
        prompt = mb.toMessage();
        ValidationCallback<Boolean> validator = new ValidationCallback<Boolean>(){

            @Override
            public Boolean validate(ConsoleApplication app, String input) {
                String ninput = input.toLowerCase().trim();
                if (ninput.length() == 0) {
                    app.println();
                    app.printMessage(errMsg);
                } else {
                    if (no.toString().startsWith(ninput)) {
                        return false;
                    }
                    if (yes.toString().startsWith(ninput)) {
                        return true;
                    }
                    app.println();
                    app.printMessage(errMsg);
                }
                return null;
            }
        };
        try {
            return this.readValidatedInput(prompt, validator);
        }
        catch (ClientException e) {
            throw new RuntimeException(e);
        }
    }

    public final void printMessage(Message msg) {
        this.err.println(StaticUtils.wrapText(msg.toString(), ServerConstants.MAX_LINE_WIDTH));
    }

    public final void println() {
        this.err.println();
    }

    public final void printVerboseMessage(Message msg) {
        if (this.isVerbose() || this.isInteractive()) {
            this.err.println(StaticUtils.wrapText(msg, ServerConstants.MAX_LINE_WIDTH));
        }
    }

    public final PrintStream getErrorStream() {
        return this.err;
    }

    public final BufferedReader getInputStream() {
        return this.in;
    }

    public abstract ManagementContext getManagementContext() throws ArgumentException, ClientException;

    public final PrintStream getOutputStream() {
        return this.out;
    }

    public abstract boolean isInteractive();

    public abstract boolean isQuiet();

    public abstract boolean isScriptFriendly();

    public abstract boolean isVerbose();

    public final <T> T readChoice(final Message prompt, List<Message> descriptions, List<T> values, final HelpCallback helpCallback) throws ArgumentException {
        int choice;
        Validator.ensureTrue(descriptions.size() == values.size());
        this.println();
        this.printMessage(prompt);
        this.println();
        final TableBuilder builder = new TableBuilder();
        final int size = descriptions.size();
        for (int i = 0; i < size; ++i) {
            builder.startRow();
            builder.appendCell("[" + (i + 1) + "]");
            builder.appendCell(descriptions.get(i));
        }
        final TextTablePrinter printer = new TextTablePrinter(this.err);
        printer.setDisplayHeadings(false);
        printer.setColumnWidth(1, 0);
        builder.print(printer);
        Message promptMsg = helpCallback != null ? ToolMessages.INFO_DSCFG_GENERAL_CHOICE_PROMPT_HELP.get(size) : ToolMessages.INFO_DSCFG_GENERAL_CHOICE_PROMPT_NOHELP.get(size);
        ValidationCallback<Integer> validator = new ValidationCallback<Integer>(){

            @Override
            public Integer validate(ConsoleApplication app, String input) {
                String ninput = input.trim();
                if (ninput.equals("?") && helpCallback != null) {
                    app.println();
                    helpCallback.display(app);
                    app.println();
                    ConsoleApplication.this.printMessage(prompt);
                    ConsoleApplication.this.println();
                    builder.print(printer);
                    return null;
                }
                try {
                    int i = Integer.parseInt(ninput);
                    if (i < 1 || i > size) {
                        throw new NumberFormatException();
                    }
                    return i;
                }
                catch (NumberFormatException e) {
                    app.println();
                    Message errMsg = ToolMessages.ERR_DSCFG_ERROR_GENERAL_CHOICE.get(size);
                    app.printMessage(errMsg);
                    return null;
                }
            }
        };
        try {
            choice = this.readValidatedInput(promptMsg, validator);
        }
        catch (ClientException e) {
            throw new RuntimeException(e);
        }
        return values.get(choice - 1);
    }

    public final String readLineOfInput(Message prompt) throws ArgumentException {
        this.err.println();
        this.err.print(StaticUtils.wrapText(prompt.toString().trim() + " ", ServerConstants.MAX_LINE_WIDTH));
        try {
            return this.in.readLine();
        }
        catch (IOException e) {
            throw ArgumentExceptionFactory.unableToReadConsoleInput(e);
        }
    }

    public final String readPassword(Message prompt) throws ArgumentException {
        char[] pwChars;
        this.err.print(StaticUtils.wrapText(prompt + " ", ServerConstants.MAX_LINE_WIDTH));
        try {
            pwChars = PasswordReader.readPassword();
        }
        catch (Exception e) {
            throw ArgumentExceptionFactory.unableToReadConsoleInput(e);
        }
        return new String(pwChars);
    }

    public final <T> T readValidatedInput(Message prompt, ValidationCallback<T> validator) throws ArgumentException, ClientException {
        String response;
        T value;
        do {
            if ((response = this.readLineOfInput(prompt)) != null) continue;
            throw ArgumentExceptionFactory.unableToReadConsoleInput(new EOFException("End of input"));
        } while ((value = validator.validate(this, response)) == null);
        return value;
    }
}

