/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.tools;

import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import org.opends.messages.Message;
import org.opends.messages.ToolMessages;
import org.opends.server.admin.std.server.BackendCfg;
import org.opends.server.api.Backend;
import org.opends.server.api.ErrorLogPublisher;
import org.opends.server.backends.jeb.BackendImpl;
import org.opends.server.backends.jeb.VerifyConfig;
import org.opends.server.config.ConfigException;
import org.opends.server.core.CoreConfigManager;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.LockFileManager;
import org.opends.server.extensions.ConfigFileHandler;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.loggers.TextWriter;
import org.opends.server.loggers.ThreadFilterTextErrorLogPublisher;
import org.opends.server.tools.BackendToolUtils;
import org.opends.server.types.DN;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.InitializationException;
import org.opends.server.types.NullOutputStream;
import org.opends.server.util.ServerConstants;
import org.opends.server.util.StaticUtils;
import org.opends.server.util.args.ArgumentException;
import org.opends.server.util.args.ArgumentParser;
import org.opends.server.util.args.BooleanArgument;
import org.opends.server.util.args.StringArgument;

public class VerifyIndex {
    private static ErrorLogPublisher errorLogPublisher = null;

    public static void main(String[] args) {
        int retCode = VerifyIndex.mainVerifyIndex(args, true, System.out, System.err);
        if (errorLogPublisher != null) {
            ErrorLogger.removeErrorLogPublisher(errorLogPublisher);
        }
        if (retCode != 0) {
            System.exit(StaticUtils.filterExitCode(retCode));
        }
    }

    public static int mainVerifyIndex(String[] args, boolean initializeServer, OutputStream outStream, OutputStream errStream) {
        Message message;
        DN verifyBaseDN;
        PrintStream out = outStream == null ? NullOutputStream.printStream() : new PrintStream(outStream);
        PrintStream err = errStream == null ? NullOutputStream.printStream() : new PrintStream(errStream);
        StringArgument configClass = null;
        StringArgument configFile = null;
        StringArgument baseDNString = null;
        StringArgument indexList = null;
        BooleanArgument cleanMode = null;
        BooleanArgument countErrors = null;
        BooleanArgument displayUsage = null;
        Message toolDescription = ToolMessages.INFO_VERIFYINDEX_TOOL_DESCRIPTION.get();
        ArgumentParser argParser = new ArgumentParser("org.opends.server.tools.VerifyIndex", toolDescription, false);
        try {
            configClass = new StringArgument("configclass", Character.valueOf('C'), "configClass", true, false, true, "{configClass}", ConfigFileHandler.class.getName(), null, ToolMessages.INFO_DESCRIPTION_CONFIG_CLASS.get());
            configClass.setHidden(true);
            argParser.addArgument(configClass);
            configFile = new StringArgument("configfile", Character.valueOf('f'), "configFile", true, false, true, "{configFile}", null, null, ToolMessages.INFO_DESCRIPTION_CONFIG_FILE.get());
            configFile.setHidden(true);
            argParser.addArgument(configFile);
            baseDNString = new StringArgument("basedn", Character.valueOf('b'), "baseDN", true, false, true, "{baseDN}", null, null, ToolMessages.INFO_VERIFYINDEX_DESCRIPTION_BASE_DN.get());
            argParser.addArgument(baseDNString);
            indexList = new StringArgument("index", Character.valueOf('i'), "index", false, true, true, "{index}", null, null, ToolMessages.INFO_VERIFYINDEX_DESCRIPTION_INDEX_NAME.get());
            argParser.addArgument(indexList);
            cleanMode = new BooleanArgument("clean", Character.valueOf('c'), "clean", ToolMessages.INFO_VERIFYINDEX_DESCRIPTION_VERIFY_CLEAN.get());
            argParser.addArgument(cleanMode);
            countErrors = new BooleanArgument("counterrors", null, "countErrors", ToolMessages.INFO_VERIFYINDEX_DESCRIPTION_COUNT_ERRORS.get());
            argParser.addArgument(countErrors);
            displayUsage = new BooleanArgument("help", Character.valueOf('H'), "help", ToolMessages.INFO_DESCRIPTION_USAGE.get());
            argParser.addArgument(displayUsage);
            argParser.setUsageArgument(displayUsage);
        }
        catch (ArgumentException ae) {
            Message message2 = ToolMessages.ERR_CANNOT_INITIALIZE_ARGS.get(ae.getMessage());
            err.println(StaticUtils.wrapText(message2, ServerConstants.MAX_LINE_WIDTH));
            return 1;
        }
        try {
            argParser.parseArguments(args);
        }
        catch (ArgumentException ae) {
            Message message3 = ToolMessages.ERR_ERROR_PARSING_ARGS.get(ae.getMessage());
            err.println(StaticUtils.wrapText(message3, ServerConstants.MAX_LINE_WIDTH));
            err.println(argParser.getUsage());
            return 1;
        }
        if (argParser.usageOrVersionDisplayed()) {
            return 0;
        }
        int numArgs = args.length;
        if (numArgs == 0) {
            out.println(argParser.getUsage());
            return 1;
        }
        if (cleanMode.isPresent() && indexList.getValues().size() != 1) {
            Message message4 = ToolMessages.ERR_VERIFYINDEX_VERIFY_CLEAN_REQUIRES_SINGLE_INDEX.get();
            err.println(StaticUtils.wrapText(message4, ServerConstants.MAX_LINE_WIDTH));
            out.println(argParser.getUsage());
            return 1;
        }
        DirectoryServer directoryServer = DirectoryServer.getInstance();
        if (initializeServer) {
            try {
                DirectoryServer.bootstrapClient();
                DirectoryServer.initializeJMX();
            }
            catch (Exception e) {
                Message message5 = ToolMessages.ERR_SERVER_BOOTSTRAP_ERROR.get(StaticUtils.getExceptionMessage(e));
                err.println(StaticUtils.wrapText(message5, ServerConstants.MAX_LINE_WIDTH));
                return 1;
            }
            try {
                directoryServer.initializeConfiguration(configClass.getValue(), configFile.getValue());
            }
            catch (InitializationException ie) {
                Message message6 = ToolMessages.ERR_CANNOT_LOAD_CONFIG.get(ie.getMessage());
                err.println(StaticUtils.wrapText(message6, ServerConstants.MAX_LINE_WIDTH));
                return 1;
            }
            catch (Exception e) {
                Message message7 = ToolMessages.ERR_CANNOT_LOAD_CONFIG.get(StaticUtils.getExceptionMessage(e));
                err.println(StaticUtils.wrapText(message7, ServerConstants.MAX_LINE_WIDTH));
                return 1;
            }
            try {
                directoryServer.initializeSchema();
            }
            catch (ConfigException ce) {
                Message message8 = ToolMessages.ERR_CANNOT_LOAD_SCHEMA.get(ce.getMessage());
                err.println(StaticUtils.wrapText(message8, ServerConstants.MAX_LINE_WIDTH));
                return 1;
            }
            catch (InitializationException ie) {
                Message message9 = ToolMessages.ERR_CANNOT_LOAD_SCHEMA.get(ie.getMessage());
                err.println(StaticUtils.wrapText(message9, ServerConstants.MAX_LINE_WIDTH));
                return 1;
            }
            catch (Exception e) {
                Message message10 = ToolMessages.ERR_CANNOT_LOAD_SCHEMA.get(StaticUtils.getExceptionMessage(e));
                err.println(StaticUtils.wrapText(message10, ServerConstants.MAX_LINE_WIDTH));
                return 1;
            }
            try {
                CoreConfigManager coreConfigManager = new CoreConfigManager();
                coreConfigManager.initializeCoreConfig();
            }
            catch (ConfigException ce) {
                Message message11 = ToolMessages.ERR_CANNOT_INITIALIZE_CORE_CONFIG.get(ce.getMessage());
                err.println(StaticUtils.wrapText(message11, ServerConstants.MAX_LINE_WIDTH));
                return 1;
            }
            catch (InitializationException ie) {
                Message message12 = ToolMessages.ERR_CANNOT_INITIALIZE_CORE_CONFIG.get(ie.getMessage());
                err.println(StaticUtils.wrapText(message12, ServerConstants.MAX_LINE_WIDTH));
                return 1;
            }
            catch (Exception e) {
                Message message13 = ToolMessages.ERR_CANNOT_INITIALIZE_CORE_CONFIG.get(StaticUtils.getExceptionMessage(e));
                err.println(StaticUtils.wrapText(message13, ServerConstants.MAX_LINE_WIDTH));
                return 1;
            }
            try {
                directoryServer.initializeCryptoManager();
            }
            catch (ConfigException ce) {
                Message message14 = ToolMessages.ERR_CANNOT_INITIALIZE_CRYPTO_MANAGER.get(ce.getMessage());
                err.println(StaticUtils.wrapText(message14, ServerConstants.MAX_LINE_WIDTH));
                return 1;
            }
            catch (InitializationException ie) {
                Message message15 = ToolMessages.ERR_CANNOT_INITIALIZE_CRYPTO_MANAGER.get(ie.getMessage());
                err.println(StaticUtils.wrapText(message15, ServerConstants.MAX_LINE_WIDTH));
                return 1;
            }
            catch (Exception e) {
                Message message16 = ToolMessages.ERR_CANNOT_INITIALIZE_CRYPTO_MANAGER.get(StaticUtils.getExceptionMessage(e));
                err.println(StaticUtils.wrapText(message16, ServerConstants.MAX_LINE_WIDTH));
                return 1;
            }
            try {
                errorLogPublisher = new ThreadFilterTextErrorLogPublisher(Thread.currentThread(), new TextWriter.STREAM(out));
                ErrorLogger.addErrorLogPublisher(errorLogPublisher);
            }
            catch (Exception e) {
                err.println("Error installing the custom error logger: " + StaticUtils.stackTraceToSingleLineString(e));
            }
        }
        try {
            verifyBaseDN = DN.decode(baseDNString.getValue());
        }
        catch (DirectoryException de) {
            Message message17 = ToolMessages.ERR_CANNOT_DECODE_BASE_DN.get(baseDNString.getValue(), de.getMessageObject());
            ErrorLogger.logError(message17);
            return 1;
        }
        catch (Exception e) {
            Message message18 = ToolMessages.ERR_CANNOT_DECODE_BASE_DN.get(baseDNString.getValue(), StaticUtils.getExceptionMessage(e));
            ErrorLogger.logError(message18);
            return 1;
        }
        Backend backend = null;
        ArrayList<Backend> backendList = new ArrayList<Backend>();
        ArrayList<BackendCfg> entryList = new ArrayList<BackendCfg>();
        ArrayList<List<DN>> dnList = new ArrayList<List<DN>>();
        BackendToolUtils.getBackends(backendList, entryList, dnList);
        int numBackends = backendList.size();
        block32: for (int i = 0; i < numBackends; ++i) {
            Backend b = backendList.get(i);
            List<DN> baseDNs = dnList.get(i);
            for (DN baseDN : baseDNs) {
                if (!baseDN.equals(verifyBaseDN)) continue;
                if (backend == null) {
                    backend = b;
                    continue block32;
                }
                Message message19 = ToolMessages.ERR_MULTIPLE_BACKENDS_FOR_BASE.get(baseDNString.getValue());
                ErrorLogger.logError(message19);
                return 1;
            }
        }
        if (backend == null) {
            Message message20 = ToolMessages.ERR_NO_BACKENDS_FOR_BASE.get(baseDNString.getValue());
            ErrorLogger.logError(message20);
            return 1;
        }
        if (!(backend instanceof BackendImpl)) {
            Message message21 = ToolMessages.ERR_BACKEND_NO_INDEXING_SUPPORT.get();
            ErrorLogger.logError(message21);
            return 1;
        }
        VerifyConfig verifyConfig = new VerifyConfig();
        verifyConfig.setBaseDN(verifyBaseDN);
        if (cleanMode.isPresent()) {
            for (String s : indexList.getValues()) {
                verifyConfig.addCleanIndex(s);
            }
        } else {
            for (String s : indexList.getValues()) {
                verifyConfig.addCompleteIndex(s);
            }
        }
        try {
            String lockFile = LockFileManager.getBackendLockFileName(backend);
            StringBuilder failureReason = new StringBuilder();
            if (!LockFileManager.acquireSharedLock(lockFile, failureReason)) {
                message = ToolMessages.ERR_VERIFYINDEX_CANNOT_LOCK_BACKEND.get(backend.getBackendID(), String.valueOf(failureReason));
                ErrorLogger.logError(message);
                return 1;
            }
        }
        catch (Exception e) {
            Message message22 = ToolMessages.ERR_VERIFYINDEX_CANNOT_LOCK_BACKEND.get(backend.getBackendID(), StaticUtils.getExceptionMessage(e));
            ErrorLogger.logError(message22);
            return 1;
        }
        int returnCode = 0;
        try {
            BackendImpl jebBackend = (BackendImpl)backend;
            long errorCount = jebBackend.verifyBackend(verifyConfig, null);
            if (countErrors.isPresent()) {
                returnCode = errorCount > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)errorCount;
            }
        }
        catch (Exception e) {
            message = ToolMessages.ERR_VERIFYINDEX_ERROR_DURING_VERIFY.get(StaticUtils.stackTraceToSingleLineString(e));
            ErrorLogger.logError(message);
            returnCode = 1;
        }
        try {
            String lockFile = LockFileManager.getBackendLockFileName(backend);
            StringBuilder failureReason = new StringBuilder();
            if (!LockFileManager.releaseLock(lockFile, failureReason)) {
                Message message23 = ToolMessages.WARN_VERIFYINDEX_CANNOT_UNLOCK_BACKEND.get(backend.getBackendID(), String.valueOf(failureReason));
                ErrorLogger.logError(message23);
            }
        }
        catch (Exception e) {
            Message message24 = ToolMessages.WARN_VERIFYINDEX_CANNOT_UNLOCK_BACKEND.get(backend.getBackendID(), StaticUtils.getExceptionMessage(e));
            ErrorLogger.logError(message24);
        }
        return returnCode;
    }
}

