/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.tools;

import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.concurrent.atomic.AtomicInteger;
import org.opends.messages.Message;
import org.opends.messages.ToolMessages;
import org.opends.server.extensions.PasswordPolicyStateExtendedOperation;
import org.opends.server.protocols.asn1.ASN1Element;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.protocols.asn1.ASN1Sequence;
import org.opends.server.protocols.ldap.ExtendedRequestProtocolOp;
import org.opends.server.protocols.ldap.ExtendedResponseProtocolOp;
import org.opends.server.protocols.ldap.LDAPMessage;
import org.opends.server.protocols.ldap.LDAPResultCode;
import org.opends.server.tools.LDAPConnection;
import org.opends.server.tools.LDAPConnectionException;
import org.opends.server.tools.LDAPConnectionOptions;
import org.opends.server.tools.LDAPReader;
import org.opends.server.tools.LDAPWriter;
import org.opends.server.tools.SSLConnectionException;
import org.opends.server.tools.SSLConnectionFactory;
import org.opends.server.types.NullOutputStream;
import org.opends.server.util.ServerConstants;
import org.opends.server.util.StaticUtils;
import org.opends.server.util.args.Argument;
import org.opends.server.util.args.ArgumentException;
import org.opends.server.util.args.BooleanArgument;
import org.opends.server.util.args.FileBasedArgument;
import org.opends.server.util.args.IntegerArgument;
import org.opends.server.util.args.MultiChoiceArgument;
import org.opends.server.util.args.StringArgument;
import org.opends.server.util.args.SubCommand;
import org.opends.server.util.args.SubCommandArgumentParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManageAccount {
    private static final String CLASS_NAME = "org.opends.server.tools.ManageAccount";
    private static final String SC_GET_ALL = "get-all";
    private static final String SC_GET_PASSWORD_POLICY_DN = "get-password-policy-dn";
    private static final String SC_GET_ACCOUNT_DISABLED_STATE = "get-account-is-disabled";
    private static final String SC_SET_ACCOUNT_DISABLED_STATE = "set-account-is-disabled";
    private static final String SC_CLEAR_ACCOUNT_DISABLED_STATE = "clear-account-is-disabled";
    private static final String SC_GET_ACCOUNT_EXPIRATION_TIME = "get-account-expiration-time";
    private static final String SC_SET_ACCOUNT_EXPIRATION_TIME = "set-account-expiration-time";
    private static final String SC_CLEAR_ACCOUNT_EXPIRATION_TIME = "clear-account-expiration-time";
    private static final String SC_GET_SECONDS_UNTIL_ACCOUNT_EXPIRATION = "get-seconds-until-account-expiration";
    private static final String SC_GET_PASSWORD_CHANGED_TIME = "get-password-changed-time";
    private static final String SC_SET_PASSWORD_CHANGED_TIME = "set-password-changed-time";
    private static final String SC_CLEAR_PASSWORD_CHANGED_TIME = "clear-password-changed-time";
    private static final String SC_GET_PASSWORD_EXP_WARNED_TIME = "get-password-expiration-warned-time";
    private static final String SC_SET_PASSWORD_EXP_WARNED_TIME = "set-password-expiration-warned-time";
    private static final String SC_CLEAR_PASSWORD_EXP_WARNED_TIME = "clear-password-expiration-warned-time";
    private static final String SC_GET_SECONDS_UNTIL_PASSWORD_EXPIRATION = "get-seconds-until-password-expiration";
    private static final String SC_GET_SECONDS_UNTIL_PASSWORD_EXPIRATION_WARNING = "get-seconds-until-password-expiration-warning";
    private static final String SC_GET_AUTHENTICATION_FAILURE_TIMES = "get-authentication-failure-times";
    private static final String SC_ADD_AUTHENTICATION_FAILURE_TIME = "add-authentication-failure-time";
    private static final String SC_SET_AUTHENTICATION_FAILURE_TIMES = "set-authentication-failure-times";
    private static final String SC_CLEAR_AUTHENTICATION_FAILURE_TIMES = "clear-authentication-failure-times";
    private static final String SC_GET_SECONDS_UNTIL_AUTHENTICATION_FAILURE_UNLOCK = "get-seconds-until-authentication-failure-unlock";
    private static final String SC_GET_REMAINING_AUTHENTICATION_FAILURE_COUNT = "get-remaining-authentication-failure-count";
    private static final String SC_GET_LAST_LOGIN_TIME = "get-last-login-time";
    private static final String SC_SET_LAST_LOGIN_TIME = "set-last-login-time";
    private static final String SC_CLEAR_LAST_LOGIN_TIME = "clear-last-login-time";
    private static final String SC_GET_SECONDS_UNTIL_IDLE_LOCKOUT = "get-seconds-until-idle-lockout";
    private static final String SC_GET_PASSWORD_RESET_STATE = "get-password-is-reset";
    private static final String SC_SET_PASSWORD_RESET_STATE = "set-password-is-reset";
    private static final String SC_CLEAR_PASSWORD_RESET_STATE = "clear-password-is-reset";
    private static final String SC_GET_SECONDS_UNTIL_PASSWORD_RESET_LOCKOUT = "get-seconds-until-password-reset-lockout";
    private static final String SC_GET_GRACE_LOGIN_USE_TIMES = "get-grace-login-use-times";
    private static final String SC_ADD_GRACE_LOGIN_USE_TIME = "add-grace-login-use-time";
    private static final String SC_SET_GRACE_LOGIN_USE_TIMES = "set-grace-login-use-times";
    private static final String SC_CLEAR_GRACE_LOGIN_USE_TIMES = "clear-grace-login-use-times";
    private static final String SC_GET_REMAINING_GRACE_LOGIN_COUNT = "get-remaining-grace-login-count";
    private static final String SC_GET_PASSWORD_CHANGED_BY_REQUIRED_TIME = "get-password-changed-by-required-time";
    private static final String SC_SET_PASSWORD_CHANGED_BY_REQUIRED_TIME = "set-password-changed-by-required-time";
    private static final String SC_CLEAR_PASSWORD_CHANGED_BY_REQUIRED_TIME = "clear-password-changed-by-required-time";
    private static final String SC_GET_SECONDS_UNTIL_REQUIRED_CHANGE_TIME = "get-seconds-until-required-change-time";
    private static final String SC_GET_PASSWORD_HISTORY = "get-password-history";
    private static final String SC_CLEAR_PASSWORD_HISTORY = "clear-password-history";
    private static final String ARG_OP_VALUE = "opvalue";
    private static final String NO_VALUE = null;
    private static LDAPReader ldapReader;
    private static LDAPWriter ldapWriter;
    private static AtomicInteger nextMessageID;
    private static LDAPConnection connection;
    private static PrintStream err;
    private static PrintStream out;
    private static String targetDNString;
    private static SubCommandArgumentParser argParser;

    public static void main(String[] args) {
        int returnCode = ManageAccount.main(args, System.out, System.err);
        if (returnCode != 0) {
            System.exit(StaticUtils.filterExitCode(returnCode));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int main(String[] args, OutputStream outStream, OutputStream errStream) {
        out = outStream == null ? NullOutputStream.printStream() : new PrintStream(outStream);
        err = errStream == null ? NullOutputStream.printStream() : new PrintStream(errStream);
        int result = ManageAccount.parseArgsAndConnect(args);
        if (result < 0) {
            return 0;
        }
        if (result != 0) {
            return result;
        }
        try {
            ArrayList<ASN1Element> responseOpElements;
            ArrayList<ASN1Element> opElements = new ArrayList<ASN1Element>(1);
            result = ManageAccount.processSubcommand(opElements);
            if (result != 0) {
                int n = result;
                return n;
            }
            ArrayList<ASN1Element> valueElements = new ArrayList<ASN1Element>(2);
            valueElements.add(new ASN1OctetString(targetDNString));
            if (!opElements.isEmpty()) {
                valueElements.add(new ASN1Sequence(opElements));
            }
            ASN1OctetString requestValue = new ASN1OctetString(new ASN1Sequence(valueElements).encode());
            ExtendedRequestProtocolOp extendedRequest = new ExtendedRequestProtocolOp("1.3.6.1.4.1.26027.1.6.1", requestValue);
            LDAPMessage requestMessage = new LDAPMessage(nextMessageID.getAndIncrement(), extendedRequest);
            try {
                ldapWriter.writeMessage(requestMessage);
            }
            catch (Exception e) {
                Message message = ToolMessages.ERR_PWPSTATE_CANNOT_SEND_REQUEST_EXTOP.get(StaticUtils.getExceptionMessage(e));
                err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
                int n = 81;
                if (connection != null) {
                    connection.close(nextMessageID);
                }
                return n;
            }
            LDAPMessage responseMessage = ldapReader.readMessage();
            if (responseMessage == null) {
                Message message = ToolMessages.ERR_PWPSTATE_CONNECTION_CLOSED_READING_RESPONSE.get();
                err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
                int n = 81;
                return n;
            }
            ExtendedResponseProtocolOp extendedResponse = responseMessage.getExtendedResponseProtocolOp();
            int resultCode = extendedResponse.getResultCode();
            if (resultCode != 0) {
                Message message = ToolMessages.ERR_PWPSTATE_REQUEST_FAILED.get(resultCode, LDAPResultCode.toString(resultCode), String.valueOf(extendedResponse.getErrorMessage()));
                err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
                int n = resultCode;
                return n;
            }
            try {
                ASN1Sequence valueSequence = ASN1Sequence.decodeAsSequence(extendedResponse.getValue().value());
                responseOpElements = valueSequence.elements().get(1).decodeAsSequence().elements();
            }
            catch (Exception e) {
                Message message = ToolMessages.ERR_PWPSTATE_CANNOT_DECODE_RESPONSE_MESSAGE.get(StaticUtils.getExceptionMessage(e));
                err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
                resultCode = 81;
                return resultCode;
            }
            block36: for (ASN1Element opElement : responseOpElements) {
                Message message;
                ArrayList<String> opValues;
                int opType;
                block46: {
                    try {
                        ASN1Sequence opSequence = opElement.decodeAsSequence();
                        ArrayList<ASN1Element> elements = opSequence.elements();
                        opType = elements.get(0).decodeAsEnumerated().intValue();
                        opValues = new ArrayList<String>();
                        if (elements.size() != 2) break block46;
                        for (ASN1Element e : elements.get(1).decodeAsSequence().elements()) {
                            opValues.add(e.decodeAsOctetString().stringValue());
                        }
                    }
                    catch (Exception e) {
                        Message message2 = ToolMessages.ERR_PWPSTATE_CANNOT_DECODE_RESPONSE_OP.get(StaticUtils.getExceptionMessage(e));
                        err.println(StaticUtils.wrapText(message2, ServerConstants.MAX_LINE_WIDTH));
                        continue;
                    }
                }
                switch (opType) {
                    case 0: {
                        message = ToolMessages.INFO_PWPSTATE_LABEL_PASSWORD_POLICY_DN.get();
                        ManageAccount.printLabelAndValues(message, opValues);
                        continue block36;
                    }
                    case 1: {
                        message = ToolMessages.INFO_PWPSTATE_LABEL_ACCOUNT_DISABLED_STATE.get();
                        ManageAccount.printLabelAndValues(message, opValues);
                        continue block36;
                    }
                    case 4: {
                        message = ToolMessages.INFO_PWPSTATE_LABEL_ACCOUNT_EXPIRATION_TIME.get();
                        ManageAccount.printLabelAndValues(message, opValues);
                        continue block36;
                    }
                    case 7: {
                        message = ToolMessages.INFO_PWPSTATE_LABEL_SECONDS_UNTIL_ACCOUNT_EXPIRATION.get();
                        ManageAccount.printLabelAndValues(message, opValues);
                        continue block36;
                    }
                    case 8: {
                        message = ToolMessages.INFO_PWPSTATE_LABEL_PASSWORD_CHANGED_TIME.get();
                        ManageAccount.printLabelAndValues(message, opValues);
                        continue block36;
                    }
                    case 11: {
                        message = ToolMessages.INFO_PWPSTATE_LABEL_PASSWORD_EXPIRATION_WARNED_TIME.get();
                        ManageAccount.printLabelAndValues(message, opValues);
                        continue block36;
                    }
                    case 14: {
                        message = ToolMessages.INFO_PWPSTATE_LABEL_SECONDS_UNTIL_PASSWORD_EXPIRATION.get();
                        ManageAccount.printLabelAndValues(message, opValues);
                        continue block36;
                    }
                    case 15: {
                        message = ToolMessages.INFO_PWPSTATE_LABEL_SECONDS_UNTIL_PASSWORD_EXPIRATION_WARNING.get();
                        ManageAccount.printLabelAndValues(message, opValues);
                        continue block36;
                    }
                    case 16: {
                        message = ToolMessages.INFO_PWPSTATE_LABEL_AUTH_FAILURE_TIMES.get();
                        ManageAccount.printLabelAndValues(message, opValues);
                        continue block36;
                    }
                    case 20: {
                        message = ToolMessages.INFO_PWPSTATE_LABEL_SECONDS_UNTIL_AUTH_FAILURE_UNLOCK.get();
                        ManageAccount.printLabelAndValues(message, opValues);
                        continue block36;
                    }
                    case 21: {
                        message = ToolMessages.INFO_PWPSTATE_LABEL_REMAINING_AUTH_FAILURE_COUNT.get();
                        ManageAccount.printLabelAndValues(message, opValues);
                        continue block36;
                    }
                    case 22: {
                        message = ToolMessages.INFO_PWPSTATE_LABEL_LAST_LOGIN_TIME.get();
                        ManageAccount.printLabelAndValues(message, opValues);
                        continue block36;
                    }
                    case 25: {
                        message = ToolMessages.INFO_PWPSTATE_LABEL_SECONDS_UNTIL_IDLE_LOCKOUT.get();
                        ManageAccount.printLabelAndValues(message, opValues);
                        continue block36;
                    }
                    case 26: {
                        message = ToolMessages.INFO_PWPSTATE_LABEL_PASSWORD_RESET_STATE.get();
                        ManageAccount.printLabelAndValues(message, opValues);
                        continue block36;
                    }
                    case 29: {
                        message = ToolMessages.INFO_PWPSTATE_LABEL_SECONDS_UNTIL_PASSWORD_RESET_LOCKOUT.get();
                        ManageAccount.printLabelAndValues(message, opValues);
                        continue block36;
                    }
                    case 30: {
                        message = ToolMessages.INFO_PWPSTATE_LABEL_GRACE_LOGIN_USE_TIMES.get();
                        ManageAccount.printLabelAndValues(message, opValues);
                        continue block36;
                    }
                    case 34: {
                        message = ToolMessages.INFO_PWPSTATE_LABEL_REMAINING_GRACE_LOGIN_COUNT.get();
                        ManageAccount.printLabelAndValues(message, opValues);
                        continue block36;
                    }
                    case 35: {
                        message = ToolMessages.INFO_PWPSTATE_LABEL_PASSWORD_CHANGED_BY_REQUIRED_TIME.get();
                        ManageAccount.printLabelAndValues(message, opValues);
                        continue block36;
                    }
                    case 38: {
                        message = ToolMessages.INFO_PWPSTATE_LABEL_SECONDS_UNTIL_REQUIRED_CHANGE_TIME.get();
                        ManageAccount.printLabelAndValues(message, opValues);
                        continue block36;
                    }
                    case 39: {
                        message = ToolMessages.INFO_PWPSTATE_LABEL_PASSWORD_HISTORY.get();
                        ManageAccount.printLabelAndValues(message, opValues);
                        continue block36;
                    }
                }
                message = ToolMessages.ERR_PWPSTATE_INVALID_RESPONSE_OP_TYPE.get(String.valueOf(opType));
                err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
            }
            int n = 0;
            return n;
        }
        finally {
            if (connection != null) {
                connection.close(nextMessageID);
            }
        }
    }

    private static int parseArgsAndConnect(String[] args) {
        Message message;
        Message message2;
        StringArgument trustStorePW;
        StringArgument trustStoreFile;
        StringArgument certNickname;
        StringArgument keyStorePW;
        StringArgument keyStoreFile;
        BooleanArgument trustAll;
        StringArgument saslOption;
        StringArgument targetDN;
        StringArgument bindPW;
        StringArgument bindDN;
        BooleanArgument useStartTLS;
        BooleanArgument useSSL;
        IntegerArgument port;
        StringArgument host;
        argParser = new SubCommandArgumentParser(CLASS_NAME, ToolMessages.INFO_PWPSTATE_TOOL_DESCRIPTION.get(), false);
        try {
            host = new StringArgument("host", Character.valueOf('h'), "hostname", false, false, true, "{host}", "127.0.0.1", null, ToolMessages.INFO_PWPSTATE_DESCRIPTION_HOST.get());
            argParser.addGlobalArgument(host);
            port = new IntegerArgument("port", Character.valueOf('p'), "port", false, false, true, "{port}", 389, null, true, 1, true, 65535, ToolMessages.INFO_PWPSTATE_DESCRIPTION_PORT.get());
            argParser.addGlobalArgument(port);
            useSSL = new BooleanArgument("usessl", Character.valueOf('Z'), "useSSL", ToolMessages.INFO_PWPSTATE_DESCRIPTION_USESSL.get());
            argParser.addGlobalArgument(useSSL);
            useStartTLS = new BooleanArgument("usestarttls", Character.valueOf('q'), "useStartTLS", ToolMessages.INFO_PWPSTATE_DESCRIPTION_USESTARTTLS.get());
            argParser.addGlobalArgument(useStartTLS);
            bindDN = new StringArgument("binddn", Character.valueOf('D'), "bindDN", false, false, true, "{bindDN}", null, null, ToolMessages.INFO_PWPSTATE_DESCRIPTION_BINDDN.get());
            argParser.addGlobalArgument(bindDN);
            bindPW = new StringArgument("bindpw", Character.valueOf('w'), "bindPassword", false, false, true, "{bindPassword}", null, null, ToolMessages.INFO_PWPSTATE_DESCRIPTION_BINDPW.get());
            argParser.addGlobalArgument(bindPW);
            FileBasedArgument bindPWFile = new FileBasedArgument("bindpwfile", Character.valueOf('j'), "bindPasswordFile", false, false, "{bindPasswordFile}", null, null, ToolMessages.INFO_PWPSTATE_DESCRIPTION_BINDPWFILE.get());
            argParser.addGlobalArgument(bindPWFile);
            targetDN = new StringArgument("targetdn", Character.valueOf('b'), "targetDN", true, false, true, "{targetDN}", null, null, ToolMessages.INFO_PWPSTATE_DESCRIPTION_TARGETDN.get());
            argParser.addGlobalArgument(targetDN);
            saslOption = new StringArgument("sasloption", Character.valueOf('o'), "saslOption", false, true, true, "{name=value}", null, null, ToolMessages.INFO_PWPSTATE_DESCRIPTION_SASLOPTIONS.get());
            argParser.addGlobalArgument(saslOption);
            trustAll = new BooleanArgument("trustall", Character.valueOf('X'), "trustAll", ToolMessages.INFO_PWPSTATE_DESCRIPTION_TRUST_ALL.get());
            argParser.addGlobalArgument(trustAll);
            keyStoreFile = new StringArgument("keystorefile", Character.valueOf('K'), "keyStorePath", false, false, true, "{keyStorePath}", null, null, ToolMessages.INFO_PWPSTATE_DESCRIPTION_KSFILE.get());
            argParser.addGlobalArgument(keyStoreFile);
            keyStorePW = new StringArgument("keystorepw", Character.valueOf('W'), "keyStorePassword", false, false, true, "{keyStorePassword}", null, null, ToolMessages.INFO_PWPSTATE_DESCRIPTION_KSPW.get());
            argParser.addGlobalArgument(keyStorePW);
            FileBasedArgument keyStorePWFile = new FileBasedArgument("keystorepwfile", Character.valueOf('u'), "keyStorePasswordFile", false, false, "{path}", null, null, ToolMessages.INFO_PWPSTATE_DESCRIPTION_KSPWFILE.get());
            argParser.addGlobalArgument(keyStorePWFile);
            certNickname = new StringArgument("certnickname", Character.valueOf('N'), "certNickname", false, false, true, "{nickname}", null, null, ToolMessages.INFO_DESCRIPTION_CERT_NICKNAME.get());
            argParser.addGlobalArgument(certNickname);
            trustStoreFile = new StringArgument("truststorefile", Character.valueOf('P'), "trustStorePath", false, false, true, "{trustStorePath}", null, null, ToolMessages.INFO_PWPSTATE_DESCRIPTION_TSFILE.get());
            argParser.addGlobalArgument(trustStoreFile);
            trustStorePW = new StringArgument("truststorepw", Character.valueOf('T'), "trustStorePassword", false, false, true, "{trustStorePassword}", null, null, ToolMessages.INFO_PWPSTATE_DESCRIPTION_TSPW.get());
            argParser.addGlobalArgument(trustStorePW);
            FileBasedArgument trustStorePWFile = new FileBasedArgument("truststorepwfile", Character.valueOf('U'), "TrustStorePasswordFile", false, false, "{path}", null, null, ToolMessages.INFO_PWPSTATE_DESCRIPTION_TSPWFILE.get());
            argParser.addGlobalArgument(trustStorePWFile);
            BooleanArgument showUsage = new BooleanArgument("showusage", Character.valueOf('H'), "help", ToolMessages.INFO_PWPSTATE_DESCRIPTION_SHOWUSAGE.get());
            argParser.addGlobalArgument(showUsage);
            argParser.setUsageArgument(showUsage, out);
            HashSet<String> booleanValues = new HashSet<String>(2);
            booleanValues.add("true");
            booleanValues.add("false");
            Message msg = ToolMessages.INFO_DESCRIPTION_PWPSTATE_GET_ALL.get();
            new SubCommand(argParser, SC_GET_ALL, msg);
            msg = ToolMessages.INFO_DESCRIPTION_PWPSTATE_GET_PASSWORD_POLICY_DN.get();
            new SubCommand(argParser, SC_GET_PASSWORD_POLICY_DN, msg);
            msg = ToolMessages.INFO_DESCRIPTION_PWPSTATE_GET_ACCOUNT_DISABLED_STATE.get();
            new SubCommand(argParser, SC_GET_ACCOUNT_DISABLED_STATE, msg);
            msg = ToolMessages.INFO_DESCRIPTION_PWPSTATE_SET_ACCOUNT_DISABLED_STATE.get();
            SubCommand sc = new SubCommand(argParser, SC_SET_ACCOUNT_DISABLED_STATE, msg);
            sc.addArgument(new MultiChoiceArgument(ARG_OP_VALUE, Character.valueOf('O'), "operationValue", true, false, true, "{true|false}", null, null, booleanValues, false, ToolMessages.INFO_DESCRIPTION_OPERATION_BOOLEAN_VALUE.get()));
            msg = ToolMessages.INFO_DESCRIPTION_PWPSTATE_CLEAR_ACCOUNT_DISABLED_STATE.get();
            new SubCommand(argParser, SC_CLEAR_ACCOUNT_DISABLED_STATE, msg);
            msg = ToolMessages.INFO_DESCRIPTION_PWPSTATE_GET_ACCOUNT_EXPIRATION_TIME.get();
            new SubCommand(argParser, SC_GET_ACCOUNT_EXPIRATION_TIME, msg);
            msg = ToolMessages.INFO_DESCRIPTION_PWPSTATE_SET_ACCOUNT_EXPIRATION_TIME.get();
            sc = new SubCommand(argParser, SC_SET_ACCOUNT_EXPIRATION_TIME, msg);
            sc.addArgument(new StringArgument(ARG_OP_VALUE, Character.valueOf('O'), "operationValue", false, false, true, "{time}", null, null, ToolMessages.INFO_DESCRIPTION_OPERATION_TIME_VALUE.get()));
            sc.setHidden(true);
            msg = ToolMessages.INFO_DESCRIPTION_PWPSTATE_CLEAR_ACCOUNT_EXPIRATION_TIME.get();
            sc = new SubCommand(argParser, SC_CLEAR_ACCOUNT_EXPIRATION_TIME, msg);
            sc.setHidden(true);
            msg = ToolMessages.INFO_DESCRIPTION_PWPSTATE_GET_SECONDS_UNTIL_ACCOUNT_EXPIRATION.get();
            new SubCommand(argParser, SC_GET_SECONDS_UNTIL_ACCOUNT_EXPIRATION, msg);
            msg = ToolMessages.INFO_DESCRIPTION_PWPSTATE_GET_PASSWORD_CHANGED_TIME.get();
            new SubCommand(argParser, SC_GET_PASSWORD_CHANGED_TIME, msg);
            msg = ToolMessages.INFO_DESCRIPTION_PWPSTATE_SET_PASSWORD_CHANGED_TIME.get();
            sc = new SubCommand(argParser, SC_SET_PASSWORD_CHANGED_TIME, msg);
            sc.addArgument(new StringArgument(ARG_OP_VALUE, Character.valueOf('O'), "operationValue", false, false, true, "{time}", null, null, ToolMessages.INFO_DESCRIPTION_OPERATION_TIME_VALUE.get()));
            sc.setHidden(true);
            msg = ToolMessages.INFO_DESCRIPTION_PWPSTATE_CLEAR_PASSWORD_CHANGED_TIME.get();
            sc = new SubCommand(argParser, SC_CLEAR_PASSWORD_CHANGED_TIME, msg);
            sc.setHidden(true);
            msg = ToolMessages.INFO_DESCRIPTION_PWPSTATE_GET_PASSWORD_EXPIRATION_WARNED_TIME.get();
            new SubCommand(argParser, SC_GET_PASSWORD_EXP_WARNED_TIME, msg);
            msg = ToolMessages.INFO_DESCRIPTION_PWPSTATE_SET_PASSWORD_EXPIRATION_WARNED_TIME.get();
            sc = new SubCommand(argParser, SC_SET_PASSWORD_EXP_WARNED_TIME, msg);
            sc.addArgument(new StringArgument(ARG_OP_VALUE, Character.valueOf('O'), "operationValue", false, false, true, "{time}", null, null, ToolMessages.INFO_DESCRIPTION_OPERATION_TIME_VALUE.get()));
            sc.setHidden(true);
            msg = ToolMessages.INFO_DESCRIPTION_PWPSTATE_CLEAR_PASSWORD_EXPIRATION_WARNED_TIME.get();
            sc = new SubCommand(argParser, SC_CLEAR_PASSWORD_EXP_WARNED_TIME, msg);
            sc.setHidden(true);
            msg = ToolMessages.INFO_DESCRIPTION_PWPSTATE_GET_SECONDS_UNTIL_PASSWORD_EXP.get();
            new SubCommand(argParser, SC_GET_SECONDS_UNTIL_PASSWORD_EXPIRATION, msg);
            msg = ToolMessages.INFO_DESCRIPTION_PWPSTATE_GET_SECONDS_UNTIL_PASSWORD_EXP_WARNING.get();
            new SubCommand(argParser, SC_GET_SECONDS_UNTIL_PASSWORD_EXPIRATION_WARNING, msg);
            msg = ToolMessages.INFO_DESCRIPTION_PWPSTATE_GET_AUTH_FAILURE_TIMES.get();
            new SubCommand(argParser, SC_GET_AUTHENTICATION_FAILURE_TIMES, msg);
            msg = ToolMessages.INFO_DESCRIPTION_PWPSTATE_ADD_AUTH_FAILURE_TIME.get();
            sc = new SubCommand(argParser, SC_ADD_AUTHENTICATION_FAILURE_TIME, msg);
            sc.addArgument(new StringArgument(ARG_OP_VALUE, Character.valueOf('O'), "operationValue", false, true, true, "{time}", null, null, ToolMessages.INFO_DESCRIPTION_OPERATION_TIME_VALUE.get()));
            sc.setHidden(true);
            msg = ToolMessages.INFO_DESCRIPTION_PWPSTATE_SET_AUTH_FAILURE_TIMES.get();
            sc = new SubCommand(argParser, SC_SET_AUTHENTICATION_FAILURE_TIMES, msg);
            sc.addArgument(new StringArgument(ARG_OP_VALUE, Character.valueOf('O'), "operationValue", false, true, true, "{time}", null, null, ToolMessages.INFO_DESCRIPTION_OPERATION_TIME_VALUES.get()));
            sc.setHidden(true);
            msg = ToolMessages.INFO_DESCRIPTION_PWPSTATE_CLEAR_AUTH_FAILURE_TIMES.get();
            sc = new SubCommand(argParser, SC_CLEAR_AUTHENTICATION_FAILURE_TIMES, msg);
            sc.setHidden(true);
            msg = ToolMessages.INFO_DESCRIPTION_PWPSTATE_GET_SECONDS_UNTIL_AUTH_FAILURE_UNLOCK.get();
            new SubCommand(argParser, SC_GET_SECONDS_UNTIL_AUTHENTICATION_FAILURE_UNLOCK, msg);
            msg = ToolMessages.INFO_DESCRIPTION_PWPSTATE_GET_REMAINING_AUTH_FAILURE_COUNT.get();
            new SubCommand(argParser, SC_GET_REMAINING_AUTHENTICATION_FAILURE_COUNT, msg);
            msg = ToolMessages.INFO_DESCRIPTION_PWPSTATE_GET_LAST_LOGIN_TIME.get();
            new SubCommand(argParser, SC_GET_LAST_LOGIN_TIME, msg);
            msg = ToolMessages.INFO_DESCRIPTION_PWPSTATE_SET_LAST_LOGIN_TIME.get();
            sc = new SubCommand(argParser, SC_SET_LAST_LOGIN_TIME, msg);
            sc.addArgument(new StringArgument(ARG_OP_VALUE, Character.valueOf('O'), "operationValue", false, false, true, "{time}", null, null, ToolMessages.INFO_DESCRIPTION_OPERATION_TIME_VALUE.get()));
            sc.setHidden(true);
            msg = ToolMessages.INFO_DESCRIPTION_PWPSTATE_CLEAR_LAST_LOGIN_TIME.get();
            sc = new SubCommand(argParser, SC_CLEAR_LAST_LOGIN_TIME, msg);
            sc.setHidden(true);
            msg = ToolMessages.INFO_DESCRIPTION_PWPSTATE_GET_SECONDS_UNTIL_IDLE_LOCKOUT.get();
            new SubCommand(argParser, SC_GET_SECONDS_UNTIL_IDLE_LOCKOUT, msg);
            msg = ToolMessages.INFO_DESCRIPTION_PWPSTATE_GET_PASSWORD_RESET_STATE.get();
            new SubCommand(argParser, SC_GET_PASSWORD_RESET_STATE, msg);
            msg = ToolMessages.INFO_DESCRIPTION_PWPSTATE_SET_PASSWORD_RESET_STATE.get();
            sc = new SubCommand(argParser, SC_SET_PASSWORD_RESET_STATE, msg);
            sc.addArgument(new MultiChoiceArgument(ARG_OP_VALUE, Character.valueOf('O'), "operationValue", true, false, true, "{true|false}", null, null, booleanValues, false, ToolMessages.INFO_DESCRIPTION_OPERATION_BOOLEAN_VALUE.get()));
            sc.setHidden(true);
            msg = ToolMessages.INFO_DESCRIPTION_PWPSTATE_CLEAR_PASSWORD_RESET_STATE.get();
            sc = new SubCommand(argParser, SC_CLEAR_PASSWORD_RESET_STATE, msg);
            sc.setHidden(true);
            msg = ToolMessages.INFO_DESCRIPTION_PWPSTATE_GET_SECONDS_UNTIL_RESET_LOCKOUT.get();
            new SubCommand(argParser, SC_GET_SECONDS_UNTIL_PASSWORD_RESET_LOCKOUT, msg);
            msg = ToolMessages.INFO_DESCRIPTION_PWPSTATE_GET_GRACE_LOGIN_USE_TIMES.get();
            new SubCommand(argParser, SC_GET_GRACE_LOGIN_USE_TIMES, msg);
            msg = ToolMessages.INFO_DESCRIPTION_PWPSTATE_ADD_GRACE_LOGIN_USE_TIME.get();
            sc = new SubCommand(argParser, SC_ADD_GRACE_LOGIN_USE_TIME, msg);
            sc.addArgument(new StringArgument(ARG_OP_VALUE, Character.valueOf('O'), "operationValue", false, true, true, "{time}", null, null, ToolMessages.INFO_DESCRIPTION_OPERATION_TIME_VALUE.get()));
            sc.setHidden(true);
            msg = ToolMessages.INFO_DESCRIPTION_PWPSTATE_SET_GRACE_LOGIN_USE_TIMES.get();
            sc = new SubCommand(argParser, SC_SET_GRACE_LOGIN_USE_TIMES, msg);
            sc.addArgument(new StringArgument(ARG_OP_VALUE, Character.valueOf('O'), "operationValue", false, true, true, "{time}", null, null, ToolMessages.INFO_DESCRIPTION_OPERATION_TIME_VALUES.get()));
            sc.setHidden(true);
            msg = ToolMessages.INFO_DESCRIPTION_PWPSTATE_CLEAR_GRACE_LOGIN_USE_TIMES.get();
            sc = new SubCommand(argParser, SC_CLEAR_GRACE_LOGIN_USE_TIMES, msg);
            sc.setHidden(true);
            msg = ToolMessages.INFO_DESCRIPTION_PWPSTATE_GET_REMAINING_GRACE_LOGIN_COUNT.get();
            new SubCommand(argParser, SC_GET_REMAINING_GRACE_LOGIN_COUNT, msg);
            msg = ToolMessages.INFO_DESCRIPTION_PWPSTATE_GET_PW_CHANGED_BY_REQUIRED_TIME.get();
            new SubCommand(argParser, SC_GET_PASSWORD_CHANGED_BY_REQUIRED_TIME, msg);
            msg = ToolMessages.INFO_DESCRIPTION_PWPSTATE_SET_PW_CHANGED_BY_REQUIRED_TIME.get();
            sc = new SubCommand(argParser, SC_SET_PASSWORD_CHANGED_BY_REQUIRED_TIME, msg);
            sc.addArgument(new StringArgument(ARG_OP_VALUE, Character.valueOf('O'), "operationValue", false, false, true, "{time}", null, null, ToolMessages.INFO_DESCRIPTION_OPERATION_TIME_VALUE.get()));
            sc.setHidden(true);
            msg = ToolMessages.INFO_DESCRIPTION_PWPSTATE_CLEAR_PW_CHANGED_BY_REQUIRED_TIME.get();
            sc = new SubCommand(argParser, SC_CLEAR_PASSWORD_CHANGED_BY_REQUIRED_TIME, msg);
            sc.setHidden(true);
            msg = ToolMessages.INFO_DESCRIPTION_PWPSTATE_GET_SECONDS_UNTIL_REQUIRED_CHANGE_TIME.get();
            new SubCommand(argParser, SC_GET_SECONDS_UNTIL_REQUIRED_CHANGE_TIME, msg);
            msg = ToolMessages.INFO_DESCRIPTION_PWPSTATE_GET_PASSWORD_HISTORY.get();
            new SubCommand(argParser, SC_GET_PASSWORD_HISTORY, msg);
            msg = ToolMessages.INFO_DESCRIPTION_PWPSTATE_CLEAR_PASSWORD_HISTORY.get();
            sc = new SubCommand(argParser, SC_CLEAR_PASSWORD_HISTORY, msg);
            sc.setHidden(true);
        }
        catch (ArgumentException ae) {
            Message message3 = ToolMessages.ERR_CANNOT_INITIALIZE_ARGS.get(ae.getMessage());
            err.println(StaticUtils.wrapText(message3, ServerConstants.MAX_LINE_WIDTH));
            return 82;
        }
        try {
            argParser.parseArguments(args);
        }
        catch (ArgumentException ae) {
            message2 = ToolMessages.ERR_ERROR_PARSING_ARGS.get(ae.getMessage());
            err.println(StaticUtils.wrapText(message2, ServerConstants.MAX_LINE_WIDTH));
            err.println(argParser.getUsage());
            return 89;
        }
        if (argParser.usageOrVersionDisplayed()) {
            return -1;
        }
        targetDNString = targetDN.getValue();
        LDAPConnectionOptions connectionOptions = new LDAPConnectionOptions();
        connectionOptions.setVersionNumber(3);
        if (useSSL.isPresent()) {
            if (useStartTLS.isPresent()) {
                message2 = ToolMessages.ERR_PWPSTATE_MUTUALLY_EXCLUSIVE_ARGUMENTS.get(useSSL.getLongIdentifier(), useStartTLS.getLongIdentifier());
                err.println(StaticUtils.wrapText(message2, ServerConstants.MAX_LINE_WIDTH));
                return 89;
            }
            connectionOptions.setUseSSL(true);
        } else if (useStartTLS.isPresent()) {
            connectionOptions.setStartTLS(true);
        }
        if (useSSL.isPresent() || useStartTLS.isPresent()) {
            try {
                String clientAlias = certNickname.isPresent() ? certNickname.getValue() : null;
                SSLConnectionFactory sslConnectionFactory = new SSLConnectionFactory();
                sslConnectionFactory.init(trustAll.isPresent(), keyStoreFile.getValue(), keyStorePW.getValue(), clientAlias, trustStoreFile.getValue(), trustStorePW.getValue());
                connectionOptions.setSSLConnectionFactory(sslConnectionFactory);
            }
            catch (SSLConnectionException sce) {
                message = ToolMessages.ERR_PWPSTATE_CANNOT_INITIALIZE_SSL.get(sce.getMessage());
                err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
                return 82;
            }
        }
        if (saslOption.isPresent()) {
            String mechanism = null;
            LinkedList<String> options = new LinkedList<String>();
            for (String s : saslOption.getValues()) {
                int equalPos = s.indexOf(61);
                if (equalPos <= 0) {
                    Message message4 = ToolMessages.ERR_PWPSTATE_CANNOT_PARSE_SASL_OPTION.get(s);
                    err.println(StaticUtils.wrapText(message4, ServerConstants.MAX_LINE_WIDTH));
                    return 89;
                }
                String name = s.substring(0, equalPos);
                if (name.equalsIgnoreCase("mech")) {
                    mechanism = s;
                    continue;
                }
                options.add(s);
            }
            if (mechanism == null) {
                Message message5 = ToolMessages.ERR_PWPSTATE_NO_SASL_MECHANISM.get();
                err.println(StaticUtils.wrapText(message5, ServerConstants.MAX_LINE_WIDTH));
                return 89;
            }
            connectionOptions.setSASLMechanism(mechanism);
            for (String option : options) {
                connectionOptions.addSASLProperty(option);
            }
        }
        nextMessageID = new AtomicInteger(1);
        try {
            connection = new LDAPConnection(host.getValue(), port.getIntValue(), connectionOptions, out, err);
            connection.connectToHost(bindDN.getValue(), bindPW.getValue(), nextMessageID);
        }
        catch (ArgumentException ae) {
            message = ToolMessages.ERR_PWPSTATE_CANNOT_DETERMINE_PORT.get(port.getLongIdentifier(), ae.getMessage());
            err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
            return 89;
        }
        catch (LDAPConnectionException lce) {
            message = ToolMessages.ERR_PWPSTATE_CANNOT_CONNECT.get(lce.getMessage());
            err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
            return 91;
        }
        ldapReader = connection.getLDAPReader();
        ldapWriter = connection.getLDAPWriter();
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static int processSubcommand(ArrayList<ASN1Element> opElements) {
        SubCommand subCommand = argParser.getSubCommand();
        if (subCommand == null) {
            Message message = ToolMessages.ERR_PWPSTATE_NO_SUBCOMMAND.get();
            err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
            err.println(argParser.getUsage());
            return 89;
        }
        String subCommandName = subCommand.getName();
        if (subCommandName.equals(SC_GET_ALL)) {
            return 0;
        }
        if (subCommandName.equals(SC_GET_PASSWORD_POLICY_DN)) {
            opElements.add(PasswordPolicyStateExtendedOperation.encode(0, NO_VALUE));
            return 0;
        }
        if (subCommandName.equals(SC_GET_ACCOUNT_DISABLED_STATE)) {
            opElements.add(PasswordPolicyStateExtendedOperation.encode(1, NO_VALUE));
            return 0;
        }
        if (subCommandName.equals(SC_SET_ACCOUNT_DISABLED_STATE)) {
            Argument a = subCommand.getArgumentForName(ARG_OP_VALUE);
            if (a != null && a.isPresent()) {
                String valueStr = a.getValue();
                if (valueStr.equalsIgnoreCase("true")) {
                    opElements.add(PasswordPolicyStateExtendedOperation.encode(2, "true"));
                    return 0;
                }
                if (valueStr.equalsIgnoreCase("false")) {
                    opElements.add(PasswordPolicyStateExtendedOperation.encode(2, "false"));
                    return 0;
                }
                Message message = ToolMessages.ERR_PWPSTATE_INVALID_BOOLEAN_VALUE.get(valueStr);
                err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
                return 89;
            }
            Message message = ToolMessages.ERR_PWPSTATE_NO_BOOLEAN_VALUE.get();
            err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
            return 89;
        }
        if (subCommandName.equals(SC_CLEAR_ACCOUNT_DISABLED_STATE)) {
            opElements.add(PasswordPolicyStateExtendedOperation.encode(3, NO_VALUE));
            return 0;
        }
        if (subCommandName.equals(SC_GET_ACCOUNT_EXPIRATION_TIME)) {
            opElements.add(PasswordPolicyStateExtendedOperation.encode(4, NO_VALUE));
            return 0;
        }
        if (subCommandName.equals(SC_SET_ACCOUNT_EXPIRATION_TIME)) {
            Argument a = subCommand.getArgumentForName(ARG_OP_VALUE);
            if (a != null && a.isPresent()) {
                opElements.add(PasswordPolicyStateExtendedOperation.encode(5, a.getValue()));
                return 0;
            }
            opElements.add(PasswordPolicyStateExtendedOperation.encode(5, NO_VALUE));
            return 0;
        }
        if (subCommandName.equals(SC_CLEAR_ACCOUNT_EXPIRATION_TIME)) {
            opElements.add(PasswordPolicyStateExtendedOperation.encode(6, NO_VALUE));
            return 0;
        }
        if (subCommandName.equals(SC_GET_SECONDS_UNTIL_ACCOUNT_EXPIRATION)) {
            opElements.add(PasswordPolicyStateExtendedOperation.encode(7, NO_VALUE));
            return 0;
        }
        if (subCommandName.equals(SC_GET_PASSWORD_CHANGED_TIME)) {
            opElements.add(PasswordPolicyStateExtendedOperation.encode(8, NO_VALUE));
            return 0;
        }
        if (subCommandName.equals(SC_SET_PASSWORD_CHANGED_TIME)) {
            Argument a = subCommand.getArgumentForName(ARG_OP_VALUE);
            if (a != null && a.isPresent()) {
                opElements.add(PasswordPolicyStateExtendedOperation.encode(9, a.getValue()));
                return 0;
            }
            opElements.add(PasswordPolicyStateExtendedOperation.encode(9, NO_VALUE));
            return 0;
        }
        if (subCommandName.equals(SC_CLEAR_PASSWORD_CHANGED_TIME)) {
            opElements.add(PasswordPolicyStateExtendedOperation.encode(10, NO_VALUE));
            return 0;
        }
        if (subCommandName.equals(SC_GET_PASSWORD_EXP_WARNED_TIME)) {
            opElements.add(PasswordPolicyStateExtendedOperation.encode(11, NO_VALUE));
            return 0;
        }
        if (subCommandName.equals(SC_SET_PASSWORD_EXP_WARNED_TIME)) {
            Argument a = subCommand.getArgumentForName(ARG_OP_VALUE);
            if (a != null && a.isPresent()) {
                opElements.add(PasswordPolicyStateExtendedOperation.encode(12, a.getValue()));
                return 0;
            }
            opElements.add(PasswordPolicyStateExtendedOperation.encode(12, NO_VALUE));
            return 0;
        }
        if (subCommandName.equals(SC_CLEAR_PASSWORD_EXP_WARNED_TIME)) {
            opElements.add(PasswordPolicyStateExtendedOperation.encode(13, NO_VALUE));
            return 0;
        }
        if (subCommandName.equals(SC_GET_SECONDS_UNTIL_PASSWORD_EXPIRATION)) {
            opElements.add(PasswordPolicyStateExtendedOperation.encode(14, NO_VALUE));
            return 0;
        }
        if (subCommandName.equals(SC_GET_SECONDS_UNTIL_PASSWORD_EXPIRATION_WARNING)) {
            opElements.add(PasswordPolicyStateExtendedOperation.encode(15, NO_VALUE));
            return 0;
        }
        if (subCommandName.equals(SC_GET_AUTHENTICATION_FAILURE_TIMES)) {
            opElements.add(PasswordPolicyStateExtendedOperation.encode(16, NO_VALUE));
            return 0;
        }
        if (subCommandName.equals(SC_ADD_AUTHENTICATION_FAILURE_TIME)) {
            Argument a = subCommand.getArgumentForName(ARG_OP_VALUE);
            if (a != null && a.isPresent()) {
                opElements.add(PasswordPolicyStateExtendedOperation.encode(17, a.getValue()));
                return 0;
            }
            opElements.add(PasswordPolicyStateExtendedOperation.encode(17, NO_VALUE));
            return 0;
        }
        if (subCommandName.equals(SC_SET_AUTHENTICATION_FAILURE_TIMES)) {
            Argument a = subCommand.getArgumentForName(ARG_OP_VALUE);
            if (a != null && a.isPresent()) {
                ArrayList<String> valueList = new ArrayList<String>(a.getValues());
                String[] values = new String[valueList.size()];
                valueList.toArray(values);
                opElements.add(PasswordPolicyStateExtendedOperation.encode(18, values));
                return 0;
            }
            opElements.add(PasswordPolicyStateExtendedOperation.encode(18, NO_VALUE));
            return 0;
        }
        if (subCommandName.equals(SC_CLEAR_AUTHENTICATION_FAILURE_TIMES)) {
            opElements.add(PasswordPolicyStateExtendedOperation.encode(19, NO_VALUE));
            return 0;
        }
        if (subCommandName.equals(SC_GET_SECONDS_UNTIL_AUTHENTICATION_FAILURE_UNLOCK)) {
            opElements.add(PasswordPolicyStateExtendedOperation.encode(20, NO_VALUE));
            return 0;
        }
        if (subCommandName.equals(SC_GET_REMAINING_AUTHENTICATION_FAILURE_COUNT)) {
            opElements.add(PasswordPolicyStateExtendedOperation.encode(21, NO_VALUE));
            return 0;
        }
        if (subCommandName.equals(SC_GET_LAST_LOGIN_TIME)) {
            opElements.add(PasswordPolicyStateExtendedOperation.encode(22, NO_VALUE));
            return 0;
        }
        if (subCommandName.equals(SC_SET_LAST_LOGIN_TIME)) {
            Argument a = subCommand.getArgumentForName(ARG_OP_VALUE);
            if (a != null && a.isPresent()) {
                opElements.add(PasswordPolicyStateExtendedOperation.encode(23, a.getValue()));
                return 0;
            }
            opElements.add(PasswordPolicyStateExtendedOperation.encode(23, NO_VALUE));
            return 0;
        }
        if (subCommandName.equals(SC_CLEAR_LAST_LOGIN_TIME)) {
            opElements.add(PasswordPolicyStateExtendedOperation.encode(24, NO_VALUE));
            return 0;
        }
        if (subCommandName.equals(SC_GET_SECONDS_UNTIL_IDLE_LOCKOUT)) {
            opElements.add(PasswordPolicyStateExtendedOperation.encode(25, NO_VALUE));
            return 0;
        }
        if (subCommandName.equals(SC_GET_PASSWORD_RESET_STATE)) {
            opElements.add(PasswordPolicyStateExtendedOperation.encode(26, NO_VALUE));
            return 0;
        }
        if (subCommandName.equals(SC_SET_PASSWORD_RESET_STATE)) {
            Argument a = subCommand.getArgumentForName(ARG_OP_VALUE);
            if (a != null && a.isPresent()) {
                String valueStr = a.getValue();
                if (valueStr.equalsIgnoreCase("true")) {
                    opElements.add(PasswordPolicyStateExtendedOperation.encode(27, "true"));
                    return 0;
                }
                if (valueStr.equalsIgnoreCase("false")) {
                    opElements.add(PasswordPolicyStateExtendedOperation.encode(27, "false"));
                    return 0;
                }
                Message message = ToolMessages.ERR_PWPSTATE_INVALID_BOOLEAN_VALUE.get(valueStr);
                err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
                return 89;
            }
            Message message = ToolMessages.ERR_PWPSTATE_NO_BOOLEAN_VALUE.get();
            err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
            return 89;
        }
        if (subCommandName.equals(SC_CLEAR_PASSWORD_RESET_STATE)) {
            opElements.add(PasswordPolicyStateExtendedOperation.encode(26, NO_VALUE));
            return 0;
        }
        if (subCommandName.equals(SC_GET_SECONDS_UNTIL_PASSWORD_RESET_LOCKOUT)) {
            opElements.add(PasswordPolicyStateExtendedOperation.encode(29, NO_VALUE));
            return 0;
        }
        if (subCommandName.equals(SC_GET_GRACE_LOGIN_USE_TIMES)) {
            opElements.add(PasswordPolicyStateExtendedOperation.encode(30, NO_VALUE));
            return 0;
        }
        if (subCommandName.equals(SC_ADD_GRACE_LOGIN_USE_TIME)) {
            Argument a = subCommand.getArgumentForName(ARG_OP_VALUE);
            if (a != null && a.isPresent()) {
                opElements.add(PasswordPolicyStateExtendedOperation.encode(31, a.getValue()));
                return 0;
            }
            opElements.add(PasswordPolicyStateExtendedOperation.encode(31, NO_VALUE));
            return 0;
        }
        if (subCommandName.equals(SC_SET_GRACE_LOGIN_USE_TIMES)) {
            Argument a = subCommand.getArgumentForName(ARG_OP_VALUE);
            if (a != null && a.isPresent()) {
                ArrayList<String> valueList = new ArrayList<String>(a.getValues());
                String[] values = new String[valueList.size()];
                valueList.toArray(values);
                opElements.add(PasswordPolicyStateExtendedOperation.encode(32, values));
                return 0;
            }
            opElements.add(PasswordPolicyStateExtendedOperation.encode(32, NO_VALUE));
            return 0;
        }
        if (subCommandName.equals(SC_CLEAR_GRACE_LOGIN_USE_TIMES)) {
            opElements.add(PasswordPolicyStateExtendedOperation.encode(33, NO_VALUE));
            return 0;
        }
        if (subCommandName.equals(SC_GET_REMAINING_GRACE_LOGIN_COUNT)) {
            opElements.add(PasswordPolicyStateExtendedOperation.encode(34, NO_VALUE));
            return 0;
        }
        if (subCommandName.equals(SC_GET_PASSWORD_CHANGED_BY_REQUIRED_TIME)) {
            opElements.add(PasswordPolicyStateExtendedOperation.encode(35, NO_VALUE));
            return 0;
        }
        if (subCommandName.equals(SC_SET_PASSWORD_CHANGED_BY_REQUIRED_TIME)) {
            Argument a = subCommand.getArgumentForName(ARG_OP_VALUE);
            if (a != null && a.isPresent()) {
                opElements.add(PasswordPolicyStateExtendedOperation.encode(36, a.getValue()));
                return 0;
            }
            opElements.add(PasswordPolicyStateExtendedOperation.encode(36, NO_VALUE));
            return 0;
        }
        if (subCommandName.equals(SC_CLEAR_PASSWORD_CHANGED_BY_REQUIRED_TIME)) {
            opElements.add(PasswordPolicyStateExtendedOperation.encode(37, NO_VALUE));
            return 0;
        }
        if (subCommandName.equals(SC_GET_SECONDS_UNTIL_REQUIRED_CHANGE_TIME)) {
            opElements.add(PasswordPolicyStateExtendedOperation.encode(38, NO_VALUE));
            return 0;
        }
        if (subCommandName.equals(SC_GET_PASSWORD_HISTORY)) {
            opElements.add(PasswordPolicyStateExtendedOperation.encode(39, NO_VALUE));
            return 0;
        }
        if (subCommandName.equals(SC_CLEAR_PASSWORD_HISTORY)) {
            opElements.add(PasswordPolicyStateExtendedOperation.encode(40, NO_VALUE));
            return 0;
        }
        Message message = ToolMessages.ERR_PWPSTATE_INVALID_SUBCOMMAND.get(subCommandName);
        err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
        err.println(argParser.getUsage());
        return 89;
    }

    private static void printLabelAndValues(Message msg, ArrayList<String> values) {
        String label = String.valueOf(msg);
        if (values == null || values.isEmpty()) {
            out.print(label);
            out.println(":");
        } else {
            for (String value : values) {
                out.print(label);
                out.print(":  ");
                out.println(value);
            }
        }
    }
}

