/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.tools;

import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.TreeMap;
import java.util.TreeSet;
import org.opends.messages.ConfigMessages;
import org.opends.messages.Message;
import org.opends.messages.ToolMessages;
import org.opends.server.config.ConfigEntry;
import org.opends.server.config.ConfigException;
import org.opends.server.config.DNConfigAttribute;
import org.opends.server.config.StringConfigAttribute;
import org.opends.server.core.DirectoryServer;
import org.opends.server.extensions.ConfigFileHandler;
import org.opends.server.types.DN;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.InitializationException;
import org.opends.server.types.NullOutputStream;
import org.opends.server.util.ServerConstants;
import org.opends.server.util.StaticUtils;
import org.opends.server.util.args.ArgumentException;
import org.opends.server.util.args.ArgumentParser;
import org.opends.server.util.args.BooleanArgument;
import org.opends.server.util.args.StringArgument;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListBackends {
    public static void main(String[] args) {
        int retCode = ListBackends.listBackends(args, true, System.out, System.err);
        if (retCode != 0) {
            System.exit(StaticUtils.filterExitCode(retCode));
        }
    }

    public static int listBackends(String[] args) {
        return ListBackends.listBackends(args, true, System.out, System.err);
    }

    public static int listBackends(String[] args, boolean initializeServer, OutputStream outStream, OutputStream errStream) {
        TreeMap<String, TreeSet<DN>> backends;
        PrintStream out = outStream == null ? NullOutputStream.printStream() : new PrintStream(outStream);
        PrintStream err = errStream == null ? NullOutputStream.printStream() : new PrintStream(errStream);
        BooleanArgument displayUsage = null;
        StringArgument backendID = null;
        StringArgument baseDN = null;
        StringArgument configClass = null;
        StringArgument configFile = null;
        Message toolDescription = ToolMessages.INFO_LISTBACKENDS_TOOL_DESCRIPTION.get();
        ArgumentParser argParser = new ArgumentParser("org.opends.server.tools.ListBackends", toolDescription, false);
        try {
            configClass = new StringArgument("configclass", Character.valueOf('C'), "configClass", true, false, true, "{configClass}", ConfigFileHandler.class.getName(), null, ToolMessages.INFO_DESCRIPTION_CONFIG_CLASS.get());
            configClass.setHidden(true);
            argParser.addArgument(configClass);
            configFile = new StringArgument("configfile", Character.valueOf('f'), "configFile", true, false, true, "{configFile}", null, null, ToolMessages.INFO_DESCRIPTION_CONFIG_FILE.get());
            configFile.setHidden(true);
            argParser.addArgument(configFile);
            backendID = new StringArgument("backendid", Character.valueOf('n'), "backendID", false, true, true, "{backendID}", null, null, ToolMessages.INFO_LISTBACKENDS_DESCRIPTION_BACKEND_ID.get());
            argParser.addArgument(backendID);
            baseDN = new StringArgument("basedn", Character.valueOf('b'), "baseDN", false, true, true, "{baseDN}", null, null, ToolMessages.INFO_LISTBACKENDS_DESCRIPTION_BASE_DN.get());
            argParser.addArgument(baseDN);
            displayUsage = new BooleanArgument("help", Character.valueOf('H'), "help", ToolMessages.INFO_LISTBACKENDS_DESCRIPTION_HELP.get());
            argParser.addArgument(displayUsage);
            argParser.setUsageArgument(displayUsage, out);
        }
        catch (ArgumentException ae) {
            Message message = ToolMessages.ERR_CANNOT_INITIALIZE_ARGS.get(ae.getMessage());
            err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
            return 1;
        }
        try {
            argParser.parseArguments(args);
        }
        catch (ArgumentException ae) {
            Message message = ToolMessages.ERR_ERROR_PARSING_ARGS.get(ae.getMessage());
            err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
            err.println(argParser.getUsage());
            return 1;
        }
        if (argParser.usageOrVersionDisplayed()) {
            return 0;
        }
        if (backendID.isPresent() && baseDN.isPresent()) {
            Message message = ToolMessages.ERR_TOOL_CONFLICTING_ARGS.get(backendID.getLongIdentifier(), baseDN.getLongIdentifier());
            err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
            return 1;
        }
        DirectoryServer directoryServer = DirectoryServer.getInstance();
        if (initializeServer) {
            try {
                directoryServer.bootstrapClient();
                directoryServer.initializeJMX();
            }
            catch (Exception e) {
                Message message = ToolMessages.ERR_SERVER_BOOTSTRAP_ERROR.get(StaticUtils.getExceptionMessage(e));
                err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
                return 1;
            }
            try {
                directoryServer.initializeConfiguration(configClass.getValue(), configFile.getValue());
            }
            catch (InitializationException ie) {
                Message message = ToolMessages.ERR_CANNOT_LOAD_CONFIG.get(ie.getMessage());
                err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
                return 1;
            }
            catch (Exception e) {
                Message message = ToolMessages.ERR_CANNOT_LOAD_CONFIG.get(StaticUtils.getExceptionMessage(e));
                err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
                return 1;
            }
            try {
                directoryServer.initializeSchema();
            }
            catch (ConfigException ce) {
                Message message = ToolMessages.ERR_CANNOT_LOAD_SCHEMA.get(ce.getMessage());
                err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
                return 1;
            }
            catch (InitializationException ie) {
                Message message = ToolMessages.ERR_CANNOT_LOAD_SCHEMA.get(ie.getMessage());
                err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
                return 1;
            }
            catch (Exception e) {
                Message message = ToolMessages.ERR_CANNOT_LOAD_SCHEMA.get(StaticUtils.getExceptionMessage(e));
                err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
                return 1;
            }
        }
        try {
            backends = ListBackends.getBackends();
        }
        catch (ConfigException ce) {
            Message message = ToolMessages.ERR_LISTBACKENDS_CANNOT_GET_BACKENDS.get(ce.getMessage());
            err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
            return 1;
        }
        catch (Exception e) {
            Message message = ToolMessages.ERR_LISTBACKENDS_CANNOT_GET_BACKENDS.get(StaticUtils.getExceptionMessage(e));
            err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
            return 1;
        }
        if (baseDN.isPresent()) {
            TreeMap<DN, String> baseToIDMap = new TreeMap<DN, String>();
            for (String id : backends.keySet()) {
                for (DN dn : backends.get(id)) {
                    baseToIDMap.put(dn, id);
                }
            }
            block21: for (String dnStr : baseDN.getValues()) {
                Message message;
                DN dn;
                try {
                    dn = DN.decode(dnStr);
                }
                catch (DirectoryException de) {
                    message = ToolMessages.ERR_LISTBACKENDS_INVALID_DN.get(dnStr, de.getMessage());
                    err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
                    return 1;
                }
                catch (Exception e) {
                    message = ToolMessages.ERR_LISTBACKENDS_INVALID_DN.get(dnStr, StaticUtils.getExceptionMessage(e));
                    err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
                    return 1;
                }
                String id = (String)baseToIDMap.get(dn);
                if (id == null) {
                    message = ToolMessages.INFO_LISTBACKENDS_NOT_BASE_DN.get(dn.toString());
                    out.println(message);
                    DN parentDN = dn.getParent();
                    while (true) {
                        if (parentDN == null) {
                            message = ToolMessages.INFO_LISTBACKENDS_NO_BACKEND_FOR_DN.get(dn.toString());
                            out.println(message);
                            continue block21;
                        }
                        id = (String)baseToIDMap.get(parentDN);
                        if (id != null) {
                            message = ToolMessages.INFO_LISTBACKENDS_DN_BELOW_BASE.get(dn.toString(), parentDN.toString(), id);
                            out.println(message);
                            continue block21;
                        }
                        parentDN = parentDN.getParent();
                    }
                }
                message = ToolMessages.INFO_LISTBACKENDS_BASE_FOR_ID.get(dn.toString(), id);
                out.println(message);
            }
        } else {
            int i;
            LinkedList<String> backendIDs = backendID.isPresent() ? backendID.getValues() : new LinkedList<String>(backends.keySet());
            Message backendIDLabel = ToolMessages.INFO_LISTBACKENDS_LABEL_BACKEND_ID.get();
            Message baseDNLabel = ToolMessages.INFO_LISTBACKENDS_LABEL_BASE_DN.get();
            int backendIDLength = 10;
            int baseDNLength = 7;
            Iterator iterator = backendIDs.iterator();
            while (iterator.hasNext()) {
                String id = (String)iterator.next();
                TreeSet<DN> baseDNs = backends.get(id);
                if (baseDNs == null) {
                    Message message = ToolMessages.ERR_LISTBACKENDS_NO_SUCH_BACKEND.get(id);
                    err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
                    iterator.remove();
                    continue;
                }
                backendIDLength = Math.max(id.length(), backendIDLength);
                for (DN dn : baseDNs) {
                    baseDNLength = Math.max(dn.toString().length(), baseDNLength);
                }
            }
            if (backendIDs.isEmpty()) {
                Message message = ToolMessages.ERR_LISTBACKENDS_NO_VALID_BACKENDS.get();
                err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
                return 1;
            }
            out.print(backendIDLabel);
            for (i = backendIDLabel.length(); i < backendIDLength + 2; ++i) {
                out.print(" ");
            }
            out.println(baseDNLabel);
            for (i = 0; i < backendIDLength; ++i) {
                out.print("-");
            }
            out.print("  ");
            for (i = 0; i < baseDNLength; ++i) {
                out.print("-");
            }
            out.println();
            for (String id : backendIDs) {
                out.print(id);
                for (int i2 = id.length(); i2 < backendIDLength + 2; ++i2) {
                    out.print(" ");
                }
                TreeSet<DN> baseDNs = backends.get(id);
                Iterator<DN> dnIterator = baseDNs.iterator();
                out.println(dnIterator.next().toString());
                while (dnIterator.hasNext()) {
                    for (int i3 = 0; i3 < backendIDLength + 2; ++i3) {
                        out.print(" ");
                    }
                    out.println(dnIterator.next().toString());
                }
            }
        }
        return 0;
    }

    private static TreeMap<String, TreeSet<DN>> getBackends() throws ConfigException {
        DN backendBaseDN = null;
        try {
            backendBaseDN = DN.decode("cn=Backends,cn=config");
        }
        catch (DirectoryException de) {
            Message message = ToolMessages.ERR_CANNOT_DECODE_BACKEND_BASE_DN.get("cn=Backends,cn=config", de.getMessageObject());
            throw new ConfigException(message, (Throwable)de);
        }
        catch (Exception e) {
            Message message = ToolMessages.ERR_CANNOT_DECODE_BACKEND_BASE_DN.get("cn=Backends,cn=config", StaticUtils.getExceptionMessage(e));
            throw new ConfigException(message, (Throwable)e);
        }
        ConfigEntry baseEntry = null;
        try {
            baseEntry = DirectoryServer.getConfigEntry(backendBaseDN);
        }
        catch (ConfigException ce) {
            Message message = ToolMessages.ERR_CANNOT_RETRIEVE_BACKEND_BASE_ENTRY.get("cn=Backends,cn=config", ce.getMessage());
            throw new ConfigException(message, (Throwable)ce);
        }
        catch (Exception e) {
            Message message = ToolMessages.ERR_CANNOT_RETRIEVE_BACKEND_BASE_ENTRY.get("cn=Backends,cn=config", StaticUtils.getExceptionMessage(e));
            throw new ConfigException(message, (Throwable)e);
        }
        TreeMap<String, TreeSet<DN>> backendMap = new TreeMap<String, TreeSet<DN>>();
        for (ConfigEntry configEntry : baseEntry.getChildren().values()) {
            Message message;
            String backendID = null;
            try {
                Message msg = ConfigMessages.INFO_CONFIG_BACKEND_ATTR_DESCRIPTION_BACKEND_ID.get();
                StringConfigAttribute idStub = new StringConfigAttribute("ds-cfg-backend-id", msg, true, false, true);
                StringConfigAttribute idAttr = (StringConfigAttribute)configEntry.getConfigAttribute(idStub);
                if (idAttr == null) continue;
                backendID = idAttr.activeValue();
            }
            catch (ConfigException ce) {
                message = ToolMessages.ERR_CANNOT_DETERMINE_BACKEND_ID.get(String.valueOf(configEntry.getDN()), ce.getMessage());
                throw new ConfigException(message, (Throwable)ce);
            }
            catch (Exception e) {
                message = ToolMessages.ERR_CANNOT_DETERMINE_BACKEND_ID.get(String.valueOf(configEntry.getDN()), StaticUtils.getExceptionMessage(e));
                throw new ConfigException(message, (Throwable)e);
            }
            TreeSet<DN> baseDNs = new TreeSet<DN>();
            try {
                Message msg = ConfigMessages.INFO_CONFIG_BACKEND_ATTR_DESCRIPTION_BASE_DNS.get();
                DNConfigAttribute baseDNStub = new DNConfigAttribute("ds-cfg-backend-base-dn", msg, true, true, true);
                DNConfigAttribute baseDNAttr = (DNConfigAttribute)configEntry.getConfigAttribute(baseDNStub);
                if (baseDNAttr != null) {
                    baseDNs.addAll(baseDNAttr.activeValues());
                }
            }
            catch (Exception e) {
                Message message2 = ToolMessages.ERR_CANNOT_DETERMINE_BASES_FOR_BACKEND.get(String.valueOf(configEntry.getDN()), StaticUtils.getExceptionMessage(e));
                throw new ConfigException(message2, (Throwable)e);
            }
            backendMap.put(backendID, baseDNs);
        }
        return backendMap;
    }
}

