/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.tools;

import java.io.IOException;
import java.net.Socket;
import org.opends.server.protocols.asn1.ASN1Element;
import org.opends.server.protocols.asn1.ASN1Writer;
import org.opends.server.protocols.ldap.LDAPMessage;
import org.opends.server.tools.VerboseTracer;

public class LDAPWriter {
    ASN1Writer asn1Writer;
    VerboseTracer tracer;

    public LDAPWriter(Socket socket) throws IOException {
        this(socket, null);
    }

    public LDAPWriter(Socket socket, VerboseTracer tracer) throws IOException {
        this.asn1Writer = new ASN1Writer(socket);
        this.tracer = tracer;
    }

    public void writeMessage(LDAPMessage message) throws IOException {
        ASN1Element element = message.encode();
        if (this.tracer != null) {
            this.tracer.traceOutgoingMessage(message, element);
        }
        this.asn1Writer.writeElement(element);
    }

    public void close() {
        this.asn1Writer.close();
    }

    public ASN1Writer getASN1Writer() {
        return this.asn1Writer;
    }
}

