/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.tasks;

import java.util.ArrayList;
import java.util.List;
import org.opends.messages.Message;
import org.opends.messages.TaskMessages;
import org.opends.messages.ToolMessages;
import org.opends.server.api.Backend;
import org.opends.server.api.ClientConnection;
import org.opends.server.backends.jeb.BackendImpl;
import org.opends.server.backends.jeb.RebuildConfig;
import org.opends.server.backends.task.Task;
import org.opends.server.backends.task.TaskState;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.LockFileManager;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.tasks.TaskUtils;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeType;
import org.opends.server.types.DN;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.Entry;
import org.opends.server.types.Operation;
import org.opends.server.types.Privilege;
import org.opends.server.types.ResultCode;
import org.opends.server.util.StaticUtils;

public class RebuildTask
extends Task {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    String baseDN = null;
    ArrayList<String> indexes = null;
    int maxThreads = -1;

    public void initializeTask() throws DirectoryException {
        ClientConnection clientConnection;
        Operation operation = this.getOperation();
        if (operation != null && !(clientConnection = operation.getClientConnection()).hasPrivilege(Privilege.LDIF_IMPORT, operation)) {
            Message message = TaskMessages.ERR_TASK_INDEXREBUILD_INSUFFICIENT_PRIVILEGES.get();
            throw new DirectoryException(ResultCode.INSUFFICIENT_ACCESS_RIGHTS, message);
        }
        Entry taskEntry = this.getTaskEntry();
        AttributeType typeBaseDN = DirectoryServer.getAttributeType("ds-task-rebuild-base-dn", true);
        AttributeType typeIndex = DirectoryServer.getAttributeType("ds-task-rebuild-index", true);
        AttributeType typeMaxThreads = DirectoryServer.getAttributeType("ds-task-rebuild-max-threads", true);
        List<Attribute> attrList = taskEntry.getAttribute(typeBaseDN);
        this.baseDN = TaskUtils.getSingleValueString(attrList);
        attrList = taskEntry.getAttribute(typeIndex);
        this.indexes = TaskUtils.getMultiValueString(attrList);
        attrList = taskEntry.getAttribute(typeMaxThreads);
        this.maxThreads = TaskUtils.getSingleValueInteger(attrList, -1);
    }

    protected TaskState runTask() {
        StringBuilder failureReason;
        String lockFile;
        Backend backend;
        RebuildConfig rebuildConfig;
        block25: {
            Message message;
            rebuildConfig = new RebuildConfig();
            try {
                rebuildConfig.setBaseDN(DN.decode(this.baseDN));
            }
            catch (DirectoryException de) {
                Message message2 = ToolMessages.ERR_CANNOT_DECODE_BASE_DN.get(this.baseDN, de.getMessageObject());
                this.logError(message2);
                return TaskState.STOPPED_BY_ERROR;
            }
            for (String index : this.indexes) {
                rebuildConfig.addRebuildIndex(index);
            }
            rebuildConfig.setMaxRebuildThreads(this.maxThreads);
            backend = DirectoryServer.getBackendWithBaseDN(rebuildConfig.getBaseDN());
            if (backend == null) {
                message = ToolMessages.ERR_NO_BACKENDS_FOR_BASE.get(this.baseDN);
                this.logError(message);
                return TaskState.STOPPED_BY_ERROR;
            }
            if (!(backend instanceof BackendImpl)) {
                message = ToolMessages.ERR_REBUILDINDEX_WRONG_BACKEND_TYPE.get();
                this.logError(message);
                return TaskState.STOPPED_BY_ERROR;
            }
            lockFile = LockFileManager.getBackendLockFileName(backend);
            failureReason = new StringBuilder();
            if (rebuildConfig.includesSystemIndex()) {
                try {
                    TaskUtils.disableBackend(backend.getBackendID());
                }
                catch (DirectoryException e) {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugCaught(DebugLogLevel.ERROR, e);
                    }
                    this.logError(e.getMessageObject());
                    return TaskState.STOPPED_BY_ERROR;
                }
                try {
                    if (!LockFileManager.acquireExclusiveLock(lockFile, failureReason)) {
                        Message message3 = ToolMessages.ERR_REBUILDINDEX_CANNOT_EXCLUSIVE_LOCK_BACKEND.get(backend.getBackendID(), String.valueOf(failureReason));
                        this.logError(message3);
                        return TaskState.STOPPED_BY_ERROR;
                    }
                    break block25;
                }
                catch (Exception e) {
                    Message message4 = ToolMessages.ERR_REBUILDINDEX_CANNOT_EXCLUSIVE_LOCK_BACKEND.get(backend.getBackendID(), StaticUtils.getExceptionMessage(e));
                    this.logError(message4);
                    return TaskState.STOPPED_BY_ERROR;
                }
            }
            try {
                if (!LockFileManager.acquireSharedLock(lockFile, failureReason)) {
                    Message message5 = ToolMessages.ERR_REBUILDINDEX_CANNOT_SHARED_LOCK_BACKEND.get(backend.getBackendID(), String.valueOf(failureReason));
                    this.logError(message5);
                    return TaskState.STOPPED_BY_ERROR;
                }
            }
            catch (Exception e) {
                Message message6 = ToolMessages.ERR_REBUILDINDEX_CANNOT_SHARED_LOCK_BACKEND.get(backend.getBackendID(), StaticUtils.getExceptionMessage(e));
                this.logError(message6);
                return TaskState.STOPPED_BY_ERROR;
            }
        }
        try {
            BackendImpl jebBackend = (BackendImpl)backend;
            jebBackend.rebuildBackend(rebuildConfig);
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = ToolMessages.ERR_REBUILDINDEX_ERROR_DURING_REBUILD.get(e.getMessage());
            this.logError(message);
            return TaskState.STOPPED_BY_ERROR;
        }
        try {
            lockFile = LockFileManager.getBackendLockFileName(backend);
            failureReason = new StringBuilder();
            if (!LockFileManager.releaseLock(lockFile, failureReason)) {
                Message message = ToolMessages.WARN_REBUILDINDEX_CANNOT_UNLOCK_BACKEND.get(backend.getBackendID(), String.valueOf(failureReason));
                this.logError(message);
                return TaskState.COMPLETED_WITH_ERRORS;
            }
        }
        catch (Exception e) {
            Message message = ToolMessages.WARN_REBUILDINDEX_CANNOT_UNLOCK_BACKEND.get(backend.getBackendID(), StaticUtils.getExceptionMessage(e));
            this.logError(message);
            return TaskState.COMPLETED_WITH_ERRORS;
        }
        if (rebuildConfig.includesSystemIndex()) {
            try {
                TaskUtils.enableBackend(backend.getBackendID());
            }
            catch (DirectoryException e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                this.logError(e.getMessageObject());
                return TaskState.STOPPED_BY_ERROR;
            }
        }
        return TaskState.COMPLETED_SUCCESSFULLY;
    }
}

