/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.tasks;

import java.util.ArrayList;
import java.util.List;
import org.opends.messages.Message;
import org.opends.messages.TaskMessages;
import org.opends.server.api.ClientConnection;
import org.opends.server.backends.task.Task;
import org.opends.server.backends.task.TaskState;
import org.opends.server.core.DirectoryServer;
import org.opends.server.tasks.TaskUtils;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeType;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.Entry;
import org.opends.server.types.Operation;
import org.opends.server.types.Privilege;
import org.opends.server.types.ResultCode;

public class ExportTask
extends Task {
    private String ldifFile;
    private String backendID;
    private int wrapColumn;
    private boolean appendToLDIF;
    private boolean compressLDIF;
    private boolean encryptLDIF;
    private boolean signHash;
    private ArrayList<String> includeAttributeStrings;
    private ArrayList<String> excludeAttributeStrings;
    private ArrayList<String> includeFilterStrings;
    private ArrayList<String> excludeFilterStrings;
    private ArrayList<String> includeBranchStrings;
    private ArrayList<String> excludeBranchStrings;

    public void initializeTask() throws DirectoryException {
        ClientConnection clientConnection;
        Operation operation = this.getOperation();
        if (operation != null && !(clientConnection = operation.getClientConnection()).hasPrivilege(Privilege.LDIF_EXPORT, operation)) {
            Message message = TaskMessages.ERR_TASK_LDIFEXPORT_INSUFFICIENT_PRIVILEGES.get();
            throw new DirectoryException(ResultCode.INSUFFICIENT_ACCESS_RIGHTS, message);
        }
        Entry taskEntry = this.getTaskEntry();
        AttributeType typeLdifFile = DirectoryServer.getAttributeType("ds-task-export-ldif-file", true);
        AttributeType typeBackendID = DirectoryServer.getAttributeType("ds-task-export-backend-id", true);
        AttributeType typeAppendToLDIF = DirectoryServer.getAttributeType("ds-task-export-append-to-ldif", true);
        AttributeType typeCompressLDIF = DirectoryServer.getAttributeType("ds-task-export-compress-ldif", true);
        AttributeType typeEncryptLDIF = DirectoryServer.getAttributeType("ds-task-export-encrypt-ldif", true);
        AttributeType typeSignHash = DirectoryServer.getAttributeType("ds-task-export-sign-hash", true);
        AttributeType typeIncludeAttribute = DirectoryServer.getAttributeType("ds-task-export-include-attribute", true);
        AttributeType typeExcludeAttribute = DirectoryServer.getAttributeType("ds-task-export-exclude-attribute", true);
        AttributeType typeIncludeFilter = DirectoryServer.getAttributeType("ds-task-export-include-filter", true);
        AttributeType typeExcludeFilter = DirectoryServer.getAttributeType("ds-task-export-exclude-filter", true);
        AttributeType typeIncludeBranch = DirectoryServer.getAttributeType("ds-task-export-include-branch", true);
        AttributeType typeExcludeBranch = DirectoryServer.getAttributeType("ds-task-export-exclude-branch", true);
        AttributeType typeWrapColumn = DirectoryServer.getAttributeType("ds-task-export-wrap-column", true);
        List<Attribute> attrList = taskEntry.getAttribute(typeLdifFile);
        this.ldifFile = TaskUtils.getSingleValueString(attrList);
        attrList = taskEntry.getAttribute(typeBackendID);
        this.backendID = TaskUtils.getSingleValueString(attrList);
        attrList = taskEntry.getAttribute(typeAppendToLDIF);
        this.appendToLDIF = TaskUtils.getBoolean(attrList, false);
        attrList = taskEntry.getAttribute(typeCompressLDIF);
        this.compressLDIF = TaskUtils.getBoolean(attrList, false);
        attrList = taskEntry.getAttribute(typeEncryptLDIF);
        this.encryptLDIF = TaskUtils.getBoolean(attrList, false);
        attrList = taskEntry.getAttribute(typeSignHash);
        this.signHash = TaskUtils.getBoolean(attrList, false);
        attrList = taskEntry.getAttribute(typeIncludeAttribute);
        this.includeAttributeStrings = TaskUtils.getMultiValueString(attrList);
        attrList = taskEntry.getAttribute(typeExcludeAttribute);
        this.excludeAttributeStrings = TaskUtils.getMultiValueString(attrList);
        attrList = taskEntry.getAttribute(typeIncludeFilter);
        this.includeFilterStrings = TaskUtils.getMultiValueString(attrList);
        attrList = taskEntry.getAttribute(typeExcludeFilter);
        this.excludeFilterStrings = TaskUtils.getMultiValueString(attrList);
        attrList = taskEntry.getAttribute(typeIncludeBranch);
        this.includeBranchStrings = TaskUtils.getMultiValueString(attrList);
        attrList = taskEntry.getAttribute(typeExcludeBranch);
        this.excludeBranchStrings = TaskUtils.getMultiValueString(attrList);
        attrList = taskEntry.getAttribute(typeWrapColumn);
        this.wrapColumn = TaskUtils.getSingleValueInteger(attrList, 0);
    }

    /*
     * Exception decompiling
     */
    protected TaskState runTask() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

