/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.tasks;

import java.util.Iterator;
import java.util.List;
import org.opends.messages.Message;
import org.opends.messages.TaskMessages;
import org.opends.server.api.ClientConnection;
import org.opends.server.api.ConnectionHandler;
import org.opends.server.backends.task.Task;
import org.opends.server.backends.task.TaskState;
import org.opends.server.core.DirectoryServer;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.DisconnectReason;
import org.opends.server.types.Entry;
import org.opends.server.types.Operation;
import org.opends.server.types.Privilege;
import org.opends.server.types.ResultCode;
import org.opends.server.util.StaticUtils;

public class DisconnectClientTask
extends Task {
    private boolean notifyClient;
    private long connectionID;
    private Message disconnectMessage;

    public void initializeTask() throws DirectoryException {
        AttributeValue v;
        Iterator i$;
        ClientConnection conn;
        Operation operation = this.getOperation();
        if (operation != null && !(conn = operation.getClientConnection()).hasPrivilege(Privilege.DISCONNECT_CLIENT, operation)) {
            Message message = TaskMessages.ERR_TASK_DISCONNECT_NO_PRIVILEGE.get();
            throw new DirectoryException(ResultCode.INSUFFICIENT_ACCESS_RIGHTS, message);
        }
        Entry taskEntry = this.getTaskEntry();
        this.connectionID = -1L;
        AttributeType attrType = DirectoryServer.getAttributeType("ds-task-disconnect-connection-id", true);
        List<Attribute> attrList = taskEntry.getAttribute(attrType);
        if (attrList != null) {
            for (Attribute a : attrList) {
                i$ = a.getValues().iterator();
                if (!i$.hasNext()) continue;
                v = (AttributeValue)i$.next();
                try {
                    this.connectionID = Long.parseLong(v.getStringValue());
                    break;
                }
                catch (Exception e) {
                    Message message = TaskMessages.ERR_TASK_DISCONNECT_INVALID_CONN_ID.get(v.getStringValue());
                    throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message, e);
                }
            }
        }
        if (this.connectionID < 0L) {
            Message message = TaskMessages.ERR_TASK_DISCONNECT_NO_CONN_ID.get("ds-task-disconnect-connection-id");
            throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, message);
        }
        this.notifyClient = false;
        attrType = DirectoryServer.getAttributeType("ds-task-disconnect-notify-client", true);
        attrList = taskEntry.getAttribute(attrType);
        if (attrList != null) {
            for (Attribute a : attrList) {
                i$ = a.getValues().iterator();
                if (!i$.hasNext()) continue;
                v = (AttributeValue)i$.next();
                String stringValue = StaticUtils.toLowerCase(v.getStringValue());
                if (stringValue.equals("true")) {
                    this.notifyClient = true;
                    break;
                }
                if (stringValue.equals("false")) break;
                Message message = TaskMessages.ERR_TASK_DISCONNECT_INVALID_NOTIFY_CLIENT.get(stringValue);
                throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message);
            }
        }
        this.disconnectMessage = TaskMessages.INFO_TASK_DISCONNECT_GENERIC_MESSAGE.get();
        attrType = DirectoryServer.getAttributeType("ds-task-disconnect-message", true);
        attrList = taskEntry.getAttribute(attrType);
        if (attrList != null) {
            for (Attribute a : attrList) {
                i$ = a.getValues().iterator();
                if (!i$.hasNext()) continue;
                v = (AttributeValue)i$.next();
                this.disconnectMessage = Message.raw(v.getStringValue(), new Object[0]);
                break;
            }
        }
    }

    protected TaskState runTask() {
        ClientConnection clientConnection = null;
        Iterator<ConnectionHandler> i$ = DirectoryServer.getConnectionHandlers().iterator();
        block0: while (i$.hasNext()) {
            ConnectionHandler handler;
            ConnectionHandler connHandler = handler = i$.next();
            for (ClientConnection c : connHandler.getClientConnections()) {
                if (c.getConnectionID() != this.connectionID) continue;
                clientConnection = c;
                continue block0;
            }
        }
        if (clientConnection == null) {
            Message message = TaskMessages.ERR_TASK_DISCONNECT_NO_SUCH_CONNECTION.get(String.valueOf(this.connectionID));
            this.logError(message);
            return TaskState.COMPLETED_WITH_ERRORS;
        }
        clientConnection.disconnect(DisconnectReason.ADMIN_DISCONNECT, this.notifyClient, this.disconnectMessage);
        return TaskState.COMPLETED_SUCCESSFULLY;
    }
}

