/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.schema;

import java.util.List;
import org.opends.server.admin.std.server.SubstringMatchingRuleCfg;
import org.opends.server.api.SubstringMatchingRule;
import org.opends.server.config.ConfigException;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.types.ByteString;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.InitializationException;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TelephoneNumberSubstringMatchingRule
extends SubstringMatchingRule {
    @Override
    public void initializeMatchingRule(SubstringMatchingRuleCfg configuration) throws ConfigException, InitializationException {
    }

    @Override
    public String getName() {
        return "telephoneNumberSubstringsMatch";
    }

    @Override
    public String getOID() {
        return "2.5.13.21";
    }

    @Override
    public String getDescription() {
        return null;
    }

    @Override
    public String getSyntaxOID() {
        return "1.3.6.1.4.1.1466.115.121.1.58";
    }

    @Override
    public ByteString normalizeValue(ByteString value) throws DirectoryException {
        String valueString = value.stringValue();
        int valueLength = valueString.length();
        StringBuilder buffer = new StringBuilder(valueLength);
        for (int i = 0; i < valueLength; ++i) {
            char c = valueString.charAt(i);
            if (!StaticUtils.isDigit(c)) continue;
            buffer.append(c);
        }
        return new ASN1OctetString(buffer.toString());
    }

    @Override
    public ByteString normalizeSubstring(ByteString substring) throws DirectoryException {
        return this.normalizeValue(substring);
    }

    @Override
    public boolean valueMatchesSubstring(ByteString value, ByteString subInitial, List<ByteString> subAnyElements, ByteString subFinal) {
        int pos;
        byte[] valueBytes = value.value();
        int valueLength = valueBytes.length;
        if (subInitial != null) {
            byte[] initialBytes = subInitial.value();
            int initialLength = initialBytes.length;
            if (initialLength > valueLength) {
                return false;
            }
            for (pos = 0; pos < initialLength; ++pos) {
                if (initialBytes[pos] == valueBytes[pos]) continue;
                return false;
            }
        }
        if (subAnyElements != null && !subAnyElements.isEmpty()) {
            for (ByteString element : subAnyElements) {
                byte[] anyBytes = element.value();
                int anyLength = anyBytes.length;
                int end = valueLength - anyLength;
                boolean match = false;
                while (pos <= end) {
                    if (anyBytes[0] == valueBytes[pos]) {
                        boolean subMatch = true;
                        for (int i = 1; i < anyLength; ++i) {
                            if (anyBytes[i] == valueBytes[pos + i]) continue;
                            subMatch = false;
                            break;
                        }
                        if (subMatch) {
                            match = subMatch;
                            break;
                        }
                    }
                    ++pos;
                }
                if (match) {
                    pos += anyLength;
                    continue;
                }
                return false;
            }
        }
        if (subFinal != null) {
            byte[] finalBytes = subFinal.value();
            int finalLength = finalBytes.length;
            if (valueLength - finalLength < pos) {
                return false;
            }
            pos = valueLength - finalLength;
            int i = 0;
            while (i < finalLength) {
                if (finalBytes[i] != valueBytes[pos]) {
                    return false;
                }
                ++i;
                ++pos;
            }
        }
        return true;
    }
}

