/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.schema;

import java.util.Arrays;
import org.opends.server.admin.std.server.EqualityMatchingRuleCfg;
import org.opends.server.api.EqualityMatchingRule;
import org.opends.server.config.ConfigException;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.types.ByteString;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.InitializationException;
import org.opends.server.util.StaticUtils;

public class TelephoneNumberEqualityMatchingRule
extends EqualityMatchingRule {
    public void initializeMatchingRule(EqualityMatchingRuleCfg configuration) throws ConfigException, InitializationException {
    }

    public String getName() {
        return "telephoneNumberMatch";
    }

    public String getOID() {
        return "2.5.13.20";
    }

    public String getDescription() {
        return null;
    }

    public String getSyntaxOID() {
        return "1.3.6.1.4.1.1466.115.121.1.50";
    }

    public ByteString normalizeValue(ByteString value) throws DirectoryException {
        String valueString = value.stringValue();
        int valueLength = valueString.length();
        StringBuilder buffer = new StringBuilder(valueLength);
        for (int i = 0; i < valueLength; ++i) {
            char c = valueString.charAt(i);
            if (!StaticUtils.isDigit(c)) continue;
            buffer.append(c);
        }
        return new ASN1OctetString(buffer.toString());
    }

    public boolean areEqual(ByteString value1, ByteString value2) {
        return Arrays.equals(value1.value(), value2.value());
    }
}

