/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.schema;

import org.opends.server.admin.std.server.OrderingMatchingRuleCfg;
import org.opends.server.api.OrderingMatchingRule;
import org.opends.server.config.ConfigException;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.types.ByteString;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.InitializationException;
import org.opends.server.util.StaticUtils;

public class OctetStringOrderingMatchingRule
extends OrderingMatchingRule {
    private static final long serialVersionUID = 3832343819704649155L;

    public void initializeMatchingRule(OrderingMatchingRuleCfg configuration) throws ConfigException, InitializationException {
    }

    public String getName() {
        return "octetStringOrderingMatch";
    }

    public String getOID() {
        return "2.5.13.18";
    }

    public String getDescription() {
        return null;
    }

    public String getSyntaxOID() {
        return "1.3.6.1.4.1.1466.115.121.1.40";
    }

    public ByteString normalizeValue(ByteString value) throws DirectoryException {
        return new ASN1OctetString(value.value());
    }

    public int compareValues(ByteString value1, ByteString value2) {
        return this.compare(value1.value(), value2.value());
    }

    public int compare(byte[] b1, byte[] b2) {
        return StaticUtils.compare(b1, b2);
    }
}

