/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.schema;

import org.opends.server.admin.std.server.EqualityMatchingRuleCfg;
import org.opends.server.api.EqualityMatchingRule;
import org.opends.server.config.ConfigException;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.types.ByteString;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.InitializationException;
import org.opends.server.util.StaticUtils;

public class CaseIgnoreEqualityMatchingRule
extends EqualityMatchingRule {
    public void initializeMatchingRule(EqualityMatchingRuleCfg configuration) throws ConfigException, InitializationException {
    }

    public String getName() {
        return "caseIgnoreMatch";
    }

    public String getOID() {
        return "2.5.13.2";
    }

    public String getDescription() {
        return null;
    }

    public String getSyntaxOID() {
        return "1.3.6.1.4.1.1466.115.121.1.15";
    }

    public ByteString normalizeValue(ByteString value) throws DirectoryException {
        int endPos;
        int startPos;
        byte[] valueBytes = value.value();
        int valueLength = valueBytes.length;
        for (startPos = 0; startPos < valueLength && valueBytes[startPos] == 32; ++startPos) {
        }
        if (startPos == valueLength) {
            return new ASN1OctetString(" ");
        }
        for (endPos = valueLength - 1; endPos > startPos && valueBytes[endPos] == 32; --endPos) {
        }
        StringBuilder buffer = new StringBuilder(endPos - startPos + 1);
        boolean lastWasSpace = false;
        block31: for (int i = startPos; i <= endPos; ++i) {
            byte b = valueBytes[i];
            if ((b & 0x7F) != b) {
                return this.normalizeNonASCII(value);
            }
            switch (b) {
                case 32: {
                    if (lastWasSpace) continue block31;
                    buffer.append(' ');
                    lastWasSpace = true;
                    continue block31;
                }
                case 65: {
                    buffer.append('a');
                    lastWasSpace = false;
                    continue block31;
                }
                case 66: {
                    buffer.append('b');
                    lastWasSpace = false;
                    continue block31;
                }
                case 67: {
                    buffer.append('c');
                    lastWasSpace = false;
                    continue block31;
                }
                case 68: {
                    buffer.append('d');
                    lastWasSpace = false;
                    continue block31;
                }
                case 69: {
                    buffer.append('e');
                    lastWasSpace = false;
                    continue block31;
                }
                case 70: {
                    buffer.append('f');
                    lastWasSpace = false;
                    continue block31;
                }
                case 71: {
                    buffer.append('g');
                    lastWasSpace = false;
                    continue block31;
                }
                case 72: {
                    buffer.append('h');
                    lastWasSpace = false;
                    continue block31;
                }
                case 73: {
                    buffer.append('i');
                    lastWasSpace = false;
                    continue block31;
                }
                case 74: {
                    buffer.append('j');
                    lastWasSpace = false;
                    continue block31;
                }
                case 75: {
                    buffer.append('k');
                    lastWasSpace = false;
                    continue block31;
                }
                case 76: {
                    buffer.append('l');
                    lastWasSpace = false;
                    continue block31;
                }
                case 77: {
                    buffer.append('m');
                    lastWasSpace = false;
                    continue block31;
                }
                case 78: {
                    buffer.append('n');
                    lastWasSpace = false;
                    continue block31;
                }
                case 79: {
                    buffer.append('o');
                    lastWasSpace = false;
                    continue block31;
                }
                case 80: {
                    buffer.append('p');
                    lastWasSpace = false;
                    continue block31;
                }
                case 81: {
                    buffer.append('q');
                    lastWasSpace = false;
                    continue block31;
                }
                case 82: {
                    buffer.append('r');
                    lastWasSpace = false;
                    continue block31;
                }
                case 83: {
                    buffer.append('s');
                    lastWasSpace = false;
                    continue block31;
                }
                case 84: {
                    buffer.append('t');
                    lastWasSpace = false;
                    continue block31;
                }
                case 85: {
                    buffer.append('u');
                    lastWasSpace = false;
                    continue block31;
                }
                case 86: {
                    buffer.append('v');
                    lastWasSpace = false;
                    continue block31;
                }
                case 87: {
                    buffer.append('w');
                    lastWasSpace = false;
                    continue block31;
                }
                case 88: {
                    buffer.append('x');
                    lastWasSpace = false;
                    continue block31;
                }
                case 89: {
                    buffer.append('y');
                    lastWasSpace = false;
                    continue block31;
                }
                case 90: {
                    buffer.append('z');
                    lastWasSpace = false;
                    continue block31;
                }
                default: {
                    buffer.append((char)b);
                    lastWasSpace = false;
                }
            }
        }
        return new ASN1OctetString(buffer.toString());
    }

    private ByteString normalizeNonASCII(ByteString value) {
        StringBuilder buffer = new StringBuilder();
        StaticUtils.toLowerCase(value.value(), buffer, true);
        int bufferLength = buffer.length();
        if (bufferLength == 0) {
            if (value.value().length > 0) {
                return new ASN1OctetString(" ");
            }
            return new ASN1OctetString();
        }
        for (int pos = bufferLength - 1; pos > 0; --pos) {
            if (buffer.charAt(pos) != ' ' || buffer.charAt(pos - 1) != ' ') continue;
            buffer.delete(pos, pos + 1);
        }
        return new ASN1OctetString(buffer.toString());
    }

    public boolean areEqual(ByteString value1, ByteString value2) {
        int length;
        byte[] b1 = value1.value();
        byte[] b2 = value2.value();
        if (b2.length != (length = b1.length)) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            if (b1[i] == b2[i]) continue;
            return false;
        }
        return true;
    }
}

