/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.replication.server;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.Semaphore;
import org.opends.messages.MessageBuilder;
import org.opends.messages.ReplicationMessages;
import org.opends.server.admin.std.server.MonitorProviderCfg;
import org.opends.server.api.MonitorProvider;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.replication.common.ChangeNumber;
import org.opends.server.replication.common.ServerState;
import org.opends.server.replication.protocol.AckMessage;
import org.opends.server.replication.protocol.HeartbeatThread;
import org.opends.server.replication.protocol.ProtocolSession;
import org.opends.server.replication.protocol.ProtocolVersion;
import org.opends.server.replication.protocol.ReplServerInfoMessage;
import org.opends.server.replication.protocol.ReplServerStartMessage;
import org.opends.server.replication.protocol.ReplicationMessage;
import org.opends.server.replication.protocol.RoutableMessage;
import org.opends.server.replication.protocol.ServerStartMessage;
import org.opends.server.replication.protocol.StartMessage;
import org.opends.server.replication.protocol.UpdateMessage;
import org.opends.server.replication.protocol.WindowMessage;
import org.opends.server.replication.protocol.WindowProbe;
import org.opends.server.replication.server.AckMessageList;
import org.opends.server.replication.server.MsgQueue;
import org.opends.server.replication.server.ReplServerAckMessageList;
import org.opends.server.replication.server.ReplicationCache;
import org.opends.server.replication.server.ReplicationIterator;
import org.opends.server.replication.server.ReplicationIteratorComparator;
import org.opends.server.replication.server.ReplicationServer;
import org.opends.server.replication.server.ServerReader;
import org.opends.server.replication.server.ServerWriter;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.DN;
import org.opends.server.types.InitializationException;
import org.opends.server.util.StaticUtils;
import org.opends.server.util.TimeThread;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerHandler
extends MonitorProvider<MonitorProviderCfg> {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private static final int SHUTDOWN_JOIN_TIMEOUT = 30000;
    private short serverId;
    private ProtocolSession session;
    private final MsgQueue msgQueue = new MsgQueue();
    private MsgQueue lateQueue = new MsgQueue();
    private final Map<ChangeNumber, AckMessageList> waitingAcks = new HashMap<ChangeNumber, AckMessageList>();
    private ReplicationCache replicationCache = null;
    private String serverURL;
    private int outCount = 0;
    private int inCount = 0;
    private int inAckCount = 0;
    private int outAckCount = 0;
    private int maxReceiveQueue = 0;
    private int maxSendQueue = 0;
    private int maxReceiveDelay = 0;
    private int maxSendDelay = 0;
    private int maxQueueSize = 10000;
    private int restartReceiveQueue;
    private int restartSendQueue;
    private int restartReceiveDelay;
    private int restartSendDelay;
    private boolean serverIsLDAPserver;
    private boolean following = false;
    private ServerState serverState;
    private boolean active = true;
    private ServerWriter writer = null;
    private DN baseDn = null;
    private String serverAddressURL;
    private int rcvWindow;
    private int rcvWindowSizeHalf;
    private int maxRcvWindow;
    private ServerReader reader;
    private Semaphore sendWindow;
    private int sendWindowSize;
    private boolean flowControl = false;
    private int saturationCount = 0;
    private short replicationServerId;
    private short protocolVersion;
    private List<String> remoteLDAPservers = new ArrayList<String>();
    private long heartbeatInterval = 0L;
    HeartbeatThread heartbeatThread = null;
    private static final Map<ChangeNumber, ReplServerAckMessageList> changelogsWaitingAcks = new HashMap<ChangeNumber, ReplServerAckMessageList>();

    public ServerHandler(ProtocolSession session, int queueSize) {
        super("Server Handler");
        this.session = session;
        this.maxQueueSize = queueSize;
        this.protocolVersion = ProtocolVersion.currentVersion();
    }

    public void start(DN baseDn, short replicationServerId, String replicationServerURL, int windowSize, ReplicationServer replicationServer) {
        this.replicationServerId = replicationServerId;
        this.rcvWindowSizeHalf = windowSize / 2;
        this.maxRcvWindow = windowSize;
        this.rcvWindow = windowSize;
        try {
            StartMessage receivedMsg;
            ReplicationMessage msg;
            if (baseDn != null) {
                this.baseDn = baseDn;
                this.replicationCache = replicationServer.getReplicationCache(baseDn);
                ServerState localServerState = this.replicationCache.getDbServerState();
                ReplServerStartMessage msg2 = new ReplServerStartMessage(replicationServerId, replicationServerURL, baseDn, windowSize, localServerState, this.protocolVersion);
                this.session.publish(msg2);
            }
            if ((msg = this.session.receive()) instanceof ServerStartMessage) {
                receivedMsg = (ServerStartMessage)msg;
                this.protocolVersion = ProtocolVersion.minWithCurrent(receivedMsg.getVersion());
                this.serverId = ((ServerStartMessage)receivedMsg).getServerId();
                this.serverURL = ((ServerStartMessage)receivedMsg).getServerURL();
                this.baseDn = ((ServerStartMessage)receivedMsg).getBaseDn();
                this.serverState = ((ServerStartMessage)receivedMsg).getServerState();
                this.maxReceiveDelay = ((ServerStartMessage)receivedMsg).getMaxReceiveDelay();
                this.maxReceiveQueue = ((ServerStartMessage)receivedMsg).getMaxReceiveQueue();
                this.maxSendDelay = ((ServerStartMessage)receivedMsg).getMaxSendDelay();
                this.maxSendQueue = ((ServerStartMessage)receivedMsg).getMaxSendQueue();
                this.heartbeatInterval = ((ServerStartMessage)receivedMsg).getHeartbeatInterval();
                this.restartReceiveQueue = this.maxReceiveQueue > 0 ? (this.maxReceiveQueue > 1000 ? this.maxReceiveQueue - 200 : this.maxReceiveQueue * 8 / 10) : 0;
                this.restartSendQueue = this.maxSendQueue > 0 ? (this.maxSendQueue > 1000 ? this.maxSendQueue - 200 : this.maxSendQueue * 8 / 10) : 0;
                this.restartReceiveDelay = this.maxReceiveDelay > 0 ? (this.maxReceiveDelay > 10 ? this.maxReceiveDelay - 1 : this.maxReceiveDelay) : 0;
                this.restartSendDelay = this.maxSendDelay > 0 ? (this.maxSendDelay > 10 ? this.maxSendDelay - 1 : this.maxSendDelay) : 0;
                if (this.heartbeatInterval < 0L) {
                    this.heartbeatInterval = 0L;
                }
                this.serverIsLDAPserver = true;
                this.replicationCache = replicationServer.getReplicationCache(this.baseDn);
                ServerState localServerState = this.replicationCache.getDbServerState();
                ReplServerStartMessage myStartMsg = new ReplServerStartMessage(replicationServerId, replicationServerURL, this.baseDn, windowSize, localServerState, this.protocolVersion);
                this.session.publish(myStartMsg);
                this.sendWindowSize = ((ServerStartMessage)receivedMsg).getWindowSize();
            } else if (msg instanceof ReplServerStartMessage) {
                receivedMsg = (ReplServerStartMessage)msg;
                this.protocolVersion = ProtocolVersion.minWithCurrent(receivedMsg.getVersion());
                this.serverId = ((ReplServerStartMessage)receivedMsg).getServerId();
                this.serverURL = ((ReplServerStartMessage)receivedMsg).getServerURL();
                int separator = this.serverURL.lastIndexOf(58);
                this.serverAddressURL = this.session.getRemoteAddress() + ":" + this.serverURL.substring(separator + 1);
                this.serverIsLDAPserver = false;
                this.baseDn = ((ReplServerStartMessage)receivedMsg).getBaseDn();
                if (baseDn == null) {
                    this.replicationCache = replicationServer.getReplicationCache(this.baseDn);
                    ServerState serverState = this.replicationCache.getDbServerState();
                    ReplServerStartMessage outMsg = new ReplServerStartMessage(replicationServerId, replicationServerURL, this.baseDn, windowSize, serverState, this.protocolVersion);
                    this.session.publish(outMsg);
                } else {
                    this.baseDn = baseDn;
                }
                this.serverState = ((ReplServerStartMessage)receivedMsg).getServerState();
                this.sendWindowSize = ((ReplServerStartMessage)receivedMsg).getWindowSize();
            } else {
                return;
            }
            this.replicationCache = replicationServer.getReplicationCache(this.baseDn);
            boolean started = this.serverIsLDAPserver ? this.replicationCache.startServer(this) : this.replicationCache.startReplicationServer(this);
            if (started) {
                this.writer = new ServerWriter(this.session, this.serverId, this, this.replicationCache);
                this.reader = new ServerReader(this.session, this.serverId, this, this.replicationCache);
                this.reader.start();
                this.writer.start();
                if (this.heartbeatInterval > 0L) {
                    this.heartbeatThread = new HeartbeatThread("replication Heartbeat", this.session, this.heartbeatInterval);
                    this.heartbeatThread.start();
                }
                DirectoryServer.deregisterMonitorProvider(this.getMonitorInstanceName());
                DirectoryServer.registerMonitorProvider(this);
            } else {
                try {
                    this.session.close();
                }
                catch (IOException e1) {}
            }
        }
        catch (Exception e) {
            MessageBuilder mb = new MessageBuilder();
            mb.append(ReplicationMessages.ERR_CHANGELOG_CONNECTION_ERROR.get(this.toString()));
            mb.append(StaticUtils.stackTraceToSingleLineString(e));
            ErrorLogger.logError(mb.toMessage());
            try {
                this.session.close();
            }
            catch (IOException e1) {
                // empty catch block
            }
        }
        this.sendWindow = new Semaphore(this.sendWindowSize);
    }

    public short getServerId() {
        return this.serverId;
    }

    public String getServerAddressURL() {
        return this.serverAddressURL;
    }

    public String getServerURL() {
        return this.serverURL;
    }

    public void incrementOutCount() {
        ++this.outCount;
    }

    public void incrementInCount() {
        ++this.inCount;
    }

    public int getInCount() {
        return this.inCount;
    }

    public int getOutCount() {
        return this.outCount;
    }

    public int getInAckCount() {
        return this.inAckCount;
    }

    public int getOutAckCount() {
        return this.outAckCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSaturated(ChangeNumber changeNumber, ServerHandler sourceHandler) {
        MsgQueue msgQueue = this.msgQueue;
        synchronized (msgQueue) {
            UpdateMessage firstUpdate;
            int size = this.msgQueue.size();
            if (this.maxReceiveQueue > 0 && size >= this.maxReceiveQueue) {
                return true;
            }
            if (sourceHandler.maxSendQueue > 0 && size >= sourceHandler.maxSendQueue) {
                return true;
            }
            if (!this.msgQueue.isEmpty() && (firstUpdate = this.msgQueue.first()) != null) {
                long timeDiff = changeNumber.getTimeSec() - firstUpdate.getChangeNumber().getTimeSec();
                if (this.maxReceiveDelay > 0 && timeDiff >= (long)this.maxReceiveDelay) {
                    return true;
                }
                if (sourceHandler.maxSendDelay > 0 && timeDiff >= (long)sourceHandler.maxSendDelay) {
                    return true;
                }
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean restartAfterSaturation(ServerHandler source) {
        MsgQueue msgQueue = this.msgQueue;
        synchronized (msgQueue) {
            int queueSize = this.msgQueue.size();
            if (this.maxReceiveQueue > 0 && queueSize >= this.restartReceiveQueue) {
                return false;
            }
            if (source != null && source.maxSendQueue > 0 && queueSize >= source.restartSendQueue) {
                return false;
            }
            if (!this.msgQueue.isEmpty()) {
                UpdateMessage firstUpdate = this.msgQueue.first();
                UpdateMessage lastUpdate = this.msgQueue.last();
                if (firstUpdate != null && lastUpdate != null) {
                    long timeDiff = lastUpdate.getChangeNumber().getTimeSec() - firstUpdate.getChangeNumber().getTimeSec();
                    if (this.maxReceiveDelay > 0 && timeDiff >= (long)this.restartReceiveDelay) {
                        return false;
                    }
                    if (source != null && source.maxSendDelay > 0 && timeDiff >= (long)source.restartSendDelay) {
                        return false;
                    }
                }
            }
        }
        return true;
    }

    public boolean isReplicationServer() {
        return !this.serverIsLDAPserver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRcvMsgQueueSize() {
        MsgQueue msgQueue = this.msgQueue;
        synchronized (msgQueue) {
            if (this.isFollowing()) {
                return this.msgQueue.size();
            }
            int totalCount = 0;
            ServerState dbState = this.replicationCache.getDbServerState();
            for (short id : dbState) {
                int max = dbState.getMaxChangeNumber(id).getSeqnum();
                ChangeNumber currentChange = this.serverState.getMaxChangeNumber(id);
                if (currentChange != null) {
                    int current = currentChange.getSeqnum();
                    if (current == max) continue;
                    if (current < max) {
                        totalCount += max - current;
                        continue;
                    }
                    totalCount += Integer.MAX_VALUE - (current - max) + 1;
                    continue;
                }
                totalCount += max;
            }
            return totalCount;
        }
    }

    public long getApproxDelay() {
        long olderUpdateTime = this.getOlderUpdateTime();
        if (olderUpdateTime == 0L) {
            return 0L;
        }
        long currentTime = TimeThread.getTime();
        return (currentTime - olderUpdateTime) / 1000L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getOlderUpdateTime() {
        MsgQueue msgQueue = this.msgQueue;
        synchronized (msgQueue) {
            if (this.isFollowing()) {
                if (this.msgQueue.isEmpty()) {
                    return 0L;
                }
                UpdateMessage msg = this.msgQueue.first();
                return msg.getChangeNumber().getTime();
            }
            if (this.lateQueue.isEmpty()) {
                return 0L;
            }
            UpdateMessage msg = this.lateQueue.first();
            return msg.getChangeNumber().getTime();
        }
    }

    public boolean isFollowing() {
        return this.following;
    }

    public void setFollowing(boolean following) {
        this.following = following;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(UpdateMessage update, ServerHandler sourceHandler) {
        MsgQueue msgQueue = this.msgQueue;
        synchronized (msgQueue) {
            if (this.msgQueue.isEmpty()) {
                this.msgQueue.notify();
            }
            this.msgQueue.add(update);
            while (this.msgQueue.size() > this.maxQueueSize) {
                this.following = false;
                this.msgQueue.removeFirst();
            }
        }
        if (this.isSaturated(update.getChangeNumber(), sourceHandler)) {
            sourceHandler.setSaturated(true);
        }
    }

    private void setSaturated(boolean value) {
        this.flowControl = value;
    }

    public UpdateMessage take() {
        boolean interrupted = true;
        UpdateMessage msg = this.getnextMessage();
        if (++this.saturationCount > 10) {
            this.saturationCount = 0;
            try {
                this.replicationCache.checkAllSaturation();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        do {
            try {
                this.sendWindow.acquire();
                interrupted = false;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        } while (interrupted);
        this.incrementOutCount();
        return msg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UpdateMessage getnextMessage() {
        while (this.active) {
            UpdateMessage msg;
            if (!this.following) {
                if (this.lateQueue.isEmpty()) {
                    MsgQueue msgQueue;
                    ReplicationIteratorComparator comparator = new ReplicationIteratorComparator();
                    TreeSet<ReplicationIterator> iteratorSortedSet = new TreeSet<ReplicationIterator>(comparator);
                    for (short serverId : this.replicationCache.getServers()) {
                        ChangeNumber lastCsn;
                        ReplicationIterator iterator = this.replicationCache.getChangelogIterator(serverId, lastCsn = this.serverState.getMaxChangeNumber(serverId));
                        if (iterator == null || iterator.getChange() == null) continue;
                        iteratorSortedSet.add(iterator);
                    }
                    while (!iteratorSortedSet.isEmpty() && this.lateQueue.size() < 100) {
                        ReplicationIterator iterator = (ReplicationIterator)iteratorSortedSet.first();
                        iteratorSortedSet.remove(iterator);
                        this.lateQueue.add(iterator.getChange());
                        if (iterator.next()) {
                            iteratorSortedSet.add(iterator);
                            continue;
                        }
                        iterator.releaseCursor();
                    }
                    for (ReplicationIterator iterator : iteratorSortedSet) {
                        iterator.releaseCursor();
                    }
                    if (this.lateQueue.isEmpty()) {
                        msgQueue = this.msgQueue;
                        synchronized (msgQueue) {
                            if (this.msgQueue.size() < this.maxQueueSize) {
                                this.following = true;
                            }
                        }
                    } else {
                        msg = this.lateQueue.first();
                        msgQueue = this.msgQueue;
                        synchronized (msgQueue) {
                            if (this.msgQueue.contains(msg)) {
                                UpdateMessage msg1;
                                this.following = true;
                                this.lateQueue.clear();
                                do {
                                    msg1 = this.msgQueue.removeFirst();
                                } while (!msg.getChangeNumber().equals(msg1.getChangeNumber()));
                                this.updateServerState(msg);
                                return msg;
                            }
                        }
                    }
                } else {
                    msg = this.lateQueue.removeFirst();
                    this.updateServerState(msg);
                    return msg;
                }
            }
            MsgQueue msgQueue = this.msgQueue;
            synchronized (msgQueue) {
                if (this.following) {
                    try {
                        while (this.msgQueue.isEmpty()) {
                            this.msgQueue.wait(500L);
                            if (this.active) continue;
                            return null;
                        }
                    }
                    catch (InterruptedException e) {
                        return null;
                    }
                    msg = this.msgQueue.removeFirst();
                    if (this.updateServerState(msg)) {
                        return msg;
                    }
                }
            }
        }
        return null;
    }

    public boolean updateServerState(UpdateMessage msg) {
        return this.serverState.update(msg.getChangeNumber());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopHandler() {
        this.active = false;
        try {
            this.session.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        MsgQueue msgQueue = this.msgQueue;
        synchronized (msgQueue) {
            this.msgQueue.clear();
            this.msgQueue.notify();
            this.msgQueue.notifyAll();
        }
        if (this.heartbeatThread != null) {
            this.heartbeatThread.shutdown();
        }
        DirectoryServer.deregisterMonitorProvider(this.getMonitorInstanceName());
    }

    public void sendAck(ChangeNumber changeNumber) throws IOException {
        AckMessage ack = new AckMessage(changeNumber);
        this.session.publish(ack);
        ++this.outAckCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ack(AckMessage message, short ackingServerId) {
        boolean completedFlag;
        ChangeNumber changeNumber = message.getChangeNumber();
        Map<ChangeNumber, AckMessageList> map = this.waitingAcks;
        synchronized (map) {
            AckMessageList ackList = this.waitingAcks.get(changeNumber);
            if (ackList == null) {
                return;
            }
            ackList.addAck(ackingServerId);
            completedFlag = ackList.completed();
            if (completedFlag) {
                this.waitingAcks.remove(changeNumber);
            }
        }
        if (completedFlag) {
            this.replicationCache.sendAck(changeNumber, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void ackChangelog(AckMessage message, short ackingServerId) {
        boolean completedFlag;
        ReplServerAckMessageList ackList;
        ChangeNumber changeNumber = message.getChangeNumber();
        Map<ChangeNumber, ReplServerAckMessageList> map = changelogsWaitingAcks;
        synchronized (map) {
            ackList = changelogsWaitingAcks.get(changeNumber);
            if (ackList == null) {
                return;
            }
            ackList.addAck(ackingServerId);
            completedFlag = ackList.completed();
            if (completedFlag) {
                changelogsWaitingAcks.remove(changeNumber);
            }
        }
        if (completedFlag) {
            ReplicationCache replicationCache = ackList.getChangelogCache();
            replicationCache.sendAck(changeNumber, false, ackList.getReplicationServerId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addWaitingAck(UpdateMessage update, int nbWaitedAck) {
        AckMessageList ackList = new AckMessageList(update.getChangeNumber(), nbWaitedAck);
        Map<ChangeNumber, AckMessageList> map = this.waitingAcks;
        synchronized (map) {
            this.waitingAcks.put(update.getChangeNumber(), ackList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addWaitingAck(UpdateMessage update, short ChangelogServerId, ReplicationCache replicationCache, int nbWaitedAck) {
        ReplServerAckMessageList ackList = new ReplServerAckMessageList(update.getChangeNumber(), nbWaitedAck, ChangelogServerId, replicationCache);
        Map<ChangeNumber, ReplServerAckMessageList> map = changelogsWaitingAcks;
        synchronized (map) {
            changelogsWaitingAcks.put(update.getChangeNumber(), ackList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getWaitingAckSize() {
        Map<ChangeNumber, AckMessageList> map = this.waitingAcks;
        synchronized (map) {
            return this.waitingAcks.size();
        }
    }

    public void incrementInAckCount() {
        ++this.inAckCount;
    }

    public boolean isLDAPserver() {
        return this.serverIsLDAPserver;
    }

    @Override
    public void initializeMonitorProvider(MonitorProviderCfg configuration) throws ConfigException, InitializationException {
    }

    @Override
    public String getMonitorInstanceName() {
        String str = this.baseDn.toString() + " " + this.serverURL + " " + String.valueOf(this.serverId);
        if (this.serverIsLDAPserver) {
            return "Remote LDAP Server " + str;
        }
        return "Remote Replication Server " + str;
    }

    @Override
    public long getUpdateInterval() {
        return 0L;
    }

    @Override
    public void updateMonitorData() {
    }

    public ArrayList<Attribute> getMonitorData() {
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        if (this.serverIsLDAPserver) {
            attributes.add(new Attribute("LDAP-Server", this.serverURL));
        } else {
            attributes.add(new Attribute("ReplicationServer-Server", this.serverURL));
        }
        attributes.add(new Attribute("server-id", String.valueOf(this.serverId)));
        attributes.add(new Attribute("base-dn", this.baseDn.toString()));
        attributes.add(new Attribute("waiting-changes", String.valueOf(this.getRcvMsgQueueSize())));
        attributes.add(new Attribute("max-waiting-changes", String.valueOf(this.maxQueueSize)));
        attributes.add(new Attribute("update-waiting-acks", String.valueOf(this.getWaitingAckSize())));
        attributes.add(new Attribute("update-sent", String.valueOf(this.getOutCount())));
        attributes.add(new Attribute("update-received", String.valueOf(this.getInCount())));
        attributes.add(new Attribute("ack-sent", String.valueOf(this.getOutAckCount())));
        attributes.add(new Attribute("ack-received", String.valueOf(this.getInAckCount())));
        attributes.add(new Attribute("approximate-delay", String.valueOf(this.getApproxDelay())));
        attributes.add(new Attribute("max-send-window", String.valueOf(this.sendWindowSize)));
        attributes.add(new Attribute("current-send-window", String.valueOf(this.sendWindow.availablePermits())));
        attributes.add(new Attribute("max-rcv-window", String.valueOf(this.maxRcvWindow)));
        attributes.add(new Attribute("current-rcv-window", String.valueOf(this.rcvWindow)));
        long olderUpdateTime = this.getOlderUpdateTime();
        if (olderUpdateTime != 0L) {
            Date date = new Date(this.getOlderUpdateTime());
            attributes.add(new Attribute("older-change-not-synchronized", String.valueOf(date.toString())));
        }
        String ATTR_SERVER_STATE = "server-state";
        AttributeType type = DirectoryServer.getDefaultAttributeType("server-state");
        LinkedHashSet<AttributeValue> values = new LinkedHashSet<AttributeValue>();
        for (String str : this.serverState.toStringSet()) {
            values.add(new AttributeValue(type, str));
        }
        Attribute attr = new Attribute(type, "server-state", values);
        attributes.add(attr);
        return attributes;
    }

    public void shutdown() {
        try {
            this.session.close();
        }
        catch (IOException e) {
            // empty catch block
        }
        this.stopHandler();
        try {
            this.writer.join(30000L);
            this.reader.join(30000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public String toString() {
        String localString;
        if (this.serverId != 0) {
            localString = this.serverIsLDAPserver ? "Directory Server " : "Replication Server ";
            localString = localString + this.serverId + " " + this.serverURL + " " + this.baseDn;
        } else {
            localString = "Unknown server";
        }
        return localString;
    }

    public synchronized void decAndCheckWindow() throws IOException {
        --this.rcvWindow;
        this.checkWindow();
    }

    public synchronized void checkWindow() throws IOException {
        if (this.rcvWindow < this.rcvWindowSizeHalf) {
            if (this.flowControl && this.replicationCache.restartAfterSaturation(this)) {
                this.flowControl = false;
            }
            if (!this.flowControl) {
                WindowMessage msg = new WindowMessage(this.rcvWindowSizeHalf);
                this.session.publish(msg);
                ++this.outAckCount;
                this.rcvWindow += this.rcvWindowSizeHalf;
            }
        }
    }

    public void updateWindow(WindowMessage windowMsg) {
        this.sendWindow.release(windowMsg.getNumAck());
    }

    public long getHeartbeatInterval() {
        return this.heartbeatInterval;
    }

    public void process(RoutableMessage msg) {
        if (DebugLogger.debugEnabled()) {
            TRACER.debugInfo("SH(" + this.replicationServerId + ") receives " + msg + " from " + this.serverId);
        }
        this.replicationCache.process(msg, this);
    }

    public void sendInfo(ReplServerInfoMessage info) throws IOException {
        this.session.publish(info);
    }

    public void setReplServerInfo(ReplServerInfoMessage infoMsg) {
        this.remoteLDAPservers = infoMsg.getConnectedServers();
    }

    public boolean isRemoteLDAPServer(short wantedServer) {
        for (String server : this.remoteLDAPservers) {
            if (wantedServer != Short.valueOf(server)) continue;
            return true;
        }
        return false;
    }

    public List<String> getRemoteLDAPServers() {
        return this.remoteLDAPservers;
    }

    public void send(RoutableMessage msg) throws IOException {
        if (DebugLogger.debugEnabled()) {
            TRACER.debugInfo("SH(" + this.replicationServerId + ") forwards " + msg + " to " + this.serverId);
        }
        this.session.publish(msg);
    }

    public void process(WindowProbe windowProbeMsg) throws IOException {
        if (this.rcvWindow > 0) {
            WindowMessage msg = new WindowMessage(this.rcvWindow);
            this.session.publish(msg);
            ++this.outAckCount;
        } else {
            this.checkWindow();
        }
    }
}

