/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.replication.server;

import com.sleepycat.je.DatabaseException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.opends.messages.Message;
import org.opends.messages.MessageBuilder;
import org.opends.messages.ReplicationMessages;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.replication.common.ChangeNumber;
import org.opends.server.replication.common.ServerState;
import org.opends.server.replication.protocol.AckMessage;
import org.opends.server.replication.protocol.ErrorMessage;
import org.opends.server.replication.protocol.ReplServerInfoMessage;
import org.opends.server.replication.protocol.RoutableMessage;
import org.opends.server.replication.protocol.UpdateMessage;
import org.opends.server.replication.server.DbHandler;
import org.opends.server.replication.server.ReplicationIterator;
import org.opends.server.replication.server.ReplicationServer;
import org.opends.server.replication.server.ServerHandler;
import org.opends.server.types.DN;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReplicationCache {
    private Object flowControlLock = new Object();
    private DN baseDn = null;
    private Map<Short, ServerHandler> connectedServers = new ConcurrentHashMap<Short, ServerHandler>();
    private Map<Short, ServerHandler> replicationServers = new ConcurrentHashMap<Short, ServerHandler>();
    private Map<Short, DbHandler> sourceDbHandlers = new ConcurrentHashMap<Short, DbHandler>();
    private ReplicationServer replicationServer;

    public ReplicationCache(DN baseDn, ReplicationServer replicationServer) {
        this.baseDn = baseDn;
        this.replicationServer = replicationServer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(UpdateMessage update, ServerHandler sourceHandler) throws IOException {
        sourceHandler.updateServerState(update);
        sourceHandler.incrementInCount();
        if (update.isAssured()) {
            int count = this.NumServers();
            if (count > 1) {
                if (sourceHandler.isReplicationServer()) {
                    ServerHandler.addWaitingAck(update, sourceHandler.getServerId(), this, count - 1);
                } else {
                    sourceHandler.addWaitingAck(update, count - 1);
                }
            } else {
                sourceHandler.sendAck(update.getChangeNumber());
            }
        }
        DbHandler dbHandler = null;
        Map<Short, DbHandler> map = this.sourceDbHandlers;
        synchronized (map) {
            short id = update.getChangeNumber().getServerId();
            dbHandler = this.sourceDbHandlers.get(id);
            if (dbHandler == null) {
                try {
                    dbHandler = this.replicationServer.newDbHandler(id, this.baseDn);
                }
                catch (DatabaseException e) {
                    MessageBuilder mb = new MessageBuilder();
                    mb.append(ReplicationMessages.ERR_CHANGELOG_SHUTDOWN_DATABASE_ERROR.get());
                    mb.append(StaticUtils.stackTraceToSingleLineString(e));
                    ErrorLogger.logError(mb.toMessage());
                    this.replicationServer.shutdown();
                    return;
                }
                this.sourceDbHandlers.put(id, dbHandler);
            }
        }
        dbHandler.add(update);
        if (!sourceHandler.isReplicationServer()) {
            for (ServerHandler handler : this.replicationServers.values()) {
                handler.add(update, sourceHandler);
            }
        }
        for (ServerHandler handler : this.connectedServers.values()) {
            if (handler == sourceHandler) continue;
            handler.add(update, sourceHandler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean startServer(ServerHandler handler) throws Exception {
        Map<Short, ServerHandler> map = this.connectedServers;
        synchronized (map) {
            ServerHandler oldHandler = this.connectedServers.get(handler.getServerId());
            if (this.connectedServers.containsKey(handler.getServerId())) {
                Message message = ReplicationMessages.ERR_DUPLICATE_SERVER_ID.get(oldHandler.toString(), handler.toString(), handler.getServerId());
                ErrorLogger.logError(message);
                return false;
            }
            this.connectedServers.put(handler.getServerId(), handler);
            this.sendReplServerInfo();
            return true;
        }
    }

    public void stopServer(ServerHandler handler) {
        handler.stopHandler();
        if (handler.isReplicationServer()) {
            this.replicationServers.remove(handler.getServerId());
        } else {
            this.connectedServers.remove(handler.getServerId());
            this.sendReplServerInfo();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean startReplicationServer(ServerHandler handler) throws Exception {
        Map<Short, ServerHandler> map = this.replicationServers;
        synchronized (map) {
            ServerHandler oldHandler = this.replicationServers.get(handler.getServerId());
            if (oldHandler != null) {
                if (!oldHandler.getServerAddressURL().equals(handler.getServerAddressURL())) {
                    Message message = ReplicationMessages.ERR_DUPLICATE_REPLICATION_SERVER_ID.get(oldHandler.getServerAddressURL(), handler.getServerAddressURL(), handler.getServerId());
                    ErrorLogger.logError(message);
                }
                return false;
            }
            this.replicationServers.put(handler.getServerId(), handler);
            handler.sendInfo(new ReplServerInfoMessage(this.getConnectedLDAPservers()));
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UpdateMessage take(ServerHandler handler) {
        UpdateMessage msg = handler.take();
        Object object = this.flowControlLock;
        synchronized (object) {
            if (handler.restartAfterSaturation(null)) {
                this.flowControlLock.notifyAll();
            }
        }
        return msg;
    }

    public Set<String> getChangelogs() {
        LinkedHashSet<String> mySet = new LinkedHashSet<String>();
        for (ServerHandler handler : this.replicationServers.values()) {
            mySet.add(handler.getServerAddressURL());
        }
        return mySet;
    }

    public Set<Short> getServers() {
        return this.sourceDbHandlers.keySet();
    }

    public List<String> getConnectedLDAPservers() {
        ArrayList<String> mySet = new ArrayList<String>(0);
        for (ServerHandler handler : this.connectedServers.values()) {
            mySet.add(String.valueOf(handler.getServerId()));
        }
        return mySet;
    }

    public ReplicationIterator getChangelogIterator(short serverId, ChangeNumber changeNumber) {
        DbHandler handler = this.sourceDbHandlers.get(serverId);
        if (handler == null) {
            return null;
        }
        try {
            return handler.generateIterator(changeNumber);
        }
        catch (Exception e) {
            return null;
        }
    }

    public DN getBaseDn() {
        return this.baseDn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void newDb(short id, DbHandler db) throws DatabaseException {
        Map<Short, DbHandler> map = this.sourceDbHandlers;
        synchronized (map) {
            this.sourceDbHandlers.put(id, db);
        }
    }

    private int NumServers() {
        return this.replicationServers.size() + this.connectedServers.size();
    }

    public void ack(AckMessage message, short fromServerId) {
        ServerHandler handler = this.connectedServers.get(message.getChangeNumber().getServerId());
        if (handler != null) {
            handler.ack(message, fromServerId);
        } else {
            ServerHandler.ackChangelog(message, fromServerId);
        }
    }

    protected List<ServerHandler> getDestinationServers(RoutableMessage msg, ServerHandler senderHandler) {
        ArrayList<ServerHandler> servers;
        block4: {
            block6: {
                block5: {
                    servers = new ArrayList<ServerHandler>();
                    if (msg.getDestination() == -3) break block4;
                    if (msg.getDestination() != -2) break block5;
                    if (!senderHandler.isReplicationServer()) {
                        for (ServerHandler destinationHandler : this.replicationServers.values()) {
                            servers.add(destinationHandler);
                        }
                    }
                    for (ServerHandler destinationHandler : this.connectedServers.values()) {
                        if (destinationHandler == senderHandler) continue;
                        servers.add(destinationHandler);
                    }
                    break block4;
                }
                ServerHandler destinationHandler = this.connectedServers.get(msg.getDestination());
                if (destinationHandler == null) break block6;
                servers.add(destinationHandler);
                break block4;
            }
            if (!senderHandler.isLDAPserver()) break block4;
            for (ServerHandler h : this.replicationServers.values()) {
                if (!h.isRemoteLDAPServer(msg.getDestination())) continue;
                servers.add(h);
            }
        }
        return servers;
    }

    public void process(RoutableMessage msg, ServerHandler senderHandler) {
        List<ServerHandler> servers = this.getDestinationServers(msg, senderHandler);
        if (servers.isEmpty()) {
            MessageBuilder mb = new MessageBuilder();
            mb.append(ReplicationMessages.ERR_NO_REACHABLE_PEER_IN_THE_DOMAIN.get());
            mb.append("serverID:" + msg.getDestination());
            ErrorMessage errMsg = new ErrorMessage(msg.getsenderID(), mb.toMessage());
            try {
                senderHandler.send(errMsg);
            }
            catch (IOException ioe) {
                MessageBuilder mb2 = new MessageBuilder();
                mb2.append(ReplicationMessages.ERR_CHANGELOG_ERROR_SENDING_ERROR.get(this.toString()));
                mb2.append(StaticUtils.stackTraceToSingleLineString(ioe));
                ErrorLogger.logError(mb2.toMessage());
                senderHandler.shutdown();
            }
        } else {
            for (ServerHandler targetHandler : servers) {
                try {
                    targetHandler.send(msg);
                }
                catch (IOException ioe) {
                    MessageBuilder mb = new MessageBuilder();
                    mb.append(ReplicationMessages.ERR_CHANGELOG_ERROR_SENDING_MSG.get(this.toString()));
                    mb.append(StaticUtils.stackTraceToSingleLineString(ioe));
                    mb.append(" ");
                    mb.append(msg.getClass().getCanonicalName());
                    ErrorLogger.logError(mb.toMessage());
                    senderHandler.shutdown();
                }
            }
        }
    }

    public void sendAck(ChangeNumber changeNumber, boolean isLDAPserver) {
        short serverId = changeNumber.getServerId();
        this.sendAck(changeNumber, isLDAPserver, serverId);
    }

    public void sendAck(ChangeNumber changeNumber, boolean isLDAPserver, short serverId) {
        ServerHandler handler = isLDAPserver ? this.connectedServers.get(serverId) : this.replicationServers.get(serverId);
        try {
            handler.sendAck(changeNumber);
        }
        catch (IOException e) {
            MessageBuilder mb = new MessageBuilder();
            mb.append(ReplicationMessages.ERR_CHANGELOG_ERROR_SENDING_ACK.get(this.toString()));
            mb.append(StaticUtils.stackTraceToSingleLineString(e));
            ErrorLogger.logError(mb.toMessage());
            handler.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        for (ServerHandler serverHandler : this.replicationServers.values()) {
            serverHandler.shutdown();
        }
        for (ServerHandler serverHandler : this.connectedServers.values()) {
            serverHandler.shutdown();
        }
        Map<Short, DbHandler> map = this.sourceDbHandlers;
        synchronized (map) {
            for (DbHandler dbHandler : this.sourceDbHandlers.values()) {
                dbHandler.shutdown();
            }
            this.sourceDbHandlers.clear();
        }
    }

    public ServerState getDbServerState() {
        ServerState serverState = new ServerState();
        for (DbHandler db : this.sourceDbHandlers.values()) {
            serverState.update(db.getLastChange());
        }
        return serverState;
    }

    public String toString() {
        return "ReplicationCache " + this.baseDn;
    }

    public void checkAllSaturation() throws IOException {
        for (ServerHandler handler : this.replicationServers.values()) {
            handler.checkWindow();
        }
        for (ServerHandler handler : this.connectedServers.values()) {
            handler.checkWindow();
        }
    }

    public boolean restartAfterSaturation(ServerHandler sourceHandler) {
        for (ServerHandler handler : this.replicationServers.values()) {
            if (handler.restartAfterSaturation(sourceHandler)) continue;
            return false;
        }
        for (ServerHandler handler : this.connectedServers.values()) {
            if (handler.restartAfterSaturation(sourceHandler)) continue;
            return false;
        }
        return true;
    }

    private void sendReplServerInfo() {
        ReplServerInfoMessage info = new ReplServerInfoMessage(this.getConnectedLDAPservers());
        for (ServerHandler handler : this.replicationServers.values()) {
            try {
                handler.sendInfo(info);
            }
            catch (IOException e) {
                MessageBuilder mb = new MessageBuilder();
                mb.append(ReplicationMessages.ERR_CHANGELOG_ERROR_SENDING_INFO.get(this.toString()));
                mb.append(StaticUtils.stackTraceToSingleLineString(e));
                ErrorLogger.logError(mb.toMessage());
                handler.shutdown();
            }
        }
    }

    public void setReplServerInfo(ServerHandler handler, ReplServerInfoMessage infoMsg) {
        handler.setReplServerInfo(infoMsg);
    }
}

