/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.replication.protocol;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.DataFormatException;
import org.opends.server.api.ClientConnection;
import org.opends.server.core.ModifyOperationBasis;
import org.opends.server.protocols.asn1.ASN1Element;
import org.opends.server.protocols.asn1.ASN1Exception;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.protocols.internal.InternalClientConnection;
import org.opends.server.protocols.ldap.LDAPAttribute;
import org.opends.server.protocols.ldap.LDAPModification;
import org.opends.server.replication.common.ChangeNumber;
import org.opends.server.replication.plugin.Historical;
import org.opends.server.replication.protocol.ModifyContext;
import org.opends.server.replication.protocol.OperationContext;
import org.opends.server.replication.protocol.UpdateMessage;
import org.opends.server.types.AbstractOperation;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AttributeUsage;
import org.opends.server.types.DN;
import org.opends.server.types.LDAPException;
import org.opends.server.types.Modification;
import org.opends.server.types.RawModification;
import org.opends.server.types.operation.PostOperationModifyOperation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModifyMsg
extends UpdateMessage {
    private static final long serialVersionUID = -4905520652801395185L;
    private byte[] encodedMods = null;
    private byte[] encodedMsg = null;

    public ModifyMsg(PostOperationModifyOperation op) {
        super((OperationContext)op.getAttachment("replicationContext"), op.getRawEntryDN().stringValue());
        this.encodedMods = this.modsToByte(op.getModifications());
    }

    public ModifyMsg(ChangeNumber changeNumber, DN dn, List<Modification> mods, String entryuuid) {
        super(new ModifyContext(changeNumber, entryuuid), dn.toNormalizedString());
        this.encodedMods = this.modsToByte(mods);
    }

    public ModifyMsg(byte[] in) throws DataFormatException, UnsupportedEncodingException {
        super(in);
        this.encodedMsg = in;
    }

    @Override
    public byte[] getBytes() throws UnsupportedEncodingException {
        if (this.encodedMsg == null) {
            this.encode();
        }
        return this.encodedMsg;
    }

    @Override
    public AbstractOperation createOperation(InternalClientConnection connection, String newDn) throws LDAPException, ASN1Exception, DataFormatException {
        if (this.encodedMods == null) {
            this.decode();
        }
        if (newDn == null) {
            newDn = this.getDn();
        }
        ArrayList<ASN1Element> mods = null;
        mods = ASN1Element.decodeElements(this.encodedMods);
        ArrayList<RawModification> ldapmods = new ArrayList<RawModification>(mods.size());
        for (ASN1Element elem : mods) {
            ldapmods.add(LDAPModification.decode(elem));
        }
        ModifyOperationBasis mod = new ModifyOperationBasis((ClientConnection)connection, InternalClientConnection.nextOperationID(), InternalClientConnection.nextMessageID(), null, new ASN1OctetString(newDn), ldapmods);
        ModifyContext ctx = new ModifyContext(this.getChangeNumber(), this.getUniqueId());
        mod.setAttachment("replicationContext", ctx);
        return mod;
    }

    private void encode() throws UnsupportedEncodingException {
        this.encodedMsg = this.encodeHeader((byte)1, this.encodedMods.length + 1);
        int pos = this.encodedMsg.length - (this.encodedMods.length + 1);
        pos = this.addByteArray(this.encodedMods, this.encodedMsg, pos);
    }

    private void decode() throws DataFormatException {
        int pos = this.decodeHeader((byte)1, this.encodedMsg);
        this.encodedMods = new byte[this.encodedMsg.length - pos - 1];
        int i = 0;
        while (pos < this.encodedMsg.length - 1) {
            this.encodedMods[i++] = this.encodedMsg[pos++];
        }
    }

    private byte[] modsToByte(List<Modification> mods) {
        ArrayList<ASN1Element> modsASN1 = new ArrayList<ASN1Element>(mods.size());
        for (Modification mod : mods) {
            Attribute attr = mod.getAttribute();
            AttributeType type = attr.getAttributeType();
            if (type != null && AttributeUsage.DSA_OPERATION.equals((Object)type.getUsage()) || attr.getAttributeType().equals(Historical.historicalAttrType)) continue;
            LDAPModification ldapmod = new LDAPModification(mod.getModificationType(), new LDAPAttribute(mod.getAttribute()));
            modsASN1.add(ldapmod.encode());
        }
        return ASN1Element.encodeValue(modsASN1);
    }

    public String toString() {
        return "Modify " + this.getDn() + " " + this.getChangeNumber();
    }
}

