/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.replication.plugin;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import org.opends.messages.Message;
import org.opends.messages.ReplicationMessages;
import org.opends.server.api.ClientConnection;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.ModifyOperationBasis;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.protocols.internal.InternalClientConnection;
import org.opends.server.protocols.internal.InternalSearchOperation;
import org.opends.server.protocols.ldap.LDAPAttribute;
import org.opends.server.protocols.ldap.LDAPFilter;
import org.opends.server.protocols.ldap.LDAPModification;
import org.opends.server.replication.common.ChangeNumber;
import org.opends.server.replication.common.ServerState;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.Control;
import org.opends.server.types.DN;
import org.opends.server.types.DereferencePolicy;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.LDAPException;
import org.opends.server.types.ModificationType;
import org.opends.server.types.RawModification;
import org.opends.server.types.ResultCode;
import org.opends.server.types.SearchFilter;
import org.opends.server.types.SearchResultEntry;
import org.opends.server.types.SearchScope;

public class PersistentServerState
extends ServerState {
    private DN baseDn;
    private boolean savedStatus = true;
    private InternalClientConnection conn = InternalClientConnection.getRootConnection();
    private ASN1OctetString asn1BaseDn;
    protected static final String REPLICATION_STATE = "ds-sync-state";

    public PersistentServerState(DN baseDn) {
        this.baseDn = baseDn;
        this.asn1BaseDn = new ASN1OctetString(baseDn.toString());
        this.loadState();
    }

    public boolean update(ChangeNumber changeNumber) {
        this.savedStatus = false;
        return super.update(changeNumber);
    }

    public void save() {
        if (this.savedStatus) {
            return;
        }
        this.savedStatus = true;
        ResultCode resultCode = this.updateStateEntry();
        if (resultCode != ResultCode.SUCCESS) {
            this.savedStatus = false;
        }
    }

    public void loadState() {
        SearchResultEntry stateEntry = null;
        stateEntry = this.searchBaseEntry();
        if (stateEntry == null) {
            stateEntry = this.searchConfigEntry();
        }
        if (stateEntry != null) {
            this.updateStateFromEntry(stateEntry);
        }
    }

    private SearchResultEntry searchBaseEntry() {
        LinkedList<SearchResultEntry> result;
        LDAPFilter filter;
        try {
            filter = LDAPFilter.decode("objectclass=*");
        }
        catch (LDAPException e) {
            return null;
        }
        LinkedHashSet<String> attributes = new LinkedHashSet<String>(1);
        attributes.add(REPLICATION_STATE);
        InternalSearchOperation search = this.conn.processSearch(this.asn1BaseDn, SearchScope.BASE_OBJECT, DereferencePolicy.DEREF_ALWAYS, 0, 0, false, filter, attributes);
        if (search.getResultCode() != ResultCode.SUCCESS && search.getResultCode() != ResultCode.NO_SUCH_OBJECT) {
            Message message = ReplicationMessages.ERR_ERROR_SEARCHING_RUV.get(search.getResultCode().getResultCodeName(), search.toString(), search.getErrorMessage(), this.baseDn.toString());
            ErrorLogger.logError(message);
            return null;
        }
        SearchResultEntry stateEntry = null;
        if (search.getResultCode() == ResultCode.SUCCESS && !(result = search.getSearchEntries()).isEmpty()) {
            stateEntry = result.getFirst();
        }
        return stateEntry;
    }

    private SearchResultEntry searchConfigEntry() {
        try {
            LinkedList<SearchResultEntry> resultEntries;
            SearchFilter filter = SearchFilter.createFilterFromString("(&(objectclass=ds-cfg-replication-domain-config)(ds-cfg-replication-dn=" + this.baseDn + "))");
            LinkedHashSet<String> attributes = new LinkedHashSet<String>(1);
            attributes.add(REPLICATION_STATE);
            InternalSearchOperation op = this.conn.processSearch(DN.decode("cn=config"), SearchScope.SUBORDINATE_SUBTREE, DereferencePolicy.NEVER_DEREF_ALIASES, 1, 0, false, filter, attributes);
            if (op.getResultCode() == ResultCode.SUCCESS && !(resultEntries = op.getSearchEntries()).isEmpty()) {
                SearchResultEntry resultEntry = resultEntries.getFirst();
                return resultEntry;
            }
            return null;
        }
        catch (DirectoryException e) {
            return null;
        }
    }

    private void updateStateFromEntry(SearchResultEntry resultEntry) {
        AttributeType synchronizationStateType = DirectoryServer.getAttributeType(REPLICATION_STATE);
        List<Attribute> attrs = resultEntry.getAttribute(synchronizationStateType);
        if (attrs != null) {
            Attribute attr = attrs.get(0);
            LinkedHashSet<AttributeValue> values = attr.getValues();
            for (AttributeValue value : values) {
                ChangeNumber changeNumber = new ChangeNumber(value.getStringValue());
                this.update(changeNumber);
            }
        }
    }

    private ResultCode updateStateEntry() {
        SearchResultEntry configEntry;
        ResultCode result = this.runUpdateStateEntry(this.baseDn);
        if (result == ResultCode.NO_SUCH_OBJECT && (configEntry = this.searchConfigEntry()) != null) {
            DN configDN = configEntry.getDN();
            result = this.runUpdateStateEntry(configDN);
        }
        return result;
    }

    private ResultCode runUpdateStateEntry(DN serverStateEntryDN) {
        ArrayList<ASN1OctetString> values = this.toASN1ArrayList();
        if (values.size() == 0) {
            return ResultCode.SUCCESS;
        }
        LDAPAttribute attr = new LDAPAttribute(REPLICATION_STATE, values);
        LDAPModification mod = new LDAPModification(ModificationType.REPLACE, attr);
        ArrayList<RawModification> mods = new ArrayList<RawModification>(1);
        mods.add(mod);
        ModifyOperationBasis op = new ModifyOperationBasis((ClientConnection)this.conn, InternalClientConnection.nextOperationID(), InternalClientConnection.nextMessageID(), new ArrayList<Control>(0), new ASN1OctetString(serverStateEntryDN.toString()), mods);
        op.setInternalOperation(true);
        op.setSynchronizationOperation(true);
        op.setDontSynchronize(true);
        op.run();
        if (op.getResultCode() != ResultCode.SUCCESS) {
            Message message = ReplicationMessages.DEBUG_ERROR_UPDATING_RUV.get(op.getResultCode().getResultCodeName().toString(), op.toString(), op.getErrorMessage().toString(), this.baseDn.toString());
            ErrorLogger.logError(message);
        }
        return op.getResultCode();
    }
}

