/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.protocols.ldap;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.concurrent.locks.ReentrantLock;
import org.opends.messages.Message;
import org.opends.messages.ProtocolMessages;
import org.opends.server.admin.std.server.MonitorProviderCfg;
import org.opends.server.api.MonitorProvider;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.protocols.ldap.LDAPMessage;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.ByteString;
import org.opends.server.types.DebugLogLevel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LDAPStatistics
extends MonitorProvider<MonitorProviderCfg> {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private long abandonRequests;
    private long addRequests;
    private long addResponses;
    private long bindRequests;
    private long bindResponses;
    private long bytesRead;
    private long bytesWritten;
    private long compareRequests;
    private long compareResponses;
    private long connectionsClosed;
    private long connectionsEstablished;
    private long deleteRequests;
    private long deleteResponses;
    private long extendedRequests;
    private long extendedResponses;
    private long messagesRead;
    private long messagesWritten;
    private long modifyRequests;
    private long modifyResponses;
    private long modifyDNRequests;
    private long modifyDNResponses;
    private long operationsAbandoned;
    private long operationsCompleted;
    private long operationsInitiated;
    private long searchRequests;
    private long searchResultEntries;
    private long searchResultReferences;
    private long searchResultsDone;
    private long unbindRequests;
    private LDAPStatistics parent;
    private ReentrantLock abandonLock;
    private ReentrantLock connectLock;
    private ReentrantLock disconnectLock;
    private ReentrantLock readLock;
    private ReentrantLock writeLock;
    private String instanceName;

    public LDAPStatistics(String instanceName) {
        this(instanceName, null);
        DirectoryServer.registerMonitorProvider(this);
    }

    public LDAPStatistics(String instanceName, LDAPStatistics parent) {
        super("LDAP Statistics Monitor Provider");
        this.instanceName = instanceName;
        this.parent = parent;
        this.abandonLock = new ReentrantLock();
        this.connectLock = new ReentrantLock();
        this.disconnectLock = new ReentrantLock();
        this.readLock = new ReentrantLock();
        this.writeLock = new ReentrantLock();
        this.abandonRequests = 0L;
        this.addRequests = 0L;
        this.addResponses = 0L;
        this.bindRequests = 0L;
        this.bindResponses = 0L;
        this.bytesRead = 0L;
        this.bytesWritten = 0L;
        this.compareRequests = 0L;
        this.compareResponses = 0L;
        this.connectionsClosed = 0L;
        this.connectionsEstablished = 0L;
        this.deleteRequests = 0L;
        this.deleteResponses = 0L;
        this.extendedRequests = 0L;
        this.extendedResponses = 0L;
        this.messagesRead = 0L;
        this.messagesWritten = 0L;
        this.modifyRequests = 0L;
        this.modifyResponses = 0L;
        this.modifyDNRequests = 0L;
        this.modifyDNResponses = 0L;
        this.operationsAbandoned = 0L;
        this.operationsCompleted = 0L;
        this.operationsInitiated = 0L;
        this.searchRequests = 0L;
        this.searchResultEntries = 0L;
        this.searchResultReferences = 0L;
        this.searchResultsDone = 0L;
        this.unbindRequests = 0L;
    }

    @Override
    public void initializeMonitorProvider(MonitorProviderCfg configuration) throws ConfigException {
        Message message = ProtocolMessages.ERR_LDAP_STATS_INVALID_MONITOR_INITIALIZATION.get(String.valueOf(configuration.dn()));
        throw new ConfigException(message);
    }

    @Override
    public String getMonitorInstanceName() {
        return this.instanceName;
    }

    @Override
    public long getUpdateInterval() {
        return -1L;
    }

    @Override
    public void updateMonitorData() {
    }

    /*
     * Exception decompiling
     */
    public ArrayList<Attribute> getMonitorData() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [21[CATCHBLOCK], 20[CATCHBLOCK]], but top level block is 8[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearStatistics() {
        this.abandonLock.lock();
        try {
            this.connectLock.lock();
            try {
                this.disconnectLock.lock();
                try {
                    this.writeLock.lock();
                    try {
                        this.readLock.lock();
                        try {
                            this.abandonRequests = 0L;
                            this.addRequests = 0L;
                            this.addResponses = 0L;
                            this.bindRequests = 0L;
                            this.bindResponses = 0L;
                            this.bytesRead = 0L;
                            this.bytesWritten = 0L;
                            this.compareRequests = 0L;
                            this.compareResponses = 0L;
                            this.connectionsClosed = 0L;
                            this.connectionsEstablished = 0L;
                            this.deleteRequests = 0L;
                            this.deleteResponses = 0L;
                            this.extendedRequests = 0L;
                            this.extendedResponses = 0L;
                            this.messagesRead = 0L;
                            this.messagesWritten = 0L;
                            this.modifyRequests = 0L;
                            this.modifyResponses = 0L;
                            this.modifyDNRequests = 0L;
                            this.modifyDNResponses = 0L;
                            this.operationsAbandoned = 0L;
                            this.operationsCompleted = 0L;
                            this.operationsInitiated = 0L;
                            this.searchRequests = 0L;
                            this.searchResultEntries = 0L;
                            this.searchResultReferences = 0L;
                            this.searchResultsDone = 0L;
                            this.unbindRequests = 0L;
                        }
                        catch (Exception e) {
                            if (DebugLogger.debugEnabled()) {
                                TRACER.debugCaught(DebugLogLevel.ERROR, e);
                            }
                        }
                        finally {
                            this.readLock.unlock();
                        }
                    }
                    catch (Exception e) {
                        if (DebugLogger.debugEnabled()) {
                            TRACER.debugCaught(DebugLogLevel.ERROR, e);
                        }
                    }
                    finally {
                        this.writeLock.unlock();
                    }
                }
                catch (Exception e) {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugCaught(DebugLogLevel.ERROR, e);
                    }
                }
                finally {
                    this.disconnectLock.unlock();
                }
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
            }
            finally {
                this.connectLock.unlock();
            }
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
        }
        finally {
            this.abandonLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateConnect() {
        this.connectLock.lock();
        try {
            ++this.connectionsEstablished;
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
        }
        finally {
            this.connectLock.unlock();
        }
        if (this.parent != null) {
            this.parent.updateConnect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateDisconnect() {
        this.disconnectLock.lock();
        try {
            ++this.connectionsClosed;
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
        }
        finally {
            this.disconnectLock.unlock();
        }
        if (this.parent != null) {
            this.parent.updateDisconnect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateBytesRead(int bytesRead) {
        this.readLock.lock();
        try {
            this.bytesRead += (long)bytesRead;
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
        }
        finally {
            this.readLock.unlock();
        }
        if (this.parent != null) {
            this.parent.updateBytesRead(bytesRead);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void updateMessageRead(LDAPMessage message) {
        this.readLock.lock();
        try {
            ++this.messagesRead;
            ++this.operationsInitiated;
            switch (message.getProtocolOp().getType()) {
                case 80: {
                    ++this.abandonRequests;
                    ** break;
lbl9:
                    // 1 sources

                    break;
                }
                case 104: {
                    ++this.addRequests;
                    ** break;
lbl13:
                    // 1 sources

                    break;
                }
                case 96: {
                    ++this.bindRequests;
                    ** break;
lbl17:
                    // 1 sources

                    break;
                }
                case 110: {
                    ++this.compareRequests;
                    ** break;
lbl21:
                    // 1 sources

                    break;
                }
                case 74: {
                    ++this.deleteRequests;
                    ** break;
lbl25:
                    // 1 sources

                    break;
                }
                case 119: {
                    ++this.extendedRequests;
                    ** break;
lbl29:
                    // 1 sources

                    break;
                }
                case 102: {
                    ++this.modifyRequests;
                    ** break;
lbl33:
                    // 1 sources

                    break;
                }
                case 108: {
                    ++this.modifyDNRequests;
                    ** break;
lbl37:
                    // 1 sources

                    break;
                }
                case 99: {
                    ++this.searchRequests;
                    ** break;
lbl41:
                    // 1 sources

                    break;
                }
                case 66: {
                    ++this.unbindRequests;
                    break;
                }
                ** default:
lbl46:
                // 1 sources

                break;
            }
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                LDAPStatistics.TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
        }
        finally {
            this.readLock.unlock();
        }
        if (this.parent != null) {
            this.parent.updateMessageRead(message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void updateMessageWritten(LDAPMessage message, int bytesWritten) {
        this.writeLock.lock();
        try {
            this.bytesWritten += (long)bytesWritten;
            ++this.messagesWritten;
            switch (message.getProtocolOp().getType()) {
                case 105: {
                    ++this.addResponses;
                    ++this.operationsCompleted;
                    ** break;
lbl10:
                    // 1 sources

                    break;
                }
                case 97: {
                    ++this.bindResponses;
                    ++this.operationsCompleted;
                    ** break;
lbl15:
                    // 1 sources

                    break;
                }
                case 111: {
                    ++this.compareResponses;
                    ++this.operationsCompleted;
                    ** break;
lbl20:
                    // 1 sources

                    break;
                }
                case 107: {
                    ++this.deleteResponses;
                    ++this.operationsCompleted;
                    ** break;
lbl25:
                    // 1 sources

                    break;
                }
                case 120: {
                    ++this.extendedResponses;
                    if (message.getMessageID() <= 0) ** break;
                    ++this.operationsCompleted;
                    ** break;
lbl31:
                    // 1 sources

                    break;
                }
                case 103: {
                    ++this.modifyResponses;
                    ++this.operationsCompleted;
                    ** break;
lbl36:
                    // 1 sources

                    break;
                }
                case 109: {
                    ++this.modifyDNResponses;
                    ++this.operationsCompleted;
                    ** break;
lbl41:
                    // 1 sources

                    break;
                }
                case 100: {
                    ++this.searchResultEntries;
                    ** break;
lbl45:
                    // 1 sources

                    break;
                }
                case 115: {
                    ++this.searchResultReferences;
                    ** break;
lbl49:
                    // 1 sources

                    break;
                }
                case 101: {
                    ++this.searchResultsDone;
                    ++this.operationsCompleted;
                    break;
                }
                ** default:
lbl55:
                // 1 sources

                break;
            }
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                LDAPStatistics.TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
        }
        finally {
            this.writeLock.unlock();
        }
        if (this.parent != null) {
            this.parent.updateMessageWritten(message, bytesWritten);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateAbandonedOperation() {
        this.abandonLock.lock();
        try {
            ++this.operationsAbandoned;
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
        }
        finally {
            this.abandonLock.unlock();
        }
        if (this.parent != null) {
            this.parent.updateAbandonedOperation();
        }
    }

    private Attribute createAttribute(String name, String value) {
        AttributeType attrType = DirectoryServer.getDefaultAttributeType(name);
        ASN1OctetString encodedValue = new ASN1OctetString(value);
        LinkedHashSet<AttributeValue> values = new LinkedHashSet<AttributeValue>(1);
        try {
            values.add(new AttributeValue(encodedValue, attrType.normalize(encodedValue)));
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            values.add(new AttributeValue(encodedValue, (ByteString)encodedValue));
        }
        return new Attribute(attrType, name, values);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getConnectionsEstablished() {
        this.connectLock.lock();
        try {
            long l = this.connectionsEstablished;
            return l;
        }
        finally {
            this.connectLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getConnectionsClosed() {
        this.disconnectLock.lock();
        try {
            long l = this.connectionsClosed;
            return l;
        }
        finally {
            this.disconnectLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getBytesRead() {
        this.readLock.lock();
        try {
            long l = this.bytesRead;
            return l;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getBytesWritten() {
        this.writeLock.lock();
        try {
            long l = this.bytesWritten;
            return l;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getMessagesRead() {
        this.readLock.lock();
        try {
            long l = this.messagesRead;
            return l;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getMessagesWritten() {
        this.writeLock.lock();
        try {
            long l = this.messagesWritten;
            return l;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getOperationsInitiated() {
        this.readLock.lock();
        try {
            long l = this.operationsInitiated;
            return l;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getOperationsCompleted() {
        this.writeLock.lock();
        try {
            long l = this.operationsCompleted;
            return l;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getOperationsAbandoned() {
        this.abandonLock.lock();
        try {
            long l = this.operationsAbandoned;
            return l;
        }
        finally {
            this.abandonLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getAbandonRequests() {
        this.readLock.lock();
        try {
            long l = this.abandonRequests;
            return l;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getAddRequests() {
        this.readLock.lock();
        try {
            long l = this.addRequests;
            return l;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getAddResponses() {
        this.writeLock.lock();
        try {
            long l = this.addResponses;
            return l;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getBindRequests() {
        this.readLock.lock();
        try {
            long l = this.bindRequests;
            return l;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getBindResponses() {
        this.writeLock.lock();
        try {
            long l = this.bindResponses;
            return l;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getCompareRequests() {
        this.readLock.lock();
        try {
            long l = this.compareRequests;
            return l;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getCompareResponses() {
        this.writeLock.lock();
        try {
            long l = this.compareResponses;
            return l;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getDeleteRequests() {
        this.readLock.lock();
        try {
            long l = this.deleteRequests;
            return l;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getDeleteResponses() {
        this.writeLock.lock();
        try {
            long l = this.deleteResponses;
            return l;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getExtendedRequests() {
        this.readLock.lock();
        try {
            long l = this.extendedRequests;
            return l;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getExtendedResponses() {
        this.writeLock.lock();
        try {
            long l = this.extendedResponses;
            return l;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getModifyRequests() {
        this.readLock.lock();
        try {
            long l = this.modifyRequests;
            return l;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getModifyResponses() {
        this.writeLock.lock();
        try {
            long l = this.modifyResponses;
            return l;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getModifyDNRequests() {
        this.readLock.lock();
        try {
            long l = this.modifyDNRequests;
            return l;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getModifyDNResponses() {
        this.writeLock.lock();
        try {
            long l = this.modifyDNResponses;
            return l;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getSearchRequests() {
        this.readLock.lock();
        try {
            long l = this.searchRequests;
            return l;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getSearchResultEntries() {
        this.writeLock.lock();
        try {
            long l = this.searchResultEntries;
            return l;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getSearchResultReferences() {
        this.writeLock.lock();
        try {
            long l = this.searchResultReferences;
            return l;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getSearchResultsDone() {
        this.writeLock.lock();
        try {
            long l = this.searchResultsDone;
            return l;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getUnbindRequests() {
        this.readLock.lock();
        try {
            long l = this.unbindRequests;
            return l;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public LDAPStatistics getParent() {
        return this.parent;
    }
}

