/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.protocols.jmx;

import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import org.opends.messages.Message;
import org.opends.messages.ProtocolMessages;
import org.opends.server.admin.server.ConfigurationChangeListener;
import org.opends.server.admin.std.server.ConnectionHandlerCfg;
import org.opends.server.admin.std.server.JMXConnectionHandlerCfg;
import org.opends.server.api.AlertGenerator;
import org.opends.server.api.ClientConnection;
import org.opends.server.api.ConnectionHandler;
import org.opends.server.api.KeyManagerProvider;
import org.opends.server.api.ServerShutdownListener;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.protocols.jmx.RmiConnector;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.DN;
import org.opends.server.types.HostPort;
import org.opends.server.types.InitializationException;
import org.opends.server.types.ResultCode;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JmxConnectionHandler
extends ConnectionHandler<JMXConnectionHandlerCfg>
implements ServerShutdownListener,
AlertGenerator,
ConfigurationChangeListener<JMXConnectionHandlerCfg> {
    public static final String TRUST_MANAGER_ARRAY_KEY = "org.opends.server.protocol.jmx.ssl.trust.manager.array";
    private static final String CLASS_NAME = "org.opends.server.protocols.jmx.JMXConnectionHandler";
    private LinkedList<ClientConnection> connectionList;
    private JMXConnectionHandlerCfg currentConfig;
    private RmiConnector rmiConnector;
    private String connectionHandlerName;
    private String protocol;
    private LinkedList<HostPort> listeners = new LinkedList();

    public JmxConnectionHandler() {
        super("JMX Connection Handler Thread");
        this.connectionList = new LinkedList();
    }

    @Override
    public ConfigChangeResult applyConfigurationChange(JMXConnectionHandlerCfg config) {
        ResultCode resultCode = ResultCode.SUCCESS;
        ArrayList<Message> messages = new ArrayList<Message>();
        boolean rmiConnectorRestart = false;
        boolean portChanged = false;
        if (this.currentConfig.getListenPort() != config.getListenPort()) {
            rmiConnectorRestart = true;
            portChanged = true;
        }
        if (this.currentConfig.isUseSSL() != config.isUseSSL()) {
            rmiConnectorRestart = true;
        }
        if (!this.currentConfig.getSSLCertNickname().equals(config.getSSLCertNickname())) {
            rmiConnectorRestart = true;
        }
        this.currentConfig = config;
        if (rmiConnectorRestart) {
            this.protocol = config.isUseSSL() ? "JMX+SSL" : "JMX";
            this.listeners.clear();
            this.listeners.add(new HostPort(config.getListenPort()));
            this.rmiConnector.finalizeConnectionHandler(true, portChanged);
            try {
                this.rmiConnector.initialize();
            }
            catch (RuntimeException e) {
                resultCode = ResultCode.OPERATIONS_ERROR;
                messages.add(Message.raw(e.getMessage(), new Object[0]));
            }
        }
        return new ConfigChangeResult(resultCode, false, messages);
    }

    @Override
    public void finalizeConnectionHandler(Message finalizeReason, boolean closeConnections) {
        this.currentConfig.removeJMXChangeListener(this);
        this.rmiConnector.finalizeConnectionHandler(closeConnections, true);
    }

    @Override
    public LinkedHashMap<String, String> getAlerts() {
        LinkedHashMap<String, String> alerts = new LinkedHashMap<String, String>();
        return alerts;
    }

    @Override
    public String getClassName() {
        return CLASS_NAME;
    }

    @Override
    public Collection<ClientConnection> getClientConnections() {
        return this.connectionList;
    }

    @Override
    public DN getComponentEntryDN() {
        return this.currentConfig.dn();
    }

    public DN getKeyManagerProviderDN() {
        return this.currentConfig.getKeyManagerProviderDN();
    }

    public int getListenPort() {
        return this.currentConfig.getListenPort();
    }

    public RmiConnector getRMIConnector() {
        return this.rmiConnector;
    }

    @Override
    public String getShutdownListenerName() {
        return this.connectionHandlerName;
    }

    public String getSSLServerCertNickname() {
        return this.currentConfig.getSSLCertNickname();
    }

    @Override
    public void initializeConnectionHandler(JMXConnectionHandlerCfg config) throws ConfigException, InitializationException {
        KeyManagerProvider provider;
        DN keyManagerProviderDN = config.getKeyManagerProviderDN();
        if (keyManagerProviderDN != null && (provider = DirectoryServer.getKeyManagerProvider(keyManagerProviderDN)) == null) {
            Message message = ProtocolMessages.ERR_JMX_CONNHANDLER_INVALID_KEYMANAGER_DN.get(String.valueOf(config.dn()), String.valueOf(keyManagerProviderDN));
            throw new ConfigException(message);
        }
        if (config.isUseSSL() && keyManagerProviderDN == null) {
            Message message = ProtocolMessages.ERR_JMX_CONNHANDLER_CANNOT_DETERMINE_USE_SSL.get(String.valueOf(this.currentConfig.dn()), "");
            ErrorLogger.logError(message);
            throw new ConfigException(message);
        }
        this.currentConfig = config;
        ServerSocket s = null;
        try {
            s = new ServerSocket();
            s.setReuseAddress(true);
            s.bind(new InetSocketAddress(config.getListenPort()));
        }
        catch (Exception e) {
            Message message = ProtocolMessages.ERR_JMX_CONNHANDLER_CANNOT_BIND.get(String.valueOf(config.dn()), config.getListenPort(), StaticUtils.getExceptionMessage(e));
            ErrorLogger.logError(message);
            throw new InitializationException(message);
        }
        finally {
            try {
                s.close();
            }
            catch (Exception e) {}
        }
        this.protocol = config.isUseSSL() ? "JMX+SSL" : "JMX";
        this.listeners.clear();
        this.listeners.add(new HostPort("0.0.0.0", config.getListenPort()));
        this.connectionHandlerName = "JMX Connection Handler " + config.getListenPort();
        this.rmiConnector = new RmiConnector(DirectoryServer.getJMXMBeanServer(), this);
        config.addJMXChangeListener(this);
    }

    @Override
    public String getConnectionHandlerName() {
        return this.connectionHandlerName;
    }

    @Override
    public String getProtocol() {
        return this.protocol;
    }

    @Override
    public Collection<HostPort> getListeners() {
        return this.listeners;
    }

    @Override
    public boolean isConfigurationAcceptable(ConnectionHandlerCfg configuration, List<Message> unacceptableReasons) {
        JMXConnectionHandlerCfg config = (JMXConnectionHandlerCfg)configuration;
        return this.isConfigurationChangeAcceptable(config, unacceptableReasons);
    }

    @Override
    public boolean isConfigurationChangeAcceptable(JMXConnectionHandlerCfg config, List<Message> unacceptableReasons) {
        KeyManagerProvider provider;
        boolean isAcceptable = true;
        DN keyManagerProviderDN = config.getKeyManagerProviderDN();
        if (keyManagerProviderDN != null && (provider = DirectoryServer.getKeyManagerProvider(keyManagerProviderDN)) == null) {
            unacceptableReasons.add(ProtocolMessages.ERR_JMX_CONNHANDLER_INVALID_KEYMANAGER_DN.get(String.valueOf(config.dn()), String.valueOf(keyManagerProviderDN)));
            isAcceptable = false;
        }
        if (config.isUseSSL() && keyManagerProviderDN == null) {
            unacceptableReasons.add(ProtocolMessages.ERR_JMX_CONNHANDLER_CANNOT_DETERMINE_USE_SSL.get(String.valueOf(config.dn()), ""));
            isAcceptable = false;
        }
        return isAcceptable;
    }

    public boolean isUseSSL() {
        return this.currentConfig.isUseSSL();
    }

    @Override
    public void processServerShutdown(Message reason) {
        this.rmiConnector.finalizeConnectionHandler(true, true);
    }

    public void registerClientConnection(ClientConnection connection) {
        this.connectionList.add(connection);
    }

    @Override
    public void run() {
        try {
            this.rmiConnector.initialize();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    @Override
    public void toString(StringBuilder buffer) {
        buffer.append(this.connectionHandlerName);
    }
}

