/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.protocols.asn1;

import org.opends.messages.Message;
import org.opends.messages.ProtocolMessages;
import org.opends.server.protocols.asn1.ASN1Element;
import org.opends.server.protocols.asn1.ASN1Exception;
import org.opends.server.types.PublicAPI;
import org.opends.server.types.StabilityLevel;
import org.opends.server.util.ServerConstants;
import org.opends.server.util.StaticUtils;

@PublicAPI(stability=StabilityLevel.UNCOMMITTED, mayInstantiate=true, mayExtend=false, mayInvoke=true)
public final class ASN1Null
extends ASN1Element {
    private static final long serialVersionUID = 8921787912269145125L;

    public ASN1Null() {
        super((byte)5);
    }

    public ASN1Null(byte type) {
        super(type);
    }

    public void setValue(byte[] value) throws ASN1Exception {
        if (value != null && value.length != 0) {
            Message message = ProtocolMessages.ERR_ASN1_NULL_SET_VALUE_INVALID_LENGTH.get(value.length);
            throw new ASN1Exception(message);
        }
    }

    public static ASN1Null decodeAsNull(ASN1Element element) throws ASN1Exception {
        if (element == null) {
            Message message = ProtocolMessages.ERR_ASN1_NULL_DECODE_ELEMENT_NULL.get();
            throw new ASN1Exception(message);
        }
        byte[] value = element.value();
        if (value.length != 0) {
            Message message = ProtocolMessages.ERR_ASN1_NULL_DECODE_ELEMENT_INVALID_LENGTH.get(value.length);
            throw new ASN1Exception(message);
        }
        return new ASN1Null(element.getType());
    }

    public static ASN1Null decodeAsNull(byte[] encodedElement) throws ASN1Exception {
        if (encodedElement == null) {
            Message message = ProtocolMessages.ERR_ASN1_NULL_DECODE_ARRAY_NULL.get();
            throw new ASN1Exception(message);
        }
        if (encodedElement.length < 2) {
            Message message = ProtocolMessages.ERR_ASN1_SHORT_ELEMENT.get(encodedElement.length);
            throw new ASN1Exception(message);
        }
        byte type = encodedElement[0];
        int length = encodedElement[1] & 0x7F;
        int valueStartPos = 2;
        if (length != encodedElement[1]) {
            int numLengthBytes = length;
            if (numLengthBytes > 4) {
                Message message = ProtocolMessages.ERR_ASN1_INVALID_NUM_LENGTH_BYTES.get(numLengthBytes);
                throw new ASN1Exception(message);
            }
            if (encodedElement.length < 2 + numLengthBytes) {
                Message message = ProtocolMessages.ERR_ASN1_TRUNCATED_LENGTH.get(numLengthBytes);
                throw new ASN1Exception(message);
            }
            length = 0;
            valueStartPos = 2 + numLengthBytes;
            for (int i = 0; i < numLengthBytes; ++i) {
                length = length << 8 | encodedElement[i + 2] & 0xFF;
            }
        }
        if (encodedElement.length - valueStartPos != length) {
            Message message = ProtocolMessages.ERR_ASN1_LENGTH_MISMATCH.get(length, encodedElement.length - valueStartPos);
            throw new ASN1Exception(message);
        }
        if (length != 0) {
            Message message = ProtocolMessages.ERR_ASN1_NULL_DECODE_ARRAY_INVALID_LENGTH.get(length);
            throw new ASN1Exception(message);
        }
        return new ASN1Null(type);
    }

    public void toString(StringBuilder buffer) {
        buffer.append("ASN1Null(type=");
        buffer.append(StaticUtils.byteToHex(this.getType()));
        buffer.append(")");
    }

    public void toString(StringBuilder buffer, int indent) {
        StringBuilder indentBuf = new StringBuilder(indent);
        for (int i = 0; i < indent; ++i) {
            indentBuf.append(' ');
        }
        buffer.append((CharSequence)indentBuf);
        buffer.append("ASN.1 Null");
        buffer.append(ServerConstants.EOL);
        buffer.append((CharSequence)indentBuf);
        buffer.append("  BER Type:  ");
        buffer.append(StaticUtils.byteToHex(this.getType()));
        buffer.append(ServerConstants.EOL);
    }
}

