/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.protocols.asn1;

import org.opends.messages.Message;
import org.opends.messages.ProtocolMessages;
import org.opends.server.protocols.asn1.ASN1Element;
import org.opends.server.protocols.asn1.ASN1Exception;
import org.opends.server.types.PublicAPI;
import org.opends.server.types.StabilityLevel;
import org.opends.server.util.ServerConstants;
import org.opends.server.util.StaticUtils;

@PublicAPI(stability=StabilityLevel.UNCOMMITTED, mayInstantiate=true, mayExtend=false, mayInvoke=true)
public final class ASN1Integer
extends ASN1Element {
    private static final long serialVersionUID = 7352628713339746558L;
    private int intValue;

    public ASN1Integer(int intValue) {
        super((byte)2, ASN1Integer.encodeValue(intValue));
        this.intValue = intValue;
    }

    public ASN1Integer(byte type, int intValue) {
        super(type, ASN1Integer.encodeValue(intValue));
        this.intValue = intValue;
    }

    private ASN1Integer(byte type, byte[] value, int intValue) {
        super(type, value);
        this.intValue = intValue;
    }

    public int intValue() {
        return this.intValue;
    }

    public void setValue(int intValue) {
        this.intValue = intValue;
        this.setValueInternal(ASN1Integer.encodeValue(intValue));
    }

    public void setValue(byte[] value) throws ASN1Exception {
        if (value == null) {
            Message message = ProtocolMessages.ERR_ASN1_INTEGER_SET_VALUE_NULL.get();
            throw new ASN1Exception(message);
        }
        if (value.length < 1 || value.length > 4) {
            Message message = ProtocolMessages.ERR_ASN1_INTEGER_SET_VALUE_INVALID_LENGTH.get(value.length);
            throw new ASN1Exception(message);
        }
        this.intValue = 0;
        for (byte b : value) {
            this.intValue = this.intValue << 8 | b & 0xFF;
        }
        this.setValueInternal(value);
    }

    public static ASN1Integer decodeAsInteger(ASN1Element element) throws ASN1Exception {
        if (element == null) {
            Message message = ProtocolMessages.ERR_ASN1_INTEGER_DECODE_ELEMENT_NULL.get();
            throw new ASN1Exception(message);
        }
        byte[] value = element.value();
        if (value.length < 1 || value.length > 4) {
            Message message = ProtocolMessages.ERR_ASN1_INTEGER_DECODE_ELEMENT_INVALID_LENGTH.get(value.length);
            throw new ASN1Exception(message);
        }
        int intValue = 0;
        for (byte b : value) {
            intValue = intValue << 8 | b & 0xFF;
        }
        return new ASN1Integer(element.getType(), value, intValue);
    }

    public static ASN1Integer decodeAsInteger(byte[] encodedElement) throws ASN1Exception {
        if (encodedElement == null) {
            Message message = ProtocolMessages.ERR_ASN1_INTEGER_DECODE_ARRAY_NULL.get();
            throw new ASN1Exception(message);
        }
        if (encodedElement.length < 3) {
            Message message = ProtocolMessages.ERR_ASN1_INTEGER_SHORT_ELEMENT.get(encodedElement.length);
            throw new ASN1Exception(message);
        }
        byte type = encodedElement[0];
        int length = encodedElement[1] & 0x7F;
        int valueStartPos = 2;
        if (length != encodedElement[1]) {
            int numLengthBytes = length;
            if (numLengthBytes > 4) {
                Message message = ProtocolMessages.ERR_ASN1_INVALID_NUM_LENGTH_BYTES.get(numLengthBytes);
                throw new ASN1Exception(message);
            }
            if (encodedElement.length < 2 + numLengthBytes) {
                Message message = ProtocolMessages.ERR_ASN1_TRUNCATED_LENGTH.get(numLengthBytes);
                throw new ASN1Exception(message);
            }
            length = 0;
            valueStartPos = 2 + numLengthBytes;
            for (int i = 0; i < numLengthBytes; ++i) {
                length = length << 8 | encodedElement[i + 2] & 0xFF;
            }
        }
        if (encodedElement.length - valueStartPos != length) {
            Message message = ProtocolMessages.ERR_ASN1_LENGTH_MISMATCH.get(length, encodedElement.length - valueStartPos);
            throw new ASN1Exception(message);
        }
        if (length < 1 || length > 4) {
            Message message = ProtocolMessages.ERR_ASN1_INTEGER_DECODE_ARRAY_INVALID_LENGTH.get(length);
            throw new ASN1Exception(message);
        }
        byte[] value = new byte[length];
        System.arraycopy(encodedElement, valueStartPos, value, 0, length);
        int intValue = 0;
        for (byte b : value) {
            intValue = intValue << 8 | b & 0xFF;
        }
        return new ASN1Integer(type, value, intValue);
    }

    public void toString(StringBuilder buffer) {
        buffer.append("ASN1Integer(type=");
        buffer.append(StaticUtils.byteToHex(this.getType()));
        buffer.append(", value=");
        buffer.append(this.intValue);
        buffer.append(")");
    }

    public void toString(StringBuilder buffer, int indent) {
        StringBuilder indentBuf = new StringBuilder(indent);
        for (int i = 0; i < indent; ++i) {
            indentBuf.append(' ');
        }
        buffer.append((CharSequence)indentBuf);
        buffer.append("ASN.1 Integer");
        buffer.append(ServerConstants.EOL);
        buffer.append((CharSequence)indentBuf);
        buffer.append("  BER Type:  ");
        buffer.append(StaticUtils.byteToHex(this.getType()));
        buffer.append(ServerConstants.EOL);
        buffer.append((CharSequence)indentBuf);
        buffer.append("  Value:  ");
        buffer.append(this.intValue);
        buffer.append(" (");
        buffer.append(StaticUtils.bytesToHex(this.value()));
        buffer.append(")");
        buffer.append(ServerConstants.EOL);
    }
}

