/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.plugins;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.opends.messages.Message;
import org.opends.messages.PluginMessages;
import org.opends.server.admin.server.ConfigurationChangeListener;
import org.opends.server.admin.std.meta.PluginCfgDefn;
import org.opends.server.admin.std.server.UniqueAttributePluginCfg;
import org.opends.server.api.plugin.DirectoryServerPlugin;
import org.opends.server.api.plugin.PluginType;
import org.opends.server.api.plugin.PreOperationPluginResult;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.protocols.internal.InternalClientConnection;
import org.opends.server.protocols.internal.InternalSearchOperation;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.DN;
import org.opends.server.types.DereferencePolicy;
import org.opends.server.types.Entry;
import org.opends.server.types.Modification;
import org.opends.server.types.ModificationType;
import org.opends.server.types.RDN;
import org.opends.server.types.ResultCode;
import org.opends.server.types.SearchFilter;
import org.opends.server.types.SearchResultEntry;
import org.opends.server.types.SearchScope;
import org.opends.server.types.operation.PreOperationAddOperation;
import org.opends.server.types.operation.PreOperationModifyDNOperation;
import org.opends.server.types.operation.PreOperationModifyOperation;
import org.opends.server.types.operation.PreOperationOperation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UniqueAttributePlugin
extends DirectoryServerPlugin<UniqueAttributePluginCfg>
implements ConfigurationChangeListener<UniqueAttributePluginCfg> {
    private UniqueAttributePluginCfg currentConfiguration;
    private LinkedHashSet<AttributeType> uniqueAttributeTypes = new LinkedHashSet();
    private LinkedHashSet<DN> baseDNs = new LinkedHashSet();

    @Override
    public final void initializePlugin(Set<PluginType> pluginTypes, UniqueAttributePluginCfg configuration) throws ConfigException {
        configuration.addUniqueAttributeChangeListener(this);
        this.currentConfiguration = configuration;
        block3: for (PluginType t : pluginTypes) {
            switch (t) {
                case PRE_OPERATION_ADD: 
                case PRE_OPERATION_MODIFY: 
                case PRE_OPERATION_MODIFY_DN: {
                    continue block3;
                }
            }
            Message message = PluginMessages.ERR_PLUGIN_UNIQUEATTR_INVALID_PLUGIN_TYPE.get(t.toString());
            throw new ConfigException(message);
        }
        for (DN baseDN : configuration.getUniqueAttributeBaseDN()) {
            this.baseDNs.add(baseDN);
        }
        for (String attributeType : configuration.getUniqueAttributeType()) {
            AttributeType type = DirectoryServer.getAttributeType(attributeType.toLowerCase());
            if (type == null) {
                type = DirectoryServer.getDefaultAttributeType(attributeType.toLowerCase());
            }
            this.uniqueAttributeTypes.add(type);
        }
    }

    @Override
    public boolean isConfigurationChangeAcceptable(UniqueAttributePluginCfg configuration, List<Message> unacceptableReasons) {
        boolean configAcceptable = true;
        block3: for (PluginCfgDefn.PluginType pluginType : configuration.getPluginType()) {
            switch (pluginType) {
                case PREOPERATIONADD: 
                case PREOPERATIONMODIFY: 
                case PREOPERATIONMODIFYDN: {
                    continue block3;
                }
            }
            Message message = PluginMessages.ERR_PLUGIN_UNIQUEATTR_INVALID_PLUGIN_TYPE.get(pluginType.toString());
            unacceptableReasons.add(message);
            configAcceptable = false;
        }
        return configAcceptable;
    }

    @Override
    public ConfigChangeResult applyConfigurationChange(UniqueAttributePluginCfg newConfiguration) {
        ResultCode resultCode = ResultCode.SUCCESS;
        boolean adminActionRequired = false;
        ArrayList<Message> messages = new ArrayList<Message>();
        LinkedHashSet<AttributeType> newUniqueattributeTypes = new LinkedHashSet<AttributeType>();
        LinkedHashSet<DN> newConfiguredBaseDNs = new LinkedHashSet<DN>();
        for (DN baseDN : newConfiguration.getUniqueAttributeBaseDN()) {
            newConfiguredBaseDNs.add(baseDN);
        }
        for (String attributeType : newConfiguration.getUniqueAttributeType()) {
            AttributeType type = DirectoryServer.getAttributeType(attributeType.toLowerCase());
            if (type == null) {
                type = DirectoryServer.getDefaultAttributeType(attributeType.toLowerCase());
            }
            newUniqueattributeTypes.add(type);
        }
        this.baseDNs = newConfiguredBaseDNs;
        this.uniqueAttributeTypes = newUniqueattributeTypes;
        this.currentConfiguration = newConfiguration;
        return new ConfigChangeResult(resultCode, adminActionRequired, messages);
    }

    @Override
    public final PreOperationPluginResult doPreOperation(PreOperationAddOperation addOperation) {
        List<AttributeValue> valueList;
        PreOperationPluginResult pluginResult = PreOperationPluginResult.SUCCESS;
        DN entryDN = addOperation.getEntryDN();
        if (this.isEntryUniquenessCandidate(entryDN) && !this.searchAllBaseDNs(valueList = this.getEntryAttributeValues(addOperation.getEntryToAdd()), entryDN)) {
            pluginResult = this.getPluginErrorResult(addOperation, PluginMessages.ERR_PLUGIN_UNIQUEATTR_ADD_NOT_UNIQUE.get(entryDN.toString()));
        }
        return pluginResult;
    }

    @Override
    public final PreOperationPluginResult doPreOperation(PreOperationModifyOperation modifyOperation) {
        List<AttributeValue> valueList;
        PreOperationPluginResult pluginResult = PreOperationPluginResult.SUCCESS;
        DN entryDN = modifyOperation.getEntryDN();
        if (this.isEntryUniquenessCandidate(entryDN) && !this.searchAllBaseDNs(valueList = this.getModificationAttributeValues(modifyOperation.getModifications(), modifyOperation.getModifiedEntry()), entryDN)) {
            pluginResult = this.getPluginErrorResult(modifyOperation, PluginMessages.ERR_PLUGIN_UNIQUEATTR_MOD_NOT_UNIQUE.get(entryDN.toString()));
        }
        return pluginResult;
    }

    @Override
    public final PreOperationPluginResult doPreOperation(PreOperationModifyDNOperation modifyDNOperation) {
        List<AttributeValue> valueList;
        PreOperationPluginResult pluginResult = PreOperationPluginResult.SUCCESS;
        DN entryDN = modifyDNOperation.getOriginalEntry().getDN();
        if (modifyDNOperation.getNewSuperior() != null) {
            entryDN = modifyDNOperation.getNewSuperior();
        }
        if (this.isEntryUniquenessCandidate(entryDN) && !this.searchAllBaseDNs(valueList = this.getRDNAttributeValues(modifyDNOperation.getNewRDN()), entryDN)) {
            pluginResult = this.getPluginErrorResult(modifyDNOperation, PluginMessages.ERR_PLUGIN_UNIQUEATTR_MODDN_NOT_UNIQUE.get(entryDN.toString()));
        }
        return pluginResult;
    }

    private boolean isEntryUniquenessCandidate(DN dn) {
        if (this.uniqueAttributeTypes.isEmpty()) {
            return false;
        }
        if (this.baseDNs.isEmpty()) {
            return true;
        }
        for (DN baseDN : this.baseDNs) {
            if (!baseDN.isAncestorOf(dn)) continue;
            return true;
        }
        return false;
    }

    private PreOperationPluginResult getPluginErrorResult(PreOperationOperation operation, Message message) {
        operation.appendErrorMessage(message);
        operation.setResultCode(ResultCode.CONSTRAINT_VIOLATION);
        return new PreOperationPluginResult(false, false, true);
    }

    private List<AttributeValue> getRDNAttributeValues(RDN rdn) {
        LinkedList<AttributeValue> valueList = new LinkedList<AttributeValue>();
        int numAVAs = rdn.getNumValues();
        for (int i = 0; i < numAVAs; ++i) {
            if (!this.uniqueAttributeTypes.contains(rdn.getAttributeType(i))) continue;
            valueList.add(rdn.getAttributeValue(i));
        }
        return valueList;
    }

    private List<AttributeValue> getEntryAttributeValues(Entry entry) {
        LinkedList<AttributeValue> valueList = new LinkedList<AttributeValue>();
        for (AttributeType attributeType : this.uniqueAttributeTypes) {
            if (!entry.hasAttribute(attributeType)) continue;
            List<Attribute> attrList = entry.getAttribute(attributeType);
            for (Attribute a : attrList) {
                valueList.addAll(a.getValues());
            }
        }
        return valueList;
    }

    private List<AttributeValue> getModificationAttributeValues(List<Modification> modificationList, Entry modifedEntry) {
        LinkedList<AttributeValue> valueList = new LinkedList<AttributeValue>();
        for (AttributeType attributeType : this.uniqueAttributeTypes) {
            this.getModValuesForAttribute(modificationList, attributeType, valueList, modifedEntry);
        }
        return valueList;
    }

    private void getModValuesForAttribute(List<Modification> modificationList, AttributeType attributeType, LinkedList<AttributeValue> valueList, Entry modifiedEntry) {
        for (Modification modification : modificationList) {
            ModificationType modType = modification.getModificationType();
            if (modType == ModificationType.DELETE || !modification.getAttribute().getAttributeType().equals(attributeType)) continue;
            if (modType == ModificationType.INCREMENT) {
                List<Attribute> modifiedAttrs = modifiedEntry.getAttribute(attributeType, modification.getAttribute().getOptions());
                if (modifiedAttrs == null) continue;
                for (Attribute a : modifiedAttrs) {
                    valueList.addAll(a.getValues());
                }
                continue;
            }
            Attribute modifiedAttribute = modification.getAttribute();
            if (!modifiedAttribute.hasValue()) continue;
            valueList.addAll(modifiedAttribute.getValues());
        }
    }

    private boolean searchAllBaseDNs(List<AttributeValue> valueList, DN entryDN) {
        if (valueList.isEmpty()) {
            return true;
        }
        if (this.baseDNs.isEmpty()) {
            for (DN baseDN : DirectoryServer.getPublicNamingContexts().keySet()) {
                if (!this.searchBaseDN(valueList, baseDN, entryDN)) continue;
                return false;
            }
        } else {
            for (DN baseDN : this.baseDNs) {
                if (!this.searchBaseDN(valueList, baseDN, entryDN)) continue;
                return false;
            }
        }
        return true;
    }

    private boolean searchBaseDN(List<AttributeValue> valueList, DN baseDN, DN entryDN) {
        HashSet<SearchFilter> componentFilters = new HashSet<SearchFilter>();
        for (AttributeValue value : valueList) {
            for (AttributeType attributeType : this.uniqueAttributeTypes) {
                componentFilters.add(SearchFilter.createEqualityFilter(attributeType, value));
            }
            InternalClientConnection conn = InternalClientConnection.getRootConnection();
            InternalSearchOperation operation = conn.processSearch(baseDN, SearchScope.WHOLE_SUBTREE, DereferencePolicy.NEVER_DEREF_ALIASES, 0, 0, true, SearchFilter.createORFilter(componentFilters), null);
            switch (operation.getResultCode()) {
                case SUCCESS: {
                    break;
                }
                case NO_SUCH_OBJECT: {
                    return false;
                }
                default: {
                    return true;
                }
            }
            for (SearchResultEntry entry : operation.getSearchEntries()) {
                if (entry.getDN().equals(entryDN)) continue;
                return true;
            }
            componentFilters.clear();
        }
        return false;
    }
}

