/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.plugins;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.concurrent.CopyOnWriteArrayList;
import org.opends.messages.Message;
import org.opends.messages.PluginMessages;
import org.opends.server.admin.server.ConfigurationChangeListener;
import org.opends.server.admin.std.meta.PluginCfgDefn;
import org.opends.server.admin.std.server.PasswordPolicyImportPluginCfg;
import org.opends.server.admin.std.server.PluginCfg;
import org.opends.server.api.Backend;
import org.opends.server.api.ImportTaskListener;
import org.opends.server.api.PasswordStorageScheme;
import org.opends.server.api.plugin.DirectoryServerPlugin;
import org.opends.server.api.plugin.LDIFPluginResult;
import org.opends.server.api.plugin.PluginType;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.PasswordPolicy;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.schema.AuthPasswordSyntax;
import org.opends.server.schema.UserPasswordSyntax;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.ByteString;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.DN;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.Entry;
import org.opends.server.types.LDIFImportConfig;
import org.opends.server.types.ResultCode;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PasswordPolicyImportPlugin
extends DirectoryServerPlugin<PasswordPolicyImportPluginCfg>
implements ConfigurationChangeListener<PasswordPolicyImportPluginCfg>,
ImportTaskListener {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private AttributeType customPolicyAttribute;
    private AttributeType[] authPasswordTypes;
    private AttributeType[] userPasswordTypes;
    private HashMap<DN, PasswordStorageScheme[]> schemesByPolicy;
    private PasswordStorageScheme[] defaultAuthPasswordSchemes;
    private PasswordStorageScheme[] defaultUserPasswordSchemes;

    @Override
    public final void initializePlugin(Set<PluginType> pluginTypes, PasswordPolicyImportPluginCfg configuration) throws ConfigException {
        configuration.addPasswordPolicyImportChangeListener(this);
        this.customPolicyAttribute = DirectoryServer.getAttributeType("ds-pwp-password-policy-dn", true);
        block3: for (PluginType t : pluginTypes) {
            switch (t) {
                case LDIF_IMPORT: {
                    continue block3;
                }
            }
            Message message = PluginMessages.ERR_PLUGIN_PWPIMPORT_INVALID_PLUGIN_TYPE.get(t.toString());
            throw new ConfigException(message);
        }
        PasswordPolicy defaultPolicy = DirectoryServer.getDefaultPasswordPolicy();
        SortedSet<String> authSchemesSet = configuration.getDefaultAuthPasswordStorageScheme();
        if (authSchemesSet == null || authSchemesSet.isEmpty()) {
            if (defaultPolicy.usesAuthPasswordSyntax()) {
                CopyOnWriteArrayList<PasswordStorageScheme> schemeList = defaultPolicy.getDefaultStorageSchemes();
                this.defaultAuthPasswordSchemes = new PasswordStorageScheme[schemeList.size()];
                schemeList.toArray(this.defaultAuthPasswordSchemes);
            } else {
                this.defaultAuthPasswordSchemes = new PasswordStorageScheme[1];
                this.defaultAuthPasswordSchemes[0] = DirectoryServer.getAuthPasswordStorageScheme("SHA1");
                if (this.defaultAuthPasswordSchemes[0] == null) {
                    Message message = PluginMessages.ERR_PLUGIN_PWIMPORT_NO_DEFAULT_AUTH_SCHEMES.get("SHA1");
                    throw new ConfigException(message);
                }
            }
        } else {
            this.defaultAuthPasswordSchemes = new PasswordStorageScheme[authSchemesSet.size()];
            int i = 0;
            for (String schemeName : authSchemesSet) {
                this.defaultAuthPasswordSchemes[i] = DirectoryServer.getAuthPasswordStorageScheme(schemeName);
                if (this.defaultAuthPasswordSchemes[i] == null) {
                    Message message = PluginMessages.ERR_PLUGIN_PWIMPORT_INVALID_DEFAULT_AUTH_SCHEME.get(schemeName);
                    throw new ConfigException(message);
                }
                ++i;
            }
        }
        SortedSet<String> userSchemeSet = configuration.getDefaultUserPasswordStorageScheme();
        if (userSchemeSet == null || userSchemeSet.isEmpty()) {
            if (!defaultPolicy.usesAuthPasswordSyntax()) {
                CopyOnWriteArrayList<PasswordStorageScheme> schemeList = defaultPolicy.getDefaultStorageSchemes();
                this.defaultUserPasswordSchemes = new PasswordStorageScheme[schemeList.size()];
                schemeList.toArray(this.defaultUserPasswordSchemes);
            } else {
                this.defaultUserPasswordSchemes = new PasswordStorageScheme[1];
                this.defaultUserPasswordSchemes[0] = DirectoryServer.getPasswordStorageScheme(StaticUtils.toLowerCase("SSHA"));
                if (this.defaultUserPasswordSchemes[0] == null) {
                    Message message = PluginMessages.ERR_PLUGIN_PWIMPORT_NO_DEFAULT_USER_SCHEMES.get("SSHA");
                    throw new ConfigException(message);
                }
            }
        } else {
            this.defaultUserPasswordSchemes = new PasswordStorageScheme[userSchemeSet.size()];
            int i = 0;
            for (String schemeName : userSchemeSet) {
                this.defaultUserPasswordSchemes[i] = DirectoryServer.getPasswordStorageScheme(StaticUtils.toLowerCase(schemeName));
                if (this.defaultUserPasswordSchemes[i] == null) {
                    Message message = PluginMessages.ERR_PLUGIN_PWIMPORT_INVALID_DEFAULT_USER_SCHEME.get(schemeName);
                    throw new ConfigException(message);
                }
                ++i;
            }
        }
        this.processImportBegin(null, null);
    }

    @Override
    public void processImportBegin(Backend backend, LDIFImportConfig config) {
        HashSet<AttributeType> authPWTypes = new HashSet<AttributeType>();
        HashSet<AttributeType> userPWTypes = new HashSet<AttributeType>();
        for (AttributeType t : DirectoryServer.getAttributeTypes().values()) {
            if (t.getSyntaxOID().equals("1.3.6.1.4.1.4203.1.1.2")) {
                authPWTypes.add(t);
                continue;
            }
            if (!t.getSyntaxOID().equals("1.3.6.1.4.1.26027.1.3.1")) continue;
            userPWTypes.add(t);
        }
        HashMap<DN, PasswordStorageScheme[]> schemeMap = new HashMap<DN, PasswordStorageScheme[]>();
        for (PasswordPolicy p : DirectoryServer.getPasswordPolicies()) {
            CopyOnWriteArrayList<PasswordStorageScheme> schemeList = p.getDefaultStorageSchemes();
            PasswordStorageScheme[] schemeArray = new PasswordStorageScheme[schemeList.size()];
            schemeList.toArray(schemeArray);
            schemeMap.put(p.getConfigEntryDN(), schemeArray);
        }
        AttributeType[] authTypesArray = new AttributeType[authPWTypes.size()];
        AttributeType[] userTypesArray = new AttributeType[userPWTypes.size()];
        authPWTypes.toArray(authTypesArray);
        userPWTypes.toArray(userTypesArray);
        this.schemesByPolicy = schemeMap;
        this.authPasswordTypes = authTypesArray;
        this.userPasswordTypes = userTypesArray;
    }

    @Override
    public void processImportEnd(Backend backend, LDIFImportConfig config, boolean successful) {
    }

    @Override
    public final LDIFPluginResult doLDIFImport(LDIFImportConfig importConfig, Entry entry) {
        ByteString value;
        AttributeValue v;
        Iterator iterator;
        LinkedHashSet<AttributeValue> values;
        ArrayList<ByteString> encodedValueList = new ArrayList<ByteString>();
        List<Attribute> attrList = entry.getAttribute(this.customPolicyAttribute);
        if (attrList != null) {
            PasswordStorageScheme[] schemes;
            DN policyDN = null;
            PasswordPolicy policy = null;
            for (Attribute a : attrList) {
                Iterator<Object> i$ = a.getValues().iterator();
                if (!i$.hasNext()) continue;
                AttributeValue v2 = (AttributeValue)i$.next();
                try {
                    policyDN = DN.decode(v2.getValue());
                    policy = DirectoryServer.getPasswordPolicy(policyDN);
                    if (policy != null) break;
                    Message message = PluginMessages.WARN_PLUGIN_PWIMPORT_NO_SUCH_POLICY.get(String.valueOf(entry.getDN()), String.valueOf(policyDN));
                    ErrorLogger.logError(message);
                }
                catch (DirectoryException de) {
                    Message message = PluginMessages.WARN_PLUGIN_PWIMPORT_CANNOT_DECODE_POLICY_DN.get(String.valueOf(entry.getDN()), de.getMessageObject());
                    ErrorLogger.logError(message);
                }
                break;
            }
            if (policy != null && (schemes = this.schemesByPolicy.get(policyDN)) != null) {
                attrList = entry.getAttribute(policy.getPasswordAttribute());
                if (attrList == null) {
                    return LDIFPluginResult.SUCCESS;
                }
                for (Attribute a : attrList) {
                    encodedValueList.clear();
                    LinkedHashSet<AttributeValue> values2 = a.getValues();
                    Iterator iterator2 = values2.iterator();
                    while (iterator2.hasNext()) {
                        AttributeValue v3 = (AttributeValue)iterator2.next();
                        ByteString value2 = v3.getValue();
                        if (policy.usesAuthPasswordSyntax()) {
                            if (AuthPasswordSyntax.isEncoded(value2)) continue;
                            try {
                                for (PasswordStorageScheme s : schemes) {
                                    encodedValueList.add(s.encodeAuthPassword(value2));
                                }
                                iterator2.remove();
                                continue;
                            }
                            catch (Exception e) {
                                if (DebugLogger.debugEnabled()) {
                                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                                }
                                Message message = PluginMessages.ERR_PLUGIN_PWPIMPORT_ERROR_ENCODING_PASSWORD.get(policy.getPasswordAttribute().getNameOrOID(), String.valueOf(entry.getDN()), StaticUtils.stackTraceToSingleLineString(e));
                                ErrorLogger.logError(message);
                                encodedValueList.clear();
                                break;
                            }
                        }
                        if (UserPasswordSyntax.isEncoded(value2)) continue;
                        try {
                            for (PasswordStorageScheme s : schemes) {
                                encodedValueList.add(s.encodePasswordWithScheme(value2));
                            }
                            iterator2.remove();
                        }
                        catch (Exception e) {
                            if (DebugLogger.debugEnabled()) {
                                TRACER.debugCaught(DebugLogLevel.ERROR, e);
                            }
                            Message message = PluginMessages.ERR_PLUGIN_PWPIMPORT_ERROR_ENCODING_PASSWORD.get(policy.getPasswordAttribute().getNameOrOID(), String.valueOf(entry.getDN()), StaticUtils.stackTraceToSingleLineString(e));
                            ErrorLogger.logError(message);
                            encodedValueList.clear();
                            break;
                        }
                    }
                    for (ByteString s : encodedValueList) {
                        values2.add(new AttributeValue(policy.getPasswordAttribute(), s));
                    }
                }
                return LDIFPluginResult.SUCCESS;
            }
        }
        for (AttributeType t : this.authPasswordTypes) {
            attrList = entry.getAttribute(t);
            if (attrList == null || attrList.isEmpty()) continue;
            for (Attribute a : attrList) {
                encodedValueList.clear();
                values = a.getValues();
                iterator = values.iterator();
                while (iterator.hasNext()) {
                    v = (AttributeValue)iterator.next();
                    value = v.getValue();
                    if (AuthPasswordSyntax.isEncoded(value)) continue;
                    try {
                        for (PasswordStorageScheme s : this.defaultAuthPasswordSchemes) {
                            encodedValueList.add(s.encodeAuthPassword(value));
                        }
                        iterator.remove();
                    }
                    catch (Exception e) {
                        if (DebugLogger.debugEnabled()) {
                            TRACER.debugCaught(DebugLogLevel.ERROR, e);
                        }
                        Message message = PluginMessages.ERR_PLUGIN_PWPIMPORT_ERROR_ENCODING_PASSWORD.get(t.getNameOrOID(), String.valueOf(entry.getDN()), StaticUtils.stackTraceToSingleLineString(e));
                        ErrorLogger.logError(message);
                        encodedValueList.clear();
                        break;
                    }
                }
                for (ByteString s : encodedValueList) {
                    values.add(new AttributeValue(t, s));
                }
            }
        }
        for (AttributeType t : this.userPasswordTypes) {
            attrList = entry.getAttribute(t);
            if (attrList == null || attrList.isEmpty()) continue;
            for (Attribute a : attrList) {
                encodedValueList.clear();
                values = a.getValues();
                iterator = values.iterator();
                while (iterator.hasNext()) {
                    v = (AttributeValue)iterator.next();
                    value = v.getValue();
                    if (UserPasswordSyntax.isEncoded(value)) continue;
                    try {
                        for (PasswordStorageScheme s : this.defaultUserPasswordSchemes) {
                            encodedValueList.add(s.encodePasswordWithScheme(value));
                        }
                        iterator.remove();
                    }
                    catch (Exception e) {
                        if (DebugLogger.debugEnabled()) {
                            TRACER.debugCaught(DebugLogLevel.ERROR, e);
                        }
                        Message message = PluginMessages.ERR_PLUGIN_PWPIMPORT_ERROR_ENCODING_PASSWORD.get(t.getNameOrOID(), String.valueOf(entry.getDN()), StaticUtils.stackTraceToSingleLineString(e));
                        ErrorLogger.logError(message);
                        encodedValueList.clear();
                        break;
                    }
                }
                for (ByteString s : encodedValueList) {
                    values.add(new AttributeValue(t, s));
                }
            }
        }
        return LDIFPluginResult.SUCCESS;
    }

    @Override
    public boolean isConfigurationAcceptable(PluginCfg configuration, List<Message> unacceptableReasons) {
        PasswordPolicyImportPluginCfg config = (PasswordPolicyImportPluginCfg)configuration;
        return this.isConfigurationChangeAcceptable(config, unacceptableReasons);
    }

    @Override
    public boolean isConfigurationChangeAcceptable(PasswordPolicyImportPluginCfg configuration, List<Message> unacceptableReasons) {
        PasswordStorageScheme[] defaultAuthSchemes;
        Message message;
        boolean configAcceptable = true;
        block3: for (PluginCfgDefn.PluginType pluginType : configuration.getPluginType()) {
            switch (pluginType) {
                case LDIFIMPORT: {
                    continue block3;
                }
            }
            message = PluginMessages.ERR_PLUGIN_PWPIMPORT_INVALID_PLUGIN_TYPE.get(pluginType.toString());
            unacceptableReasons.add(message);
            configAcceptable = false;
        }
        SortedSet<String> authSchemesSet = configuration.getDefaultAuthPasswordStorageScheme();
        if (authSchemesSet == null || authSchemesSet.isEmpty()) {
            defaultAuthSchemes = new PasswordStorageScheme[]{DirectoryServer.getAuthPasswordStorageScheme("SHA1")};
            if (defaultAuthSchemes[0] == null) {
                message = PluginMessages.ERR_PLUGIN_PWIMPORT_NO_DEFAULT_AUTH_SCHEMES.get("SHA1");
                unacceptableReasons.add(message);
                configAcceptable = false;
            }
        } else {
            defaultAuthSchemes = new PasswordStorageScheme[authSchemesSet.size()];
            int i = 0;
            for (String schemeName : authSchemesSet) {
                defaultAuthSchemes[i] = DirectoryServer.getAuthPasswordStorageScheme(schemeName);
                if (defaultAuthSchemes[i] == null) {
                    Message message2 = PluginMessages.ERR_PLUGIN_PWIMPORT_INVALID_DEFAULT_AUTH_SCHEME.get(schemeName);
                    unacceptableReasons.add(message2);
                    configAcceptable = false;
                }
                ++i;
            }
        }
        SortedSet<String> userSchemeSet = configuration.getDefaultUserPasswordStorageScheme();
        if (userSchemeSet == null || userSchemeSet.isEmpty()) {
            PasswordStorageScheme[] defaultUserSchemes = new PasswordStorageScheme[]{DirectoryServer.getPasswordStorageScheme(StaticUtils.toLowerCase("SSHA"))};
            if (defaultUserSchemes[0] == null) {
                Message message3 = PluginMessages.ERR_PLUGIN_PWIMPORT_NO_DEFAULT_USER_SCHEMES.get("SSHA");
                unacceptableReasons.add(message3);
                configAcceptable = false;
            }
        } else {
            PasswordStorageScheme[] defaultUserSchemes = new PasswordStorageScheme[userSchemeSet.size()];
            int i = 0;
            for (String schemeName : userSchemeSet) {
                defaultUserSchemes[i] = DirectoryServer.getPasswordStorageScheme(StaticUtils.toLowerCase(schemeName));
                if (defaultUserSchemes[i] == null) {
                    Message message4 = PluginMessages.ERR_PLUGIN_PWIMPORT_INVALID_DEFAULT_USER_SCHEME.get(schemeName);
                    unacceptableReasons.add(message4);
                    configAcceptable = false;
                }
                ++i;
            }
        }
        return configAcceptable;
    }

    @Override
    public ConfigChangeResult applyConfigurationChange(PasswordPolicyImportPluginCfg configuration) {
        PasswordStorageScheme[] defaultUserSchemes;
        PasswordStorageScheme[] defaultAuthSchemes;
        ArrayList<Message> messages;
        boolean adminActionRequired;
        ResultCode resultCode;
        block10: {
            SortedSet<String> userSchemeSet;
            block8: {
                block9: {
                    PasswordPolicy defaultPolicy;
                    block7: {
                        SortedSet<String> authSchemesSet;
                        block5: {
                            block6: {
                                resultCode = ResultCode.SUCCESS;
                                adminActionRequired = false;
                                messages = new ArrayList<Message>();
                                defaultPolicy = DirectoryServer.getDefaultPasswordPolicy();
                                authSchemesSet = configuration.getDefaultAuthPasswordStorageScheme();
                                if (authSchemesSet != null && !authSchemesSet.isEmpty()) break block5;
                                if (!defaultPolicy.usesAuthPasswordSyntax()) break block6;
                                CopyOnWriteArrayList<PasswordStorageScheme> schemeList = defaultPolicy.getDefaultStorageSchemes();
                                defaultAuthSchemes = new PasswordStorageScheme[schemeList.size()];
                                schemeList.toArray(defaultAuthSchemes);
                                break block7;
                            }
                            defaultAuthSchemes = new PasswordStorageScheme[]{DirectoryServer.getAuthPasswordStorageScheme("SHA1")};
                            if (defaultAuthSchemes[0] != null) break block7;
                            resultCode = DirectoryServer.getServerErrorResultCode();
                            messages.add(PluginMessages.ERR_PLUGIN_PWIMPORT_NO_DEFAULT_AUTH_SCHEMES.get("SHA1"));
                            break block7;
                        }
                        defaultAuthSchemes = new PasswordStorageScheme[authSchemesSet.size()];
                        int i = 0;
                        for (String schemeName : authSchemesSet) {
                            defaultAuthSchemes[i] = DirectoryServer.getAuthPasswordStorageScheme(schemeName);
                            if (defaultAuthSchemes[i] == null) {
                                resultCode = DirectoryServer.getServerErrorResultCode();
                                messages.add(PluginMessages.ERR_PLUGIN_PWIMPORT_INVALID_DEFAULT_AUTH_SCHEME.get(schemeName));
                            }
                            ++i;
                        }
                    }
                    userSchemeSet = configuration.getDefaultUserPasswordStorageScheme();
                    if (userSchemeSet != null && !userSchemeSet.isEmpty()) break block8;
                    if (defaultPolicy.usesAuthPasswordSyntax()) break block9;
                    CopyOnWriteArrayList<PasswordStorageScheme> schemeList = defaultPolicy.getDefaultStorageSchemes();
                    defaultUserSchemes = new PasswordStorageScheme[schemeList.size()];
                    schemeList.toArray(defaultUserSchemes);
                    break block10;
                }
                defaultUserSchemes = new PasswordStorageScheme[]{DirectoryServer.getPasswordStorageScheme(StaticUtils.toLowerCase("SSHA"))};
                if (defaultUserSchemes[0] != null) break block10;
                resultCode = DirectoryServer.getServerErrorResultCode();
                messages.add(PluginMessages.ERR_PLUGIN_PWIMPORT_NO_DEFAULT_USER_SCHEMES.get("SSHA"));
                break block10;
            }
            defaultUserSchemes = new PasswordStorageScheme[userSchemeSet.size()];
            int i = 0;
            for (String schemeName : userSchemeSet) {
                defaultUserSchemes[i] = DirectoryServer.getPasswordStorageScheme(StaticUtils.toLowerCase(schemeName));
                if (defaultUserSchemes[i] == null) {
                    resultCode = DirectoryServer.getServerErrorResultCode();
                    messages.add(PluginMessages.ERR_PLUGIN_PWIMPORT_INVALID_DEFAULT_USER_SCHEME.get(schemeName));
                }
                ++i;
            }
        }
        if (resultCode == ResultCode.SUCCESS) {
            this.defaultAuthPasswordSchemes = defaultAuthSchemes;
            this.defaultUserPasswordSchemes = defaultUserSchemes;
        }
        return new ConfigChangeResult(resultCode, adminActionRequired, messages);
    }
}

