/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.loggers;

import java.io.File;
import java.io.FilenameFilter;
import org.opends.server.loggers.FileNamingPolicy;
import org.opends.server.util.TimeThread;

public class TimeStampNaming
implements FileNamingPolicy {
    File file;

    public TimeStampNaming(File file) {
        this.file = file;
    }

    public File getInitialName() {
        return this.file;
    }

    public File getNextName() {
        return new File(this.file + "." + TimeThread.getGMTTime());
    }

    public FilenameFilter getFilenameFilter() {
        return new TimeStampNamingFilter();
    }

    public File[] listFiles() {
        File directory = this.file.getParentFile();
        return directory.listFiles(this.getFilenameFilter());
    }

    private class TimeStampNamingFilter
    implements FilenameFilter {
        private TimeStampNamingFilter() {
        }

        public boolean accept(File dir, String name) {
            if (new File(dir, name).isDirectory()) {
                return false;
            }
            name = name.toLowerCase();
            return name.startsWith(TimeStampNaming.this.file.getName().toLowerCase());
        }
    }
}

