/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.loggers;

import java.util.ArrayList;
import java.util.List;
import org.opends.messages.Message;
import org.opends.server.admin.server.ConfigurationChangeListener;
import org.opends.server.admin.std.server.TimeLimitLogRotationPolicyCfg;
import org.opends.server.loggers.MultifileTextWriter;
import org.opends.server.loggers.RotationPolicy;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.ResultCode;
import org.opends.server.util.TimeThread;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TimeLimitRotationPolicy
implements RotationPolicy<TimeLimitLogRotationPolicyCfg>,
ConfigurationChangeListener<TimeLimitLogRotationPolicyCfg> {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private long timeInterval = 0L;

    @Override
    public void initializeLogRotationPolicy(TimeLimitLogRotationPolicyCfg config) {
        this.timeInterval = config.getRotationInterval();
        config.addTimeLimitChangeListener(this);
    }

    @Override
    public boolean isConfigurationChangeAcceptable(TimeLimitLogRotationPolicyCfg config, List<Message> unacceptableReasons) {
        return true;
    }

    @Override
    public ConfigChangeResult applyConfigurationChange(TimeLimitLogRotationPolicyCfg config) {
        ResultCode resultCode = ResultCode.SUCCESS;
        boolean adminActionRequired = false;
        ArrayList<Message> messages = new ArrayList<Message>();
        this.timeInterval = config.getRotationInterval();
        return new ConfigChangeResult(resultCode, adminActionRequired, messages);
    }

    @Override
    public boolean rotateFile(MultifileTextWriter writer) {
        long currTime = TimeThread.getTime();
        long currInterval = currTime - writer.getLastRotationTime();
        if (DebugLogger.debugEnabled()) {
            TRACER.debugInfo("Last rotation occurred %ds ago. Next rotation in %ds", currInterval / 1000L, (this.timeInterval - currInterval) / 1000L);
        }
        return currInterval > this.timeInterval;
    }
}

