/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.loggers;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.SortedSet;
import java.util.StringTokenizer;
import org.opends.messages.Category;
import org.opends.messages.ConfigMessages;
import org.opends.messages.LoggerMessages;
import org.opends.messages.Message;
import org.opends.messages.Severity;
import org.opends.server.admin.server.ConfigurationChangeListener;
import org.opends.server.admin.std.meta.ErrorLogPublisherCfgDefn;
import org.opends.server.admin.std.server.ErrorLogPublisherCfg;
import org.opends.server.admin.std.server.FileBasedErrorLogPublisherCfg;
import org.opends.server.api.ErrorLogPublisher;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.AsyncronousTextWriter;
import org.opends.server.loggers.LogPublisherErrorHandler;
import org.opends.server.loggers.MultifileTextWriter;
import org.opends.server.loggers.RetentionPolicy;
import org.opends.server.loggers.RotationPolicy;
import org.opends.server.loggers.TextWriter;
import org.opends.server.loggers.TimeStampNaming;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.DN;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.FilePermission;
import org.opends.server.types.InitializationException;
import org.opends.server.types.ResultCode;
import org.opends.server.util.StaticUtils;
import org.opends.server.util.TimeThread;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextErrorLogPublisher
extends ErrorLogPublisher<FileBasedErrorLogPublisherCfg>
implements ConfigurationChangeListener<FileBasedErrorLogPublisherCfg> {
    private TextWriter writer;
    private FileBasedErrorLogPublisherCfg currentConfig;

    public static TextErrorLogPublisher getStartupTextErrorPublisher(TextWriter writer) {
        TextErrorLogPublisher startupPublisher = new TextErrorLogPublisher();
        startupPublisher.writer = writer;
        startupPublisher.defaultSeverities.add(Severity.FATAL_ERROR);
        startupPublisher.defaultSeverities.add(Severity.SEVERE_ERROR);
        startupPublisher.defaultSeverities.add(Severity.SEVERE_WARNING);
        startupPublisher.defaultSeverities.add(Severity.NOTICE);
        return startupPublisher;
    }

    @Override
    public void initializeErrorLogPublisher(FileBasedErrorLogPublisherCfg config) throws ConfigException, InitializationException {
        File logFile = StaticUtils.getFileForPath(config.getLogFile());
        TimeStampNaming fnPolicy = new TimeStampNaming(logFile);
        try {
            Object policy;
            FilePermission perm = FilePermission.decodeUNIXMode(config.getLogFileMode());
            LogPublisherErrorHandler errorHandler = new LogPublisherErrorHandler(config.dn());
            boolean writerAutoFlush = config.isAutoFlush() && !config.isAsynchronous();
            MultifileTextWriter writer = new MultifileTextWriter("Multifile Text Writer for " + config.dn().toNormalizedString(), config.getTimeInterval(), fnPolicy, perm, errorHandler, "UTF-8", writerAutoFlush, config.isAppend(), (int)config.getBufferSize());
            for (DN dn : config.getRotationPolicyDN()) {
                policy = DirectoryServer.getRotationPolicy(dn);
                if (policy != null) {
                    writer.addRotationPolicy((RotationPolicy)policy);
                    continue;
                }
                Message message = ConfigMessages.ERR_CONFIG_LOGGER_INVALID_ROTATION_POLICY.get(dn.toString(), config.dn().toString());
                throw new ConfigException(message);
            }
            for (DN dn : config.getRetentionPolicyDN()) {
                policy = DirectoryServer.getRetentionPolicy(dn);
                if (policy != null) {
                    writer.addRetentionPolicy((RetentionPolicy)policy);
                    continue;
                }
                Message message = ConfigMessages.WARN_CONFIG_LOGGER_INVALID_RETENTION_POLICY.get(dn.toString(), config.dn().toString());
                throw new ConfigException(message);
            }
            this.writer = config.isAsynchronous() ? new AsyncronousTextWriter("Asyncronous Text Writer for " + config.dn().toNormalizedString(), config.getQueueSize(), config.isAutoFlush(), writer) : writer;
        }
        catch (DirectoryException e) {
            Message message = ConfigMessages.ERR_CONFIG_LOGGING_CANNOT_CREATE_WRITER.get(config.dn().toString(), String.valueOf(e));
            throw new InitializationException(message, (Throwable)e);
        }
        catch (IOException e) {
            Message message = ConfigMessages.ERR_CONFIG_LOGGING_CANNOT_CREATE_WRITER.get(config.dn().toString(), String.valueOf(e));
            throw new InitializationException(message, (Throwable)e);
        }
        SortedSet<ErrorLogPublisherCfgDefn.DefaultSeverity> defSevs = config.getDefaultSeverity();
        if (defSevs.isEmpty()) {
            this.defaultSeverities.add(Severity.FATAL_ERROR);
            this.defaultSeverities.add(Severity.SEVERE_ERROR);
            this.defaultSeverities.add(Severity.SEVERE_WARNING);
        } else {
            for (ErrorLogPublisherCfgDefn.DefaultSeverity defSev : defSevs) {
                Severity errorSeverity;
                if (defSev.toString().equalsIgnoreCase("all")) {
                    this.defaultSeverities.add(Severity.FATAL_ERROR);
                    this.defaultSeverities.add(Severity.INFORMATION);
                    this.defaultSeverities.add(Severity.MILD_ERROR);
                    this.defaultSeverities.add(Severity.MILD_WARNING);
                    this.defaultSeverities.add(Severity.NOTICE);
                    this.defaultSeverities.add(Severity.SEVERE_ERROR);
                    this.defaultSeverities.add(Severity.SEVERE_WARNING);
                    continue;
                }
                if (defSev.toString().equalsIgnoreCase("none") || (errorSeverity = Severity.parseString(defSev.name())) == null) continue;
                this.defaultSeverities.add(errorSeverity);
            }
        }
        for (String overrideSeverity : config.getOverrideSeverity()) {
            if (overrideSeverity == null) continue;
            int equalPos = overrideSeverity.indexOf(61);
            if (equalPos < 0) {
                Message msg = LoggerMessages.WARN_ERROR_LOGGER_INVALID_OVERRIDE_SEVERITY.get(overrideSeverity);
                throw new ConfigException(msg);
            }
            String categoryName = overrideSeverity.substring(0, equalPos);
            Category category = Category.valueOf(categoryName);
            if (category == null) {
                Message msg = LoggerMessages.WARN_ERROR_LOGGER_INVALID_CATEGORY.get(categoryName);
                throw new ConfigException(msg);
            }
            HashSet<Severity> severities = new HashSet<Severity>();
            StringTokenizer sevTokenizer = new StringTokenizer(overrideSeverity.substring(equalPos + 1), ",");
            while (sevTokenizer.hasMoreElements()) {
                String severityName = sevTokenizer.nextToken();
                if (severityName.equalsIgnoreCase("all")) {
                    severities.add(Severity.FATAL_ERROR);
                    severities.add(Severity.INFORMATION);
                    severities.add(Severity.MILD_ERROR);
                    severities.add(Severity.MILD_WARNING);
                    severities.add(Severity.NOTICE);
                    severities.add(Severity.SEVERE_ERROR);
                    severities.add(Severity.SEVERE_WARNING);
                    continue;
                }
                Severity severity = Severity.parseString(severityName);
                if (severity == null) {
                    Message msg = LoggerMessages.WARN_ERROR_LOGGER_INVALID_SEVERITY.get(severityName);
                    throw new ConfigException(msg);
                }
                severities.add(severity);
            }
            this.definedSeverities.put(category, severities);
        }
        this.currentConfig = config;
        config.addFileBasedErrorChangeListener(this);
    }

    @Override
    public boolean isConfigurationAcceptable(ErrorLogPublisherCfg configuration, List<Message> unacceptableReasons) {
        Object policy;
        FileBasedErrorLogPublisherCfg config = (FileBasedErrorLogPublisherCfg)configuration;
        for (DN dn : config.getRotationPolicyDN()) {
            policy = DirectoryServer.getRotationPolicy(dn);
            if (policy != null) continue;
            Message message = ConfigMessages.ERR_CONFIG_LOGGER_INVALID_ROTATION_POLICY.get(dn.toString(), config.dn().toString());
            unacceptableReasons.add(message);
            return false;
        }
        for (DN dn : config.getRetentionPolicyDN()) {
            policy = DirectoryServer.getRetentionPolicy(dn);
            if (policy != null) continue;
            Message message = ConfigMessages.WARN_CONFIG_LOGGER_INVALID_RETENTION_POLICY.get(dn.toString(), config.dn().toString());
            unacceptableReasons.add(message);
            return false;
        }
        for (String overrideSeverity : config.getOverrideSeverity()) {
            if (overrideSeverity == null) continue;
            int equalPos = overrideSeverity.indexOf(61);
            if (equalPos < 0) {
                Message msg = LoggerMessages.WARN_ERROR_LOGGER_INVALID_OVERRIDE_SEVERITY.get(overrideSeverity);
                unacceptableReasons.add(msg);
                return false;
            }
            String categoryName = overrideSeverity.substring(0, equalPos);
            Category category = Category.valueOf(categoryName);
            if (category == null) {
                Message msg = LoggerMessages.WARN_ERROR_LOGGER_INVALID_CATEGORY.get(categoryName);
                unacceptableReasons.add(msg);
                return false;
            }
            StringTokenizer sevTokenizer = new StringTokenizer(overrideSeverity.substring(equalPos + 1), ",");
            while (sevTokenizer.hasMoreElements()) {
                Severity severity;
                String severityName = sevTokenizer.nextToken();
                if (severityName.equalsIgnoreCase("all") || (severity = Severity.parseString(severityName)) != null) continue;
                Message msg = LoggerMessages.WARN_ERROR_LOGGER_INVALID_SEVERITY.get(severityName);
                unacceptableReasons.add(msg);
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean isConfigurationChangeAcceptable(FileBasedErrorLogPublisherCfg config, List<Message> unacceptableReasons) {
        try {
            File logFile;
            if (!this.currentConfig.getLogFileMode().equalsIgnoreCase(config.getLogFileMode())) {
                FilePermission.decodeUNIXMode(config.getLogFileMode());
            }
            if (!this.currentConfig.getLogFile().equalsIgnoreCase(config.getLogFile()) && (logFile = StaticUtils.getFileForPath(config.getLogFile())).createNewFile()) {
                logFile.delete();
            }
        }
        catch (Exception e) {
            Message message = ConfigMessages.ERR_CONFIG_LOGGING_CANNOT_CREATE_WRITER.get(config.dn().toString(), StaticUtils.stackTraceToSingleLineString(e));
            unacceptableReasons.add(message);
            return false;
        }
        return this.isConfigurationAcceptable(config, unacceptableReasons);
    }

    @Override
    public ConfigChangeResult applyConfigurationChange(FileBasedErrorLogPublisherCfg config) {
        ResultCode resultCode = ResultCode.SUCCESS;
        boolean adminActionRequired = false;
        ArrayList<Message> messages = new ArrayList<Message>();
        SortedSet<ErrorLogPublisherCfgDefn.DefaultSeverity> defSevs = config.getDefaultSeverity();
        this.defaultSeverities.clear();
        if (defSevs.isEmpty()) {
            this.defaultSeverities.add(Severity.FATAL_ERROR);
            this.defaultSeverities.add(Severity.SEVERE_ERROR);
            this.defaultSeverities.add(Severity.SEVERE_WARNING);
        } else {
            for (ErrorLogPublisherCfgDefn.DefaultSeverity defSev : defSevs) {
                Severity errorSeverity;
                if (defSev.toString().equalsIgnoreCase("all")) {
                    this.defaultSeverities.add(Severity.FATAL_ERROR);
                    this.defaultSeverities.add(Severity.INFORMATION);
                    this.defaultSeverities.add(Severity.MILD_ERROR);
                    this.defaultSeverities.add(Severity.MILD_WARNING);
                    this.defaultSeverities.add(Severity.NOTICE);
                    this.defaultSeverities.add(Severity.SEVERE_ERROR);
                    this.defaultSeverities.add(Severity.SEVERE_WARNING);
                    continue;
                }
                if (defSev.toString().equalsIgnoreCase("none") || (errorSeverity = Severity.parseString(defSev.name())) == null) continue;
                this.defaultSeverities.add(errorSeverity);
            }
        }
        this.definedSeverities.clear();
        for (String overrideSeverity : config.getOverrideSeverity()) {
            if (overrideSeverity == null) continue;
            int equalPos = overrideSeverity.indexOf(61);
            if (equalPos < 0) {
                Message msg = LoggerMessages.WARN_ERROR_LOGGER_INVALID_OVERRIDE_SEVERITY.get(overrideSeverity);
                resultCode = DirectoryServer.getServerErrorResultCode();
                messages.add(msg);
                continue;
            }
            String categoryName = overrideSeverity.substring(0, equalPos);
            Category category = Category.valueOf(categoryName);
            if (category == null) {
                Message msg = LoggerMessages.WARN_ERROR_LOGGER_INVALID_CATEGORY.get(categoryName);
                resultCode = DirectoryServer.getServerErrorResultCode();
                messages.add(msg);
                continue;
            }
            HashSet<Severity> severities = new HashSet<Severity>();
            StringTokenizer sevTokenizer = new StringTokenizer(overrideSeverity.substring(equalPos + 1), ",");
            while (sevTokenizer.hasMoreElements()) {
                String severityName = sevTokenizer.nextToken();
                if (severityName.equalsIgnoreCase("all")) {
                    severities.add(Severity.FATAL_ERROR);
                    severities.add(Severity.INFORMATION);
                    severities.add(Severity.MILD_ERROR);
                    severities.add(Severity.MILD_WARNING);
                    severities.add(Severity.NOTICE);
                    severities.add(Severity.SEVERE_ERROR);
                    severities.add(Severity.SEVERE_WARNING);
                    continue;
                }
                Severity severity = Severity.parseString(severityName);
                if (severity == null) {
                    Message msg = LoggerMessages.WARN_ERROR_LOGGER_INVALID_SEVERITY.get(severityName);
                    resultCode = DirectoryServer.getServerErrorResultCode();
                    messages.add(msg);
                    continue;
                }
                severities.add(severity);
            }
            this.definedSeverities.put(category, severities);
        }
        File logFile = StaticUtils.getFileForPath(config.getLogFile());
        TimeStampNaming fnPolicy = new TimeStampNaming(logFile);
        try {
            FilePermission perm = FilePermission.decodeUNIXMode(config.getLogFileMode());
            boolean writerAutoFlush = config.isAutoFlush() && !config.isAsynchronous();
            TextWriter currentWriter = this.writer instanceof AsyncronousTextWriter ? ((AsyncronousTextWriter)this.writer).getWrappedWriter() : this.writer;
            if (currentWriter instanceof MultifileTextWriter) {
                AsyncronousTextWriter asyncWriter;
                Message message;
                Object policy;
                MultifileTextWriter mfWriter = (MultifileTextWriter)this.writer;
                mfWriter.setNamingPolicy(fnPolicy);
                mfWriter.setFilePermissions(perm);
                mfWriter.setAppend(config.isAppend());
                mfWriter.setAutoFlush(writerAutoFlush);
                mfWriter.setBufferSize((int)config.getBufferSize());
                mfWriter.setInterval(config.getTimeInterval());
                mfWriter.removeAllRetentionPolicies();
                mfWriter.removeAllRotationPolicies();
                for (DN dn : config.getRotationPolicyDN()) {
                    policy = DirectoryServer.getRotationPolicy(dn);
                    if (policy != null) {
                        mfWriter.addRotationPolicy((RotationPolicy)policy);
                        continue;
                    }
                    message = ConfigMessages.ERR_CONFIG_LOGGER_INVALID_ROTATION_POLICY.get(dn.toString(), config.dn().toString());
                    resultCode = DirectoryServer.getServerErrorResultCode();
                    messages.add(message);
                }
                for (DN dn : config.getRetentionPolicyDN()) {
                    policy = DirectoryServer.getRetentionPolicy(dn);
                    if (policy != null) {
                        mfWriter.addRetentionPolicy((RetentionPolicy)policy);
                        continue;
                    }
                    message = ConfigMessages.WARN_CONFIG_LOGGER_INVALID_RETENTION_POLICY.get(dn.toString(), config.dn().toString());
                    resultCode = DirectoryServer.getServerErrorResultCode();
                    messages.add(message);
                }
                if (this.writer instanceof AsyncronousTextWriter && !config.isAsynchronous()) {
                    asyncWriter = (AsyncronousTextWriter)this.writer;
                    this.writer = mfWriter;
                    asyncWriter.shutdown(false);
                }
                if (!(this.writer instanceof AsyncronousTextWriter) && config.isAsynchronous()) {
                    asyncWriter = new AsyncronousTextWriter("Asyncronous Text Writer for " + config.dn().toNormalizedString(), config.getQueueSize(), config.isAutoFlush(), mfWriter);
                    this.writer = asyncWriter;
                }
                if (this.currentConfig.isAsynchronous() && config.isAsynchronous() && this.currentConfig.getQueueSize() != config.getQueueSize()) {
                    adminActionRequired = true;
                }
                this.currentConfig = config;
            }
        }
        catch (Exception e) {
            Message message = ConfigMessages.ERR_CONFIG_LOGGING_CANNOT_CREATE_WRITER.get(config.dn().toString(), StaticUtils.stackTraceToSingleLineString(e));
            resultCode = DirectoryServer.getServerErrorResultCode();
            messages.add(message);
        }
        return new ConfigChangeResult(resultCode, adminActionRequired, messages);
    }

    @Override
    public void close() {
        this.writer.shutdown();
        if (this.currentConfig != null) {
            this.currentConfig.removeFileBasedErrorChangeListener(this);
        }
    }

    @Override
    public void logError(Message message) {
        Severity severity = message.getDescriptor().getSeverity();
        Category category = message.getDescriptor().getCategory();
        int msgId = message.getDescriptor().getId();
        HashSet severities = (HashSet)this.definedSeverities.get((Object)category);
        if (severities == null) {
            severities = this.defaultSeverities;
        }
        if (severities.contains((Object)severity)) {
            StringBuilder sb = new StringBuilder();
            sb.append("[");
            sb.append(TimeThread.getLocalTime());
            sb.append("] category=").append((Object)category).append(" severity=").append((Object)severity).append(" msgID=").append(msgId).append(" msg=").append(message);
            this.writer.writeRecord(sb.toString());
        }
    }

    @Override
    public DN getDN() {
        if (this.currentConfig != null) {
            return this.currentConfig.dn();
        }
        return null;
    }
}

