/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.loggers;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.opends.messages.Message;
import org.opends.server.admin.server.ConfigurationChangeListener;
import org.opends.server.admin.std.server.FileCountLogRetentionPolicyCfg;
import org.opends.server.loggers.FileComparator;
import org.opends.server.loggers.MultifileTextWriter;
import org.opends.server.loggers.RetentionPolicy;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.ResultCode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileNumberRetentionPolicy
implements RetentionPolicy<FileCountLogRetentionPolicyCfg>,
ConfigurationChangeListener<FileCountLogRetentionPolicyCfg> {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private int numFiles = 0;

    @Override
    public void initializeLogRetentionPolicy(FileCountLogRetentionPolicyCfg config) {
        this.numFiles = config.getNumberOfFiles();
        config.addFileCountChangeListener(this);
    }

    @Override
    public boolean isConfigurationChangeAcceptable(FileCountLogRetentionPolicyCfg config, List<Message> unacceptableReasons) {
        return true;
    }

    @Override
    public ConfigChangeResult applyConfigurationChange(FileCountLogRetentionPolicyCfg config) {
        ResultCode resultCode = ResultCode.SUCCESS;
        boolean adminActionRequired = false;
        ArrayList<Message> messages = new ArrayList<Message>();
        this.numFiles = config.getNumberOfFiles();
        return new ConfigChangeResult(resultCode, adminActionRequired, messages);
    }

    @Override
    public int deleteFiles(MultifileTextWriter writer) {
        int count = 0;
        File[] files = writer.getNamingPolicy().listFiles();
        if (files.length <= this.numFiles) {
            return 0;
        }
        Arrays.sort(files, new FileComparator());
        for (int j = this.numFiles; j < files.length; ++j) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugInfo("Deleting log file:", files[j]);
            }
            files[j].delete();
            ++count;
        }
        return count;
    }
}

