/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.extensions;

import java.util.List;
import java.util.Set;
import org.opends.messages.ExtensionMessages;
import org.opends.messages.Message;
import org.opends.messages.MessageBuilder;
import org.opends.server.admin.server.ConfigurationChangeListener;
import org.opends.server.admin.std.server.SimilarityBasedPasswordValidatorCfg;
import org.opends.server.api.PasswordValidator;
import org.opends.server.config.ConfigException;
import org.opends.server.types.ByteString;
import org.opends.server.types.ByteStringFactory;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.Entry;
import org.opends.server.types.InitializationException;
import org.opends.server.types.Operation;
import org.opends.server.types.ResultCode;
import org.opends.server.util.LevenshteinDistance;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimilarityBasedPasswordValidator
extends PasswordValidator<SimilarityBasedPasswordValidatorCfg>
implements ConfigurationChangeListener<SimilarityBasedPasswordValidatorCfg> {
    private SimilarityBasedPasswordValidatorCfg currentConfig;

    @Override
    public void initializePasswordValidator(SimilarityBasedPasswordValidatorCfg configuration) throws ConfigException, InitializationException {
        configuration.addSimilarityBasedChangeListener(this);
        this.currentConfig = configuration;
    }

    @Override
    public void finalizePasswordValidator() {
        this.currentConfig.removeSimilarityBasedChangeListener(this);
    }

    @Override
    public boolean passwordIsAcceptable(ByteString newPassword, Set<ByteString> currentPasswords, Operation operation, Entry userEntry, MessageBuilder invalidReason) {
        ByteString passwd;
        int minDifference = this.currentConfig.getMinimumPasswordDifference();
        ByteString byteString = passwd = newPassword == null ? ByteStringFactory.create("") : newPassword;
        if (currentPasswords == null || currentPasswords.size() == 0) {
            return true;
        }
        for (ByteString bs : currentPasswords) {
            int ldistance;
            if (bs == null || (ldistance = LevenshteinDistance.calculate(passwd.stringValue(), bs.stringValue())) >= minDifference) continue;
            invalidReason.append(ExtensionMessages.ERR_PWDIFFERENCEVALIDATOR_TOO_SMALL.get(minDifference));
            return false;
        }
        return true;
    }

    @Override
    public boolean isConfigurationChangeAcceptable(SimilarityBasedPasswordValidatorCfg configuration, List<Message> unacceptableReasons) {
        return true;
    }

    @Override
    public ConfigChangeResult applyConfigurationChange(SimilarityBasedPasswordValidatorCfg configuration) {
        this.currentConfig = configuration;
        return new ConfigChangeResult(ResultCode.SUCCESS, false);
    }
}

