/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.extensions;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.opends.messages.ExtensionMessages;
import org.opends.messages.Message;
import org.opends.messages.MessageBuilder;
import org.opends.server.admin.server.ConfigurationChangeListener;
import org.opends.server.admin.std.server.RepeatedCharactersPasswordValidatorCfg;
import org.opends.server.api.PasswordValidator;
import org.opends.server.types.ByteString;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.Entry;
import org.opends.server.types.Operation;
import org.opends.server.types.ResultCode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RepeatedCharactersPasswordValidator
extends PasswordValidator<RepeatedCharactersPasswordValidatorCfg>
implements ConfigurationChangeListener<RepeatedCharactersPasswordValidatorCfg> {
    private RepeatedCharactersPasswordValidatorCfg currentConfig;

    @Override
    public void initializePasswordValidator(RepeatedCharactersPasswordValidatorCfg configuration) {
        configuration.addRepeatedCharactersChangeListener(this);
        this.currentConfig = configuration;
    }

    @Override
    public void finalizePasswordValidator() {
        this.currentConfig.removeRepeatedCharactersChangeListener(this);
    }

    @Override
    public boolean passwordIsAcceptable(ByteString newPassword, Set<ByteString> currentPasswords, Operation operation, Entry userEntry, MessageBuilder invalidReason) {
        RepeatedCharactersPasswordValidatorCfg config = this.currentConfig;
        int maxRepeats = config.getMaximumConsecutiveLength();
        if (maxRepeats <= 0) {
            return true;
        }
        String passwordString = newPassword.stringValue();
        if (!config.isCaseSensitiveValidation()) {
            passwordString = passwordString.toLowerCase();
        }
        char lastCharacter = '\u0000';
        int consecutiveCount = 0;
        for (int i = 0; i < passwordString.length(); ++i) {
            char currentCharacter = passwordString.charAt(i);
            if (currentCharacter == lastCharacter) {
                if (++consecutiveCount <= maxRepeats) continue;
                Message message = ExtensionMessages.ERR_REPEATEDCHARS_VALIDATOR_TOO_MANY_CONSECUTIVE.get(maxRepeats);
                invalidReason.append(message);
                return false;
            }
            lastCharacter = currentCharacter;
            consecutiveCount = 1;
        }
        return true;
    }

    @Override
    public boolean isConfigurationChangeAcceptable(RepeatedCharactersPasswordValidatorCfg configuration, List<Message> unacceptableReasons) {
        return true;
    }

    @Override
    public ConfigChangeResult applyConfigurationChange(RepeatedCharactersPasswordValidatorCfg configuration) {
        ResultCode resultCode = ResultCode.SUCCESS;
        boolean adminActionRequired = false;
        ArrayList<Message> messages = new ArrayList<Message>();
        this.currentConfig = configuration;
        return new ConfigChangeResult(resultCode, adminActionRequired, messages);
    }
}

