/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.extensions;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.List;
import org.opends.messages.ExtensionMessages;
import org.opends.messages.Message;
import org.opends.server.admin.server.ConfigurationChangeListener;
import org.opends.server.admin.std.server.GSSAPISASLMechanismHandlerCfg;
import org.opends.server.admin.std.server.SASLMechanismHandlerCfg;
import org.opends.server.api.ClientConnection;
import org.opends.server.api.IdentityMapper;
import org.opends.server.api.SASLMechanismHandler;
import org.opends.server.config.ConfigException;
import org.opends.server.core.BindOperation;
import org.opends.server.core.DirectoryServer;
import org.opends.server.extensions.GSSAPIStateInfo;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.types.AuthenticationInfo;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.DN;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.Entry;
import org.opends.server.types.InitializationException;
import org.opends.server.types.ResultCode;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GSSAPISASLMechanismHandler
extends SASLMechanismHandler<GSSAPISASLMechanismHandlerCfg>
implements ConfigurationChangeListener<GSSAPISASLMechanismHandlerCfg> {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private DN configEntryDN;
    private GSSAPISASLMechanismHandlerCfg currentConfig;
    private IdentityMapper identityMapper;
    private String serverFQDN;

    @Override
    public void initializeSASLMechanismHandler(GSSAPISASLMechanismHandlerCfg configuration) throws ConfigException, InitializationException {
        String configFileName;
        configuration.addGSSAPIChangeListener(this);
        this.currentConfig = configuration;
        this.configEntryDN = configuration.dn();
        DN identityMapperDN = configuration.getIdentityMapperDN();
        this.identityMapper = DirectoryServer.getIdentityMapper(identityMapperDN);
        if (this.identityMapper == null) {
            Message message = ExtensionMessages.ERR_SASLGSSAPI_NO_SUCH_IDENTITY_MAPPER.get(String.valueOf(identityMapperDN), String.valueOf(this.configEntryDN));
            throw new ConfigException(message);
        }
        this.serverFQDN = configuration.getServerFqdn();
        if (this.serverFQDN == null) {
            try {
                this.serverFQDN = InetAddress.getLocalHost().getCanonicalHostName();
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                Message message = ExtensionMessages.ERR_SASLGSSAPI_CANNOT_GET_SERVER_FQDN.get(String.valueOf(this.configEntryDN), StaticUtils.getExceptionMessage(e));
                throw new InitializationException(message, (Throwable)e);
            }
        }
        try {
            File tempFile = File.createTempFile("login", "conf");
            configFileName = tempFile.getAbsolutePath();
            tempFile.deleteOnExit();
            BufferedWriter w = new BufferedWriter(new FileWriter(tempFile, false));
            w.write(this.getClass().getName() + " {");
            w.newLine();
            w.write("  com.sun.security.auth.module.Krb5LoginModule required storeKey=true useKeyTab=true ");
            String keyTabFile = configuration.getKeytab();
            if (keyTabFile != null) {
                w.write("keyTab=\"" + keyTabFile + "\" ");
            }
            w.write("principal=\"ldap/" + this.serverFQDN);
            String realm = configuration.getRealm();
            if (realm != null) {
                w.write("@" + realm);
            }
            w.write("\";");
            w.newLine();
            w.write("};");
            w.newLine();
            w.flush();
            w.close();
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = ExtensionMessages.ERR_SASLGSSAPI_CANNOT_CREATE_JAAS_CONFIG.get(StaticUtils.getExceptionMessage(e));
            throw new InitializationException(message, (Throwable)e);
        }
        System.setProperty("java.security.auth.login.config", configFileName);
        System.setProperty("javax.security.auth.useSubjectCredsOnly", "false");
        DirectoryServer.registerSASLMechanismHandler("GSSAPI", this);
    }

    @Override
    public void finalizeSASLMechanismHandler() {
        this.currentConfig.removeGSSAPIChangeListener(this);
        DirectoryServer.deregisterSASLMechanismHandler("GSSAPI");
    }

    @Override
    public void processSASLBind(BindOperation bindOperation) {
        ClientConnection clientConnection = bindOperation.getClientConnection();
        if (clientConnection == null) {
            Message message = ExtensionMessages.ERR_SASLGSSAPI_NO_CLIENT_CONNECTION.get();
            bindOperation.setAuthFailureReason(message);
            bindOperation.setResultCode(ResultCode.INVALID_CREDENTIALS);
            return;
        }
        GSSAPIStateInfo stateInfo = null;
        Object saslBindState = clientConnection.getSASLAuthStateInfo();
        if (saslBindState != null && saslBindState instanceof GSSAPIStateInfo) {
            stateInfo = (GSSAPIStateInfo)saslBindState;
        } else {
            try {
                stateInfo = new GSSAPIStateInfo(this, bindOperation, this.serverFQDN);
            }
            catch (InitializationException ie) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, ie);
                }
                bindOperation.setAuthFailureReason(ie.getMessageObject());
                bindOperation.setResultCode(ResultCode.INVALID_CREDENTIALS);
                clientConnection.setSASLAuthStateInfo(null);
                return;
            }
        }
        stateInfo.setBindOperation(bindOperation);
        stateInfo.processAuthenticationStage();
        if (bindOperation.getResultCode() == ResultCode.SUCCESS) {
            Entry userEntry = stateInfo.getUserEntry();
            AuthenticationInfo authInfo = new AuthenticationInfo(userEntry, "GSSAPI", DirectoryServer.isRootDN(userEntry.getDN()));
            bindOperation.setAuthenticationInfo(authInfo);
            bindOperation.setResultCode(ResultCode.SUCCESS);
            clientConnection.setSASLAuthStateInfo(null);
            try {
                stateInfo.dispose();
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
            }
        } else if (bindOperation.getResultCode() == ResultCode.SASL_BIND_IN_PROGRESS) {
            clientConnection.setSASLAuthStateInfo(stateInfo);
        } else {
            clientConnection.setSASLAuthStateInfo(null);
        }
    }

    public Entry getUserForAuthzID(BindOperation bindOperation, String authzID) throws DirectoryException {
        return this.identityMapper.getEntryForID(authzID);
    }

    @Override
    public boolean isPasswordBased(String mechanism) {
        return false;
    }

    @Override
    public boolean isSecure(String mechanism) {
        return true;
    }

    @Override
    public boolean isConfigurationAcceptable(SASLMechanismHandlerCfg configuration, List<Message> unacceptableReasons) {
        GSSAPISASLMechanismHandlerCfg config = (GSSAPISASLMechanismHandlerCfg)configuration;
        return this.isConfigurationChangeAcceptable(config, unacceptableReasons);
    }

    @Override
    public boolean isConfigurationChangeAcceptable(GSSAPISASLMechanismHandlerCfg configuration, List<Message> unacceptableReasons) {
        boolean configAcceptable = true;
        DN cfgEntryDN = configuration.dn();
        DN identityMapperDN = configuration.getIdentityMapperDN();
        IdentityMapper newIdentityMapper = DirectoryServer.getIdentityMapper(identityMapperDN);
        if (newIdentityMapper == null) {
            unacceptableReasons.add(ExtensionMessages.ERR_SASLGSSAPI_NO_SUCH_IDENTITY_MAPPER.get(String.valueOf(identityMapperDN), String.valueOf(cfgEntryDN)));
            configAcceptable = false;
        }
        return configAcceptable;
    }

    @Override
    public ConfigChangeResult applyConfigurationChange(GSSAPISASLMechanismHandlerCfg configuration) {
        String newFQDN;
        ResultCode resultCode = ResultCode.SUCCESS;
        boolean adminActionRequired = false;
        ArrayList<Message> messages = new ArrayList<Message>();
        DN identityMapperDN = configuration.getIdentityMapperDN();
        IdentityMapper newIdentityMapper = DirectoryServer.getIdentityMapper(identityMapperDN);
        if (newIdentityMapper == null) {
            if (resultCode == ResultCode.SUCCESS) {
                resultCode = ResultCode.CONSTRAINT_VIOLATION;
            }
            messages.add(ExtensionMessages.ERR_SASLGSSAPI_NO_SUCH_IDENTITY_MAPPER.get(String.valueOf(identityMapperDN), String.valueOf(this.configEntryDN)));
        }
        if ((newFQDN = configuration.getServerFqdn()) == null) {
            try {
                newFQDN = InetAddress.getLocalHost().getCanonicalHostName();
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                if (resultCode == ResultCode.SUCCESS) {
                    resultCode = DirectoryServer.getServerErrorResultCode();
                }
                messages.add(ExtensionMessages.ERR_SASLGSSAPI_CANNOT_GET_SERVER_FQDN.get(String.valueOf(this.configEntryDN), StaticUtils.getExceptionMessage(e)));
            }
        }
        if (resultCode == ResultCode.SUCCESS) {
            String configFileName;
            try {
                File tempFile = File.createTempFile("login", "conf");
                configFileName = tempFile.getAbsolutePath();
                tempFile.deleteOnExit();
                BufferedWriter w = new BufferedWriter(new FileWriter(tempFile, false));
                w.write(this.getClass().getName() + " {");
                w.newLine();
                w.write("  com.sun.security.auth.module.Krb5LoginModule required storeKey=true useKeyTab=true ");
                String keyTabFile = configuration.getKeytab();
                if (keyTabFile != null) {
                    w.write("keyTab=\"" + keyTabFile + "\" ");
                }
                w.write("principal=\"ldap/" + this.serverFQDN);
                String realm = configuration.getRealm();
                if (realm != null) {
                    w.write("@" + realm);
                }
                w.write("\";");
                w.newLine();
                w.write("};");
                w.newLine();
                w.flush();
                w.close();
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                resultCode = DirectoryServer.getServerErrorResultCode();
                messages.add(ExtensionMessages.ERR_SASLGSSAPI_CANNOT_CREATE_JAAS_CONFIG.get(StaticUtils.getExceptionMessage(e)));
                return new ConfigChangeResult(resultCode, adminActionRequired, messages);
            }
            System.setProperty("java.security.auth.login.config", configFileName);
            this.identityMapper = newIdentityMapper;
            this.serverFQDN = newFQDN;
            this.currentConfig = configuration;
        }
        return new ConfigChangeResult(resultCode, adminActionRequired, messages);
    }
}

