/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.extensions;

import java.util.Arrays;
import java.util.Random;
import java.util.concurrent.locks.ReentrantLock;
import org.opends.messages.ExtensionMessages;
import org.opends.messages.Message;
import org.opends.server.admin.std.server.PasswordStorageSchemeCfg;
import org.opends.server.api.PasswordStorageScheme;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.types.ByteString;
import org.opends.server.types.ByteStringFactory;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.InitializationException;
import org.opends.server.types.ResultCode;
import org.opends.server.util.Crypt;
import org.opends.server.util.StaticUtils;

public class CryptPasswordStorageScheme
extends PasswordStorageScheme {
    private static final String CLASS_NAME = "org.opends.server.extensions.CryptPasswordStorageScheme";
    private static final byte[] SALT_CHARS = "./0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ".getBytes();
    private final Random randomSaltIndex = new Random();
    private final ReentrantLock saltLock = new ReentrantLock();
    private final Crypt crypt = new Crypt();

    public void initializePasswordStorageScheme(PasswordStorageSchemeCfg configuration) throws ConfigException, InitializationException {
    }

    public String getStorageSchemeName() {
        return "CRYPT";
    }

    public ByteString encodePassword(ByteString plaintext) throws DirectoryException {
        byte[] digestBytes;
        try {
            digestBytes = this.crypt.crypt(plaintext.value(), this.randomSalt());
        }
        catch (Exception e) {
            Message message = ExtensionMessages.ERR_PWSCHEME_CANNOT_ENCODE_PASSWORD.get(CLASS_NAME, StaticUtils.stackTraceToSingleLineString(e));
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message, e);
        }
        return ByteStringFactory.create(digestBytes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] randomSalt() {
        this.saltLock.lock();
        try {
            byte[] salt = new byte[2];
            int sb1 = this.randomSaltIndex.nextInt(SALT_CHARS.length);
            int sb2 = this.randomSaltIndex.nextInt(SALT_CHARS.length);
            salt[0] = SALT_CHARS[sb1];
            salt[1] = SALT_CHARS[sb2];
            byte[] byArray = salt;
            return byArray;
        }
        finally {
            this.saltLock.unlock();
        }
    }

    public ByteString encodePasswordWithScheme(ByteString plaintext) throws DirectoryException {
        StringBuilder buffer = new StringBuilder("CRYPT".length() + 12);
        buffer.append('{');
        buffer.append("CRYPT");
        buffer.append('}');
        buffer.append(this.encodePassword(plaintext));
        return ByteStringFactory.create(buffer.toString());
    }

    public boolean passwordMatches(ByteString plaintextPassword, ByteString storedPassword) {
        byte[] userPWDigestBytes;
        byte[] storedPWDigestBytes = storedPassword.value();
        try {
            byte[] salt = storedPWDigestBytes;
            userPWDigestBytes = this.crypt.crypt(plaintextPassword.value(), salt);
        }
        catch (Exception e) {
            return false;
        }
        return Arrays.equals(userPWDigestBytes, storedPWDigestBytes);
    }

    public boolean supportsAuthPasswordSyntax() {
        return false;
    }

    public ByteString encodeAuthPassword(ByteString plaintext) throws DirectoryException {
        Message message = ExtensionMessages.ERR_PWSCHEME_DOES_NOT_SUPPORT_AUTH_PASSWORD.get(this.getStorageSchemeName());
        throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message);
    }

    public boolean authPasswordMatches(ByteString plaintextPassword, String authInfo, String authValue) {
        return false;
    }

    public boolean isReversible() {
        return false;
    }

    public ByteString getPlaintextValue(ByteString storedPassword) throws DirectoryException {
        Message message = ExtensionMessages.ERR_PWSCHEME_NOT_REVERSIBLE.get("CRYPT");
        throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, message);
    }

    public ByteString getAuthPasswordPlaintextValue(String authInfo, String authValue) throws DirectoryException {
        Message message = ExtensionMessages.ERR_PWSCHEME_DOES_NOT_SUPPORT_AUTH_PASSWORD.get(this.getStorageSchemeName());
        throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message);
    }

    public boolean isStorageSchemeSecure() {
        return false;
    }
}

