/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.extensions;

import java.security.MessageDigest;
import java.security.SecureRandom;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.opends.messages.ExtensionMessages;
import org.opends.messages.Message;
import org.opends.server.admin.server.ConfigurationChangeListener;
import org.opends.server.admin.std.server.CramMD5SASLMechanismHandlerCfg;
import org.opends.server.admin.std.server.SASLMechanismHandlerCfg;
import org.opends.server.api.ClientConnection;
import org.opends.server.api.IdentityMapper;
import org.opends.server.api.SASLMechanismHandler;
import org.opends.server.config.ConfigException;
import org.opends.server.core.BindOperation;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.PasswordPolicyState;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.types.AuthenticationInfo;
import org.opends.server.types.ByteString;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.DN;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.Entry;
import org.opends.server.types.InitializationException;
import org.opends.server.types.LockManager;
import org.opends.server.types.ResultCode;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CRAMMD5SASLMechanismHandler
extends SASLMechanismHandler<CramMD5SASLMechanismHandlerCfg>
implements ConfigurationChangeListener<CramMD5SASLMechanismHandlerCfg> {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private byte[] iPad;
    private byte[] oPad;
    private CramMD5SASLMechanismHandlerCfg currentConfig;
    private DN configEntryDN;
    private IdentityMapper identityMapper;
    private MessageDigest md5Digest;
    private ReentrantLock digestLock;
    private SecureRandom randomGenerator;

    @Override
    public void initializeSASLMechanismHandler(CramMD5SASLMechanismHandlerCfg configuration) throws ConfigException, InitializationException {
        configuration.addCramMD5ChangeListener(this);
        this.currentConfig = configuration;
        this.configEntryDN = configuration.dn();
        this.digestLock = new ReentrantLock();
        this.randomGenerator = new SecureRandom();
        try {
            this.md5Digest = MessageDigest.getInstance("MD5");
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = ExtensionMessages.ERR_SASLCRAMMD5_CANNOT_GET_MESSAGE_DIGEST.get(StaticUtils.getExceptionMessage(e));
            throw new InitializationException(message, (Throwable)e);
        }
        this.iPad = new byte[64];
        this.oPad = new byte[64];
        Arrays.fill(this.iPad, (byte)54);
        Arrays.fill(this.oPad, (byte)92);
        DN identityMapperDN = configuration.getIdentityMapperDN();
        this.identityMapper = DirectoryServer.getIdentityMapper(identityMapperDN);
        if (this.identityMapper == null) {
            Message message = ExtensionMessages.ERR_SASLCRAMMD5_NO_SUCH_IDENTITY_MAPPER.get(String.valueOf(identityMapperDN), String.valueOf(this.configEntryDN));
            throw new ConfigException(message);
        }
        DirectoryServer.registerSASLMechanismHandler("CRAM-MD5", this);
    }

    @Override
    public void finalizeSASLMechanismHandler() {
        this.currentConfig.removeCramMD5ChangeListener(this);
        DirectoryServer.deregisterSASLMechanismHandler("CRAM-MD5");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processSASLBind(BindOperation bindOperation) {
        Message message;
        List<ByteString> clearPasswords;
        byte[] digestBytes;
        ASN1OctetString clientCredentials = bindOperation.getSASLCredentials();
        ClientConnection clientConnection = bindOperation.getClientConnection();
        if (clientCredentials == null) {
            byte[] challengeBytes = new byte[16];
            this.randomGenerator.nextBytes(challengeBytes);
            StringBuilder challengeString = new StringBuilder(18);
            challengeString.append('<');
            for (byte b : challengeBytes) {
                challengeString.append(StaticUtils.byteToLowerHex(b));
            }
            challengeString.append('>');
            ASN1OctetString challenge = new ASN1OctetString(challengeString.toString());
            clientConnection.setSASLAuthStateInfo(challenge);
            bindOperation.setServerSASLCredentials(challenge);
            bindOperation.setResultCode(ResultCode.SASL_BIND_IN_PROGRESS);
            return;
        }
        Object saslStateInfo = clientConnection.getSASLAuthStateInfo();
        if (saslStateInfo == null) {
            bindOperation.setResultCode(ResultCode.INVALID_CREDENTIALS);
            Message message2 = ExtensionMessages.ERR_SASLCRAMMD5_NO_STORED_CHALLENGE.get();
            bindOperation.setAuthFailureReason(message2);
            return;
        }
        if (!(saslStateInfo instanceof ASN1OctetString)) {
            bindOperation.setResultCode(ResultCode.INVALID_CREDENTIALS);
            Message message3 = ExtensionMessages.ERR_SASLCRAMMD5_INVALID_STORED_CHALLENGE.get();
            bindOperation.setAuthFailureReason(message3);
            return;
        }
        ASN1OctetString challenge = (ASN1OctetString)saslStateInfo;
        clientConnection.setSASLAuthStateInfo(null);
        String credString = clientCredentials.stringValue();
        int spacePos = credString.lastIndexOf(32);
        if (spacePos < 0) {
            bindOperation.setResultCode(ResultCode.INVALID_CREDENTIALS);
            Message message4 = ExtensionMessages.ERR_SASLCRAMMD5_NO_SPACE_IN_CREDENTIALS.get();
            bindOperation.setAuthFailureReason(message4);
            return;
        }
        String userName = credString.substring(0, spacePos);
        String digest = credString.substring(spacePos + 1);
        if (digest.length() != 32) {
            bindOperation.setResultCode(ResultCode.INVALID_CREDENTIALS);
            Message message5 = ExtensionMessages.ERR_SASLCRAMMD5_INVALID_DIGEST_LENGTH.get(digest.length(), 32);
            bindOperation.setAuthFailureReason(message5);
            return;
        }
        try {
            digestBytes = StaticUtils.hexStringToByteArray(digest);
        }
        catch (ParseException pe) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, pe);
            }
            bindOperation.setResultCode(ResultCode.INVALID_CREDENTIALS);
            Message message6 = ExtensionMessages.ERR_SASLCRAMMD5_INVALID_DIGEST_CONTENT.get(pe.getMessage());
            bindOperation.setAuthFailureReason(message6);
            return;
        }
        Entry userEntry = null;
        String lowerUserName = StaticUtils.toLowerCase(userName);
        if (lowerUserName.startsWith("dn:")) {
            DN userDN;
            try {
                userDN = DN.decode(userName.substring(3));
            }
            catch (DirectoryException de) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, de);
                }
                bindOperation.setResultCode(ResultCode.INVALID_CREDENTIALS);
                Message message7 = ExtensionMessages.ERR_SASLCRAMMD5_CANNOT_DECODE_USERNAME_AS_DN.get(userName, de.getMessageObject());
                bindOperation.setAuthFailureReason(message7);
                return;
            }
            if (userDN.isNullDN()) {
                bindOperation.setResultCode(ResultCode.INVALID_CREDENTIALS);
                Message message8 = ExtensionMessages.ERR_SASLCRAMMD5_USERNAME_IS_NULL_DN.get();
                bindOperation.setAuthFailureReason(message8);
                return;
            }
            DN rootDN = DirectoryServer.getActualRootBindDN(userDN);
            if (rootDN != null) {
                userDN = rootDN;
            }
            Lock readLock = null;
            for (int i = 0; i < 3 && (readLock = LockManager.lockRead(userDN)) == null; ++i) {
            }
            if (readLock == null) {
                bindOperation.setResultCode(DirectoryServer.getServerErrorResultCode());
                Message message9 = ExtensionMessages.INFO_SASLCRAMMD5_CANNOT_LOCK_ENTRY.get(String.valueOf(userDN));
                bindOperation.setAuthFailureReason(message9);
                return;
            }
            try {
                userEntry = DirectoryServer.getEntry(userDN);
            }
            catch (DirectoryException de) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, de);
                }
                bindOperation.setResultCode(ResultCode.INVALID_CREDENTIALS);
                Message message10 = ExtensionMessages.ERR_SASLCRAMMD5_CANNOT_GET_ENTRY_BY_DN.get(String.valueOf(userDN), de.getMessageObject());
                bindOperation.setAuthFailureReason(message10);
                return;
            }
            finally {
                LockManager.unlock(userDN, readLock);
            }
        }
        if (lowerUserName.startsWith("u:")) {
            userName = userName.substring(2);
        }
        try {
            userEntry = this.identityMapper.getEntryForID(userName);
        }
        catch (DirectoryException de) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, de);
            }
            bindOperation.setResultCode(ResultCode.INVALID_CREDENTIALS);
            Message message11 = ExtensionMessages.ERR_SASLCRAMMD5_CANNOT_MAP_USERNAME.get(String.valueOf(userName), de.getMessageObject());
            bindOperation.setAuthFailureReason(message11);
            return;
        }
        if (userEntry == null) {
            bindOperation.setResultCode(ResultCode.INVALID_CREDENTIALS);
            Message message12 = ExtensionMessages.ERR_SASLCRAMMD5_NO_MATCHING_ENTRIES.get(userName);
            bindOperation.setAuthFailureReason(message12);
            return;
        }
        bindOperation.setSASLAuthUserEntry(userEntry);
        try {
            PasswordPolicyState pwPolicyState = new PasswordPolicyState(userEntry, false, false);
            clearPasswords = pwPolicyState.getClearPasswords();
            if (clearPasswords == null || clearPasswords.isEmpty()) {
                bindOperation.setResultCode(ResultCode.INVALID_CREDENTIALS);
                message = ExtensionMessages.ERR_SASLCRAMMD5_NO_REVERSIBLE_PASSWORDS.get(String.valueOf(userEntry.getDN()));
                bindOperation.setAuthFailureReason(message);
                return;
            }
        }
        catch (Exception e) {
            bindOperation.setResultCode(ResultCode.INVALID_CREDENTIALS);
            message = ExtensionMessages.ERR_SASLCRAMMD5_CANNOT_GET_REVERSIBLE_PASSWORDS.get(String.valueOf(userEntry.getDN()), String.valueOf(e));
            bindOperation.setAuthFailureReason(message);
            return;
        }
        boolean matchFound = false;
        for (ByteString clearPassword : clearPasswords) {
            byte[] generatedDigest = this.generateDigest(clearPassword, challenge);
            if (!Arrays.equals(digestBytes, generatedDigest)) continue;
            matchFound = true;
            break;
        }
        if (!matchFound) {
            bindOperation.setResultCode(ResultCode.INVALID_CREDENTIALS);
            message = ExtensionMessages.ERR_SASLCRAMMD5_INVALID_PASSWORD.get();
            bindOperation.setAuthFailureReason(message);
            return;
        }
        bindOperation.setResultCode(ResultCode.SUCCESS);
        AuthenticationInfo authInfo = new AuthenticationInfo(userEntry, "CRAM-MD5", DirectoryServer.isRootDN(userEntry.getDN()));
        bindOperation.setAuthenticationInfo(authInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] generateDigest(ByteString password, ByteString challenge) {
        byte[] p = password.value();
        byte[] c = challenge.value();
        this.digestLock.lock();
        try {
            if (p.length > 64) {
                p = this.md5Digest.digest(p);
            }
            byte[] iPadAndData = new byte[64 + c.length];
            System.arraycopy(this.iPad, 0, iPadAndData, 0, 64);
            System.arraycopy(c, 0, iPadAndData, 64, c.length);
            byte[] oPadAndHash = new byte[80];
            System.arraycopy(this.oPad, 0, oPadAndHash, 0, 64);
            for (int i = 0; i < p.length; ++i) {
                int n = i;
                iPadAndData[n] = (byte)(iPadAndData[n] ^ p[i]);
                int n2 = i;
                oPadAndHash[n2] = (byte)(oPadAndHash[n2] ^ p[i]);
            }
            System.arraycopy(this.md5Digest.digest(iPadAndData), 0, oPadAndHash, 64, 16);
            byte[] byArray = this.md5Digest.digest(oPadAndHash);
            return byArray;
        }
        finally {
            this.digestLock.unlock();
        }
    }

    @Override
    public boolean isPasswordBased(String mechanism) {
        return true;
    }

    @Override
    public boolean isSecure(String mechanism) {
        return true;
    }

    @Override
    public boolean isConfigurationAcceptable(SASLMechanismHandlerCfg configuration, List<Message> unacceptableReasons) {
        CramMD5SASLMechanismHandlerCfg config = (CramMD5SASLMechanismHandlerCfg)configuration;
        return this.isConfigurationChangeAcceptable(config, unacceptableReasons);
    }

    @Override
    public boolean isConfigurationChangeAcceptable(CramMD5SASLMechanismHandlerCfg configuration, List<Message> unacceptableReasons) {
        boolean configAcceptable = true;
        DN cfgEntryDN = configuration.dn();
        DN identityMapperDN = configuration.getIdentityMapperDN();
        IdentityMapper newIdentityMapper = DirectoryServer.getIdentityMapper(identityMapperDN);
        if (newIdentityMapper == null) {
            unacceptableReasons.add(ExtensionMessages.ERR_SASLCRAMMD5_NO_SUCH_IDENTITY_MAPPER.get(String.valueOf(identityMapperDN), String.valueOf(cfgEntryDN)));
            configAcceptable = false;
        }
        return configAcceptable;
    }

    @Override
    public ConfigChangeResult applyConfigurationChange(CramMD5SASLMechanismHandlerCfg configuration) {
        ResultCode resultCode = ResultCode.SUCCESS;
        boolean adminActionRequired = false;
        ArrayList<Message> messages = new ArrayList<Message>();
        DN identityMapperDN = configuration.getIdentityMapperDN();
        IdentityMapper newIdentityMapper = DirectoryServer.getIdentityMapper(identityMapperDN);
        if (newIdentityMapper == null) {
            if (resultCode == ResultCode.SUCCESS) {
                resultCode = ResultCode.CONSTRAINT_VIOLATION;
            }
            messages.add(ExtensionMessages.ERR_SASLCRAMMD5_NO_SUCH_IDENTITY_MAPPER.get(String.valueOf(identityMapperDN), String.valueOf(this.configEntryDN)));
        }
        if (resultCode == ResultCode.SUCCESS) {
            this.identityMapper = newIdentityMapper;
            this.currentConfig = configuration;
        }
        return new ConfigChangeResult(resultCode, adminActionRequired, messages);
    }
}

