/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.core;

import org.opends.server.core.NetworkGroupNamingContexts;
import org.opends.server.core.SearchOperation;
import org.opends.server.core.WorkflowImpl;
import org.opends.server.core.WorkflowResultCode;
import org.opends.server.core.WorkflowTopology;
import org.opends.server.core.WorkflowTopologyNode;
import org.opends.server.types.DN;
import org.opends.server.types.Operation;
import org.opends.server.types.OperationType;
import org.opends.server.types.SearchScope;

public class RootDseWorkflowTopology
extends WorkflowTopology {
    private NetworkGroupNamingContexts namingContexts = null;

    public RootDseWorkflowTopology(WorkflowImpl workflowImpl, NetworkGroupNamingContexts namingContexts) {
        super(workflowImpl);
        this.namingContexts = namingContexts;
    }

    public void execute(Operation operation) {
        OperationType operationType = operation.getOperationType();
        if (operationType != OperationType.SEARCH) {
            this.getWorkflowImpl().execute(operation);
        } else {
            this.executeSearch((SearchOperation)operation);
        }
    }

    private void executeSearch(SearchOperation searchOp) {
        SearchScope originalScope = searchOp.getScope();
        if (originalScope == SearchScope.BASE_OBJECT) {
            this.getWorkflowImpl().execute(searchOp);
            return;
        }
        WorkflowResultCode workflowResultCode = new WorkflowResultCode(searchOp.getResultCode(), searchOp.getErrorMessage());
        SearchScope newScope = this.elaborateScopeForSearchInSubordinates(originalScope);
        searchOp.setScope(newScope);
        DN originalBaseDN = searchOp.getBaseDN();
        for (WorkflowTopologyNode namingContext : this.namingContexts.getPublicNamingContexts()) {
            DN ncDN = namingContext.getBaseDN();
            searchOp.setBaseDN(ncDN);
            namingContext.execute(searchOp);
            boolean sendReferenceEntry = workflowResultCode.elaborateGlobalResultCode(searchOp.getResultCode(), searchOp.getErrorMessage());
            if (!sendReferenceEntry) continue;
        }
        searchOp.setBaseDN(originalBaseDN);
        searchOp.setScope(originalScope);
        searchOp.setResultCode(workflowResultCode.resultCode());
        searchOp.setErrorMessage(workflowResultCode.errorMessage());
    }

    public StringBuffer toString(String leftMargin) {
        StringBuffer sb = new StringBuffer();
        sb.append(leftMargin + "Workflow baseDN:[ \"\" ]\n");
        return sb;
    }
}

