/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.core;

import java.util.ArrayList;
import org.opends.server.core.WorkflowTopologyNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NetworkGroupNamingContexts {
    private ArrayList<WorkflowTopologyNode> namingContexts = null;
    private ArrayList<WorkflowTopologyNode> publicNamingContexts = null;
    private ArrayList<WorkflowTopologyNode> privateNamingContexts = null;

    public NetworkGroupNamingContexts() {
        this.resetLists();
    }

    public void resetLists() {
        this.namingContexts = new ArrayList();
        this.privateNamingContexts = new ArrayList();
        this.publicNamingContexts = new ArrayList();
    }

    public void addNamingContext(WorkflowTopologyNode workflow) {
        this.namingContexts.add(workflow);
        if (workflow.isPrivate()) {
            this.privateNamingContexts.add(workflow);
        } else {
            this.publicNamingContexts.add(workflow);
        }
    }

    public ArrayList<WorkflowTopologyNode> getNamingContexts() {
        return this.namingContexts;
    }

    public ArrayList<WorkflowTopologyNode> getPrivateNamingContexts() {
        return this.privateNamingContexts;
    }

    public ArrayList<WorkflowTopologyNode> getPublicNamingContexts() {
        return this.publicNamingContexts;
    }

    public StringBuffer toString(String leftMargin) {
        StringBuffer sb = new StringBuffer();
        String newMargin = leftMargin + "   ";
        sb.append(leftMargin + "List of naming contexts:\n");
        for (WorkflowTopologyNode w : this.namingContexts) {
            sb.append(w.toString(newMargin));
        }
        sb.append(leftMargin + "List of PRIVATE naming contexts:\n");
        for (WorkflowTopologyNode w : this.privateNamingContexts) {
            sb.append(w.toString(newMargin));
        }
        sb.append(leftMargin + "List of PUBLIC naming contexts:\n");
        for (WorkflowTopologyNode w : this.publicNamingContexts) {
            sb.append(w.toString(newMargin));
        }
        return sb;
    }
}

